/*

oer+MySQL - IRC bot

See ftp://nic.funet.fi/pub/unix/irc/docs/FAQ.gz section 11 for the
definition of the word bot.

Copyright (C) 2000, 2001 EQU <equ@equnet.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "oer+MySQL-common.h"
#include "ds.h"
#include "network.h"
#include "misc.h"

/* global (to all) variables */
struct state *mystate;
int do_console;
int do_debug;
int do_tempoutput;

char salt_chars[] = { "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz" };

/* global (to oer.c) variables */
int do_signals;

/* prototype definitions */
static void handlesignal(int);

int main(int argc, char *argv[])
{
	extern char *optarg;
        
        extern int optind;
        extern int opterr;
        extern int optopt;

#ifdef HAVE_LOCALE_H
        char *locptr;
#endif
	char config[TINYSTRINGLEN + 1];
	int retval;
	int c;
	int do_help;
	int do_version;
	fd_set rsock;
	pid_t newpid;
	struct timeval tv;

	do_console = 0;
	do_debug = OER_DEBUG_INFO;
	do_help = 0;
	do_signals = 1;
	do_version = 0;
	do_tempoutput = 1;
	strncpy(config, "oer+MySQL.conf", TINYSTRINGLEN);
        while((c = getopt(argc, argv, "cd:f:hsv")) > 0) {
		switch(c) {
		case 'c':
			do_console = 1;
			break;
		case 'd':
			do_debug = atoi(optarg);
			break;
		case 'f':
			strncpy(config, optarg, TINYSTRINGLEN);
			break;
		case 'h':
			do_help = 1;
			break;
		case 's':
			do_signals = 0;
			break;
		case 'v':
			do_version = 1;
			break;
		default:
			exit(EXIT_FAILURE);
		}
	}
	if(do_help) {
		oer_debug(OER_DEBUG_INFO, "usage: %s [-c] [-d <level>] [-f <config>] [-h] [-s] [-v]\n", argv[0]);
		exit(EXIT_SUCCESS);
	}
	oer_debug(OER_DEBUG_INFO, "%s\n\n", OER_COPYRIGHT1);
	oer_debug(OER_DEBUG_INFO, "%s\n", OER_COPYRIGHT2);
	if(do_version) {
		exit(EXIT_SUCCESS);
	}
#ifdef HAVE_LOCALE_H
        if((locptr = setlocale(LC_CTYPE, "")) == NULL) {
                oer_debug(OER_DEBUG_FATAL, "main->setlocale() failed for %s\n");
                exit(EXIT_FAILURE);
        }
#endif
	if(signal(SIGINT, handlesignal) == SIG_ERR) {
                oer_debug(OER_DEBUG_FATAL, "main->failed to set SIGINT: %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }
	if(signal(SIGTERM, handlesignal) == SIG_ERR) {
                oer_debug(OER_DEBUG_FATAL, "main->failed to set SIGTERM: %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }
	if(signal(SIGPIPE, handlesignal) == SIG_ERR) {
                oer_debug(OER_DEBUG_FATAL, "main->failed to set SIGPIPE: %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }
	if((mystate = emptystate()) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "main->failed to allocate memory for irc state\n");
		exit(EXIT_FAILURE);
	}
	strncpy(mystate->config, config, TINYSTRINGLEN);
	if(!loadconf(mystate->config)) {
                oer_debug(OER_DEBUG_FATAL, "main->loadconf() failed\n");
		exit(EXIT_FAILURE);
        }
	if(mysql_real_connect(&mystate->mysqldb.mysqldbconn, mystate->mysqldb.mysqldbdbhost, mystate->mysqldb.mysqldbdbuser, mystate->mysqldb.mysqldbdbpw, mystate->mysqldb.mysqldbdbname, 0, NULL, 0) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "main->mysql_real_connect() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
		exit(EXIT_FAILURE);
        }
	if(!initenv()) {
                oer_debug(OER_DEBUG_FATAL, "main->initenv() failed\n");
		exit(EXIT_FAILURE);
        }
        if(do_console) {
		oer_debug(OER_DEBUG_INFO, "console mode is on (debug messages will be shown on screen)\n");
	}
	if(index(mystate->flags, (int)'o') != NULL) {
		oer_debug(OER_DEBUG_INFO, "debug messages will be saved to MySQL\n");
	}
	if(index(mystate->flags, (int)'l') != NULL) {
		oer_debug(OER_DEBUG_INFO, "IRC traffic will be logged to MySQL\n");
	}
	if(!do_console) {
		oer_debug(OER_DEBUG_INFO, "main->oer+MySQL calling fork()\n");
		newpid = fork();
		if(newpid < 0) {
			oer_debug(OER_DEBUG_FATAL, "main->couldn't fork()\n");
			exit(EXIT_FAILURE);
		}
		if(newpid) {
			/* the parent */
			oer_debug(OER_DEBUG_INFO, "main->fork successful, oer+MySQL new pid is %ld (parent exiting)\n", newpid);
			exit(EXIT_SUCCESS);
		}
		/* necessary for some remote progs */
		close(STDIN_FILENO);
		close(STDOUT_FILENO);
		close(STDERR_FILENO);
		do_console = 0;
	}
	/* from now on we write to console and/or database */
	do_tempoutput = 0;
	mystate->loopforever = 1;
	while(mystate->loopforever) {
		mystate->now = time(NULL);
		switch(serverconnection()) {
		case OER_SERVERCONNECTION_ERR_SOCKET:
			oer_debug(OER_DEBUG_FATAL, "main->socket() failed, exiting.\n");
			exit(EXIT_FAILURE);
		case OER_SERVERCONNECTION_ERR_GETHOSTNAME:
			oer_debug(OER_DEBUG_FATAL, "main->gethostname() failed, exiting.\n");
			exit(EXIT_FAILURE);
		case OER_SERVERCONNECTION_ERR_GETHOSTBYNAME_RETRY:
			oer_debug(OER_DEBUG_ERROR, "main->gethostbyname() temporary error, retrying.\n");
			sleep(OER_WAIT_BETWEEN_CONNECTION_ATTEMPTS);
			break;
		case OER_SERVERCONNECTION_ERR_GETSERVER_RETRY:
			oer_debug(OER_DEBUG_ERROR, "main->getserver() temporary error, retrying.\n");
			sleep(OER_WAIT_BETWEEN_CONNECTION_ATTEMPTS);
			break;
		case OER_SERVERCONNECTION_ERR_GETHOSTBYNAME:
			oer_debug(OER_DEBUG_FATAL, "main->gethostbyname() fatal error, exiting.\n");
			exit(EXIT_FAILURE);
		case OER_SERVERCONNECTION_ERR_BIND:
			oer_debug(OER_DEBUG_FATAL, "main->bind() fatal error, exiting.\n");
			exit(EXIT_FAILURE);
		case OER_SERVERCONNECTION_ERR_CONNECT_RETRY:
			oer_debug(OER_DEBUG_ERROR, "main->connect() temporary error, retrying.\n");
			sleep(OER_WAIT_BETWEEN_CONNECTION_ATTEMPTS);
			break;
		case OER_SERVERCONNECTION_ERR_CONNECT:
			oer_debug(OER_DEBUG_FATAL, "main->connect() fatal error, exiting.\n");
			exit(EXIT_FAILURE);
		case OER_SERVERCONNECTION_ALREADY_CONNECTED:
		case OER_SERVERCONNECTION_EVERYTHING_OK:
			break;
		}
		/* check if we are connected */
		if((mystate->current_server == NULL) || !mystate->current_server->connected) {
			continue;
		}
		FD_ZERO(&rsock);
		FD_SET(mystate->sockfd, &rsock);
		tv.tv_sec = OER_MAINLOOP_TIMEOUT_SECS;
		tv.tv_usec = OER_MAINLOOP_TIMEOUT_USECS;
		retval = select(mystate->sockfd + 1, &rsock, NULL, NULL, &tv);
		if(retval < 0) {
			oer_debug(OER_DEBUG_INFO, "main->select() failed: %s\n", strerror(errno));
			if(errno != EINTR) {
				mystate->reconnect = OER_RECONNECT_ERROR;
				reconnect();
			}
			continue;
		}
		if(retval > 0) {
			/* we have server I/O */
			if(FD_ISSET(mystate->sockfd, &rsock)) {
				switch(handleserverdata()) {
				case OER_HANDLESERVERDATA_ERR_WRITE:
				case OER_HANDLESERVERDATA_ERR_READ:
				case OER_HANDLESERVERDATA_ERR_NOTHING_READ:
					mystate->reconnect = OER_RECONNECT_ERROR;
					reconnect();
					break;
				}
			}
			continue;
		}
		reconnect();
		/* retval == 0, timeout */
		switch(registerconnection()) {
		case OER_REGISTERCONNECTION_ERR_GETPWUID:
			exit(EXIT_FAILURE);
		case OER_REGISTERCONNECTION_ERR_WRITE:
		case OER_REGISTERCONNECTION_ERR_HANDLESERVERDATA:
			mystate->reconnect = OER_RECONNECT_ERROR;
			reconnect();
			break;
		case OER_REGISTERCONNECTION_ALREADY_REGISTERED:
		case OER_REGISTERCONNECTION_EVERYTHING_OK:
			break;
		}
		/* do some housekeeping */
		processenv();	
		/* check if it's safe to do some server actions */
		if((mystate->last_actions + 1) >= mystate->now) {
			continue;
		}
		switch(processmmodes()) {
		case OER_PROCESSMMODES_ERR_WRITE:
			mystate->reconnect = OER_RECONNECT_ERROR;
			reconnect();
			break;
		}
		switch(processtimeds()) {
		case OER_PROCESSTIMEDS_ERR_WRITE:
			mystate->reconnect = OER_RECONNECT_ERROR;
			reconnect();
			break;
		}
		mystate->last_actions = mystate->now;
	}
        mysql_close(&mystate->mysqldb.mysqldbconn);
	exit(EXIT_SUCCESS);
}

static void handlesignal(int signal)
{
	if(signal == SIGINT || signal == SIGTERM) {
		if(do_signals) {
			snprintf(mystate->signoff, STRINGLEN, "received %s, leaving for now but I will return!", (signal == SIGINT) ? "SIGINT" : "SIGTERM");
			quit();
			return;
			
		} else {
			oer_debug(OER_DEBUG_INFO, "handlesignal->%s received, ignoring (do_signals = 0)\n", (signal == SIGINT) ? "SIGINT" : "SIGTERM");
		}
	}
	if(signal == SIGPIPE) {
		mystate->reconnect = OER_RECONNECT_ERROR;
		strncpy(mystate->signoff, "received SIGPIPE, connecting to next server", STRINGLEN);
		return;
	}
}
