#!/bin/sh

CURRDIR=`pwd`

function readln () {
	echo -n "$1"
        IFS='@' read ans || exit 1
        [ -z "$ans" ] && ans=$2
}

if [ $# -ne 1 ]; then
        echo "wrong number of arguments"
        echo ""
        exit
fi

echo "Now configuring MySQL for oer+MySQL"
echo ""
echo -n "Checking if I can find all the necesarry binaries... "

if [ ! -x $1/bin/mysqladmin ]; then
	echo "mysqladmin not found in $1/bin/"
	echo ""
        exit
fi

if [ ! -x $1/bin/mysql ]; then
	echo "mysql not found in $1/bin/"
        echo ""
        exit
fi

echo "ok"
echo ""
readln "Do you want to create the database (+ user) for oer+MySQL? [Y/n] " "Y"
CREATEDB=$ans

if [ "$CREATEDB" = "Y" ]; then
    readln "Please specify the host where MySQL is running [localhost] " "localhost"
    HOST=$ans
    readln "Please specify the MySQL admin user [root] " "root"
    USER=$ans
    stty -echo
    readln "Please specify the MySQL admin password [] " ""
    PW=$ans
    stty echo
    echo ""
    echo ""
    echo -n "Attempting to connect to $HOST as $USER... "

    if [ "$PW" = "" ]; then
	    OUTPUT=`$1/bin/mysqladmin -h $HOST -u $USER ping 2>&1`
    else
	    OUTPUT=`$1/bin/mysqladmin -h $HOST -u $USER -p$PW ping 2>&1`
    fi

    RC=$?

    if [ $RC -eq 1 ]; then
	echo "failed"
	echo ""
        exit
    fi

    echo "ok"
    echo
    readln "What should your database be named [oerdb] " "oerdb"
    DB=$ans
    echo ""
    echo -n "Attempting to create database... "

    if [ "$PW" = "" ]; then
	    OUTPUT=`$1/bin/mysqladmin -h $HOST -u $USER create $DB 2>&1`
    else
	    OUTPUT=`$1/bin/mysqladmin -h $HOST -u $USER -p$PW create $DB 2>&1`
    fi

    RC=$?

    if [ $RC -eq 1 ]; then
	echo "failed"
	echo ""
        exit
    fi

    echo "ok"
    echo ""

    readln "What database user will be granted rights to $DB [oer] " "oer"
    DBUSER=$ans
    stty -echo
    readln "Please specify password for $DBUSER [] " ""
    DBUSERPW=$ans
    stty echo
    echo ""
    HOSTNAME=`hostname`
    GRANTFOR="$HOSTNAME localhost"
    for i in $GRANTFOR; do
	echo -n "Attempting to grant rights to $DBUSER coming from $i... "

	if [ "$PW" = "" ]; then

	    if [ "$DBUSERPW" = "" ]; then
		OUTPUT=`(echo "GRANT ALL PRIVILEGES ON $DB.* TO $DBUSER@$i" | $1/bin/mysql -h $HOST -u $USER) 2>&1`
	    else
		OUTPUT=`(echo "GRANT ALL PRIVILEGES ON $DB.* TO $DBUSER@$i IDENTIFIED BY '$DBUSERPW'" | $1/bin/mysql -h $HOST -u $USER) 2>&1`
	    fi

	else

	    if [ "$DBUSERPW" = "" ]; then
		OUTPUT=`(echo "GRANT ALL PRIVILEGES ON $DB.* TO $DBUSER@$i" | $1/bin/mysql -h $HOST -u $USER -p$PW) 2>&1`
	    else
		OUTPUT=`(echo "GRANT ALL PRIVILEGES ON $DB.* TO $DBUSER@$i IDENTIFIED BY '$DBUSERPW'" | $1/bin/mysql -h $HOST -u $USER -p$PW) 2>&1`
	    fi

	fi

	RC=$?

	if [ $RC -eq 1 ]; then
	    echo "failed"
	    echo ""
	    exit
	fi

	echo "ok"
    done
    echo -n "Attempting to FLUSH PRIVILEGES... "

    if [ "$PW" = "" ]; then
	OUTPUT=`(echo "FLUSH PRIVILEGES" | $1/bin/mysql -h $HOST -u $USER) 2>&1`
    else
	OUTPUT=`(echo "FLUSH PRIVILEGES" | $1/bin/mysql -h $HOST -u $USER -p$PW) 2>&1`
    fi
    
    RC=$?

    if [ $RC -eq 1 ]; then
	echo "failed"
	echo ""
	exit
    fi

    echo "ok"
else
    readln "Please specify the host where MySQL is running [localhost] " "localhost"
    HOST=$ans
    readln "Please specify the database [oerdb] " "oerdb"
    DB=$ans
    readln "Please specify the database user [oer] " "oer"
    DBUSER=$ans
    stty -echo
    readln "Please specify password for $DBUSER [] " ""
    DBUSERPW=$ans
    stty echo
    echo ""
    echo ""
    echo -n "Attempting to connect to $HOST as $DBUSER... "

    if [ "$DBUSERPW" = "" ]; then
	    OUTPUT=`$1/bin/mysqladmin -h $HOST -u $DBUSER ping 2>&1`
    else
	    OUTPUT=`$1/bin/mysqladmin -h $HOST -u $DBUSER -p$DBUSERPW ping 2>&1`
    fi

    RC=$?

    if [ $RC -eq 1 ]; then
	echo "failed"
	echo ""
        exit
    fi

    echo "ok"
fi

echo -n "Creating initial tables... "

if [ "$DBUSERPW" = "" ]; then
    OUTPUT=`($1/bin/mysql -h $HOST -u $DBUSER $DB < $CURRDIR/scripts/initial.sql) 2>&1`
else
    OUTPUT=`($1/bin/mysql -h $HOST -u $DBUSER -p$DBUSERPW $DB < $CURRDIR/scripts/initial.sql) 2>&1`
fi
    
RC=$?

if [ $RC -eq 1 ]; then
    echo "failed"
    echo ""
    exit
fi

echo "ok"

echo ""
echo "oer+MySQL configuration follows"
echo ""
readln "Please specify default IRC nick [oer] " "oer"
NICK=$ans
readln "Please specify alternate IRC nick [oeroer] " "oeroer"
ALTNICK=$ans
readln "Please specify user ID [oer] " "oer"
USERID=$ans
readln "Please specify user modes [+i] " "+i"
USERMODES=$ans
readln "Please specify bot flags [f] " "f"
BOTFLAGS=$ans
readln "Please specify command prefix [!] " "!"
PREFIX=$ans
readln "Please specify IRC REALNAME [http://oer.equnet.org/help.html] " "http://oer.equnet.org/help.html"
REALNAME=$ans
readln "Please specify obtional virtual host [] " ""
VIRTHOST=$ans
readln "Please specify bot handle [oer] " "oer"
HANDLE=$ans

INSERT_CONF="INSERT INTO conf VALUES ('$NICK','$ALTNICK','$USERID','$USERMODES','$BOTFLAGS','$PREFIX','$REALNAME','$VIRTHOST','$HANDLE')"

readln "Please specify bot admin handle [EQU] " "EQU"
ADMIN=$ans
readln "Please specify bot admin flags [n] " "n"
ADMINFLAGS=$ans

INSERT_ADMINS="INSERT INTO admins VALUES ('$ADMIN','$ADMINFLAGS','$HANDLE')"

readln "Please specify bot admin hostmask [equ@*.equnet.org] " "equ@*.equnet.org"
ADMINHOSTMASK=$ans

INSERT_HOSTMASKS="INSERT INTO hostmasks VALUES ('$ADMINHOSTMASK','',1,'$ADMIN','$HANDLE')"

readln "Please specify default IRC server to connect to [irc.equnet.org] " "irc.equnet.org"
SERVER=$ans
readln "Please specify port [6667] " "6667"
PORT=$ans
readln "Please specify amount of allowed server modes [6] " "6"
MODES=$ans
readln "Please specify ping frequency in seconds on $SERVER [90] " "90"
PINGFREQ=$ans
readln "Please specify whether IRC operators are protected on $SERVER [1] " "1"
PROT=$ans
readln "Please specify whether you want line noise for $SERVER [0] " "0"
NOISE=$ans
readln "Please specify obtional server password for $SERVER [] " ""
SERVERPW=$ans

INSERT_SERVERS="INSERT INTO servers VALUES ('$SERVER','$PORT','$MODES','$PINGFREQ','$PROT','$NOISE','$SERVERPW','$HANDLE')"

echo ""
echo -n "Importing data into database... "

for i in 1 2 3 4; do
    case $i in
	1)
	INSERT_COMMAND=$INSERT_CONF
	;;
	2)
	INSERT_COMMAND=$INSERT_ADMINS
	;;
	3)
	INSERT_COMMAND=$INSERT_HOSTMASKS
	;;
	4)
	INSERT_COMMAND=$INSERT_SERVERS
	;;
    esac

    if [ "$DBUSERPW" = "" ]; then
	OUTPUT=`(echo "$INSERT_COMMAND" | $1/bin/mysql -h $HOST -u $DBUSER $DB) 2>&1`
    else
	OUTPUT=`(echo "$INSERT_COMMAND" | $1/bin/mysql -h $HOST -u $DBUSER -p$DBUSERPW $DB) 2>&1`
    fi
    
    RC=$?

    if [ $RC -eq 1 ]; then
	echo "failed"
	echo ""
	exit
    fi

done

echo "ok"
echo -n "Creating oer+MySQL.conf... "
echo "mysql::$HOST::$DB::$DBUSER::$DBUSERPW" > sample-configuration/oer+MySQL.conf

RC=$?

if [ $RC -eq 1 ]; then
    echo "failed"
    echo ""
    exit
fi

echo "ident::$HANDLE" >> sample-configuration/oer+MySQL.conf

RC=$?

if [ $RC -eq 1 ]; then
    echo "failed"
    echo ""
    exit
fi

echo "ok"
echo ""
