/*

oer+MySQL - IRC bot

See ftp://nic.funet.fi/pub/unix/irc/docs/FAQ.gz section 11 for the
definition of the word bot.

Copyright (C) 2000-2001 EQU <equ@equnet.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "oer+MySQL-common.h"
#include "oer+MySQL.h"
#include "misc.h"
#include "reg.h"

/* prototype definitions */
char *getlamer(char *);
char *getchanmode(char *);
char *getchankey(char *);
char *getchanflags(char *);
char *safeban(char *);
char *getfirsthostless(char *);
char *isnickbk(char *, char *);
char *getkickreason(char *);
int topiccount(char *);
int settopic(void);
int setnewtopic(char *, char *, char *);
int addnewtopic(char *, char *, char *);
int insertnewtopic(char *, char *, char *, int);
int edittopic(char *, char *, char *, int);
int gettopic(char *, char *);
int listtopic(char *, int, char *);
int deltopic(char *, int, char *);
int deltopics(char *);
int refreshtopic(char *);
int swaptopic(char *, int, int);
int partcount(char *, char *, char *);
int admincount(void);
int usercount(char *);
int loadconf(char *);
int parseconf(char *);
int saveconf(void);
int getadmins(void);
int getusers(char *);
int updateadmints(void);
int updateuserts(char *);
int initenv(void);
int allhostsknown(char *);
int burstjoins(char *);
int amiop(char *);
int isq(char *);
int isme(char *);
int isvalidchannel(char *);
int isvoicenow(char *, char *);
int isatleastopnow(char *, char *, char *);
int isatleastop(char *, char *, char *);
int isallowedop(char *, char *);
int isop(char *, char *);
int isvalidlogon(char *, char *);
int isopa(char *);
int ishostless(char *);
int delopa(char *);
int isadmin(char *, char *);
int isonchan(char *, char *);
int issameuser(char *, char *, char *);
int isopnow(char *, char *);
int iswordbk(char *, char *);
int isflood(char *, char *, char *, char *);
int ispermban(char *, char *);
int ismoderated(char *);
int permbancount(char *);
int haschanflags(char *, char *);
int hasadminflags(char *, char *);
int hasuserflags(char *, char *, char *);
int nickchange(char *, char *, char *);
int usersonchan(char *);
int nthmode(char *, int);
int userleft(char *, char *, char *);
int changeuser(char *, char *, int, int, int);
int whichctcp(char *);
int whichcommand(char *, int);
int gettobek(char *, char *);
int checkforansi(char *, char *, char *, char *);
int checkforflood(char *, char *, char *, char *);
int checkforbadword(char *, char *, char *, char *);
int checkforbadnick(char *, char *, char *);
int checkforautorejoin(char *, char *, char *);
int checkforpartrejoin(char *, char *, char *);
int delchankey(char *);
int delnickbk(char *, char *);
int delwordbk(char *, char *);
int uptime(time_t *, time_t *);
int deladmin(char *, int);
int deladminmask(char *, char *);
int deluser(char *, char *);
int delusermask(char *, char *, char *);
int deltrusted(char *);
int delchannel(char *);
int getondiskmsgcount(char *, char *);
int getondiskjoincount(char *, char *);
int getjoincount(char *, char *);
int getrandom(int);
int getrandommsg(char *, char *, int, char *, int, int);
int lastquote(char *);
int delserver(char *, int, int, int, int, int);
int setpassword(char *, char *, char *);
int logoff(char *, char *);
int logon(char *, char *, char *, char *, int);
struct advert *addnewadvert(char *, char *, char *);
struct authed *addnewauthed(char *, time_t, struct botuser *, char *);
struct botuser *addbotuser(char *, char *);
struct botuser *addnewadmin(char *, char *);
struct botuser *addnewuser(char *, char *, char *);
struct channel *addnewchannel(char *);
struct channel *getchptr(char *);
struct chanuser *userjoined(char *, char *, char *, int, int, int);
struct chanuser *getcuptr(char *, char *);
struct state *emptystate(void);
struct server *getserver(void);
struct server *addnewserver(char *, int, int, int, int, int, char *);
struct maskstruct *addnewnickbk(char *, char *, char *);
struct maskstruct *addnewwordbk(char *, char *, char *);
struct maskstruct *addnewtrusted(char *);
struct maskstruct *addnewusermask(char *, char *, char *);
struct maskstruct *addnewadminmask(char *, char *);
struct maskstruct *editmask(struct maskstruct *, char *, char *);
struct modeline *addnewmm(char *, time_t, char *, char *);
struct pubmsg *addnewpubmsg(char *, time_t, char *, char *, char *);
struct part *addnewpart(char *, time_t, char *, char *);
struct join *addnewjoin(char *, time_t, char *, char *);
struct timed *addnewtimed(time_t, int, int, char *, char *, char *, char *);
struct chanuser *getrandomuser(char *);
time_t lastoff(char *, char *, char *);
void sendadverts(char *, char *, char *);
void deladverts(char *, char *);
void resetparts(char *, char *, char *);
void iamop(char *, int);
void initpubmsgs(char *);
void freepubmsguser(char *, char *, char *);
void lockchan(char *, char *, int, char *, char *);
void unlockchan(char *, char *, char *);
void clearflood(char *, char *, char *);
void initchannel(char *);
void initall(void);
void initmmodes(char *);
void inittimeds(void);
void initnicks(char *);
void initparts(char *);
void initjoins(char *);
void initnickbks(char *);
void initwordbks(char *);
void initusers(char *);
void linenoise(void);
void checkstoned(void);
void setuserhost(char *, char *);
void sethostquerystatus(char *, int);
void iwaskicked(char *);
void banuser(char *, char *);
void unbanuser(char *, char *);
void kickuser(char *, char *, char *);
void sendreply(char *, int, int, int, char *);
void sendchannelnotice(char *, int, char *);
void listcommand(char *, int, char *, char *, char *, char *);
void addcommand(char *, int, char *, char *, char *, char *);
void delcommand(char *, int, char *, char *, char *, char *);
void editcommand(char *, int, char *, char *, char *, char *);
void logoffcommand(char *, int, char *, char *, char *, char *);
void logoncommand(char *, int, char *, char *, char *, char *);
void isjoined(char *);
void changetobek(char *, char *, int);
void setnick(void);
void setumode(void);
void syncvoices(char *);
void syncops(char *);
void syncpermbans(char *);
void syncnickbks(char *);
void syncuserhosts(void);
void processenv(void);
void processlock(void);
void joinchannels(void);
void updatelast(char *, char *, char *, char *);
void updateseen(char *, char *, char *);
void showlast(char *, int, char *, char *);
void showseen(char *, int, char *, char *);
void setchanflags(char *, char *);
void setchanmode(char *, char *);
void setchankey(char *, char *);
void channelsync(char *);
void cleartobeks(char *);
void getnthmode(char *, int, char *);
void massmessage(char *, char *);
void setlastquote(char *, time_t);
void quit(void);
void parsectcp(char *, char *, int, char *);
void nstats(char *, int, char *, char *);
void wall(char *, char *, char *, char *);
void cleanautheds(char *);
void listchanusers(void);

void listchanusers()
{
        struct channel *this;
        struct chanuser *cu;
	
        for(this = mystate->channels; this != NULL; this = this->next) {
		oer_debug(OER_DEBUG_INFO, "there are %d users on %s%s\n", this->nickcount, this->name, (amiop(this->name)) ? "" : " *");
                cu = this->nicks;
                while(cu != NULL) {
                        oer_debug(OER_DEBUG_FLOOD, "channel: %s, nick: %s, host: %s, oper: %s, op: %s, voice: %s\n", this->name, cu->nick, (cu->host == NULL) ? "(null)" : cu->host, (cu->ircop) ? "YES" : "NO", (cu->chanop) ? "YES" : "NO", (cu->voice) ? "YES" : "NO");
                        cu = cu->next;
                }
        }
}

void deladverts(char *channel, char *type)
{
        struct channel *this;
        struct advert *a;
        struct advert *a2;

        if((this = getchptr(channel)) == NULL) {
                return;
        }
        a = this->adverts;
        a2 = a;
        while(a != NULL) {
                a2 = a;
                if(!strcmp(a->type, type)) {
                        /* adjust lists */
                        if(a->prev == NULL) {
                                /* first advert in list */
                                this->adverts = a->next;
                                /* ... check if also last */
                                if(a->next != NULL) {
                                        a->next->prev = NULL;
                                }
                        }
			if(a->next == NULL) {
                                /* last advert in list */
                                /* ... check also if the only one */
                                if(a->prev != NULL) {
                                        a->prev->next = NULL;
                                } else {
                                        this->adverts = NULL;
                                }
                        }
                        if(a->prev != NULL && a->next != NULL) {
                                /* between 2 or more adverts */
                                a->prev->next = a->next;
                                a->next->prev = a->prev;
                        }
                        free(a->message);
			free(a->type);
                        free(a);
                }
                a = a2->next;
        }
}

struct advert *addnewadvert(char *channel, char *type, char *message)
{
        struct channel *this;
        struct advert *a;
        struct advert *a2;

        if((this = getchptr(channel)) == NULL) {
                return NULL;
        }
        a = this->adverts;
        a2 = a;
        while(a != NULL) {
                a2 = a;
                if(!strcmp(a->type, type) && !strcasecmp(a->message, message)) {
                        return NULL;
                }
                a = a2->next;
        }
	if((a = (struct advert *) malloc(sizeof(struct advert))) == NULL) {
                return NULL;
        }
        if((a->type = (char *) malloc(strlen(type) + 1)) == NULL) {
                return NULL;
        }
        strcpy(a->type, type);
        if((a->message = (char *) malloc(strlen(message) + 1)) == NULL) {
                return NULL;
        }
        strcpy(a->message, message);
        a->next = NULL;
        a->prev = NULL;
        if(this->adverts == NULL) {
                /* first advert, special case */
                this->adverts = a;
                return a;
        }
        /* >=1 adverts, normal processing (append) */
        a2->next = a;
        a->prev = a2;
        return a;
}

void sendadverts(char *channel, char *nick, char *host)
{
        int send_lamers;
        int send_ops;
        int send_admins;
        int send_other;
        struct channel *this;
        struct advert *a;

        if((this = getchptr(channel)) == NULL) {
                return;
        }
        send_lamers = 1;
        send_ops = 0;
        send_admins = 0;
        send_other = 0;
	if(isopa(host) || isadmin(channel, host)) {
                send_lamers = 0;
                send_ops = 1;
                send_admins = 1;
        }
        if(isop(channel, host)) {
                send_lamers = 0;
                send_ops = 1;
        }
        if(hasuserflags(channel, host, "d") || hasuserflags(channel, host, "f")) {
                send_lamers = 0;
                send_other = 1;
        }
        a = this->adverts;
        while(a != NULL) {
                if(!strcmp(a->type, "lamers") && send_lamers) {
                        sendreply(nick, 0, 0, 0, a->message);
                }
                if(!strcmp(a->type, "ops") && send_ops) {
                        sendreply(nick, 0, 0, 0, a->message);
                }
                if(!strcmp(a->type, "admins") && send_admins) {
                        sendreply(nick, 0, 0, 0, a->message);
                }
                if(!strcmp(a->type, "other") && send_other) {
                        sendreply(nick, 0, 0, 0, a->message);
                }
                a = a->next;
        }
}

void quit(void)
{
        char stringbuffer[STRINGLEN + 1];
	
	if(mystate->current_server == NULL || mystate->current_server->registered != OER_REGISTERCONNECTION_STATUS_DONE) {
		close(mystate->sockfd);
		exit(EXIT_SUCCESS);
	}
	snprintf(stringbuffer, STRINGLEN, "QUIT :%s\n", mystate->signoff);
	addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
	mystate->quitting = 1;
}

int uptime(time_t *uptime, time_t *idle)
{
        float this_uptime;
        float this_idle;
	FILE *fp;
        char stringbuffer[STRINGLEN + 1];

	/* read uptime & idle from /proc */
        if((fp = fopen("/proc/uptime", "r")) == NULL) {
		return 0;
	}
        while(fgets(stringbuffer, STRINGLEN, fp) != NULL) {
                sscanf(stringbuffer, "%f %f", &this_uptime, &this_idle);
        }
	fclose(fp);
	*uptime = this_uptime;
	*idle = this_idle;
	return 1;
}

int delserver(char *serverhost, int serverport, int servermodes, int pingfrequency, int protected_ircops, int linenoise)
{
	struct server *s;
	struct server *s2;

	/* find & remove server */
	s = mystate->servers;
        s2 = s;
        while(s != NULL) {
                s2 = s;
                if(!strcasecmp(s->serverhost, serverhost) && s->serverport == serverport && s->servermodes == servermodes && s->pingfrequency == pingfrequency && s->protected_ircops == protected_ircops && s->linenoise == linenoise) {
			break;
                }
                s = s2->next;
        }
	if(s == NULL) {
		return 0;
	}
	if(s == mystate->current_server) {
		/* we won't remove the current server */
		return 0;
	}
	/* adjust lists */
	if(s->prev == NULL) {
		/* first mask in list */
		mystate->servers = s->next;
		/* ... check if also last */
		if(s->next != NULL) {
			s->next->prev = NULL;
		}
	}
	if(s->next == NULL) {
		/* last server in list */
		/* ... check also if the only one */
		if(s->prev != NULL) {
			s->prev->next = NULL;
		}
	}
	if(s->prev != NULL && s->next != NULL) {
		/* between 2 or more servers */
		s->prev->next = s->next;
		s->next->prev = s->prev;
	}
	free(s);
	return 1;
}

int delnickbk(char *channel, char *mask)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	/* find & remove mask */
	ms = this->nickbks;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			break;
		}
		ms = ms2->next;
	}
	if(ms == NULL) {
		return 0;
	}
	/* adjust lists */
	if(ms->prev == NULL) {
		/* first mask in list */
		this->nickbks = ms->next;
		/* ... check if also last */
		if(ms->next != NULL) {
			ms->next->prev = NULL;
		}
	}
	if(ms->next == NULL) {
		/* last mask in list */
		/* ... check also if the only one */
		if(ms->prev != NULL) {
				ms->prev->next = NULL;
		}
	}
	if(ms->prev != NULL && ms->next != NULL) {
		/* between 2 or more masks */
		ms->prev->next = ms->next;
		ms->next->prev = ms->prev;
	}
	free(ms->mask);
	free(ms->optstring);
	free(ms);
	return 1;
}

int delwordbk(char *channel, char *mask) 
{
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	/* find & remove mask */
	ms = this->wordbks;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			break;
		}
		ms = ms2->next;
	}
	if(ms == NULL) {
		return 0;
	}
	/* adjust lists */
	if(ms->prev == NULL) {
		/* first mask in list */
		this->wordbks = ms->next;
		/* ... check if also last */
		if(ms->next != NULL) {
			ms->next->prev = NULL;
		}
	}
	if(ms->next == NULL) {
		/* last mask in list */
		/* ... check also if the only one */
		if(ms->prev != NULL) {
			ms->prev->next = NULL;
		}
	}
	if(ms->prev != NULL && ms->next != NULL) {
		/* between 2 or more masks */
		ms->prev->next = ms->next;
		ms->next->prev = ms->prev;
	}
	free(ms->mask);
	free(ms->optstring);
	free(ms);
	return 1;
}

int getondiskmsgcount(char *channel, char *nick)
{
	int total;
	MYSQL_RES *result;
	char safe_name[CHANLEN + 1];

	oer_debug(OER_DEBUG_INFO, "getondiskmsgcount->getting message count for %s user %s\n", channel, nick);
	if(!oer_doquery("getondiskmsgcount", OER_DEBUG_INFO, "SELECT twhen, nick, hostmask, message FROM last_%s WHERE nick = '%s'", mysqldbname(channel, safe_name, CHANLEN), nick)) {
		return -1;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "getondiskmsgcount->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
		return -1;
	}
	total = mysql_num_rows(result);
	oer_debug(OER_DEBUG_INFO, "getondiskmsgcount->returning %d\n", total);
	mysql_free_result(result);
	return total;
}

int getondiskjoincount(char *channel, char *nick)
{
	int total;
	MYSQL_RES *result;
	char safe_name[CHANLEN + 1];

	oer_debug(OER_DEBUG_INFO, "getondiskjoincount->getting join count for %s user %s\n", channel, nick);
	if(!oer_doquery("getondiskmsgcount", OER_DEBUG_INFO, "SELECT twhen, nick, hostmask FROM seen_%s WHERE nick = '%s'", mysqldbname(channel, safe_name, CHANLEN), nick)) {
		return -1;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "getondiskjoincount->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
		return -1;
	}
	total = mysql_num_rows(result);
	oer_debug(OER_DEBUG_INFO, "getondiskjoincount->returning %d\n", total);
	mysql_free_result(result);
	return total;
}

int getrandommsg(char *channel, char *nick, int nicklen, char *msgstore, int msgstorelen, int retall)
{
	int total;
	int random;
	MYSQL_RES *result;
        MYSQL_ROW row;
	char safe_name[CHANLEN + 1];

	oer_debug(OER_DEBUG_INFO, "getrandommsg->getting random message for %s user %s\n", channel, nick);
	if(!oer_doquery("getrandommsg", OER_DEBUG_INFO, "SELECT twhen, nick, hostmask, message FROM last_%s WHERE nick = '%s'", mysqldbname(channel, safe_name, CHANLEN), nick)) {
		return -1;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "getrandommsg->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
		return -1;
	}
	if((total = mysql_num_rows(result)) <= 0) {
		oer_debug(OER_DEBUG_INFO, "getrandommsg->no messages for %s user %s\n", channel, nick);
		mysql_free_result(result);
		return -1;
	}
	oer_debug(OER_DEBUG_INFO, "getrandommsg->user has %d message(s)\n", total);
	random = getrandom(total) - 1;
	mysql_data_seek(result, random);
	row = mysql_fetch_row(result);
	if((strlen(row[3]) < OER_QUOTE_MIN_LENGTH || strlen(row[3]) > OER_QUOTE_MAX_LENGTH) && !retall) {
		mysql_free_result(result);
		return -1;
	}
	strncpy(nick, row[1], nicklen);
	strncpy(msgstore, row[3], msgstorelen);
	oer_debug(OER_DEBUG_INFO, "getrandommsg->returning message %d\n", random);
	mysql_free_result(result);
	return 1;
}

void showlast(char *to, int tochan, char *channel, char *mask)
{
	time_t ts;
	MYSQL_RES *result;
        MYSQL_ROW row;
	char message[HUGESTRINGLEN + 1];
	char outstring[HUGESTRINGLEN + 1];
	char safe_name[CHANLEN + 1];
	char nick_match[NICKLEN + 1];
	char timestamp[STRINGLEN + 1];

	if(mask != NULL) {
		strncpy(nick_match, mask, NICKLEN);
	} else {
		strncpy(nick_match, "%", NICKLEN);
	}
	oer_debug(OER_DEBUG_INFO, "showlast->channel %s for mask %s\n", channel, mysqlmatch(nick_match));
	if(!oer_doquery("showlast", OER_DEBUG_INFO, "SELECT twhen, nick, hostmask, message FROM last_%s WHERE nick LIKE '%s' ORDER BY 1 DESC LIMIT %d", mysqldbname(channel, safe_name, CHANLEN), nick_match, OER_LASTS)) {
		return;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "showlast->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
		return;
	}
	if(!mysql_num_rows(result)) {
		oer_debug(OER_DEBUG_FATAL, "showlast->no last rows for channel %s mask %s\n", channel, (mask == NULL) ? "(null)" : mask);
		mysql_free_result(result);
		return;
	}
	while((row = mysql_fetch_row(result))) {
		if(strlen(row[3]) > OER_LAST_MAX_LENGTH) {
			strncpy(outstring, row[3], OER_LAST_MAX_LENGTH);
			snprintf(message, HUGESTRINGLEN, "%s (truncated)", outstring);
		} else {
			strncpy(message, row[3], HUGESTRINGLEN);
		}
		tzset();
		ts = atol(row[0]);
		snprintf(timestamp, STRINGLEN, "%s", ctime(&ts));
		striplf(timestamp);
		snprintf(outstring, HUGESTRINGLEN, "%s (%s, %s, %s %s %s)", message, row[1], row[2], timestamp, tzname[0], tzname[1]);
		sendreply(to, tochan, 0, 0, outstring);
	}
	mysql_free_result(result);
}

void updatelast(char *channel, char *nick, char *host, char *message)
{
	char safe_name[CHANLEN + 1];
	char safe_nick[NICKLEN + 1];
	char safe_message[READ_BUFFER_LENGTH + 1];

	if((strstr(mystate->state, "+ro") != NULL) || (strstr(mystate->state, "-LS") != NULL)) {
		return;
	}
	oer_debug(OER_DEBUG_INFO, "updatelast->updating %s last information at %lu for %s!%s\n", channel, mystate->now, nick, host);
	if(!oer_doquery("updatelast", OER_DEBUG_FLOOD, "INSERT INTO last_%s VALUES (%lu, '%s', '%s', '%s')", mysqldbname(channel, safe_name, CHANLEN), mystate->now, mysqlsafestr(nick, safe_nick, NICKLEN), host, mysqlsafestr(message, safe_message, READ_BUFFER_LENGTH))) {
		return;
	}
}

void showseen(char *to, int tochan, char *channel, char *mask)
{
	time_t ts;
	MYSQL_RES *result;
        MYSQL_ROW row;
	char outstring[HUGESTRINGLEN + 1];
	char safe_name[CHANLEN + 1];
	char nick_match[NICKLEN + 1];
	char timestamp[STRINGLEN + 1];

	if(mask != NULL) {
		strncpy(nick_match, mask, NICKLEN);
	} else {
		strncpy(nick_match, "%", NICKLEN);
	}
	oer_debug(OER_DEBUG_INFO, "showseen->channel %s for mask %s\n", channel, mysqlmatch(nick_match));
	if(!oer_doquery("showseen", OER_DEBUG_INFO, "SELECT twhen, nick, hostmask FROM seen_%s WHERE nick LIKE '%s' ORDER BY 1 DESC LIMIT %d", mysqldbname(channel, safe_name, CHANLEN), nick_match, OER_SEEN)) {
		return;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "showseen->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
		return;
	}
	if(!mysql_num_rows(result)) {
		oer_debug(OER_DEBUG_FATAL, "showseen->no last rows for channel %s mask %s\n", channel, (mask == NULL) ? "(null)" : mask);
		mysql_free_result(result);
		return;
	}
	while((row = mysql_fetch_row(result))) {
		tzset();
		ts = atol(row[0]);
		snprintf(timestamp, STRINGLEN, "%s", ctime(&ts));
		striplf(timestamp);
                snprintf(outstring, HUGESTRINGLEN, "I saw %s with host %s last %s %s %s", row[1], row[2], timestamp, tzname[0], tzname[1]);
		sendreply(to, tochan, 0, 0, outstring);
	}
	mysql_free_result(result);
}

void updateseen(char *channel, char *nick, char *host)
{
	char safe_name[CHANLEN + 1];
	char safe_nick[NICKLEN + 1];

	if((strstr(mystate->state, "+ro") != NULL) || (strstr(mystate->state, "-LS") != NULL)) {
		return;
	}
	oer_debug(OER_DEBUG_INFO, "updateseen->updating %s seen information at %lu for %s!%s\n", channel, mystate->now, nick, host);
	if(!oer_doquery("updateseen", OER_DEBUG_FLOOD, "INSERT INTO seen_%s VALUES (%lu, '%s', '%s')", mysqldbname(channel, safe_name, CHANLEN), mystate->now, mysqlsafestr(nick, safe_nick, NICKLEN), host)) {
		return;
	}
}

void nstats(char *to, int tochan, char *channel, char *nick)
{
	int msgs;
	int joins;
	char outstring[BIGSTRINGLEN + 1];

	msgs = getondiskmsgcount(channel, nick);
	joins = getondiskjoincount(channel, nick);
	if(!msgs && !joins) {
		return;
	}
	snprintf(outstring, BIGSTRINGLEN, "I have seen %d joins and %d messages from %s on channel %s", joins, msgs, nick, channel);
	sendreply(to, tochan, 0, 0, outstring);
}

int checkforpartrejoin(char *channel, char *nick, char *host)
{
	int parts;
        char ban[HOSTLEN + 1];
        char outstring[STRINGLEN + 1];
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	if(!haschanflags(channel, "r")) {
                return 0;
        }
	if(isq(nick)) {
                return 0;
        }
        if(isadmin(channel, host)) {
                return 0;
        }
        if(isop(channel, host)) {
                return 0;
        }
        if(isopnow(channel, nick)) {
                return 0;
        }
	if(haschanflags(channel, "F") && hasuserflags(channel, host, "f")) {
		return 0;
	}
	parts = partcount(channel, nick, host);
        oer_debug(OER_DEBUG_INFO, "checkforpartrejoin->credited parts on %s for %s!%s: %d\n", channel, nick, host, parts);
        if(parts < OER_ALLOWED_PARTS) {
                return 0;
        }
        strncpy(ban, host, HOSTLEN);
        if(safeban(ban) == NULL) {
                return 0;
        }
        addnewmm(channel, mystate->now, "+b", ban);
        snprintf(outstring, STRINGLEN, "KICK %s %s :part-rejoin protection triggered, come back when you have made up your mind\n", channel, nick);
        addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
        addnewmm(channel, mystate->now + this->banvars.part_rejoin, "-b", ban);
        return 1;
}

int checkforautorejoin(char *channel, char *nick, char *host)
{
        char ban[HOSTLEN + 1];
        char outstring[STRINGLEN + 1];
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
        if(!haschanflags(channel, "r")) {
                return 0;
        }
	if(isq(nick)) {
                return 0;
        }
        if(isadmin(channel, host)) {
                return 0;
        }
        if(isop(channel, host)) {
                return 0;
        }
        if(isopnow(channel, nick)) {
                return 0;
        }
	if(haschanflags(channel, "F") && hasuserflags(channel, host, "f")) {
		return 0;
	}
        if(lastoff(channel, nick, host) > OER_AUTO_REJOIN_TIME) {
                return 0;
        }
        strncpy(ban, host, HOSTLEN);
        if(safeban(ban) == NULL) {
                return 0;
        }
        addnewmm(channel, mystate->now, "+b", ban);
        snprintf(outstring, STRINGLEN, "KICK %s %s :auto-rejoin, your prize: a %d second ban\n", channel, nick, this->banvars.auto_rejoin);
        addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
        addnewmm(channel, mystate->now + this->banvars.auto_rejoin, "-b", ban);
        return 1;
}

int checkforansi(char *channel, char *nick, char *host, char *message)
{
        char outstring[STRINGLEN + 1];

        if(!haschanflags(channel, "a")) {
                return 0;
        }
	if(isq(nick)) {
                return 0;
        }
        if(isadmin(channel, host)) {
                return 0;
        }
        if(isop(channel, host)) {
                return 0;
        }
        if(isopnow(channel, nick)) {
                return 0;
        }
	if(haschanflags(channel, "F") && hasuserflags(channel, host, "f")) {
		return 0;
	}
        if(!isansi(message)) {
                return 0;
        }
        oer_debug(OER_DEBUG_INFO, "checkforansi->ansi/control-codes detected on %s from %s\n", channel, nick);
	snprintf(outstring, STRINGLEN, "KICK %s %s :mIRC or non-standard control codes not permitted on this channel\n", channel, nick);
        addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
        return 1;
}

int ismoderated(char *channel)
{
	int moderated;
	char *mode;
	char *p;
	char *q;
	
	if((mode = getchanmode(channel)) == NULL) {
		return 0;
	}
	moderated = 0;
	if((p = index(mode, 'm')) != NULL) {
		for(q = mode; q != p; q++) {
			if(*q == '+') {
				moderated = 1;
			}
			if(*q == '-') {
				moderated = 0;
			}
		}
	}
	return moderated;
}

int checkforflood(char *channel, char *nick, char *host, char *message)
{
        int floodtype;
        char ban[HOSTLEN + 1];
        char outstring[STRINGLEN + 1];
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
        if(!haschanflags(channel, "f")) {
                return 0;
        }
	if(isq(nick)) {
                return 0;
        }
        if(isadmin(channel, host)) {
                return 0;
        }
	if(!haschanflags(channel, "G")) {
		if(isop(channel, host)) {
			return 0;
		}
		if(isopnow(channel, nick)) {
			return 0;
		}
		if(haschanflags(channel, "F") && hasuserflags(channel, host, "f")) {
			return 0;
		}
	}
        floodtype = isflood(channel, nick, host, message);
        if(floodtype != OER_PUBMSG_FLOOD_NORMAL && floodtype != OER_PUBMSG_FLOOD_REPEAT) {
                return 0;
        }
        strncpy(ban, host, HOSTLEN);
        if(safeban(ban) == NULL) {
                return 0;
        }
        switch(floodtype) {
        case OER_PUBMSG_FLOOD_NORMAL:
		if(isvoicenow(channel, nick) && ismoderated(channel)) {
			addnewmm(channel, mystate->now, "-v", nick);
			addnewmm(channel, mystate->now + this->banvars.public_flood, "+v", nick);
		}
		addnewmm(channel, mystate->now, "+b", ban);
                snprintf(outstring, STRINGLEN, "flood protection triggered, you can talk again in %d seconds", this->banvars.public_flood);
		sendreply(nick, 0, 0, 1, outstring);
                addnewmm(channel, mystate->now + this->banvars.public_flood, "-b", ban);
                clearflood(channel, nick, host);
                return 1;
        case OER_PUBMSG_FLOOD_REPEAT:
                addnewmm(channel, mystate->now, "+b", ban);
                snprintf(outstring, STRINGLEN, "KICK %s %s :bad choice of channel for your repeating fetish\n", channel, nick);
                addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
                addnewmm(channel, mystate->now + this->banvars.public_flood_repeat, "-b", ban);
		changetobek(channel, nick, 1);
                clearflood(channel, nick, host);
                return 1;
        case OER_PUBMSG_FLOOD_NONE:
                return 0;
        }
        return 0;
}

int checkforbadword(char *channel, char *nick, char *host, char *message)
{
        char ban[HOSTLEN + 1];
        char outstring[STRINGLEN + 1];
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
        if(!haschanflags(channel, "w")) {
                return 0;
        }
	if(isq(nick)) {
                return 0;
        }
        if(isadmin(channel, host)) {
                return 0;
        }
        if(isop(channel, host)) {
                return 0;
        }
        if(isopnow(channel, nick)) {
                return 0;
        }
	if(haschanflags(channel, "F") && hasuserflags(channel, host, "f")) {
		return 0;
	}
        if(!iswordbk(channel, message)) {
                return 0;
        }
        strncpy(ban, host, HOSTLEN);
        if(safeban(ban) == NULL) {
                return 0;
        }
        addnewmm(channel, mystate->now, "+b", ban);
        snprintf(outstring, STRINGLEN, "KICK %s %s :word ban-kick triggered, have a nice life...\n", channel, nick);
        addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
        addnewmm(channel, mystate->now + this->banvars.bad_word, "-b", ban);
        return 1;
}

int checkforbadnick(char *channel, char *nick, char *host)
{
	char *reason;
        char ban[HOSTLEN + 1];
        char outstring[WRITE_BUFFER_LENGTH + 1];
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
        if(!haschanflags(channel, "n")) {
                return 0;
        }
	if(isq(nick)) {
                return 0;
        }
        if(isadmin(channel, host)) {
                return 0;
        }
        if(isop(channel, host)) {
                return 0;
        }
        if(isopnow(channel, nick)) {
                return 0;
        }
	/* we don't allow friends to use prohibited nicks,
	   syncnickbks would kick them anyway */
	if((reason = isnickbk(channel, nick)) == NULL) {
                return 0;
        }
        strncpy(ban, host, HOSTLEN);
        if(safeban(ban) == NULL) {
                return 0;
        }
	if(gettobek(channel, nick)) {
		return 0;
	}
        addnewmm(channel, mystate->now, "+b", ban);
	/* if there was no ban reason, reason = nick */
	if(strcasecmp(nick, reason)) {
		snprintf(outstring, WRITE_BUFFER_LENGTH, "KICK %s %s :%s, reason: %s\n", channel, nick, DEFAULT_NICKBK_MESSAGE, reason);
	} else {
		snprintf(outstring, WRITE_BUFFER_LENGTH, "KICK %s %s :%s\n", channel, nick, DEFAULT_NICKBK_MESSAGE);
	}
        addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
        addnewmm(channel, mystate->now + this->banvars.bad_nick, "-b", ban);
        return 1;
}

void joinchannels()
{
        char stringbuffer[STRINGLEN + 1];
        struct channel *this;

        for(this = mystate->channels; this != NULL; this = this->next) {
                if(!this->joined && !this->joining && (mystate->now >= this->rejoin_at) && !haschanflags(this->name, "!")) {
			break;
		}
	}
	if(this == NULL) {
		return;
	}
	/* set flags indicating we are joining this channel */
	this->joined = 0;
	this->joining = 1;
	this->rejoin_at = 0;
	this->last_quote = 0;
	this->synced = 0;
	if(this->haskey) {
		snprintf(stringbuffer, STRINGLEN, "JOIN %s %s\n", this->name, this->key);
	} else {
		snprintf(stringbuffer, STRINGLEN, "JOIN %s\n", this->name);
	}
	addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
}

void processenv()
{
	int total;
	time_t newts;
        struct channel *this;
	struct botuser *admin;
	struct botuser *user;
        char stringbuffer[STRINGLEN + 1];
	MYSQL_RES *result;
        MYSQL_ROW row;

        /* check if connected */
        if(mystate->current_server == NULL) {
                return;
        }
        /* check if registered */
        if(mystate->current_server->registered != OER_REGISTERCONNECTION_STATUS_DONE) {
                return;
        }
	/* check the admin timestamp */
	if(!oer_doquery("processenv", OER_DEBUG_FLOOD, "SELECT twhen FROM timestamps WHERE ttype = 'admins' AND ident = '%s'", mystate->usersfrom)) {
		return;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "processenv->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
		return;
	}
	if((total = mysql_num_rows(result))) {
		row = mysql_fetch_row(result);
		newts = atol(row[0]);
		if(newts > mystate->admints) {
			oer_debug(OER_DEBUG_INFO, "processenv->database has a newer copy of admins, reloading\n");
			for(admin = mystate->admins; admin != NULL; admin = admin->next) {
				deladmin(admin->handle, 1);
			}
			if(!getadmins()) {
				oer_debug(OER_DEBUG_INFO, "processenv->couldn't load admins\n");
			}
		}
	}
	mysql_free_result(result);
	/* check the user timestamp */
	for(this = mystate->channels; this != NULL; this = this->next) {
		if(!oer_doquery("processenv", OER_DEBUG_FLOOD, "SELECT twhen FROM timestamps WHERE ttype = 'users' AND tchannel = '%s' AND ident = '%s'", this->name, mystate->usersfrom)) {
			return;
		}
		if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
			oer_debug(OER_DEBUG_FATAL, "processenv->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
			return;
		}
		if((total = mysql_num_rows(result))) {
			row = mysql_fetch_row(result);
			newts = atol(row[0]);
			if(newts > this->userts) {
				oer_debug(OER_DEBUG_INFO, "processenv->database has a newer copy of %s users, reloading\n", this->name);
				/* purge channel users then reload */
				for(user = this->users; user != NULL; user = user->next) {
					deluser(this->name, user->handle);
				}
				if(!getusers(this->name)) {
					oer_debug(OER_DEBUG_INFO, "processenv->couldn't load users\n");
				}
			}
		}
		mysql_free_result(result);
	}
        if(mystate->netjoining && mystate->now < mystate->postnj_checks_at) {
		/* don't do any actions until it's safe */
		return;
	}
	if(mystate->netjoining && mystate->now >= mystate->postnj_checks_at) {
                oer_debug(OER_DEBUG_INFO, "processenv->processing post netjoin actions\n");
                for(this = mystate->channels; this != NULL; this = this->next) {
                        /* check for post net join */
                        if(this->joined && haschanflags(this->name, "p") && amiop(this->name)) {
                                /* do the post netjoin checks (ops, voices, permbans and nickbks) */
                                syncvoices(this->name);
                                syncops(this->name);
                                syncpermbans(this->name);
				syncnickbks(this->name);
                        }
                }
                oer_debug(OER_DEBUG_INFO, "processenv->end of netjoin\n");
		mystate->netjoining = 0;
                mystate->postnj_checks_at = 0;
        }
        /* check that all channels are synced */
        for(this = mystate->channels; this != NULL; this = this->next) {
		if(!this->synced && amiop(this->name)) {
			channelsync(this->name);
		}
	}
        /* check for unset channel-modes */
        for(this = mystate->channels; this != NULL; this = this->next) {
                if(amiop(this->name) && this->joined && this->setchanmode) {
			if(this->haskey) {
				snprintf(stringbuffer, STRINGLEN, "%sk %s", this->mode, this->key);
			} else {
				snprintf(stringbuffer, STRINGLEN, "%s", this->mode);
			}
			addnewmm(this->name, mystate->now, stringbuffer, "");
			this->setchanmode = 0;
                }
        }
	linenoise();
	checkstoned();
	joinchannels();
	syncuserhosts();
	processlock();
	setumode();
	setnick();
	settopic();
}

void channelsync(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	/* are we through with USERHOST queries? */
	if(!allhostsknown(this->name)) {
		return;
	}
	syncvoices(this->name);
	syncops(this->name);
	syncpermbans(this->name);
	syncnickbks(this->name);
	this->synced = 1;
}

void processlock()
{
	int nicks;
        char *nick;
        char outstring[BIGSTRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];
        char stringbuffer2[BIGSTRINGLEN + 1];
        struct channel *this;

	for(this = mystate->channels; this != NULL; this = this->next) {
		/* get any channel that we have joined & is locked */
                if(this->joined && this->locked.locked) {
                        break;
                }
        }
        if(this == NULL) {
                return;
        }
	if(this->locked.unlocked) {
		/* channel has been unlocked due to manual prevention */
		this->locked.locked = 0;
		return;
	}
	memset(&stringbuffer, 0, BIGSTRINGLEN + 1);
	memset(&stringbuffer2, 0, BIGSTRINGLEN + 1);
	nicks = 0;
	nick = NULL;
	while((nicks < OER_NICKS_PER_KICK) && ((nick = getlamer(this->name)) != NULL)) {
		strncat(stringbuffer, nick, BIGSTRINGLEN - strlen(stringbuffer));
		strncat(stringbuffer2, this->name, BIGSTRINGLEN - strlen(stringbuffer2));
		if((nicks + 1) < OER_NICKS_PER_KICK) {
			strncat(stringbuffer, ",", BIGSTRINGLEN - strlen(stringbuffer));
			strncat(stringbuffer2, ",", BIGSTRINGLEN - strlen(stringbuffer2));
		}
		nicks++;
        }
	if(nicks) {
                if(strlen(this->locked.reason)) {
			snprintf(outstring, BIGSTRINGLEN, "KICK %s %s :%s\n", stringbuffer2, stringbuffer, this->locked.reason);
		} else {
			snprintf(outstring, BIGSTRINGLEN, "KICK %s %s :locking channel\n", stringbuffer2, stringbuffer);
		}
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_KICK, outstring, this->name, NULL, NULL);
	}
	if(nick == NULL) {
		/* no more lamers, unlocking if auto */
		if(this->locked.auto_unlock) {
			/* this has to be a timed because of the way mmodes & timeds
			   are processed in the mainloop (we want the -i to appear
			   after all lamers have been kicked out, not before) */
			snprintf(outstring, BIGSTRINGLEN, "MODE %s -i\n", this->name);
			addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
			this->locked.locked = 0;
		}
	}
}

void syncvoices(char *channel)
{
	struct channel *this;
        struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
        for(cu = this->nicks; cu != NULL; cu = cu->next) {
                if(!cu->voice && hasuserflags(this->name, cu->host, "v")) {
                        addnewmm(this->name, mystate->now, "+v", cu->nick);
                }
		/* .. dynusers, let them have +v even if not logoned */
		if(!cu->voice && hasuserflags(this->name, cu->host, "dv")) {
                        addnewmm(this->name, mystate->now, "+v", cu->nick);
                }
        }
}

void syncops(char *channel)
{
	struct channel *this;
        struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
        for(cu = this->nicks; cu != NULL; cu = cu->next) {
		/* if not opped, give +o if op */
                if(!cu->chanop && isop(this->name, cu->host)) {
                        addnewmm(this->name, mystate->now, "+o", cu->nick);
			continue;
                }
		/* .. else take away +o if not op & channel has "u" flag */
		if(cu->chanop && haschanflags(this->name, "u") && !isallowedop(this->name, cu->nick)) {
                        addnewmm(this->name, mystate->now, "-o", cu->nick);
		}
        }
}

void syncpermbans(char *channel)
{
        MYSQL_RES *result;
        MYSQL_ROW row;

	if(!oer_doquery("syncpermbans", OER_DEBUG_INFO, "SELECT mask FROM permbans WHERE channel = '%s' AND ident = '%s'", channel, mystate->ident)) {
		return;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "syncpermbans->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return;
	}
	if(!mysql_num_rows(result)) {
		/* no permbans */
		mysql_free_result(result);
		return;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		/* bans are set each time, doing a query would be too heavy */
                addnewmm(channel, mystate->now, "+b", row[0]);
	}
	mysql_free_result(result);
}

void syncnickbks(char *channel)
{
	struct channel *this;
        struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(cu->host != NULL && !cu->tobek) {
			checkforbadnick(this->name, cu->nick, cu->host);
		}
	}
}

void setumode()
{
	char outstring[STRINGLEN + 1];

        if(mystate->newmode) {
		snprintf(outstring, STRINGLEN, "MODE %s %s\n", (mystate->use_alt_nick) ? mystate->altnick : mystate->nick, mystate->mode);
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
                mystate->newmode = 0;
        }
}

void setnick()
{
        char outstring[STRINGLEN + 1];

        if(mystate->newnick) {
                snprintf(outstring, STRINGLEN, "NICK %s\n", (mystate->use_alt_nick) ? mystate->altnick : mystate->nick);
                addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
                mystate->newnick = 0;
        }
}

void syncuserhosts()
{
	int nicks;
        char nick[NICKLEN + 1];
        char outstring[BIGSTRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];

	nicks = 0;
	memset(&stringbuffer, 0, BIGSTRINGLEN + 1);
	while((nicks < OER_NICKS_PER_USERHOST) && (getfirsthostless(nick) != NULL)) {
		sethostquerystatus(nick, 1);
		strncat(stringbuffer, nick, BIGSTRINGLEN - strlen(stringbuffer));
		if((nicks + 1) < OER_NICKS_PER_USERHOST) {
			strncat(stringbuffer, " ", BIGSTRINGLEN - strlen(stringbuffer));
		}
		nicks++;
        }
	if(!strlen(stringbuffer)) {
		return;
	}
        snprintf(outstring, BIGSTRINGLEN, "USERHOST %s\n", stringbuffer);
        addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
}

struct server *getserver()
{
        struct server *this;

	/* if admin specified a server, we'll take that no matter
	   what (if it exists, doh) */
	if(strlen(mystate->preferredserver) > 0) {
		for(this = mystate->servers; this != NULL; this = this->next) {
			if(!strcasecmp(this->serverhost, mystate->preferredserver)) {
				memset(mystate->preferredserver, 0, HOSTLEN + 1);
				return this;
			}
		}
	}
        for(this = mystate->servers; this != NULL; this = this->next) {
                if(this->used) {
                        /* this will prevent from us getting stuck
                           with no usable server */
                        this->used = 0;
			continue;
		}
		/* check if server is stoned and whether the stoned
                   time has been elapsed */
                if(!this->stoned) {
                        return this;
                }
                if(mystate->now >= (this->stoned + OER_SERVER_IS_STONED_FOR)) {
                        this->stoned = 0;
                        return this;
                }
        }
        return NULL;
}

void massmessage(char *from, char *message)
{
	int delay;
        char stringbuffer[WRITE_BUFFER_LENGTH + 1];
	struct channel *this;

	snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "notice from admin %s: %s", from, message);
	for(this = mystate->channels, delay = 0; this != NULL; this = this->next, delay++) {
		sendchannelnotice(this->name, delay, stringbuffer);
	}
}

void iwaskicked(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	this->rejoin_at = mystate->now + OER_DELAY_BETWEEN_REJOINS;
}

void initchannel(char *channel)
{
	struct channel *this;

        oer_debug(OER_DEBUG_INFO, "initchannel->initializing channel %s\n", channel);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	this->joined = 0;
	this->joining = 0;
	this->setchanmode = 0;
	this->rejoin_at = 0;
	this->last_quote = 0;
	this->i_am_op = 0;
	this->synced = 0;
	initjoins(this->name);
	initparts(this->name);
	initpubmsgs(this->name);
	initmmodes(this->name);
	memset(&this->locked, 0, sizeof(struct locked));
	initnicks(this->name);
}

void initall(void)
{
	struct channel *this;

	for(this = mystate->channels; this != NULL; this = this->next) {
		initchannel(this->name);
	}
}

void initmmodes(char *channel)
{
	struct modeline *mm;
	struct modeline *mm2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	mm = this->modelines;
	while(mm != NULL) {
		mm2 = mm->next;
		free(mm->mode);
		free(mm->target);
		free(mm);
		mm = mm2;
	}
	this->modelines = NULL;
}

void inittimeds()
{
	struct timed *tim;
	struct timed *tim2;

	tim = mystate->timeds;
	while(tim != NULL) {
		tim2 = tim->next;
		free(tim->irc_command);
		free(tim->optstring1);
		free(tim->optstring2);
		free(tim->optstring3);
		free(tim);
		tim = tim2;
	}
	mystate->timeds = NULL;
}

void initnicks(char *channel)
{
	struct chanuser *cu;
	struct chanuser *cu2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	cu = this->nicks;
	while(cu != NULL) {
		cu2 = cu->next;
		if(cu->host != NULL) {
			free(cu->host);
		}
		free(cu->nick);
		free(cu);
		cu = cu2;
	}
	this->nicks = NULL;
	this->nickcount = 0;
}

void initpubmsgs(char *channel)
{
	struct pubmsg *pm;
	struct pubmsg *pm2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	pm = this->pubmsgs;
	while(pm != NULL) {
		pm2 = pm->next;
		free(pm->message);
		free(pm->nick);
		free(pm->host);
		free(pm);
		pm = pm2;
	}
	this->pubmsgs = NULL;
}

void initparts(char *channel)
{
	struct part *p;
	struct part *p2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	p = this->parts;
	while(p != NULL) {
		p2 = p->next;
		free(p->nick);
		free(p->host);
		free(p);
		p = p2;
	}
	this->parts = NULL;
}

void initjoins(char *channel)
{
	struct join *j;
	struct join *j2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	j = this->joins;
	while(j != NULL) {
		j2 = j->next;
		free(j->nick);
		free(j->host);
		free(j);
		j = j2;
	}
	this->joins = NULL;
}

void initnickbks(char *channel)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	ms = this->nickbks;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms->next;
		free(ms);
		ms = ms2;
	}
	this->nickbks = NULL;
}

void initwordbks(char *channel)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	ms = this->wordbks;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms->next;
		free(ms);
		ms = ms2;
	}
	this->wordbks = NULL;
}

void initusers(char *channel)
{
	struct botuser *u;
	struct botuser *u2;
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	u = this->users;
	while(u != NULL) {
		u2 = u->next;
		ms = u->firstmask;
		while(ms != NULL) {
			ms2 = ms->next;
			free(ms->mask);
			free(ms);
			ms = ms2;
		}
		free(u);
		u = u2;
	}
	this->users = NULL;
}

struct state *emptystate()
{
	struct state *state;

	if((state = (struct state *) malloc(sizeof(struct state))) == NULL) {
		return NULL;
	}
	memset(state->config, 0, TINYSTRINGLEN + 1);
	memset(state->nick, 0, NICKLEN + 1);
	memset(state->altnick, 0, NICKLEN + 1);
	memset(state->user, 0, USERLEN + 1);
	memset(state->host, 0, HOSTLEN + 1);
	memset(state->mode, 0, CHANLEN + 1);
	memset(state->signoff, 0, STRINGLEN + 1);
	memset(state->preferredserver, 0, HOSTLEN + 1);
	memset(state->realname, 0, STRINGLEN + 1);
	memset(state->flags, 0, FLAGLEN + 1);
	memset(state->state, 0, STRINGLEN + 1);
	memset(state->ident, 0, STRINGLEN + 1);
	memset(state->usersfrom, 0, STRINGLEN + 1);
	memset(state->prefix, 0, STRINGLEN + 1);
	memset(&state->mysqldb, 0, sizeof(struct mysqldb));
        if(mysql_init(&state->mysqldb.mysqldbconn) == NULL) {
                oer_debug(OER_DEBUG_FATAL, "emptystate->mysql_init() failed\n");
                return NULL;
        }
	state->netjoining = 0;
	state->reconnect = 0;
	state->now = time(NULL);
	state->last_actions = 0;
	state->startup = time(NULL);
	state->postnj_checks_at = 0;
	state->admints = 0;
	state->sockfd = 0;
	state->loopforever = 0;
	state->customuser = 0;
	state->vhost = 0;
	state->use_alt_nick = 0;
	state->newnick = 0;
	state->newmode = 0;
	state->bailout = 0;
	state->quitting = 0;
	state->trusted = NULL;
	state->admins = NULL;
	state->channels = NULL;
	state->timeds = NULL;
	state->current_server = NULL;
	state->servers = NULL;
	return state;
}

int topiccount(char *channel)
{
	int topics;
	MYSQL_RES *result;

	/* get topic count for channel */
        if(!oer_doquery("topiccount", OER_DEBUG_INFO, "SELECT message FROM topics WHERE channel = '%s' AND ident = '%s'", channel, mystate->ident)) {
                return 0;
        }
        if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
                oer_debug(OER_DEBUG_FATAL, "topiccount->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
        }
	topics = mysql_num_rows(result);
	mysql_free_result(result);
	return topics;
}

int settopic()
{
	int topics;
	int topic;
        struct channel *this;
	MYSQL_RES *result;
        MYSQL_ROW row;
        char stringbuffer[WRITE_BUFFER_LENGTH + 1];

	for(this = mystate->channels; this != NULL; this = this->next) {
                if(this->joined && this->topic_change) {
                        break;
                }
        }
        if(this == NULL) {
                return 0;
        }
	/* get topics for channel */
        if(!oer_doquery("settopic", OER_DEBUG_INFO, "SELECT message FROM topics WHERE channel = '%s' AND ident = '%s' ORDER BY pos", this->name, mystate->ident)) {
                return 0;
        }
        if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
                oer_debug(OER_DEBUG_FATAL, "settopic->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
        }
        if(!(topics = mysql_num_rows(result))) {
		/* no topic for channel */
		this->topic_change = 0;
		/* check if topic needs resetting */
		if(this->topic_reset) {
			snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "TOPIC %s :\n", this->name);
			addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
			this->topic_reset = 0;
		}
		mysql_free_result(result);
		return 0;
	}
	snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "TOPIC %s :", this->name);
	topic = 0;
	while((row = mysql_fetch_row(result)) != NULL) {
		if(topic) {
			strncat(stringbuffer, " | ", WRITE_BUFFER_LENGTH - strlen(stringbuffer) - 1);
		}
		strncat(stringbuffer, row[0], WRITE_BUFFER_LENGTH - strlen(stringbuffer) - 1);
		topic++;
	}
	strncat(stringbuffer, "\n", WRITE_BUFFER_LENGTH - strlen(stringbuffer));
        mysql_free_result(result);
	this->topic_change = 0;
	addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
	return 1;
}

int setnewtopic(char *channel, char *setby, char *topic)
{
	deltopics(channel);
	if(!insertnewtopic(channel, setby, topic, 1)) {
		return 0;
	}
	return 1;
}

int addnewtopic(char *channel, char *setby, char *topic)
{
	int topics;

	topics = topiccount(channel);
	if(!insertnewtopic(channel, setby, topic, topics + 1)) {
		return 0;
	}
	return 1;
}

int insertnewtopic(char *channel, char *setby, char *topic, int pos)
{
	int topics;
	struct channel *this;
	char safe_topic[OER_TOPICLEN + 1];

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	topics = topiccount(this->name);
	if(pos < 1 || pos > OER_TOPICS || pos > (topics + 1)) {
		return 0;
	}
	if(strstr(mystate->state, "+ro") == NULL) {
		/* first increase all >= pos by 1 */
		if(!oer_doquery("insertnewtopic", OER_DEBUG_INFO, "UPDATE topics SET pos = pos + 1 WHERE channel = '%s' AND pos >= %d AND ident = '%s'", this->name, pos, mystate->ident)) {
			return 0;
		}
		/* then insert the new topic */
		if(!oer_doquery("insertnewtopic", OER_DEBUG_INFO, "INSERT INTO topics VALUES ('%s', %d, %lu, '%s', '%s', '%s')", this->name, pos, mystate->now, setby, mysqlsafestr(topic, safe_topic, OER_TOPICLEN), mystate->ident)) {
			return 0;
		}
	}
	this->topic_change = 1;
	return 1;
}

int edittopic(char *channel, char *setby, char *topic, int pos)
{
	int topics;
	struct channel *this;
	char safe_topic[OER_TOPICLEN + 1];

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	topics = topiccount(channel);
	if(pos < 1 || pos > OER_TOPICS || pos > topics) {
		return 0;
	}
	if(strstr(mystate->state, "+ro") == NULL) {
		if(!oer_doquery("edittopic", OER_DEBUG_INFO, "UPDATE topics SET twhen = %lu, setby = '%s', message = '%s' WHERE channel = '%s' AND pos = %d AND ident = '%s'", mystate->now, setby, mysqlsafestr(topic, safe_topic, OER_TOPICLEN), this->name, pos, mystate->ident)) {
			return 0;
		}
	}
	this->topic_change = 1;
	return 1;
}

int gettopic(char *channel, char *topic)
{
	int i;
	int k;
	int length;
	char thistopic[OER_TOPICLEN + 1];

	deltopics(channel);
	for(i = 0, k = 0, length = strlen(topic); i < length; i++) {
		if(topic[i] == ' ' && topic[i + 1] == '|' && topic[i + 2] == ' ') {
			thistopic[k++] = '\0';
			if(!addnewtopic(channel, "gettopic()", thistopic)) {
				return 0;
			}
			k = 0;
			i += 2;
		} else {
			thistopic[k++] = topic[i];
		}
	}
	if(k > 0) {
		thistopic[k++] = '\0';
		if(!addnewtopic(channel, "gettopic()", thistopic)) {
			return 0;
		}
	}
	return 1;
}

int listtopic(char *to, int tochan, char *channel)
{
	int topics;
        struct channel *this;
        char stringbuffer[BIGSTRINGLEN + 1];
	time_t origts;
        char ts[STRINGLEN + 1];
	MYSQL_RES *result;
        MYSQL_ROW row;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	/* get topics for channel */
        if(!oer_doquery("listtopic", OER_DEBUG_INFO, "SELECT pos, twhen, setby, message FROM topics WHERE channel = '%s' AND ident = '%s' ORDER BY pos", this->name, mystate->ident)) {
                return 0;
        }
        if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
                oer_debug(OER_DEBUG_FATAL, "listtopic->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
        }
        if(!(topics = mysql_num_rows(result))) {
		/* no topics for channel */
		mysql_free_result(result);
		return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		origts = atol(row[1]);
		strncpy(ts, ctime(&origts), STRINGLEN);
		striplf(ts);
		if(!strcasecmp(row[2], "gettopic()")) {
			tzset();
			snprintf(stringbuffer, BIGSTRINGLEN, "Topic #%s: %s (%s %s %s)", row[0], row[3], ts, tzname[0], tzname[1]);
		} else {
			tzset();
			snprintf(stringbuffer, BIGSTRINGLEN, "Topic #%s: %s (%s %s %s, %s)", row[0], row[3], ts, tzname[0], tzname[1], row[2]);
		}
		sendreply(to, tochan, 0, 0, stringbuffer);
	}
        mysql_free_result(result);
	return 1;
}

int deltopic(char *channel, int nth, char *deleted)
{
	int topics;
        struct channel *this;
	MYSQL_RES *result;
        MYSQL_ROW row;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	topics = topiccount(this->name);
	if(nth < 1 || nth > OER_TOPICS || nth > topics) {
		return 0;
	}
	if(topics == 1 && nth == 1) {
		/* last topic will be deleted, reset topic */
		this->topic_reset = 1;
	}
	/* get topic nth for channel */
        if(!oer_doquery("deltopic", OER_DEBUG_INFO, "SELECT message FROM topics WHERE channel = '%s' AND pos = %d AND ident = '%s'", this->name, nth, mystate->ident)) {
                return 0;
        }
        if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
                oer_debug(OER_DEBUG_FATAL, "deltopic->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
        }
        if(!(topics = mysql_num_rows(result))) {
		/* no nth topic */
		mysql_free_result(result);
		return 0;
	}
	row = mysql_fetch_row(result);
	strncpy(deleted, row[0], OER_TOPICLEN);
	mysql_free_result(result);
	if(strstr(mystate->state, "+ro") == NULL) {
		if(!oer_doquery("deltopic", OER_DEBUG_INFO, "DELETE FROM topics WHERE channel = '%s' AND pos = %d AND ident = '%s'", this->name, nth, mystate->ident)) {
			return 0;
		}
		if(!oer_doquery("deltopic", OER_DEBUG_INFO, "UPDATE topics SET pos = pos - 1 WHERE channel = '%s' AND pos > %d AND ident = '%s'", this->name, nth, mystate->ident)) {
			return 0;
		}
	}
	this->topic_change = 1;
	return 1;
}

int deltopics(char *channel)
{
        struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	if(strstr(mystate->state, "+ro") == NULL) {
		if(!oer_doquery("deltopic", OER_DEBUG_INFO, "DELETE FROM topics WHERE channel = '%s' AND ident = '%s'", this->name, mystate->ident)) {
			return 0;
		}
	}
	this->topic_change = 1;
	return 1;
}

int refreshtopic(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	this->topic_change = 1;
	return 1;
}

int swaptopic(char *channel, int x, int y)
{
	int topics;
        struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	topics = topiccount(this->name);
	if(x > topics || x < 1 || y > topics || y < 1 || x == y) {
		return 0;
	}
	if(strstr(mystate->state, "+ro") == NULL) {
		if(!oer_doquery("swaptopic", OER_DEBUG_INFO, "UPDATE topics SET pos = %d WHERE channel = '%s' AND pos = %d AND ident = '%s'", OER_TOPICS + 1, this->name, x, mystate->ident)) {
			return 0;
		}
	}
	if(strstr(mystate->state, "+ro") == NULL) {
		if(!oer_doquery("swaptopic", OER_DEBUG_INFO, "UPDATE topics SET pos = %d WHERE channel = '%s' AND pos = %d AND ident = '%s'", x, this->name, y, mystate->ident)) {
			return 0;
		}
	}
	if(strstr(mystate->state, "+ro") == NULL) {
		if(!oer_doquery("swaptopic", OER_DEBUG_INFO, "UPDATE topics SET pos = %d WHERE channel = '%s' AND pos = %d AND ident = '%s'", y, this->name, OER_TOPICS + 1, mystate->ident)) {
			return 0;
		}
	}
	this->topic_change = 1;
	return 1;
}

void parsectcp(char *nick, char *host, int ctcp, char *message)
{
	int proceed;
	char stringbuffer[HUGESTRINGLEN + 1];
	struct channel *this;

	proceed = 0;
	if(index(mystate->flags, (int)'f') != NULL) {
                proceed = 1;
        }
	for(this = mystate->channels; this != NULL && !proceed; this = this->next) {
		if(haschanflags(this->name, "U") && !isatleastop(this->name, nick, host)) {
			continue;
		}
		if(isatleastopnow(this->name, nick, host)) {
			proceed = 1;
		}
	}
	if(!proceed) {
		return;
	}
	switch(ctcp) {
	case OER_WHICHCTCP_FINGER:
		snprintf(stringbuffer, HUGESTRINGLEN, "Notice %s :%cFINGER (%s@%s) Idle 0 seconds%c\n", nick, 1, mystate->user, mystate->host, 1);
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
		break;
	case OER_WHICHCTCP_PING:
		snprintf(stringbuffer, HUGESTRINGLEN, "Notice %s :%s\n", nick, message);
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
		break;
	case OER_WHICHCTCP_USERINFO:
		snprintf(stringbuffer, HUGESTRINGLEN, "Notice %s :%cUSERINFO oer+MySQL IRC bot%s%c\n", nick, 1, (index(mystate->flags, (int)'q') != NULL) ? " (Q friendly)" : "", 1);
                addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
                break;
	case OER_WHICHCTCP_VERSION:
		snprintf(stringbuffer, HUGESTRINGLEN, "Notice %s :%cVERSION %s%c\n", nick, 1, OER_COPYRIGHT1, 1);
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
		break;
	}
}

int whichctcp(char *message)
{
	int i;
	int k;
	int length;
	char stringbuffer[HUGESTRINGLEN + 1];

	/* We start from the 2nd char (first is ^A) */
	for(i = 1, k = 0, length = strlen(message); i < length && k < HUGESTRINGLEN; i++) {
		if(message[i] == 1) {
			break;
		}
		stringbuffer[k++] = message[i];
	}
	if(k >= HUGESTRINGLEN) {
		return OER_WHICHCTCP_INVALID;
	}
	stringbuffer[k] = '\0';
	if(!strncasecmp(stringbuffer, "ACTION", 6)) {
		return OER_WHICHCTCP_ACTION;
	}
	if(!strncasecmp(stringbuffer, "FINGER", 6)) {
		return OER_WHICHCTCP_FINGER;
	}
	if(!strncasecmp(stringbuffer, "PING", 4)) {
		return OER_WHICHCTCP_PING;
	}
	if(!strncasecmp(stringbuffer, "USERINFO", 8)) {
                return OER_WHICHCTCP_USERINFO;
        }
	if(!strncasecmp(stringbuffer, "VERSION", 7)) {
		return OER_WHICHCTCP_VERSION;
	}
	return OER_WHICHCTCP_INVALID;
}

int whichcommand(char *command, int params)
{
	if(!strcasecmp(command, "action")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_ACTION;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "add")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_ADD;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "b")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_BAN;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "ban")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_BAN;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "bankick")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_BANKICK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "bk")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_BANKICK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "del")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_DEL;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "dop")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_DOP;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "edit")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_EDIT;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "help")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_HELP;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "info")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_INFO;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "invite")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_INVITE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "jump")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_JUMP;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "k")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_KICK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "kick")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_KICK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "last")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_LAST;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "list")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_LIST;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "lock")) {
                if(params >= 0) {
                        return OER_WHICHCOMMAND_LOCK;
                }
                return OER_WHICHCOMMAND_INVALID;
        }
        if(!strcasecmp(command, "locku")) {
                if(params >= 0) {
                        return OER_WHICHCOMMAND_LOCKU;
                }
                return OER_WHICHCOMMAND_INVALID;
        }
	if(!strcasecmp(command, "logoff")) {
		if(params == 1) {
			return OER_WHICHCOMMAND_LOGOFF;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "logon")) {
		/* params == 1 when admin logon */
		if(params == 1 || params == 2) {
			return OER_WHICHCOMMAND_LOGON;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "mm")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_MASSMESSAGE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "massmessage")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_MASSMESSAGE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "m")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_MODE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "mode")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_MODE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "nstats")) {
		if(params == 1) {
			return OER_WHICHCOMMAND_NSTATS;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "op")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_OP;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "quit")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_QUIT;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "quote")) {
		if(params == 1) {
			return OER_WHICHCOMMAND_QUOTE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "raw")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_RAW;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "rbk")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_RANDOM_BANKICK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "rk")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_RANDOM_KICK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "say")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_SAY;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "seen")) {
		if(params == 1) {
			return OER_WHICHCOMMAND_SEEN;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "sync")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_SYNC;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "syncall")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_SYNCALL;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "t")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_TOPIC_SET;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "topic")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_TOPIC_SET;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "ta")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_TOPIC_ADD;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "td")) {
		if(params == 1) {
			return OER_WHICHCOMMAND_TOPIC_DEL;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "te")) {
		if(params >= 2) {
			return OER_WHICHCOMMAND_TOPIC_EDIT;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "ti")) {
		if(params >= 2) {
			return OER_WHICHCOMMAND_TOPIC_INS;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "tl")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_TOPIC_LIST;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "tg")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_TOPIC_GET;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "tr")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_TOPIC_REFRESH;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "ts")) {
		if(params == 2) {
			return OER_WHICHCOMMAND_TOPIC_SWAP;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "uptime")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_UPTIME;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "ub")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_UNBAN;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "unban")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_UNBAN;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "unlock")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_UNLOCK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "v")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_VOICE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "voice")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_VOICE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "wall")) {
		if(params > 1) {
			return OER_WHICHCOMMAND_WALL;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	return OER_WHICHCOMMAND_INVALID;
}

struct maskstruct *addnewadminmask(char *handle, char *mask)
{
	struct botuser *admin;
	struct maskstruct *ms;
	struct maskstruct *ms2;
	
	for(admin = mystate->admins; admin != NULL; admin = admin->next) {
		if(!strcasecmp(admin->handle, handle)) {
			break;
		}
	}
	if(admin == NULL) {
		return NULL;
	}
	ms = admin->firstmask;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			return NULL;
		}
		ms = ms2->next;
	}
	if((ms = (struct maskstruct *) malloc(sizeof(struct maskstruct))) == NULL) {
		return NULL;
	}
	if((ms->mask = (char *) malloc(strlen(mask) + 1)) == NULL) {
		return NULL;
	}
	strcpy(ms->mask, mask);
	ms->next = NULL;
	ms->prev = NULL;
	if(admin->firstmask == NULL) {
		/* first mask, special case */
		admin->firstmask = ms;
		return ms;
	}
	/* >=1 masks, normal processing */
	ms2->next = ms;
	ms->prev = ms2;
	return ms;
}

int deladmin(char *handle, int force)
{
	struct botuser *admin;
        struct maskstruct *ms;
        struct maskstruct *ms2;

	for(admin = mystate->admins; admin != NULL; admin = admin->next) {
		if(!strcasecmp(admin->handle, handle)) {
			break;
		}
	}
	if(admin == NULL) {
		return 0;
	}
	/* check if admin can be deleted */
	if(!force && !delopa(admin->handle)) {
		oer_debug(OER_DEBUG_INFO, "deladmin->attempted to delete protected admin %s\n", admin->handle);
		return 0;
	}
	/* first free all masks */
	ms = admin->firstmask;
	while(ms != NULL) {
		ms2 = ms->next;
		free(ms->mask);
		free(ms);
		ms = ms2;
	}
	/* then free the admin & adjust lists */
	if(admin->prev == NULL) {
		/* first admin in list */
		mystate->admins = admin->next;
		/* ... check if also last */
		if(admin->next != NULL) {
			admin->next->prev = NULL;
		}
	}
	if(admin->next == NULL) {
		/* last admin in list */
		/* ... check also if the only one */
		if(admin->prev != NULL) {
			admin->prev->next = NULL;
		} else {
			mystate->admins = NULL;
		}
	}
	if(admin->prev != NULL && admin->next != NULL) {
		/* between 2 or more admins */
		admin->prev->next = admin->next;
		admin->next->prev = admin->prev;
	}
	free(admin->handle);
	free(admin->options);
	free(admin);
	return 1;
}

int deladminmask(char *handle, char *mask)
{
	struct botuser *admin;
	struct maskstruct *ms;
	struct maskstruct *ms2;

	for(admin = mystate->admins; admin != NULL; admin = admin->next) {
		if(!strcasecmp(admin->handle, handle)) {
			break;
		}
	}
	if(admin == NULL) {
		return 0;
	}
	/* find & remove mask */
	ms = admin->firstmask;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			break;
		}
		ms = ms2->next;
	}
	if(ms == NULL) {
		return 0;
	}
	/* adjust lists */
	if(ms->prev == NULL) {
		/* first mask in list */
		admin->firstmask = ms->next;
		/* ... check if also last */
		if(ms->next != NULL) {
			ms->next->prev = NULL;
		}
	}
	if(ms->next == NULL) {
		/* last mask in list */
		/* ... check also if the only one */
		if(ms->prev != NULL) {
			ms->prev->next = NULL;
		} else {
			admin->firstmask = NULL;
		}
	}
	if(ms->prev != NULL && ms->next != NULL) {
		/* between 2 or more masks */
		ms->prev->next = ms->next;
		ms->next->prev = ms->prev;
	}
	free(ms->mask);
	free(ms);
	return 1;
}

int deluser(char *channel, char *handle)
{
	struct channel *this;
	struct botuser *user;
	struct maskstruct *ms;
	struct maskstruct *ms2;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(user = this->users; user != NULL; user = user->next) {
		if(!strcasecmp(user->handle, handle)) {
			break;
		}
	}
	if(user == NULL) {
		return 0;
	}
	/* first free all masks */
	ms = user->firstmask;
	while(ms != NULL) {
		ms2 = ms->next;
		free(ms->mask);
		free(ms);
		ms = ms2;
	}
	/* then free the user & adjust lists */
	if(user->prev == NULL) {
		/* first user in list */
		this->users = user->next;
		/* ... check if also last */
		if(user->next != NULL) {
			user->next->prev = NULL;
		}
	}
	if(user->next == NULL) {
		/* last user in list
		   ... check also if the only one */
		if(user->prev != NULL) {
			user->prev->next = NULL;
		} else {
			this->users = NULL;
		}
	}
	if(user->prev != NULL && user->next != NULL) {
		/* between 2 or more users */
		user->prev->next = user->next;
		user->next->prev = user->prev;
	}
	free(user->handle);
	free(user->options);
	free(user->password);
	free(user);
	return 1;
}

int delusermask(char *channel, char *handle, char *mask)
{
	struct channel *this;
	struct botuser *user;
	struct maskstruct *ms;
	struct maskstruct *ms2;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(user = this->users; user != NULL; user = user->next) {
		if(!strcasecmp(user->handle, handle)) {
			break;
		}
	}
	if(user == NULL) {
		return 0;
	}
	/* find & remove mask */
	ms = user->firstmask;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			break;
		}
		ms = ms2->next;
	}
	if(ms == NULL) {
		return 0;
	}
	/* adjust lists */
	if(ms->prev == NULL) {
		/* first mask in list */
		user->firstmask = ms->next;
		/* ... check if also last */
		if(ms->next != NULL) {
			ms->next->prev = NULL;
		}
	}
	if(ms->next == NULL) {
		/* last mask in list */
		/* ... check also if the only one */
		if(ms->prev != NULL) {
			ms->prev->next = NULL;
		} else {
			user->firstmask = NULL;
		}
	}
	if(ms->prev != NULL && ms->next != NULL) {
		/* between 2 or more masks */
		ms->prev->next = ms->next;
		ms->next->prev = ms->prev;
	}
	free(ms->mask);
	free(ms);
	return 1;
}

int deltrusted(char *hostname)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;

	/* find & remove hostname */
	ms = mystate->trusted;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, hostname)) {
			break;
		}
		ms = ms2->next;
	}
	if(ms == NULL) {
		return 0;
	}
	/* adjust lists */
	if(ms->prev == NULL) {
		/* first mask in list */
		mystate->trusted = ms->next;
		/* ... check if also last */
		if(ms->next != NULL) {
			ms->next->prev = NULL;
		}
	}
	if(ms->next == NULL) {
		/* last mask in list */
		/* ... check also if the only one */
		if(ms->prev != NULL) {
			ms->prev->next = NULL;
		}
	}
	if(ms->prev != NULL && ms->next != NULL) {
		/* between 2 or more masks */
		ms->prev->next = ms->next;
		ms->next->prev = ms->prev;
	}
	free(ms->mask);
	free(ms->optstring);
	free(ms);
	return 1;
}

int delchannel(char *channel)
{
	char outstring[STRINGLEN + 1];
	struct channel *this;
	struct channel *this2;

	/* find channel */
	this = mystate->channels;
	this2 = this;
	while(this != NULL) {
		this2 = this;
		if(!strcasecmp(this->name, channel)) {
			break;
		}
		this = this2->next;
	}
	if(this == NULL) {
		return 0;
	}
	if(this->joined) {
		/* leave the channel */
		snprintf(outstring, STRINGLEN, "PART %s\n", this->name);
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
	}
	/* do the normal init */
	initchannel(channel);
	/* the following differ from normal initchannel() */
	deltopics(channel);
	initnickbks(channel);
	initwordbks(channel);
	initusers(channel);
	/* adjust lists */
	if(this->prev == NULL) {
		/* first channel in list */
		mystate->channels = this->next;
		/* ... check if also last */
		if(this->next != NULL) {
			this->next->prev = NULL;
		}
	}
	if(this->next == NULL) {
		/* last channel in list */
		/* ... check also if the only one */
		if(this->prev != NULL) {
			this->prev->next = NULL;
		}
	}
	if(this->prev != NULL && this->next != NULL) {
		/* between 2 or more channels */
		this->prev->next = this->next;
		this->next->prev = this->prev;
	}
	free(this);
	return 1;
}

struct maskstruct *editmask(struct maskstruct *first, char *from, char *to)
{
	while(first != NULL) {
		if(!strcasecmp(first->mask, from)) {
			break;
		}
		first = first->next;
	}
	if(first == NULL) {
		return NULL;
	}
	free(first->mask);
	if((first->mask = (char *) malloc(strlen(to) + 1)) == NULL) {
		return NULL;
	}
	strcpy(first->mask, to);
	return first;
}

struct maskstruct *addnewusermask(char *channel, char *handle, char *mask)
{
	struct channel *this;
	struct botuser *user;
	struct maskstruct *ms;
	struct maskstruct *ms2;
	
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	for(user = this->users; user != NULL; user = user->next) {
		if(!strcasecmp(user->handle, handle)) {
			break;
		}
	}
	if(user == NULL) {
		return NULL;
	}
	ms = user->firstmask;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			return NULL;
		}
		ms = ms2->next;
	}
	if((ms = (struct maskstruct *) malloc(sizeof(struct maskstruct))) == NULL) {
		return NULL;
	}
	if((ms->mask = (char *) malloc(strlen(mask) + 1)) == NULL) {
		return NULL;
	}
	strcpy(ms->mask, mask);
	ms->next = NULL;
	ms->prev = NULL;
	if(user->firstmask == NULL) {
		/* first mask, special case */
		user->firstmask = ms;
		return ms;
	}
	/* >=1 masks, normal processing */
	ms2->next = ms;
	ms->prev = ms2;
	return ms;
}

struct maskstruct *addnewnickbk(char *channel, char *mask, char *reason)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewnickbk->adding nick %s as nickbk to channel %s\n", mask, channel);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	ms = this->nickbks;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			return NULL;
		}
		ms = ms2->next;
	}
	if((ms = (struct maskstruct *) malloc(sizeof(struct maskstruct))) == NULL) {
		return NULL;
	}
	if((ms->mask = (char *) malloc(strlen(mask) + 1)) == NULL) {
		return NULL;
	}
	if(reason != NULL) {
		if((ms->optstring = (char *) malloc(strlen(reason) + 1)) == NULL) {
			return NULL;
		}
		strcpy(ms->optstring, reason);
	} else {
		ms->optstring = NULL;
	}
	strcpy(ms->mask, mask);
	ms->next = NULL;
	ms->prev = NULL;
	if(this->nickbks == NULL) {
		/* first nickbk, special case */
		this->nickbks = ms;
		return ms;
	}
	/* >=1 nickbks, normal processing */
	ms2->next = ms;
	ms->prev = ms2;
	return ms;
}

struct maskstruct *addnewwordbk(char *channel, char *mask, char *reason)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewwordbk->adding new %s as wordbk to channel %s (reason: %s)\n", mask, channel, reason);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	ms = this->wordbks;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			return NULL;
		}
		ms = ms2->next;
	}
	if((ms = (struct maskstruct *) malloc(sizeof(struct maskstruct))) == NULL) {
		return NULL;
	}
	if((ms->mask = (char *) malloc(strlen(mask) + 1)) == NULL) {
		return NULL;
	}
	strcpy(ms->mask, mask);
	if((ms->optstring = (char *) malloc(strlen(reason) + 1)) == NULL) {
		return NULL;
	}
	strcpy(ms->optstring, reason);
	ms->next = NULL;
	ms->prev = NULL;
	if(this->wordbks == NULL) {
		/* first wordbk, special case */
		this->wordbks = ms;
		return ms;
	}
	/* >=1 wordbks, normal processing */
	ms2->next = ms;
	ms->prev = ms2;
	return ms;
}

struct maskstruct *addnewtrusted(char *hostname)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;

	oer_debug(OER_DEBUG_INFO, "addnewtrusted->adding new trusted hostname %s\n", hostname);
	ms = mystate->trusted;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, hostname)) {
			return NULL;
		}
		ms = ms2->next;
	}
	if((ms = (struct maskstruct *) malloc(sizeof(struct maskstruct))) == NULL) {
		return NULL;
	}
	if((ms->mask = (char *) malloc(strlen(hostname) + 1)) == NULL) {
		return NULL;
	}
	strcpy(ms->mask, hostname);
	ms->optstring = NULL;
	ms->next = NULL;
	ms->prev = NULL;
	if(mystate->trusted == NULL) {
		/* first trusted, special case */
		mystate->trusted = ms;
		return ms;
	}
	/* >=1 trusted, normal processing */
	ms2->next = ms;
	ms->prev = ms2;
	return ms;
}

struct botuser *addbotuser(char *handle, char *options)
{
	struct botuser *botuser;

	oer_debug(OER_DEBUG_INFO, "addbotuser->adding botuser %s options: %s\n", handle, options);
	if((botuser = (struct botuser *) malloc(sizeof(struct botuser))) == NULL) {
		return NULL;
	}
	botuser->password = NULL;
	botuser->firstmask = NULL;
	botuser->prev = NULL;
	botuser->next = NULL;
	if((botuser->handle = (char *) malloc(strlen(handle) + 1)) == NULL) {
		return NULL;
	}
	strcpy(botuser->handle, handle);
	if((botuser->options = (char *) malloc(strlen(options) + 1)) == NULL) {
		return NULL;
	}
	strcpy(botuser->options, options);
	return botuser;
}

struct botuser *addnewuser(char *channel, char *handle, char *options)
{
	struct botuser *bu;
	struct botuser *bu2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewuser->adding new user %s to %s with flags %s\n", handle, channel, options);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	bu = this->users;
	bu2 = bu;
	while(bu != NULL) {
		bu2 = bu;
		if(!strcasecmp(bu->handle, handle)) {
			return NULL;
		}
		bu = bu2->next;
	}
	if((bu = addbotuser(handle, options)) == NULL) {
		return NULL;
	}
	if(this->users == NULL) {
		this->users = bu;
		return bu;
	}
	/* >=1 users, normal processing */
	bu2->next = bu;
	bu->prev = bu2;
	return bu;
}

struct botuser *addnewadmin(char *handle, char *options)
{
	struct botuser *admin;
	struct botuser *admin2;

	oer_debug(OER_DEBUG_INFO, "addnewadmin->adding new admin %s with flags %s\n", handle, options);
	admin = mystate->admins;
	admin2 = admin;
	while(admin != NULL) {
		admin2 = admin;
		if(!strcasecmp(admin->handle, handle)) {
			return NULL;
		}
		admin = admin2->next;
	}
	if((admin = addbotuser(handle, options)) == NULL) {
		return NULL;
	}
	if(mystate->admins == NULL) {
		mystate->admins = admin;
		return admin;
	}
	/* >1 admins, normal processing */
	admin2->next = admin;
	admin->prev = admin2;
	return admin;
}

struct server *addnewserver(char *serverhost, int serverport, int servermodes, int pingfrequency, int protected_ircops, int linenoise, char *password)
{
	struct server *s;
	struct server *s2;

	oer_debug(OER_DEBUG_INFO, "addnewserver->checking server hostname: %s port: %d servermodes: %d ping frequency: %d protected ircops: %d linenoise: %d password: %s\n", serverhost, serverport, servermodes, pingfrequency, protected_ircops, linenoise, (password == NULL) ? "(null)" : password);
	s = mystate->servers;
	s2 = s;
	while(s != NULL) {
		s2 = s;
		if(!strcasecmp(s->serverhost, serverhost) && s->serverport == serverport && s->servermodes == servermodes && s->pingfrequency == pingfrequency && s->protected_ircops == protected_ircops && s->linenoise == linenoise) {
			/* server already exists */
			return NULL;
		}
		s = s2->next;
	}
	if((s = (struct server *) malloc(sizeof(struct server))) == NULL) {
		return NULL;
	}
	strncpy(s->serverhost, serverhost, HOSTLEN);
	s->serverport = serverport;
	s->servermodes = servermodes;
	s->pingfrequency = pingfrequency;
	s->protected_ircops = protected_ircops;
	s->used = 0;
	s->connected = 0;
	s->stoned = 0;
	s->linenoise = linenoise;
	memset(s->password, 0, TINYSTRINGLEN + 1);
	if(password != NULL) {
                strncpy(s->password, password, TINYSTRINGLEN);
        }
	s->registered = OER_REGISTERCONNECTION_STATUS_BEGIN;
	s->lastping = 0;
	s->prev = NULL;
	s->next = NULL;
	if(mystate->servers == NULL) {
		/* first server, special case */
		mystate->servers = s;
		return s;
	}
	/* >=1 servers, normal case */
	s2->next = s;
	s->prev = s2;
	return s;
}

struct channel *addnewchannel(char *name)
{
	struct channel *this;
	struct channel *this2;

	oer_debug(OER_DEBUG_INFO, "addnewchannel->adding channel %s\n", name);
	this = mystate->channels;
	this2 = this;
	while(this != NULL) {
		this2 = this;
		if(!strcasecmp(this->name, name)) {
			return NULL;
		}
		this = this2->next;
	}
	if((this = (struct channel *) malloc(sizeof(struct channel))) == NULL) {
		return NULL;
	}
	strncpy(this->name, name, CHANLEN);
	memset(this->mode, 0, CHANLEN + 1);
	memset(this->key, 0, CHANLEN + 1);
	this->haskey = 0;
	this->joined = 0;
	this->joining = 0;
	this->setchanmode = 0;
	this->rejoin_at = 0;
	this->last_quote = 0;
	this->userts = 0;
	this->nickcount = 0;
	this->i_am_op = 0;
	memset(&this->chanflags, 0, FLAGLEN + 1);
	this->modelines = NULL;
	this->nicks = NULL;
	this->pubmsgs = NULL;
	this->parts = NULL;
	this->joins = NULL;
	memset(&this->locked, 0, sizeof(struct locked));
	memset(&this->floodvars, 0, sizeof(struct floodvars));
	/* set the flood defaults, run-time changable */
	this->floodvars.repeat_expire = PUBMSG_FLOOD_REPEAT_EXPIRE;
	this->floodvars.repeat_limit = PUBMSG_FLOOD_REPEAT;
	this->floodvars.interval = PUBMSG_FLOOD_INTERVAL;
	this->floodvars.lines = PUBMSG_FLOOD_LINES;
	this->floodvars.chars = PUBMSG_FLOOD_CHARS;
	/* .. */
	memset(&this->banvars, 0, sizeof(struct banvars));
	/* set the ban time defaults, run-time changable */
	this->banvars.auto_rejoin = OER_BANVARS_AUTO_REJOIN;
	this->banvars.part_rejoin = OER_BANVARS_PART_REJOIN;
	this->banvars.public_flood = OER_BANVARS_PUBLIC_FLOOD;
	this->banvars.public_flood_repeat = OER_BANVARS_PUBLIC_FLOOD_REPEAT;
	this->banvars.bad_word = OER_BANVARS_BAD_WORD;
	this->banvars.bad_nick = OER_BANVARS_BAD_NICK;
	this->banvars.normal_ban = OER_BANVARS_NORMAL_BAN;
	/* .. */
	this->nickbks = NULL;
	this->wordbks = NULL;
	this->users = NULL;
	this->autheds = NULL;
	this->topic_change = 0;
	this->topic_reset = 0;
	this->synced = 0;
        this->adverts = NULL;
	this->prev = NULL;
	this->next = NULL;
	/* first one is a special case */
	if(mystate->channels == NULL) {
		mystate->channels = this;
		return this;
	}
	/* >=1 channels, normal case */
	this2->next = this;
	this->prev = this2;
	return this;
}

struct channel *getchptr(char *channel_name)
{
	struct channel *channel_ptr;

	for(channel_ptr = mystate->channels; channel_ptr != NULL; channel_ptr = channel_ptr->next) {
		if(!strcasecmp(channel_ptr->name, channel_name)) {
			break;
		}
	}
	return channel_ptr;
}

int loadconf(char *config)
{
	FILE *fp;
        char stringbuffer[BIGSTRINGLEN + 1];

	oer_debug(OER_DEBUG_INFO, "loadconf->loading main configuration from \"%s\"\n", config);
	if((fp = fopen(config, "r")) == NULL) {
                return 0;
        }
        while(fgets(stringbuffer, BIGSTRINGLEN, fp)) {
		striplf(stringbuffer);
		if(emptyline(stringbuffer)) {
			continue;
		}
		if(iscomment(stringbuffer)) {
			continue;
		}
                if(!parseconf(stringbuffer)) {
			oer_debug(OER_DEBUG_WARNING, "loadconf->non-parsable line: '%s'\n", stringbuffer);
                        return 0;
                }
        }
        fclose(fp);
        return 1;
}

int parseconf(char *paramline)
{
	int ppos;
	char p1[STRINGLEN + 1];
	char p2[STRINGLEN + 1];
	char p3[STRINGLEN + 1];
	char p4[STRINGLEN + 1];
	char p5[STRINGLEN + 1];

	ppos = 0;
	if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p1, STRINGLEN, 1)) < 0) {
		return 0;
	}
	if(!strcasecmp(p1, "mysql")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p3, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p4, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p5, STRINGLEN, 1)) < 0) {
			return 0;
		}
		strncpy(mystate->mysqldb.mysqldbdbhost, p2, HOSTLEN);
		strncpy(mystate->mysqldb.mysqldbdbname, p3, TINYSTRINGLEN);
		strncpy(mystate->mysqldb.mysqldbdbuser, p4, TINYSTRINGLEN);
		strncpy(mystate->mysqldb.mysqldbdbpw, p5, TINYSTRINGLEN);
                oer_debug(OER_DEBUG_INFO, "parseconf->using MySQL database [host: %s] [database: %s] [user: %s]\n", mystate->mysqldb.mysqldbdbhost, mystate->mysqldb.mysqldbdbname, mystate->mysqldb.mysqldbdbuser);
		return 1;
	}
	if(!strcasecmp(p1, "ident")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		strncpy(mystate->ident, p2, STRINGLEN);
		oer_debug(OER_DEBUG_INFO, "parseconf->my ident is %s\n", mystate->ident);
		return 1;
	}
	if(!strcasecmp(p1, "usersfrom")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		strncpy(mystate->usersfrom, p2, STRINGLEN);
		oer_debug(OER_DEBUG_INFO, "parseconf->I will get my users with ident %s\n", mystate->usersfrom);
		return 1;
	}
	if(!strcasecmp(p1, "state")) {
		if(!strlen(paramline + ppos)) {
			return 0;
		}
		strncpy(mystate->state, paramline + ppos, STRINGLEN);
		oer_debug(OER_DEBUG_INFO, "parseconf->my state is %s\n", mystate->state);
		return 1;
	}
	oer_debug(OER_DEBUG_WARNING, "parseconf->unknown line: '%s'\n", paramline);
	return 1;
}

int saveconf(void)
{
	FILE *fp;
        char filename[STRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];

	snprintf(filename, STRINGLEN, "%s.saving", mystate->config);
	oer_debug(OER_DEBUG_INFO, "saveconf->saving to %s\n", filename);
	if((fp = fopen(filename, "w")) == NULL) {
                return 0;
        }
	snprintf(stringbuffer, BIGSTRINGLEN, "mysql::%s::%s::%s::%s\n", mystate->mysqldb.mysqldbdbhost, mystate->mysqldb.mysqldbdbname, mystate->mysqldb.mysqldbdbuser, mystate->mysqldb.mysqldbdbpw);
        fputs(stringbuffer, fp);
        snprintf(stringbuffer, BIGSTRINGLEN, "ident::%s\n", mystate->ident);
        fputs(stringbuffer, fp);
	if(strcasecmp(mystate->usersfrom, mystate->ident)) {
		snprintf(stringbuffer, BIGSTRINGLEN, "usersfrom::%s\n", mystate->usersfrom);
		fputs(stringbuffer, fp);
	}
        fclose(fp);
        oer_debug(OER_DEBUG_INFO, "saveconf->renaming %s to %s\n", filename, mystate->config);
        if(rename(filename, mystate->config) < 0) {
                return 0;
        }
        return 1;
}

int getadmins(void)
{
	int total;
	struct maskstruct *ms;
        struct botuser *admin;
	MYSQL_RES *result;
        MYSQL_ROW row;

	/* get oer+MySQL admins */
	if(!oer_doquery("getadmins", OER_DEBUG_INFO, "SELECT handle, flags FROM admins where ident = '%s'", mystate->usersfrom)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "getadmins->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		if((admin = addnewadmin(row[0], row[1])) == NULL) {
			oer_debug(OER_DEBUG_FATAL, "getadmins->failure while adding oer+MySQL admin %s\n", row[0]);
			mysql_free_result(result);
                        return 0;
                }
                oer_debug(OER_DEBUG_INFO, "getadmins->added admin %s with flags %s\n", admin->handle, admin->options);
	}
	mysql_free_result(result);
	/* get oer+MySQL admin hostmasks */
	if(!oer_doquery("getadmins", OER_DEBUG_INFO, "SELECT handle, hostmask FROM hostmasks WHERE ident = '%s' AND type = 1", mystate->usersfrom)) {
		mysql_free_result(result);
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "getadmins->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
		mysql_free_result(result);
		return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		if((ms = addnewadminmask(row[0], row[1])) == NULL) {
			oer_debug(OER_DEBUG_FATAL, "getadmins->failure while adding hostmask %s to oer+MySQL admin %s\n", row[1], row[0]);
			mysql_free_result(result);
			return 0;
		}
		oer_debug(OER_DEBUG_INFO, "added mask %s to admin %s\n", ms->mask, row[0]);
	}
	mysql_free_result(result);
	/* get the admin timestamp */
	if(!oer_doquery("getadmins", OER_DEBUG_INFO, "SELECT twhen FROM timestamps WHERE ttype = 'admins' AND ident = '%s'", mystate->usersfrom)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "getadmins->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	mystate->admints = time(NULL);
	if((total = mysql_num_rows(result))) {
		row = mysql_fetch_row(result);
		mystate->admints = atol(row[0]);
	} else {
		updateadmints();
	}
	oer_debug(OER_DEBUG_INFO, "getadmins->admints set to %lu\n", mystate->admints);
	mysql_free_result(result);
	return 1;
}

int getusers(char *channel)
{
	int total;
	struct maskstruct *ms;
        struct botuser *user;
	struct channel *this;
	MYSQL_RES *result;
        MYSQL_ROW row;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	/* get handles for the channel */
	if(!oer_doquery("getusers", OER_DEBUG_INFO, "SELECT handle, flags FROM users WHERE channel = '%s' AND ident = '%s'", this->name, mystate->usersfrom)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "getusers->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		if((user = addnewuser(this->name, row[0], row[1])) == NULL) {
			oer_debug(OER_DEBUG_FATAL, "getusers->failure while adding %s user %s\n", this->name, row[0]);
			mysql_free_result(result);
                        return 0;
		}
		oer_debug(OER_DEBUG_INFO, "getusers->added %s user %s with flags %s\n", this->name, user->handle, user->options);
	}
	mysql_free_result(result);
	/* get passwords for handles requiring it */
	if(!oer_doquery("getusers", OER_DEBUG_INFO, "SELECT handle, password FROM passwords WHERE channel = '%s' AND ident = '%s' and type = 1", this->name, mystate->usersfrom)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "getusers->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		if(!setpassword(this->name, row[0], row[1])) {
			oer_debug(OER_DEBUG_FATAL, "getusers->failed to add password %s to %s dyn-user %s\n", row[1], row[0], this->name);
			mysql_free_result(result);
			return 0;
		}
		oer_debug(OER_DEBUG_INFO, "getusers->added password %s to %s dyn-user %s\n", row[1], this->name, row[0]);
	}
	mysql_free_result(result);
	/* get hostmasks for all channel users */
	if(!oer_doquery("getusers", OER_DEBUG_INFO, "SELECT hostmask, handle FROM hostmasks WHERE channel = '%s' AND ident = '%s' and type = 2", this->name, mystate->usersfrom)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "getusers->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		if((ms = addnewusermask(this->name, row[1], row[0])) == NULL) {
			oer_debug(OER_DEBUG_FATAL, "getusers->failure while adding hostmask %s to %s user %s\n", row[0], this->name, row[1]);
			mysql_free_result(result);
                        return 0;
		}
		oer_debug(OER_DEBUG_INFO, "added hostmask %s to %s user %s\n", ms->mask, this->name, row[1]);
	}
	mysql_free_result(result);
	/* get the user timestamp */
	if(!oer_doquery("getusers", OER_DEBUG_INFO, "SELECT twhen FROM timestamps WHERE ttype = 'users' AND tchannel = '%s' AND ident = '%s'", this->name, mystate->usersfrom)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "getusers->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
		return 0;
	}
	this->userts = time(NULL);
	if((total = mysql_num_rows(result))) {
		row = mysql_fetch_row(result);
		this->userts = atol(row[0]);
	} else {
		updateuserts(this->name);
	}
	oer_debug(OER_DEBUG_FATAL, "getusers->%s userts set to %lu\n", this->name, this->userts);
	mysql_free_result(result);
	return 1;
}

int updateadmints()
{
	mystate->admints = mystate->now;
	if(strstr(mystate->state, "+ro") != NULL) {
		return 0;
	}
	/* first remove all admin timestamps */
	if(!oer_doquery("updateadmints", OER_DEBUG_INFO, "DELETE FROM timestamps WHERE ttype = 'admins' AND ident = '%s'", mystate->usersfrom)) {
		return 0;
	}
	/* then insert a new one */
	if(!oer_doquery("updateadmints", OER_DEBUG_INFO, "INSERT INTO timestamps VALUES ('admins', %lu, '', '%s')", mystate->now, mystate->usersfrom)) {
		return 0;
	}
	return 1;
}

int updateuserts(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	this->userts = mystate->now;
	if(strstr(mystate->state, "+ro") != NULL) {
		return 0;
	}
	/* first remove all user timestamps */
	if(!oer_doquery("updateuserts", OER_DEBUG_INFO, "DELETE FROM timestamps WHERE ttype = 'users' AND tchannel = '%s' AND ident = '%s'", channel, mystate->usersfrom)) {
		return 0;
	}
	/* then insert a new one */
	if(!oer_doquery("updateuserts", OER_DEBUG_INFO, "INSERT INTO timestamps VALUES ('users', %lu, '%s', '%s')", mystate->now, channel, mystate->usersfrom)) {
		return 0;
	}
	return 1;
}

int initenv(void)
{
	int servers;
	struct server *server;
	struct channel *this;
	struct maskstruct *ms;
	struct advert *a;
	char *pwptr;
	MYSQL_RES *result;
        MYSQL_ROW row;

	/* we will start off by querying all information that is
	   required for running oer+MySQL, begin with conf */
	if(!oer_doquery("initenv", OER_DEBUG_INFO, "SELECT nick, altnick, user, usermode, flags, prefix, realname, vhost FROM conf where ident = '%s'", mystate->ident)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "initenv->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	if(!mysql_num_rows(result)) {
		mysql_free_result(result);
		return 0;
	}
	/* only one record should be returned */
	row = mysql_fetch_row(result);
	strncpy(mystate->nick, row[0], NICKLEN);
	strncpy(mystate->altnick, row[1], NICKLEN);
	if(strlen(row[2])) {
		strncpy(mystate->user, row[2], NICKLEN);
		mystate->customuser = 1;
	}
	if(strlen(row[3])) {
		strncpy(mystate->mode, row[3], CHANLEN);
		mystate->newmode = 1;
	}
	if(strlen(row[4])) {
		strncpy(mystate->flags, row[4], FLAGLEN);
	}
	if(strlen(row[5])) {
		strncpy(mystate->prefix, row[5], STRINGLEN);
	} else {
		strncpy(mystate->prefix, "!", STRINGLEN);
	}
	strncpy(mystate->realname, row[6], STRINGLEN);
	if(strlen(row[7])) {
		strncpy(mystate->host, row[7], HOSTLEN);
		mystate->vhost = 1;
	}
	oer_debug(OER_DEBUG_FLOOD, "initenv->my nick is %s\n", mystate->nick);
	oer_debug(OER_DEBUG_FLOOD, "initenv->my altnick is %s\n", mystate->altnick);
	oer_debug(OER_DEBUG_FLOOD, "initenv->my user is %s\n", mystate->user);
	oer_debug(OER_DEBUG_FLOOD, "initenv->my usermode is %s\n", mystate->mode);
	oer_debug(OER_DEBUG_FLOOD, "initenv->my flags are %s\n", mystate->flags);
	oer_debug(OER_DEBUG_FLOOD, "initenv->my prefix is %s\n", mystate->prefix);
	oer_debug(OER_DEBUG_FLOOD, "initenv->my IRC REALNAME is %s\n", mystate->realname);
	oer_debug(OER_DEBUG_FLOOD, "initenv->using virtual host %s\n", mystate->host);
	mysql_free_result(result);
	/* get IRC servers */
	servers = 0;
	if(!oer_doquery("initenv", OER_DEBUG_INFO, "SELECT hostname, port, servermodes, pingfreq, protopers, linenoise, password FROM servers where ident = '%s'", mystate->ident)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "initenv->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	if(!mysql_num_rows(result)) {
		oer_debug(OER_DEBUG_FATAL, "initenv->no IRC servers to connect to\n");
		mysql_free_result(result);
		return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		pwptr = (strlen(row[6])) ? row[6] : NULL;
		if((server = addnewserver(row[0], atoi(row[1]), atoi(row[2]), atoi(row[3]), atoi(row[4]), atoi(row[5]), pwptr)) == NULL) {
			oer_debug(OER_DEBUG_FATAL, "initenv->failure while adding IRC server\n");
			mysql_free_result(result);
			return 0;
		}
	}
	mysql_free_result(result);
	/* get IRC channels */
	if(!oer_doquery("initenv", OER_DEBUG_INFO, "SELECT name, chanmodes, chankey, chanflags FROM channels where ident = '%s' ORDER BY 1 ASC", mystate->ident)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "initenv->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		if((this = addnewchannel(row[0])) == NULL) {
			oer_debug(OER_DEBUG_FATAL, "initenv->failure while adding IRC channel\n");
			mysql_free_result(result);
                        return 0;
                }
		if(strlen(row[2])) {
			setchankey(row[0], row[2]);
		}
		if(strlen(row[1])) {
			setchanmode(row[0], row[1]);
		}
		if(strlen(row[3])) {
			setchanflags(row[0], row[3]);
		}
		if(this->haskey) {
			oer_debug(OER_DEBUG_INFO, "initenv->added channel %s with key %s modes %s and flags %s\n", this->name, this->key, this->mode, this->chanflags);
		} else {
			oer_debug(OER_DEBUG_INFO, "initenv->added channel %s with modes %s and flags %s\n", this->name, this->mode, this->chanflags);
		}
	}
	mysql_free_result(result);
	/* take users from another bot? */
	if(!strlen(mystate->usersfrom)) {
		strncpy(mystate->usersfrom, mystate->ident, STRINGLEN);
	}
	if(!getadmins()) {
		return 0;
	}
	if(!admincount()) {
		oer_debug(OER_DEBUG_FATAL, "initenv->no valid admins loaded, oer+MySQL would be unaccessible from IRC\n");
		return 0;
	}
	for(this = mystate->channels; this != NULL; this = this->next) {
		if(!getusers(this->name)) {
			return 0;
		}
	}
	/* get nickbks (for all channels) */
	if(!oer_doquery("initenv", OER_DEBUG_INFO, "SELECT channel, pattern, reason, setby, twhen FROM nickbks where ident = '%s'", mystate->ident)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "initenv->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		if((ms = addnewnickbk(row[0], row[1], row[2])) == NULL) {
			oer_debug(OER_DEBUG_FATAL, "initenv->failure while adding nickbk\n");
			mysql_free_result(result);
                        return 0;
		}
		oer_debug(OER_DEBUG_INFO, "added nickbk %s to %s\n", ms->mask, row[0]);
	}
	mysql_free_result(result);
	/* get wordbks (for all channels) */
	if(!oer_doquery("initenv", OER_DEBUG_INFO, "SELECT channel, pattern, reason, setby, twhen FROM wordbks where ident = '%s'", mystate->ident)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "initenv->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		if((ms = addnewwordbk(row[0], row[1], row[2])) == NULL) {
			oer_debug(OER_DEBUG_FATAL, "initenv->failure while adding wordbk\n");
			mysql_free_result(result);
                        return 0;
		}
		oer_debug(OER_DEBUG_INFO, "added wordbk %s to %s\n", ms->mask, row[0]);
	}
	mysql_free_result(result);
	/* get channel adverts (for all channels) */
	if(!oer_doquery("initenv", OER_DEBUG_INFO, "SELECT channel, type, message FROM adverts where ident = '%s'", mystate->ident)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "initenv->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		if(strcasecmp(row[1], "admins") && strcasecmp(row[1], "ops") && strcasecmp(row[1], "lamers") && strcasecmp(row[1], "other")) {
			continue;
		}
		if((a = addnewadvert(row[0], row[1], row[2])) == NULL) {
			oer_debug(OER_DEBUG_FATAL, "initenv->failure while adding advert\n");
			mysql_free_result(result);
                        return 0;
		}
		oer_debug(OER_DEBUG_FLOOD, "parsechaninfo->added advert \"%s\" (type: %s) to channel %s\n", a->message, a->type, row[0]);
	}
	mysql_free_result(result);
	/* get floodvars (for all channels) */
	if(!oer_doquery("initenv", OER_DEBUG_INFO, "SELECT channel, f_expire, f_limit, f_interval, f_lines, f_chars FROM floodvars where ident = '%s'", mystate->ident)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "initenv->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		if((this = getchptr(row[0])) == NULL) {
			continue;
		}
		this->floodvars.repeat_expire = atoi(row[1]);
		this->floodvars.repeat_limit = atoi(row[2]);
		this->floodvars.interval = atoi(row[3]);
		this->floodvars.lines = atoi(row[4]);
		this->floodvars.chars = atoi(row[5]);
		oer_debug(OER_DEBUG_FLOOD, "parsechaninfo->channel %s floodvars set to %d %d %d %d %d\n", this->name, this->floodvars.repeat_expire, this->floodvars.repeat_limit, this->floodvars.interval, this->floodvars.lines, this->floodvars.chars);
	}
	mysql_free_result(result);
	/* get banvars (for all channels) */
	if(!oer_doquery("initenv", OER_DEBUG_INFO, "SELECT channel, b_auto_rejoin, b_part_rejoin, b_flood, b_flood_repeat, b_bad_word, b_bad_nick, b_normal_ban FROM banvars where ident = '%s'", mystate->ident)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "initenv->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		if((this = getchptr(row[0])) == NULL) {
			continue;
		}
		this->banvars.auto_rejoin = atoi(row[1]);
		this->banvars.part_rejoin = atoi(row[2]);
		this->banvars.public_flood = atoi(row[3]);
		this->banvars.public_flood_repeat = atoi(row[4]);
		this->banvars.bad_word = atoi(row[5]);
		this->banvars.bad_nick = atoi(row[6]);
		this->banvars.normal_ban = atoi(row[7]);
		oer_debug(OER_DEBUG_FLOOD, "parsechaninfo->channel %s banvars set to %d %d %d %d %d %d %d\n", this->name, this->banvars.auto_rejoin, this->banvars.part_rejoin, this->banvars.public_flood, this->banvars.public_flood_repeat, this->banvars.bad_word, this->banvars.bad_nick, this->banvars.normal_ban);
	}
	mysql_free_result(result);
	/* get trusted hostnames */
	if(!oer_doquery("initenv", OER_DEBUG_INFO, "SELECT hostmask FROM trusted WHERE ident = '%s'", mystate->ident)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "initenv->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		if((ms = addnewtrusted(row[0])) == NULL) {
			oer_debug(OER_DEBUG_FATAL, "initenv->failure while adding trusted hostname %s\n", row[0]);
			mysql_free_result(result);
                        return 0;
		}
		oer_debug(OER_DEBUG_INFO, "initenv->added trusted hostname %s\n", row[0]);
	}
	mysql_free_result(result);
	return 1;
}

char *getchanflags(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	return this->chanflags;
}

void setchanflags(char *channel, char *chanflags)
{
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "setchanflags->setting %s flags to %s\n", channel, chanflags);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	strncpy(this->chanflags, chanflags, FLAGLEN);
}

int burstjoins(char *channel)
{
	int i;
	time_t delta;
	struct channel *this;
	struct join *j;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(j = this->joins, i = 0; j != NULL; j = j->next) {
		delta = mystate->now - j->at;
		if(delta <= OER_BURST_JOINS_LIMIT) {
			i++;
		}
		if(i >= OER_BURST_JOINS) {
			return 1;
		}
	}
	return 0;
}

int partcount(char *channel, char *nick, char *host)
{
	int count;
	struct channel *this;
	struct part *p;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(count = 0, p = this->parts; p != NULL; p = p->next) {
		if(p->valid && (mystate->now < (p->at + OER_PART_EXPIRE))) {
			if(issamenickandhost(p->nick, nick, p->host, host)) {
				count++;
			}
                }
	}
	return count;
}

int admincount(void)
{
	int admins;
	struct botuser *admin;

	for(admins = 0, admin = mystate->admins; admin != NULL; admin = admin->next) {
		if(admin->firstmask != NULL) {
			admins++;
		}
	}
	return admins;
}

int usercount(char *channel)
{
	int users;
	struct channel *this;
	struct botuser *user;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(users = 0, user = this->users; user != NULL; user = user->next) {
		if(user->firstmask != NULL) {
			users++;
		}
	}
	return users;
}

void resetparts(char *channel, char *nick, char *host)
{
	struct channel *this;
	struct part *p;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(p = this->parts; p != NULL; p = p->next) {
		if(issamenickandhost(p->nick, nick, p->host, host)) {
			p->valid = 0;
		}
	}
}

time_t lastoff(char *channel, char *nick, char *host)
{
	time_t delta;
	struct channel *this;
	struct part *p;

	if((this = getchptr(channel)) == NULL) {
		return OER_AUTO_REJOIN_TIME + 1;
	}
	p = this->parts;
	while(p != NULL) {
                if(issamenickandhost(p->nick, nick, p->host, host)) {
			delta = (mystate->now - p->at);
			return delta;
		}
		p = p->next;
	}
	return OER_AUTO_REJOIN_TIME + 1;
}

int lastquote(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	return mystate->now - this->last_quote;
}

void setlastquote(char *channel, time_t last)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	this->last_quote = last;
}

int getjoincount(char *channel, char *nick)
{
	int joins;
	struct channel *this;
	struct join *j;

	if((this = getchptr(channel)) == NULL) {
		return -1;
	}
	joins = 0;
	j = this->joins;
	while(j != NULL) {
		if(!strcasecmp(j->nick, nick)) {
			joins++;
		}
		j = j->next;
	}
	return joins;
}

int isq(char *nick)
{
        if((index(mystate->flags, (int)'q') != NULL) && !strcasecmp(nick, Q_NICK)) {
                return 1;
        }
        return 0;
}

int isme(char *nick)
{
	if(!strcasecmp((mystate->use_alt_nick) ? mystate->altnick : mystate->nick, nick)) {
		return 1;
	} else {
		return 0;
	}
}

int amiop(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	return this->i_am_op;
}

void iamop(char *channel, int flag)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	this->i_am_op = flag;
}

int ispermban(char *channel, char *mask)
{
        MYSQL_RES *result;
        MYSQL_ROW row;

	if(!oer_doquery("ispermban", OER_DEBUG_INFO, "SELECT mask FROM permbans WHERE channel = '%s' AND ident = '%s'", channel, mystate->ident)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "ispermban->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	if(!mysql_num_rows(result)) {
		/* no permbans */
		mysql_free_result(result);
		return 0;
	}
	while((row = mysql_fetch_row(result)) != NULL) {
		if(!strcasecmp(row[0], mask)) {
			return 1;
		}
	}
	mysql_free_result(result);
	return 0;
}

int permbancount(char *channel)
{
	int pbs;
        MYSQL_RES *result;

	if(!oer_doquery("permbancount", OER_DEBUG_INFO, "SELECT mask FROM permbans WHERE channel = '%s' AND ident = '%s'", channel, mystate->ident)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "permbancount->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	pbs = mysql_num_rows(result);
	mysql_free_result(result);
	return pbs;
}

char *getkickreason(char *reason)
{
	int kr_count;
	int nth;
	int counter;
	MYSQL_RES *result;
        MYSQL_ROW row;

	/* get kickreasons */
	if(!oer_doquery("getkickreason", OER_DEBUG_INFO, "SELECT reason FROM kickreasons WHERE ident = '%s'", mystate->ident)) {
		return 0;
	}
	if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
		oer_debug(OER_DEBUG_FATAL, "getkickreason->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
                return 0;
	}
	if(!(kr_count = mysql_num_rows(result))) {
		mysql_free_result(result);
		return NULL;
	}
	nth = getrandom(kr_count);
	counter = 0;
	while((row = mysql_fetch_row(result)) != NULL) {
		if(counter == nth) {
			strncpy(reason, row[0], STRINGLEN);
			break;
		}
		counter++;
	}
	mysql_free_result(result);
	return reason;
}

int isop(char *channel, char *host)
{
	/* check for static +o user */
	if(hasuserflags(channel, host, "o") && !hasuserflags(channel, host, "d")) {
		return 1;
	}
	/* check for dynamic +o (logoned) user */
	if(hasuserflags(channel, host, "od") && isvalidlogon(channel, host)) {
		return 1;
	}
	return 0;
}

int isadmin(char *channel, char *host)
{
	/* check for admin */
	if(isopa(host)) {
		return 1;
	}
	/* check for static +a user */
	if(hasuserflags(channel, host, "a") && !hasuserflags(channel, host, "d")) {
		return 1;
	}
	/* check for dynamic +a (logoned) user */
	if(hasuserflags(channel, host, "ad") && isvalidlogon(channel, host)) {
		return 1;
	}
	return 0;
}

int isvalidlogon(char *channel, char *host)
{
	struct channel *this;
	struct authed *a;
	struct botuser *user;
	struct maskstruct *ms;

	if(host == NULL) {
		return 0;
	}
	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	/* go through all authed hostmasks that are valid */
	for(a = this->autheds; a != NULL; a = a->next) {
		if(mystate->now > (a->at + OER_LOGON_TIMEOUT)) {
			continue;
		}
		/* check if the auth matches */
		if(strcasecmp(a->host, host)) {
			continue;
		}
		user = a->user;
		/* check if the host in the user field match */
		for(ms = user->firstmask; ms != NULL; ms = ms->next) {
			if(wild_match(ms->mask, host)) {
				return 1;
			}
		}
		/* this auth didn't match, go to next */
		a = a->next;
	}
	/* no authed for this mask */
	return 0;
}

int isatleastopnow(char *channel, char *nick, char *host)
{
	if(isq(nick) || isadmin(channel, host) || isop(channel, host) || isopnow(channel, nick)) {
		return 1;
	}
	return 0;
}

int isatleastop(char *channel, char *nick, char *host)
{
	if(isq(nick) || isadmin(channel, host) || isop(channel, host)) {
		return 1;
	}
	return 0;
}

int isallowedop(char *channel, char *nick)
{
	struct channel *this;
	struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			break;
		}
	}
	if(cu == NULL) {
		return 0;
	}
	if(isq(nick)) {
                return 1;
        }
	/* first check for admin */
	if(isadmin(channel, cu->host)) {
		return 1;
	}
	/* then user */
        if(isop(channel, cu->host)) {
                return 1;
        }
        /* only dyn left, is dyn user with o flag? */
        if(!hasuserflags(channel, cu->host, "do")) {
                return 0;
        }
        if(!haschanflags(channel, "P")) {
                return 1;
        }
        /* paranoid channel, check for valid logon */
        if(isvalidlogon(channel, cu->host)) {
                return 1;
        }
        return 0;
}

int isopa(char *host)
{
	struct botuser *admin;
	struct maskstruct *ms;

	if(host == NULL) {
		return 0;
	}
	for(admin = mystate->admins; admin != NULL; admin = admin->next) {
		for(ms = admin->firstmask; ms != NULL; ms = ms->next) {
			if(wild_match(ms->mask, host)) {
				return 1;
			}
		}
	}
	return 0;
}

int delopa(char *handle)
{
	struct botuser *admin;

	for(admin = mystate->admins; admin != NULL; admin = admin->next) {
		if(!strcasecmp(admin->handle, handle)) {
			break;
		}
	}
	if(admin == NULL) {
		return 0;
	}
	if(index(admin->options, (int)'n') != NULL) {
		/* we won't delete admins with "n" flag */
		return 0;
	}
	return 1;
}

int isonchan(char *channel, char *nick)
{
	struct channel *this;
	struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			return 1;
		}
	}
	return 0;
}

int issameuser(char *channel, char *handle, char *host)
{
	struct botuser *user;
	struct maskstruct *ms;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(user = this->users; user != NULL; user = user->next) {
		if(!strcasecmp(user->handle, handle)) {
			break;
		}
	}
	if(user == NULL) {
		return 0;
	}
	for(ms = user->firstmask; ms != NULL; ms = ms->next) {
		if(wild_match(ms->mask, host)) {
			return 1;
		}
	}
	return 0;
}

int isopnow(char *channel, char *nick)
{
	struct channel *this;
	struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick) && cu->chanop) {
			return 1;
		}
	}
	return 0;
}

void banuser(char *channel, char *nick)
{
	struct channel *this;
	struct chanuser *cu;
	char ban[HOSTLEN + 1];

	oer_debug(OER_DEBUG_INFO, "banuser->channel %s nick: %s\n", channel, nick);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			if(cu->host == NULL) {
				return;
			}
			strncpy(ban, cu->host, HOSTLEN);
			if(safeban(ban) == NULL) {
				return;
			}
			addnewmm(this->name, mystate->now, "+b", ban);
			addnewmm(this->name, mystate->now + this->banvars.normal_ban, "-b", ban);
			return;
		}
	}
}

void unbanuser(char *channel, char *nick)
{
	struct channel *this;
	struct chanuser *cu;
	char ban[HOSTLEN + 1];

	oer_debug(OER_DEBUG_INFO, "unbanuser->channel %s nick: %s\n", channel, nick);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			if(cu->host == NULL) {
				return;
			}
			if(cu->chanop) {
				continue;
			}
			strncpy(ban, cu->host, HOSTLEN);
			if(safeban(ban) == NULL) {
				return;
			}
			addnewmm(this->name, mystate->now, "-b", ban);
			return;
		}
	}
}

void editcommand(char *to, int tochan, char *channel, char *nick, char *host, char *commandline)
{
	int proceed;
	int ppos;
        char p1[STRINGLEN + 1];
        char p2[STRINGLEN + 1];
        char p3[STRINGLEN + 1];
        char p4[STRINGLEN + 1];
        char p5[STRINGLEN + 1];
        char p6[STRINGLEN + 1];
        char p7[STRINGLEN + 1];
        char p8[STRINGLEN + 1];
	char stringbuffer[BIGSTRINGLEN + 1];
	char cryptsalt[3];
	char *crypted;
	struct channel *this;
	struct botuser *admin;
	struct botuser *user;

	oer_debug(OER_DEBUG_INFO, "editcommand->command: %s\n", commandline);
	/* command line parsing begins here, first parameter = the command */
	ppos = 0;
        if((ppos = parse(commandline, ppos, " ", p1, STRINGLEN, 0)) < 0) {
                return;
        }
	if(!strcasecmp(p1, "state")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if(!strlen(commandline + ppos)) {
			return;
		}
		strncpy(mystate->state, commandline + ppos, STRINGLEN);
		snprintf(stringbuffer, BIGSTRINGLEN, "my state is now %s", mystate->state);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "flags")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		strncpy(mystate->flags, p2, FLAGLEN);
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE conf SET flags = '%s' WHERE ident = '%s'", mystate->flags, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "my flags are now %s", mystate->flags);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "floodvars")) {
		if(numofparams(commandline) != 5) {
			return;
		}
		if(!isadmin(channel, host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p5, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p6, STRINGLEN, 0)) < 0) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		this->floodvars.repeat_expire = atoi(p2);
		this->floodvars.repeat_limit = atoi(p3);
		this->floodvars.interval = atoi(p4);
		this->floodvars.lines = atoi(p5);
		this->floodvars.chars = atoi(p6);
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE floodvars SET f_expire = %d, f_limit = %d, f_interval = %d, f_lines = %d, f_chars = %d WHERE channel = '%s' AND ident = '%s'", this->floodvars.repeat_expire, this->floodvars.repeat_limit, this->floodvars.interval, this->floodvars.lines, this->floodvars.chars, this->name, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "%s floodvars are now %d %d %d %d %d", this->name, this->floodvars.repeat_expire, this->floodvars.repeat_limit, this->floodvars.interval, this->floodvars.lines, this->floodvars.chars);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "banvars")) {
		if(numofparams(commandline) != 7) {
			return;
		}
		if(!isadmin(channel, host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p5, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p6, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p7, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p8, STRINGLEN, 0)) < 0) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		this->banvars.auto_rejoin = atoi(p2);
		this->banvars.part_rejoin = atoi(p3);
		this->banvars.public_flood = atoi(p4);
		this->banvars.public_flood_repeat = atoi(p5);
		this->banvars.bad_word = atoi(p6);
		this->banvars.bad_nick = atoi(p7);
		this->banvars.normal_ban = atoi(p8);
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE banvars SET b_auto_rejoin = %d, b_part_rejoin = %d, b_flood = %d, b_flood_repeat = %d, b_bad_word = %d, b_bad_nick = %d, b_normal_ban = %d WHERE channel = '%s' AND ident = '%s'", this->banvars.auto_rejoin, this->banvars.part_rejoin, this->banvars.public_flood, this->banvars.public_flood_repeat, this->banvars.bad_word, this->banvars.bad_nick, this->banvars.normal_ban, this->name, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "%s banvars are now %d %d %d %d %d %d %d", this->name, this->banvars.auto_rejoin, this->banvars.part_rejoin, this->banvars.public_flood, this->banvars.public_flood_repeat, this->banvars.bad_word, this->banvars.bad_nick, this->banvars.normal_ban);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "chanflags")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isadmin(channel, host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		setchanflags(channel, p2);
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE channels SET chanflags = '%s' WHERE name = '%s' AND ident = '%s'", p2, channel, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "%s chanflags are now %s", channel, getchanflags(channel));
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "chanmode")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isadmin(channel, host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		setchanmode(channel, p2);
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE channels SET chanmodes = '%s' WHERE name = '%s' AND ident = '%s'", p2, channel, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "%s chanmodes are now %s", channel, getchanmode(channel));
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "chankey")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isadmin(channel, host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		setchankey(channel, p2);
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE channels SET chankey = '%s' WHERE name = '%s' AND ident = '%s'", p2, channel, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "%s channel key is now %s", channel, getchankey(channel));
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "nick")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		strncpy(mystate->nick, p2, NICKLEN);
		mystate->newnick = 1;
		mystate->use_alt_nick = 0;
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE conf SET nick = '%s' WHERE ident = '%s'", mystate->nick, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "my nick is now %s", mystate->nick);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "altnick")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		strncpy(mystate->altnick, p2, NICKLEN);
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE conf SET altnick = '%s' WHERE ident = '%s'", mystate->altnick, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "my alternative nick is now %s", mystate->altnick);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "prefix")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		strncpy(mystate->prefix, p2, STRINGLEN);
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE conf SET prefix = '%s' WHERE ident = '%s'", mystate->prefix, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "my command prefix is now %s", mystate->prefix);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "realname")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		strncpy(mystate->realname, commandline + ppos, STRINGLEN);
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE conf SET realname = '%s' WHERE ident = '%s'", mystate->realname, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "my IRC REALNAME is now %s", mystate->realname);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "usermode")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		strncpy(mystate->mode, commandline + ppos, CHANLEN);
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE conf SET usermode = '%s' WHERE ident = '%s'", mystate->mode, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "my usermodes are now %s", mystate->mode);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "user")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		strncpy(mystate->user, commandline + ppos, USERLEN);
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE conf SET user = '%s' WHERE ident = '%s'", mystate->user, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "my user ID (ident) is now %s", mystate->user);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "vhost")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		strncpy(mystate->host, commandline + ppos, HOSTLEN);
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE conf SET vhost = '%s' WHERE ident = '%s'", mystate->host, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "my virtual hostname is now %s", mystate->host);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "password")) {
		if(numofparams(commandline) != 2) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		for(user = this->users; user != NULL; user = user->next) {
			if(!strcasecmp(user->handle, p2)) {
				break;
			}
		}
		if(user == NULL) {
			return;
		}
		proceed = (isopa(host)) ? 1 : 0;
		if(index(user->options, (int)'a') != NULL) {
			/* the user has +a flag */
			if(isadmin(channel, host) && issameuser(channel, p2, host)) {
				proceed = 1;
			}
		} else {
			/* a normal user */
			if(isadmin(channel, host)) {
				proceed = 1;
			}
			if(isop(channel, host) && issameuser(channel, p2, host)) {
				proceed = 1;
			}
		}
		if(!proceed) {
			return;
		}
		cryptsalt[0] = salt_chars[getrandom(strlen(salt_chars)) - 1];
		cryptsalt[1] = cryptsalt[0];
		cryptsalt[2] = '\0';
		crypted = crypt(p3, cryptsalt);
		if(!setpassword(channel, p2, crypted)) {
			return;
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "DELETE FROM passwords WHERE handle = '%s' AND channel = '%s' AND ident = '%s'", p2, channel, mystate->usersfrom)) {
				return;
			}
			if(!oer_doquery("editcommand", OER_DEBUG_INFO, "INSERT passwords VALUES ('%s', '%s', 1, '%s', '%s')", p2, channel, crypted, mystate->usersfrom)) {
				return;
			}
		}
		updateuserts(channel);
		snprintf(stringbuffer, BIGSTRINGLEN, "password for %s user %s is now %s", channel, p2, p3);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "options")) {
		if(numofparams(commandline) != 3) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		if(!strcasecmp(p2, "admin")) {
			if(!isopa(host)) {
				return;
			}
			for(admin = mystate->admins; admin != NULL; admin = admin->next) {
				if(!strcasecmp(admin->handle, p3)) {
					break;
				}
			}
			if(admin == NULL) {
				return;
			}
			/* we won't allow removal of the "n" flag for admins */
			if((index(admin->options, (int)'n') != NULL) && (index(p4, (int)'n') == NULL)) {
				oer_debug(OER_DEBUG_INFO, "editcommand->%s!%s attempted to unprotect protected admin %s\n", nick, host, p3);
				return;
			}
			free(admin->options);
			if((admin->options = malloc(strlen(p4) + 1)) == NULL) {
				return;
			}
			strcpy(admin->options, p4);
			if(strstr(mystate->state, "+ro") == NULL) {
				if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE admins SET flags = '%s' WHERE handle = '%s' AND ident = '%s'", admin->options, admin->handle, mystate->usersfrom)) {
					return;
				}
			}
			updateadmints();
			snprintf(stringbuffer, BIGSTRINGLEN, "flags for admin %s are now %s", admin->handle, admin->options);
			sendreply(to, tochan, 0, 0, stringbuffer);
			return;
		}
		if(!strcasecmp(p2, "user")) {
			if((this = getchptr(channel)) == NULL) {
				return;
			}
			for(user = this->users; user != NULL; user = user->next) {
				if(!strcasecmp(user->handle, p3)) {
					break;
				}
			}
			if(user == NULL) {
				return;
			}
			proceed = (isopa(host)) ? 1 : 0;
			if(index(user->options, (int)'a') != NULL) {
				/* the user has +a flag */
				if(isadmin(channel, host) && issameuser(channel, p3, host)) {
					proceed = 1;
				}
			} else {
				/* a normal user, check that no "a" flag is added */
                                if(isadmin(channel, host) && (index(p4, (int)'a') == NULL)) {
                                        proceed = 1;
                                }
			}
			if(!proceed) {
				return;
			}
			free(user->options);
			if((user->options = malloc(strlen(p4) + 1)) == NULL) {
				return;
			}
			strcpy(user->options, p4);
			if(strstr(mystate->state, "+ro") == NULL) {
				if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE users SET flags = '%s' WHERE handle = '%s' AND channel = '%s' AND ident = '%s'", user->options, user->handle, channel, mystate->usersfrom)) {
					return;
				}
			}
			updateuserts(channel);
			snprintf(stringbuffer, BIGSTRINGLEN, "flags for %s user %s are now %s", channel, user->handle, user->options);
			sendreply(to, tochan, 0, 0, stringbuffer);
			if(amiop(channel)) {
				syncvoices(channel);
				syncops(channel);
			}
			return;
		}
		return;
	}
	if(!strcasecmp(p1, "mask")) {
		if(numofparams(commandline) != 4) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p5, STRINGLEN, 0)) < 0) {
			return;
		}
		if(!strcasecmp(p2, "admin")) {
			if(!isopa(host)) {
				return;
			}
			for(admin = mystate->admins; admin != NULL; admin = admin->next) {
				if(!strcasecmp(admin->handle, p3)) {
					break;
				}
			}
			if(admin == NULL) {
				return;
			}
			if(editmask(admin->firstmask, p4, p5) == NULL) {
				return;
			}
			if(strstr(mystate->state, "+ro") == NULL) {
				if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE hostmasks SET hostmask = '%s' WHERE hostmask = '%s' AND handle = '%s' AND TYPE = 1 AND ident = '%s'", p5, p4, admin->handle, mystate->usersfrom)) {
					return;
				}
			}
			updateadmints();
			snprintf(stringbuffer, BIGSTRINGLEN, "changed mask for admin %s from %s to %s", admin->handle, p4, p5);
			sendreply(to, tochan, 0, 0, stringbuffer);
			return;
		}
		if(!strcasecmp(p2, "user")) {
			if((this = getchptr(channel)) == NULL) {
				return;
			}
			for(user = this->users; user != NULL; user = user->next) {
				if(!strcasecmp(user->handle, p3)) {
					break;
				}
			}
			if(user == NULL) {
				return;
			}
			proceed = (isopa(host)) ? 1 : 0;
			if(index(user->options, (int)'a') != NULL) {
				/* the user has +a flag */
				if(isadmin(channel, host) && issameuser(channel, p3, host)) {
					proceed = 1;
				}
			} else {
				/* a normal user */
				if(isadmin(channel, host)) {
					proceed = 1;
				}
				if(isop(channel, host) && issameuser(channel, p3, host)) {
					proceed = 1;
				}
			}
			if(!proceed) {
				return;
			}
			if(editmask(user->firstmask, p4, p5) == NULL) {
				return;
			}
			if(strstr(mystate->state, "+ro") == NULL) {
				if(!oer_doquery("editcommand", OER_DEBUG_INFO, "UPDATE hostmasks SET hostmask = '%s' WHERE hostmask = '%s' AND handle = '%s' AND channel = '%s' AND TYPE = 2 AND ident = '%s'", p5, p4, user->handle, this->name, mystate->usersfrom)) {
					return;
				}
			}
			updateuserts(this->name);
			snprintf(stringbuffer, BIGSTRINGLEN, "changed mask for %s channel user %s from %s to %s", this->name, p3, p4, p5);
			sendreply(to, tochan, 0, 0, stringbuffer);
			if(amiop(channel)) {
				syncvoices(channel);
				syncops(channel);
			}
			return;
		}
		return;
	}
}

void delcommand(char *to, int tochan, char *channel, char *nick, char *host, char *commandline)
{
	int proceed;
	int port;
	int modes;
	int ping;
	int opers;
	int noise;
	int req;
	int ppos;
	int nppos;
        char p1[STRINGLEN + 1];
        char p2[STRINGLEN + 1];
        char p3[STRINGLEN + 1];
        char p4[STRINGLEN + 1];
        char p5[STRINGLEN + 1];
        char p6[STRINGLEN + 1];
        char p7[STRINGLEN + 1];
	char stringbuffer[BIGSTRINGLEN + 1];
	char *ptr;
	struct channel *this;
	struct botuser *user;

	oer_debug(OER_DEBUG_INFO, "delcommand->command: %s\n", commandline);
	/* command line parsing begins here, first parameter = the command */
	ppos = 0;
        if((ppos = parse(commandline, ppos, " ", p1, STRINGLEN, 0)) < 0) {
                return;
        }
	if(!strcasecmp(p1, "admin")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if(!deladmin(p2, 0)) {
			return;
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM admins WHERE handle = '%s' AND ident = '%s'", p2, mystate->usersfrom)) {
				return;
			}
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM hostmasks WHERE handle = '%s' AND type = 1 AND ident = '%s'", p2, mystate->usersfrom)) {
				return;
			}
		}
		updateadmints();
		snprintf(stringbuffer, BIGSTRINGLEN, "deleted admin %s", p2);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "chankey")) {
		if((numofparams(commandline) != 0)) {
			return;
		}
		if(!isadmin(channel, host)) {
			return;
		}
		if(!delchankey(channel)) {
			return;
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "UPDATE channels SET chankey = '' WHERE name = '%s' AND ident = '%s'", channel, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "deleted channel key from %s", channel);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "channel")) {
		req = (tochan) ? 0 : 1;
		if((numofparams(commandline) != req)) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if(!tochan) {
			if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
				return;
			}
			ptr = p2;
		} else {
			ptr = channel;
		}
		if(!delchannel(ptr)) {
			return;
		}
		/* first off, delete channel */
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM channels WHERE name = '%s' AND ident = '%s'", ptr, mystate->ident)) {
				return;
			}
		}
		/* then delete channel banvars */
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM banvars WHERE channel = '%s' AND ident = '%s'", ptr, mystate->ident)) {
				return;
			}
		}
		/* then delete channel floodvars */
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM floodvars WHERE channel = '%s' AND ident = '%s'", ptr, mystate->ident)) {
				return;
			}
		}
		/* then delete hostmasks of channel users */
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM hostmasks WHERE channel = '%s' AND ident = '%s'", ptr, mystate->usersfrom)) {
				return;
			}
		}
		/* then delete channel nickbks */
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM nickbks WHERE channel = '%s' AND ident = '%s'", ptr, mystate->ident)) {
				return;
			}
		}
		/* then delete passwords of channel users */
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM passwords WHERE channel = '%s' AND ident = '%s'", ptr, mystate->usersfrom)) {
				return;
			}
		}
		/* then delete channel permbans */
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM permbans WHERE channel = '%s' AND ident = '%s'", ptr, mystate->ident)) {
				return;
			}
		}
		/* then delete channel users */
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM users WHERE channel = '%s' AND ident = '%s'", ptr, mystate->usersfrom)) {
				return;
			}
		}
		/* then delete channel wordbks */
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM wordbks WHERE channel = '%s' AND ident = '%s'", ptr, mystate->ident)) {
				return;
			}
		}
		/* then delete channel adverts */
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM adverts WHERE channel = '%s' AND ident = '%s'", ptr, mystate->ident)) {
				return;
			}
		}
		/* then delete channel timestamps */
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM timestamps WHERE tchannel = '%s' AND ident = '%s'", ptr, mystate->usersfrom)) {
				return;
			}
		}
		updateuserts(ptr);
		snprintf(stringbuffer, BIGSTRINGLEN, "deleted channel %s", ptr);
		sendreply(to, tochan, 0, 1, stringbuffer);
		mysqldbname(ptr, p3, STRINGLEN);
		snprintf(stringbuffer, BIGSTRINGLEN, "database tables last_%s and seen_%s have to be deleted manually (if they exist)", p3, p3);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "user")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		for(user = this->users; user != NULL; user = user->next) {
			if(!strcasecmp(user->handle, p2)) {
				break;
			}
		}
		if(user == NULL) {
			return;
		}
		proceed = (isopa(host)) ? 1 : 0;
		if(index(user->options, (int)'a') == NULL) {
			/* a normal user */
			if(isadmin(channel, host)) {
				proceed = 1;
			}
		}
		if(!proceed) {
			return;
		}
		if(!deluser(channel, p2)) {
			return;
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM users WHERE handle = '%s' AND channel = '%s' AND ident = '%s'", p2, channel, mystate->usersfrom)) {
				return;
			}
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM hostmasks WHERE handle = '%s' AND channel = '%s' AND type = 2 AND ident = '%s'", p2, channel, mystate->usersfrom)) {
				return;
			}
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM passwords WHERE handle = '%s' AND channel = '%s' AND type = 1 AND ident = '%s'", p2, channel, mystate->usersfrom)) {
				return;
			}
		}
		updateuserts(channel);
		snprintf(stringbuffer, BIGSTRINGLEN, "deleted %s channel user %s", channel, p2);
		sendreply(to, tochan, 0, 1, stringbuffer);
		if(amiop(channel)) {
			syncops(channel);
		}
		return;
	}
	if(!strcasecmp(p1, "mask")) {
		if(numofparams(commandline) != 3) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		if(!strcasecmp(p2, "admin")) {
			if(!isopa(host)) {
				return;
			}
			if(!deladminmask(p3, p4)) {
				return;
			}
			if(strstr(mystate->state, "+ro") == NULL) {
				if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM hostmasks WHERE handle = '%s' AND hostmask = '%s' AND type = 1 AND ident = '%s'", p3, p4, mystate->usersfrom)) {
					return;
				}
			}
			updateadmints();
			snprintf(stringbuffer, BIGSTRINGLEN, "deleted mask %s from admin %s", p3, p4);
			sendreply(to, tochan, 0, 1, stringbuffer);
			return;
		}
		if(!strcasecmp(p2, "user")) {
			if((this = getchptr(channel)) == NULL) {
				return;
			}
			for(user = this->users; user != NULL; user = user->next) {
				if(!strcasecmp(user->handle, p3)) {
					break;
				}
			}
			if(user == NULL) {
				return;
			}
			proceed = (isopa(host)) ? 1 : 0;
			if(index(user->options, (int)'a') != NULL) {
				/* the user has +a flag */
				if(isadmin(channel, host) && issameuser(channel, p3, host)) {
					proceed = 1;
				}
			} else {
				/* a normal user */
				if(isadmin(channel, host)) {
					proceed = 1;
				}
				if(isop(channel, host) && issameuser(channel, p3, host)) {
					proceed = 1;
				}
			}
			if(!proceed) {
				return;
			}
			if(!delusermask(channel, p3, p4)) {
				return;
			}
			if(strstr(mystate->state, "+ro") == NULL) {
				if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM hostmasks WHERE handle = '%s' AND hostmask = '%s' AND channel = '%s' AND type = 2 AND ident = '%s'", p3, p4, channel, mystate->usersfrom)) {
					return;
				}
			}
			updateuserts(channel);
			snprintf(stringbuffer, BIGSTRINGLEN, "deleted mask %s from %s user %s", p4, channel, p3);
			sendreply(to, tochan, 0, 1, stringbuffer);
			if(amiop(channel)) {
				syncops(channel);
			}
			return;
		}
		return;
	}
	if(!strcasecmp(p1, "permban")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		while(1) {
                        nppos = parse(commandline, ppos, " ", p2, NICKLEN, 0);
                        if(nppos == ppos || nppos < 0) {
                                break;
                        }
			ppos = nppos;
			if(strstr(mystate->state, "+ro") == NULL) {
				if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM permbans WHERE channel = '%s' AND mask = '%s' AND ident = '%s'", channel, p2, mystate->ident)) {
					continue;
				}
			}
			snprintf(stringbuffer, BIGSTRINGLEN, "removed permban %s from channel %s", p2, channel);
			sendreply(to, tochan, 0, 1, stringbuffer);
			if(amiop(channel)) {
				addnewmm(channel, mystate->now, "-b", p2);
			}
		}
		return;
	}
	if(!strcasecmp(p1, "nickbk")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		while(1) {
                        nppos = parse(commandline, ppos, " ", p2, NICKLEN, 0);
                        if(nppos == ppos || nppos < 0) {
                                break;
                        }
			ppos = nppos;
			if(delnickbk(channel, p2)) {
				if(strstr(mystate->state, "+ro") == NULL) {
					if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM nickbks WHERE channel = '%s' AND pattern = '%s' AND ident = '%s'", channel, p2, mystate->ident)) {
						continue;
					}
				}
				snprintf(stringbuffer, BIGSTRINGLEN, "removed nickbk %s from channel %s", p2, channel);
				sendreply(to, tochan, 0, 1, stringbuffer);
			}
		}
		return;
	}
	if(!strcasecmp(p1, "wordbk")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		while(1) {
                        nppos = parse(commandline, ppos, " ", p2, NICKLEN, 0);
                        if(nppos == ppos || nppos < 0) {
                                break;
                        }
			ppos = nppos;
			if(delwordbk(channel, p2)) {
				if(strstr(mystate->state, "+ro") == NULL) {
					if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM wordbks WHERE channel = '%s' AND pattern = '%s' AND ident = '%s'", channel, p2, mystate->ident)) {
						continue;
					}
				}
				snprintf(stringbuffer, BIGSTRINGLEN, "removed wordbk %s from channel %s", p2, channel);
				sendreply(to, tochan, 0, 1, stringbuffer);
			}
		}
		return;
	}
	if(!strcasecmp(p1, "adverts")) {
                if(numofparams(commandline) < 1) {
                        return;
                }
                if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
                        return;
                }
                if(strcasecmp(p2, "admins") && strcasecmp(p2, "ops") && strcasecmp(p2, "other") && strcasecmp(p2, "lamers")) {
			return;
		}
                if(!strcasecmp(p2, "admins")) {
                        if(!isopa(host) && !isadmin(channel, host)) {
                                return;
                        }
                }
                deladverts(channel, p2);
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM adverts WHERE channel = '%s' AND type = '%s' AND ident = '%s'", channel, p2, mystate->ident)) {
				return;
			}
		}
                snprintf(stringbuffer, BIGSTRINGLEN, "removed all adverts of type \"%s\" from channel %s", p2, channel);
                sendreply(to, tochan, 0, 1, stringbuffer);
                return;
        }
	if(!strcasecmp(p1, "kickreason")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM kickreasons WHERE reason = '%s' AND ident = '%s'", commandline + ppos, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "removed kickreason: %s", commandline + ppos);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "trusted")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		while(1) {
                        nppos = parse(commandline, ppos, " ", p2, NICKLEN, 0);
                        if(nppos == ppos || nppos < 0) {
                                break;
                        }
			ppos = nppos;
			if(deltrusted(p2)) {
				if(strstr(mystate->state, "+ro") == NULL) {
					if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM trusted WHERE hostmask = '%s' AND ident = '%s'", p2, mystate->ident)) {
						continue;
					}
				}
				snprintf(stringbuffer, BIGSTRINGLEN, "removed trusted hostname %s", p2);
				sendreply(to, tochan, 0, 1, stringbuffer);
			}
		}
		return;
	}
	if(!strncasecmp(commandline, "server", 6)) {
		if(numofparams(commandline) != 6) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if(!strlen(p3)) {
			return;
		}
		port = atoi(p3);
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		modes = (strlen(p4) > 0) ? atoi(p4) : 6;
		if((ppos = parse(commandline, ppos, " ", p5, STRINGLEN, 0)) < 0) {
			return;
		}
		ping = (strlen(p5) > 0) ? atoi(p5) : 90;
		if((ppos = parse(commandline, ppos, " ", p6, STRINGLEN, 0)) < 0) {
			return;
		}
		opers = (strlen(p6) > 0) ? atoi(p6) : 1;
		if((ppos = parse(commandline, ppos, " ", p7, STRINGLEN, 0)) < 0) {
			return;
		}
		noise = (strlen(p7) > 0) ? atoi(p7) : 1;
		if(!delserver(p2, port, modes, ping, opers, noise)) {
			return;
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("delcommand", OER_DEBUG_INFO, "DELETE FROM servers WHERE hostname = '%s' AND port = %d AND servermodes = %d AND pingfreq = %d AND protopers = %d AND linenoise = %d AND ident = '%s'", p2, port, modes, ping, opers, noise, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "removed IRC server: %s %d %d %d %d %d", p2, port, modes, ping, opers, noise);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
}

void addcommand(char *to, int tochan, char *channel, char *nick, char *host, char *commandline)
{
	int amount;
	int port;
	int modes;
	int ping;
	int opers;
	int noise;
	int proceed;
	int ppos;
	int nppos;
        char p1[STRINGLEN + 1];
        char p2[STRINGLEN + 1];
        char p3[STRINGLEN + 1];
        char p4[STRINGLEN + 1];
        char p5[STRINGLEN + 1];
        char p6[STRINGLEN + 1];
        char p7[STRINGLEN + 1];
        char p8[STRINGLEN + 1];
	char stringbuffer[BIGSTRINGLEN + 1];
	char *pwptr;
	struct botuser *admin;
	struct botuser *user;
	struct maskstruct *ms;
	struct channel *this;
	struct server *server;
	struct advert *a;

	oer_debug(OER_DEBUG_INFO, "addcommand->command: %s\n", commandline);
	/* command line parsing begins here, first parameter = the command */
	ppos = 0;
        if((ppos = parse(commandline, ppos, " ", p1, STRINGLEN, 0)) < 0) {
                return;
        }
	if(!strcasecmp(p1, "channel")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((this = addnewchannel(p2)) == NULL) {
			return;
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("addcommand", OER_DEBUG_INFO, "INSERT INTO channels VALUES ('%s', '', '', '', '%s')", this->name, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "added new channel %s", this->name);
		sendreply(to, tochan, 0, 0, stringbuffer);
		mysqldbname(this->name, p3, STRINGLEN);
		snprintf(stringbuffer, BIGSTRINGLEN, "database tables last_%s and seen_%s have to be created manually using the provided oer+MySQL-last.sql and oer+MySQL-seen.sql scripts", p3, p3);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "server")) {
		if(numofparams(commandline) != 3 && numofparams(commandline) != 6 && numofparams(commandline) != 7) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if(!strlen(p3)) {
			return;
		}
		port = atoi(p3);
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		modes = (strlen(p4) > 0) ? atoi(p4) : 6;
		if((ppos = parse(commandline, ppos, " ", p5, STRINGLEN, 0)) < 0) {
			return;
		}
		ping = (strlen(p5) > 0) ? atoi(p5) : 90;
		if((ppos = parse(commandline, ppos, " ", p6, STRINGLEN, 0)) < 0) {
			return;
		}
		opers = (strlen(p6) > 0) ? atoi(p6) : 1;
		if((ppos = parse(commandline, ppos, " ", p7, STRINGLEN, 0)) < 0) {
			return;
		}
		noise = (strlen(p7) > 0) ? atoi(p7) : 0;
		if((ppos = parse(commandline, ppos, " ", p8, STRINGLEN, 0)) < 0) {
			return;
		}
		pwptr = (strlen(p8)) ? p8 : NULL;
		if((server = addnewserver(p2, port, modes, ping, opers, noise, pwptr)) == NULL) {
			return;
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("addcommand", OER_DEBUG_INFO, "INSERT INTO servers VALUES ('%s', '%d', '%d', '%d', '%d', '%d', '%s', '%s')", server->serverhost, server->serverport, server->servermodes, server->pingfrequency, server->protected_ircops, server->linenoise, (pwptr == NULL) ? "" : pwptr, mystate->ident)) {
				return;
			}
		}
                snprintf(stringbuffer, BIGSTRINGLEN, "added new IRC server: %s %d %d %d %d %d %s", server->serverhost, server->serverport, server->servermodes, server->pingfrequency, server->protected_ircops, server->linenoise, (pwptr == NULL) ? "(null)" : pwptr);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "admin")) {
		/* we allow the user to tell flags later... */
		if(numofparams(commandline) != 1 && numofparams(commandline) != 2) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		/* only allow +n admins to add other +n admins */
		if((index(p3, (int)'n') != NULL) && !hasadminflags(host, "n")) {
			return;
		}
		if((admin = addnewadmin(p2, p3)) == NULL) {
			return;
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("addcommand", OER_DEBUG_INFO, "INSERT INTO admins VALUES ('%s', '%s', '%s')", admin->handle, admin->options, mystate->usersfrom)) {
				return;
			}
		}
		updateadmints();
		snprintf(stringbuffer, BIGSTRINGLEN, "added admin %s with flags %s", admin->handle, admin->options);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "user")) {
		/* we allow the user to tell flags later... */
		if(numofparams(commandline) != 1 && numofparams(commandline) != 2) {
			return;
		}
		if(!isadmin(channel, host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((index(p3, (int)'a') != NULL) && !isopa(host)) {
			/* only admins can add +a users */
			return;
		}
		if((user = addnewuser(channel, p2, p3)) == NULL) {
			return;
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("addcommand", OER_DEBUG_INFO, "INSERT INTO users VALUES ('%s', '%s', '%s', '%s')", user->handle, channel, user->options, mystate->usersfrom)) {
				return;
			}
		}
		updateuserts(channel);
		snprintf(stringbuffer, BIGSTRINGLEN, "added user %s to channel %s with flags %s", user->handle, channel, user->options);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "mask")) {
		if(numofparams(commandline) != 3) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		if(!strcasecmp(p2, "admin")) {
			if(!isopa(host)) {
				return;
			}
			if((ms = addnewadminmask(p3, p4)) == NULL) {
				return;
			}
			if(strstr(mystate->state, "+ro") == NULL) {
				if(!oer_doquery("addcommand", OER_DEBUG_INFO, "INSERT INTO hostmasks VALUES ('%s', '', %d, '%s', '%s')", ms->mask, 1, p3, mystate->usersfrom)) {
					return;
				}
			}
			updateadmints();
			snprintf(stringbuffer, BIGSTRINGLEN, "added mask %s to admin %s", ms->mask, p3);
			sendreply(to, tochan, 0, 0, stringbuffer);
			return;
		}
		if(!strcasecmp(p2, "user")) {
			if((this = getchptr(channel)) == NULL) {
				return;
			}
			for(user = this->users; user != NULL; user = user->next) {
				if(!strcasecmp(user->handle, p3)) {
					break;
				}
			}
			if(user == NULL) {
				return;
			}
			proceed = (isopa(host)) ? 1 : 0;
			if(index(user->options, (int)'a') != NULL) {
				/* the user has +a flag */
				if(isadmin(channel, host) && issameuser(channel, p3, host)) {
					proceed = 1;
				}
			} else {
				/* a normal user */
				if(isadmin(channel, host)) {
					proceed = 1;
				}
				if(isop(channel, host) && issameuser(channel, p3, host)) {
					proceed = 1;
				}
			}
			if(!proceed) {
				return;
			}
			if((ms = addnewusermask(channel, p3, p4)) == NULL) {
				return;
			}
			if(strstr(mystate->state, "+ro") == NULL) {
				if(!oer_doquery("addcommand", OER_DEBUG_INFO, "INSERT INTO hostmasks VALUES ('%s', '%s', %d, '%s', '%s')", ms->mask, channel, 2, p3, mystate->usersfrom)) {
					return;
				}
			}
			updateuserts(channel);
			snprintf(stringbuffer, BIGSTRINGLEN, "added mask %s to %s user %s", ms->mask, channel, p3);
			sendreply(to, tochan, 0, 0, stringbuffer);
			if(amiop(channel)) {
				syncvoices(channel);
				syncops(channel);
			}
			return;
		}
		return;
	}
	if(!strcasecmp(p1, "permban")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		amount = permbancount(channel);
		if(amount >= OER_PERMBANS) {
			snprintf(stringbuffer, BIGSTRINGLEN, "I won't add permban %s to channel %s (max. %d)", p2, channel, OER_PERMBANS);
			sendreply(to, tochan, 0, 0, stringbuffer);
			return;
		}
		/* check that new permban doesn't harm us */
		snprintf(stringbuffer, BIGSTRINGLEN, "%s!%s@%s", (mystate->use_alt_nick) ? mystate->altnick : mystate->nick, mystate->user, mystate->host);
		if(wild_match(p2, stringbuffer)) {
			snprintf(stringbuffer, BIGSTRINGLEN, "I won't add %s as permban to %s (do NOT ban me)", p2, channel);
			sendreply(to, tochan, 0, 0, stringbuffer);
			return;
		}
		if(amiop(channel)) {
			addnewmm(channel, mystate->now, "+b", p2);
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("addcommand", OER_DEBUG_INFO, "INSERT INTO permbans VALUES ('%s', '%s', '%s', '%s', %lu, '%s')", channel, p2, nick, nick, mystate->now, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "added new permban %s to channel %s", p2, channel);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "nickbk")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ms = addnewnickbk(channel, p2, commandline + ppos)) == NULL) {
			return;
		}
		if(amiop(channel)) {
			syncnickbks(channel);
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("addcommand", OER_DEBUG_INFO, "INSERT INTO nickbks VALUES ('%s', '%s', '%s', '%s', %lu, '%s')", channel, ms->mask, ms->optstring, nick, mystate->now, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "added nick %s as ban & kick for channel %s", ms->mask, channel);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "wordbk")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ms = addnewwordbk(channel, p2, commandline + ppos)) == NULL) {
			return;
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("addcommand", OER_DEBUG_INFO, "INSERT INTO wordbks VALUES ('%s', '%s', '%s', '%s', %lu, '%s')", channel, ms->mask, ms->optstring, nick, mystate->now, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "added word %s as ban & kick for channel %s", ms->mask, channel);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "kickreason")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("addcommand", OER_DEBUG_INFO, "INSERT INTO kickreasons VALUES ('%s', '%s')", commandline + ppos, mystate->ident)) {
				return;
			}
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "added new kickreason: %s", commandline + ppos);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "trusted")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		while(1) {
                        nppos = parse(commandline, ppos, " ", p2, NICKLEN, 0);
                        if(nppos == ppos || nppos < 0) {
                                break;
                        }
			ppos = nppos;
			if((ms = addnewtrusted(p2)) == NULL) {
				return;
			}
			if(strstr(mystate->state, "+ro") == NULL) {
				if(!oer_doquery("addcommand", OER_DEBUG_INFO, "INSERT INTO trusted VALUES ('%s', '%s')", ms->mask, mystate->ident)) {
					return;
				}
			}
			snprintf(stringbuffer, BIGSTRINGLEN, "added new trusted hostname %s", ms->mask);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "advert")) {
                if(numofparams(commandline) < 2) {
                        return;
                }
                if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
                        return;
                }
                if(strcasecmp(p2, "admins") && strcasecmp(p2, "ops") && strcasecmp(p2, "other") && strcasecmp(p2, "lamers")) {
			return;
		}
                if(!strcasecmp(p2, "admins")) {
                        if(!isopa(host) && !isadmin(channel, host)) {
                                return;
                        }
                }
                if((a = addnewadvert(channel, p2, commandline + ppos)) == NULL) {
                        return;
                }
		if(strstr(mystate->state, "+ro") == NULL) {
			if(!oer_doquery("addcommand", OER_DEBUG_INFO, "INSERT INTO adverts VALUES ('%s', '%s', '%s', '%s')", channel, a->type, a->message, mystate->ident)) {
				return;
			}
		}
                snprintf(stringbuffer, BIGSTRINGLEN, "added new advert \"%s\" (type: %s) to channel %s", a->message, a->type, channel);
                sendreply(to, tochan, 0, 0, stringbuffer);
                return;
        }
}

void listcommand(char *to, int tochan, char *channel, char *nick, char *host, char *commandline)
{
	int lines;
	int startpos;
	int curpos;
	int more;
	int amount;
	int ppos;
	int proceed;
        char p1[STRINGLEN + 1];
        char p2[STRINGLEN + 1];
        char p3[STRINGLEN + 1];
	char outstring[STRINGLEN + 1];
	char stringbuffer[HUGESTRINGLEN + 1];
	char stringbuffer2[HUGESTRINGLEN + 1];
	struct server *server;
	struct channel *this;
	struct botuser *admin;
	struct botuser *user;
	struct maskstruct *ms;
	struct chanuser *cu;
	struct authed *a;
	struct advert *adv;
	MYSQL_RES *result;
        MYSQL_ROW row;

	ppos = 0;
        if((ppos = parse(commandline, ppos, " ", p1, STRINGLEN, 0)) < 0) {
                return;
        }
	if(!strcasecmp(p1, "state")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "my state is %s", mystate->state);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "nick")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "my nick is %s", mystate->nick);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "altnick")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "my alternative nick is %s", mystate->altnick);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "user")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "my user ID (ident) is %s", mystate->user);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "flags")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "my flags are %s", mystate->flags);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "prefix")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "my command prefix is %s", mystate->prefix);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "usermode")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "my usermodes are %s", mystate->mode);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "realname")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "my IRC REALNAME is %s", mystate->realname);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "vhost")) {
		if(mystate->vhost) {
			snprintf(stringbuffer, HUGESTRINGLEN, "my virtual hostname is %s", mystate->host);
			sendreply(to, tochan, 0, 1, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "servers")) {
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		for(server = mystate->servers, lines = 0, curpos = 1, more = 0; server != NULL; server = server->next, curpos++) {
			if(lines < OER_MAX_LIST_LINES) {
				if(curpos >= startpos) {
					snprintf(stringbuffer, HUGESTRINGLEN, "%s %d %d %d %d %d %s%s", server->serverhost, server->serverport, server->servermodes, server->pingfrequency, server->protected_ircops, server->linenoise, (strlen(server->password) && isopa(host)) ? server->password : "(null)", (server == mystate->current_server) ? " (current)" : "");
					sendreply(to, tochan, 0, 0, stringbuffer);
					lines++;
				}
			} else {
				more = 1;
			}
		}
		if(more) {
			snprintf(stringbuffer, HUGESTRINGLEN, "%d servers, listing limited to %d lines", curpos - 1, OER_MAX_LIST_LINES);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "channels")) {
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		for(this = mystate->channels, lines = 0, curpos = 1, more = 0; this != NULL; this = this->next, curpos++) {
                        if(haschanflags(this->name, "U") && !isatleastop(this->name, nick, host)) {
                                continue;
                        }
			if(!isatleastopnow(this->name, nick, host)) {
				/* do not show everything */
				continue;
                        }
			if(lines < OER_MAX_LIST_LINES) {
				if(curpos >= startpos) {
					if(this->haskey) {
                                                snprintf(stringbuffer, HUGESTRINGLEN, "%s (%d %s) [key: %s]", this->name, this->nickcount, (this->nickcount == 1) ? "user" : "users", this->key);
                                        } else {
                                                snprintf(stringbuffer, HUGESTRINGLEN, "%s (%d %s)", this->name, this->nickcount, (this->nickcount == 1) ? "user" : "users");
                                        }
					sendreply(to, tochan, 0, 0, stringbuffer);
					lines++;
				}
			} else {
				more = 1;
			}
		}
		if(more) {
			snprintf(stringbuffer, HUGESTRINGLEN, "%d channels, listing limited to %d lines", curpos - 1, OER_MAX_LIST_LINES);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "adverts")) {
                if((this = getchptr(channel)) == NULL) {
                        return;
                }
                if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
                        return;
                }
                startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		for(adv = this->adverts, lines = 0, curpos = 1, more = 0; adv != NULL; adv = adv->next, curpos++) {
                        if(haschanflags(this->name, "U") && !isatleastop(this->name, nick, host)) {
                                continue;
                        }
                        if(!isatleastopnow(this->name, nick, host)) {
                                continue;
                        }
			if(!strcmp(adv->type, "admins")) {
                                if(!isopa(host) && !isadmin(this->name, host)) {
                                        continue;
                                }
                        }
			if(lines < OER_MAX_LIST_LINES) {
                                if(curpos >= startpos) {
                                        snprintf(stringbuffer, HUGESTRINGLEN, "%s (type: %s)", adv->message, adv->type);
                                        sendreply(to, tochan, 0, 0, stringbuffer);
                                        lines++;
                                }
                        } else {
                                more = 1;
                        }
		}
                if(more) {
                        snprintf(stringbuffer, HUGESTRINGLEN, "%d adverts, listing limited to %d lines", curpos - 1, OER_MAX_LIST_LINES);
                        sendreply(to, tochan, 0, 0, stringbuffer);
                }
                return;
        }
	if(!strcasecmp(p1, "trusted")) {
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		for(ms = mystate->trusted, lines = 0, curpos = 1, more = 0; ms != NULL; ms = ms->next, curpos++) {
			if(lines < OER_MAX_LIST_LINES) {
				if(curpos >= startpos) {
					snprintf(stringbuffer, HUGESTRINGLEN, "trusted hostname: %s", ms->mask);
					sendreply(to, tochan, 0, 0, stringbuffer);
					lines++;
				}
			} else {
				more = 1;
			}
		}
		if(more) {
			snprintf(stringbuffer, HUGESTRINGLEN, "%d trusted hostnames, listing limited to %d lines", curpos - 1, OER_MAX_LIST_LINES);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "admins")) {
		if(numofparams(commandline) >= 1) {
			if(!isopa(host)) {
				return;
			}
			if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
				return;
			}
			if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
				return;
			}
			for(admin = mystate->admins; admin != NULL; admin = admin->next) {
				if(!strcasecmp(admin->handle, p2)) {
					break;
				}
			}
			if(admin == NULL) {
				return;
			}
			if(strlen(p3) > 0) {
				startpos = atoi(p3);
			} else {
				startpos = 1;
				/* only send header info if no startpos */
				snprintf(stringbuffer, HUGESTRINGLEN, "flags for admin %s: %s", admin->handle, admin->options);
				sendreply(to, tochan, 0, 0, stringbuffer);
			}
			for(ms = admin->firstmask, lines = 0, curpos = 1, more = 0; ms != NULL; ms = ms->next, curpos++) {
				if(lines < OER_MAX_LIST_LINES) {
					if(curpos >= startpos) {
						snprintf(stringbuffer, HUGESTRINGLEN, "hostmask for admin %s: %s", admin->handle, ms->mask);
						sendreply(to, tochan, 0, 0, stringbuffer);
						lines++;
					}
				} else {
					more = 1;
				}
			}
			if(more) {
				snprintf(stringbuffer, HUGESTRINGLEN, "%d hostmasks in total, listing limited to %d lines", curpos - 1, OER_MAX_LIST_LINES);
				sendreply(to, tochan, 0, 0, stringbuffer);
			}
			return;
		}
		/* no parameters, list all admins */
		memset(stringbuffer, 0, HUGESTRINGLEN + 1);
		strncpy(stringbuffer, "admins: ", HUGESTRINGLEN);
		admin = mystate->admins;
		while(admin != NULL) {
			if(strlen(stringbuffer) + strlen(admin->handle) > HUGESTRINGLEN) {
				sendreply(to, tochan, 0, 0, stringbuffer);
				memset(stringbuffer, 0, HUGESTRINGLEN + 1);
				strncpy(stringbuffer, "admins: ", HUGESTRINGLEN);
			}
			strncat(stringbuffer, admin->handle, HUGESTRINGLEN - strlen(stringbuffer));
			strncat(stringbuffer, " ", HUGESTRINGLEN - strlen(stringbuffer));
			admin = admin->next;
		}
		if(strlen(stringbuffer) > 0) {
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "kickreasons")) {
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		if(!oer_doquery("listcommand", OER_DEBUG_INFO, "SELECT reason FROM kickreasons WHERE ident = '%s'", mystate->ident)) {
			return;
		}
		if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
			oer_debug(OER_DEBUG_FATAL, "listcommand->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
			return;
		}
		if(!mysql_num_rows(result)) {
			mysql_free_result(result);
			return;
		}
		for(lines = 0, curpos = 1, more = 0; (row = mysql_fetch_row(result)) != NULL; curpos++) {
			if(lines < OER_MAX_LIST_LINES) {
				if(curpos >= startpos) {
					snprintf(stringbuffer, HUGESTRINGLEN, "kickreason: %s", row[0]);
					sendreply(to, tochan, 0, 0, stringbuffer);
					lines++;
				}
			} else {
				more = 1;
			}
		}
		mysql_free_result(result);
		if(more) {
			snprintf(stringbuffer, HUGESTRINGLEN, "%d kickreasons, listing limited to %d lines", curpos - 1, OER_MAX_LIST_LINES);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "chankey")) {
		if(haschanflags(channel, "U") && !isatleastop(channel, nick, host)) {
			return;
		}
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "channel key is %s", this->key);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "chanmode")) {
		if(haschanflags(channel, "U") && !isatleastop(channel, nick, host)) {
			return;
		}
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "channel modes are %s", this->mode);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "chanflags")) {
		if(haschanflags(channel, "U") && !isatleastop(channel, nick, host)) {
			return;
		}
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		memset(outstring, 0, STRINGLEN + 1);
		memset(stringbuffer, 0, HUGESTRINGLEN + 1);
		strncat(outstring, (haschanflags(this->name, "!")) ? "!" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "!")) ? "!/inactive=1 " : "!/inactive=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "a")) ? "a" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "a")) ? "a/ansi_prot=1 " : "a/ansi_prot=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "A")) ? "A" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "A")) ? "A/adverts=1 " : "A/adverts=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "b")) ? "b" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "b")) ? "b/ban_prot=1 " : "b/ban_prot=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "e")) ? "e" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "e")) ? "e/perm_bans=1 " : "e/perm_bans=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "f")) ? "f" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "f")) ? "f/pubmsg_floodp=1 " : "f/pubmsg_floodp=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "F")) ? "F" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "F")) ? "F/friends=1 " : "F/friends=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "G")) ? "G" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "G")) ? "G/allflood=1 " : "G/allflood=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "l")) ? "l" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "l")) ? "l/lock_chan=1 " : "l/lock_chan=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "L")) ? "L" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "L")) ? "L/last=1 " : "L/last=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "m")) ? "m" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "m")) ? "m/mass_prot=1 " : "m/mass_prot=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "n")) ? "n" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "n")) ? "n/nick_bk=1 " : "n/nick_bk=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "o")) ? "o" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "o")) ? "o/auto_op=1 " : "o/auto_op=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "O")) ? "O" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "O")) ? "O/auto_op_admins=1 " : "O/auto_op_admins=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "p")) ? "p" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "p")) ? "p/postnj_check=1 " : "p/postnj_check=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "P")) ? "P" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "P")) ? "P/paranoid=1 " : "P/paranoid=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "q")) ? "q" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "q")) ? "q/quote=1 " : "q/quote=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "r")) ? "r" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "r")) ? "r/autorejoin_kb=1 " : "r/autorejoin_kb=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "S")) ? "S" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "S")) ? "S/seen=1 " : "S/seen=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "T")) ? "T" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "T")) ? "T/notopics=1 " : "T/notopics=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "u")) ? "u" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "u")) ? "u/users_op=1 " : "u/users_op=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "U")) ? "U" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "U")) ? "U/botusersonly=1 " : "U/botusersonly=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "v")) ? "v" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "v")) ? "v/auto_voice=1 " : "v/auto_voice=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "w")) ? "w" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "w")) ? "w/word_bk=1 " : "w/word_bk=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		/* strip leading space if any */
		if(strlen(stringbuffer)) {
			stringbuffer[strlen(stringbuffer) - 1] = '\0';
		}
		snprintf(stringbuffer2, HUGESTRINGLEN, "channel flags for %s are [%s] %s", this->name, outstring, stringbuffer);
		sendreply(to, tochan, 0, 1, stringbuffer2);
		return;
	}
	if(!strcasecmp(p1, "users")) {
		if(haschanflags(channel, "U") && !isatleastop(channel, nick, host)) {
			return;
		}
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		if(numofparams(commandline) >= 1) {
			if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
				return;
			}
			if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
				return;
			}
			for(user = this->users; user != NULL; user = user->next) {
				if(!strcasecmp(user->handle, p2)) {
					break;
				}
			}
			if(user == NULL) {
				return;
			}
			proceed = (isopa(host)) ? 1 : 0;
			if(index(user->options, (int)'a') != NULL) {
				if(isadmin(channel, host)) {
					proceed = 1;
				}
			} else {
				proceed = 1;
			}
			if(!proceed) {
				return;
			}
			if(strlen(p3) > 0) {
				startpos = atoi(p3);
			} else {
				startpos = 1;
				/* only send header info if no startpos */
				snprintf(stringbuffer, HUGESTRINGLEN, "flags for user %s: %s", user->handle, user->options);
				sendreply(to, tochan, 0, 0, stringbuffer);
			}
			for(ms = user->firstmask, lines = 0, curpos = 1, more = 0; ms != NULL; ms = ms->next, curpos++) {
				if(lines < OER_MAX_LIST_LINES) {
					if(curpos >= startpos) {
						snprintf(stringbuffer, HUGESTRINGLEN, "hostmask for user %s: %s", user->handle, ms->mask);
						sendreply(to, tochan, 0, 0, stringbuffer);
						lines++;
					}
				} else {
					more = 1;
				}
			}
			if(more) {
				snprintf(stringbuffer, HUGESTRINGLEN, "%d hostmasks in total, listing limited to %d lines", curpos - 1, OER_MAX_LIST_LINES);
				sendreply(to, tochan, 0, 0, stringbuffer);
			}
			return;
		}
                /* no parameters, list all channel operators */
		memset(stringbuffer, 0, HUGESTRINGLEN + 1);
		snprintf(stringbuffer, HUGESTRINGLEN, "%s users: ", this->name);
		for(user = this->users; user != NULL; user = user->next) {
			if(strlen(stringbuffer) + strlen(user->handle) > HUGESTRINGLEN) {
				sendreply(to, tochan, 0, 0, stringbuffer);
				memset(stringbuffer, 0, HUGESTRINGLEN + 1);
				snprintf(stringbuffer, HUGESTRINGLEN, "%s users: ", this->name);
			}
			if(index(user->options, (int)'!') != NULL) {
				strncat(stringbuffer, "!", HUGESTRINGLEN - strlen(stringbuffer));
			}
			if(index(user->options, (int)'a') != NULL) {
				strncat(stringbuffer, "*", HUGESTRINGLEN - strlen(stringbuffer));
			}
			strncat(stringbuffer, user->handle, HUGESTRINGLEN - strlen(stringbuffer));
			strncat(stringbuffer, " ", HUGESTRINGLEN - strlen(stringbuffer));
		}
		if(strlen(stringbuffer) > 0) {
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "nicks")) {
		if(haschanflags(channel, "U") && !isatleastop(channel, nick, host)) {
			return;
		}
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		if(numofparams(commandline) >= 1) {
			if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
				return;
			}
			for(cu = this->nicks; cu != NULL; cu = cu->next) {
				if(!strcasecmp(cu->nick, p2)) {
					break;
				}
			}
			if(cu == NULL) {
				return;
			}
			snprintf(stringbuffer, HUGESTRINGLEN, "%s!%s (ircop=%d chanop=%d voice=%d)", cu->nick, (cu->host == NULL) ? "(null)" : cu->host, cu->ircop, cu->chanop, cu->voice);
			sendreply(to, tochan, 0, 0, stringbuffer);
			return;
		}
                /* no parameters, list all channel nicks */
		amount = 0;
		memset(stringbuffer, 0, HUGESTRINGLEN + 1);
		cu = this->nicks;
		while(cu != NULL) {
			if((strlen(stringbuffer) + CHANLEN + NICKLEN + 16) > HUGESTRINGLEN) {
				/* send the thing, empty string */
				snprintf(stringbuffer2, HUGESTRINGLEN, "nicks on %s [%d]:", this->name, amount);
				strncat(stringbuffer2, stringbuffer, HUGESTRINGLEN - strlen(stringbuffer2));
				sendreply(to, tochan, 0, 0, stringbuffer2);
				amount = 0;
				memset(stringbuffer, 0, HUGESTRINGLEN + 1);
			}
			strncat(stringbuffer, " ", HUGESTRINGLEN - strlen(stringbuffer));
			if(cu->ircop) {
				strncat(stringbuffer, "*", HUGESTRINGLEN - strlen(stringbuffer));
			}
			if(cu->voice) {
				strncat(stringbuffer, "+", HUGESTRINGLEN - strlen(stringbuffer));
			}
			if(cu->chanop) {
				strncat(stringbuffer, "@", HUGESTRINGLEN - strlen(stringbuffer));
			}
			strncat(stringbuffer, cu->nick, HUGESTRINGLEN - strlen(stringbuffer));
			amount++;
			cu = cu->next;
		}
		if(amount > 0) {
			snprintf(stringbuffer2, HUGESTRINGLEN, "nicks on %s [%d]:", this->name, amount);
			strncat(stringbuffer2, stringbuffer, HUGESTRINGLEN - strlen(stringbuffer2));
			sendreply(to, tochan, 0, 0, stringbuffer2);
		}
		return;
	}
	if(!strcasecmp(p1, "wordbks")) {
		if(haschanflags(channel, "U") && !isatleastop(channel, nick, host)) {
			return;
		}
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		for(ms = this->wordbks, lines = 0, curpos = 1, more = 0; ms != NULL; ms = ms->next, curpos++) {
			if(lines < OER_MAX_LIST_LINES) {
				if(curpos >= startpos) {
					snprintf(stringbuffer, HUGESTRINGLEN, "%s wordbk: %s", this->name, ms->mask);
					sendreply(to, tochan, 0, 0, stringbuffer);
					lines++;
				}
			} else {
				more = 1;
			}
		}
		if(more) {
			snprintf(stringbuffer, HUGESTRINGLEN, "%d %s wordbks, listing limited to %d lines", curpos - 1, this->name, OER_MAX_LIST_LINES);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "nickbks")) {
		if(haschanflags(channel, "U") && !isatleastop(channel, nick, host)) {
			return;
		}
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		for(ms = this->nickbks, lines = 0, curpos = 1, more = 0; ms != NULL; ms = ms->next, curpos++) {
			if(lines < OER_MAX_LIST_LINES) {
				if(curpos >= startpos) {
					snprintf(stringbuffer, HUGESTRINGLEN, "%s nickbk: %s (%s)", this->name, ms->mask, ms->optstring);
					sendreply(to, tochan, 0, 0, stringbuffer);
					lines++;
				}
			} else {
				more = 1;
			}
		}
		if(more) {
			snprintf(stringbuffer, HUGESTRINGLEN, "%d %s nickbks, listing limited to %d lines", curpos - 1, this->name, OER_MAX_LIST_LINES);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "permbans")) {
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		if(!oer_doquery("listcommand", OER_DEBUG_INFO, "SELECT mask FROM permbans WHERE channel = '%s' AND ident = '%s'", channel, mystate->ident)) {
			return;
		}
		if((result = mysql_store_result(&mystate->mysqldb.mysqldbconn)) == NULL) {
			oer_debug(OER_DEBUG_FATAL, "listcommand->mysql_store_result() failed: %s\n", mysql_error(&mystate->mysqldb.mysqldbconn));
			return;
		}
		if(!mysql_num_rows(result)) {
			mysql_free_result(result);
			return;
		}
		for(lines = 0, curpos = 1, more = 0; (row = mysql_fetch_row(result)) != NULL; curpos++) {
			if(lines < OER_MAX_LIST_LINES) {
				if(curpos >= startpos) {
					snprintf(stringbuffer, HUGESTRINGLEN, "permban: %s", row[0]);
					sendreply(to, tochan, 0, 0, stringbuffer);
					lines++;
				}
			} else {
				more = 1;
			}
		}
		mysql_free_result(result);
		if(more) {
			snprintf(stringbuffer, HUGESTRINGLEN, "%s has %d permbans, listing limited to %d lines", channel, curpos - 1, OER_MAX_LIST_LINES);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "floodvars")) {
		if(haschanflags(channel, "U") && !isatleastop(channel, nick, host)) {
			return;
		}
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "%s floodvars are %d %d %d %d %d", this->name, this->floodvars.repeat_expire, this->floodvars.repeat_limit, this->floodvars.interval, this->floodvars.lines, this->floodvars.chars);
		sendreply(to, tochan, 0, 1, stringbuffer);
	}
	if(!strcasecmp(p1, "banvars")) {
		if(haschanflags(channel, "U") && !isatleastop(channel, nick, host)) {
			return;
		}
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "%s banvars are %d %d %d %d %d %d %d", this->name, this->banvars.auto_rejoin, this->banvars.part_rejoin, this->banvars.public_flood, this->banvars.public_flood_repeat, this->banvars.bad_word, this->banvars.bad_nick, this->banvars.normal_ban);
		sendreply(to, tochan, 0, 1, stringbuffer);
	}
	if(!strcasecmp(p1, "autheds")) {
		if(haschanflags(channel, "U") && !isatleastop(channel, nick, host)) {
			return;
		}
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		if(numofparams(commandline) >= 1) {
			if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
				return;
			}
			proceed = (isadmin(this->name, host)) ? 1 : 0;
			if(issameuser(this->name, p2, host)) {
				proceed = 1;
			}
			if(!proceed) {
				return;
			}
			for(a = this->autheds; a != NULL; a = a->next) {
				if(mystate->now > (a->at + OER_LOGON_TIMEOUT)) {
					continue;
				}
				if(!strcasecmp(a->user->handle, p2)) {
					snprintf(stringbuffer, HUGESTRINGLEN, "%s is authed from %s", a->user->handle, a->host);
					sendreply(to, tochan, 0, 0, stringbuffer);
				}
			}
			return;
		}
                /* no parameters, list all autheds for channel */
		amount = 0;
		memset(stringbuffer, 0, HUGESTRINGLEN + 1);
		a = this->autheds;
		while(a != NULL) {
			if((strlen(stringbuffer) + CHANLEN + NICKLEN + 16) > HUGESTRINGLEN) {
				/* send the thing, empty string */
				snprintf(stringbuffer2, HUGESTRINGLEN, "autheds on %s [%d]:", this->name, amount);
				strncat(stringbuffer2, stringbuffer, HUGESTRINGLEN - strlen(stringbuffer2));
				sendreply(to, tochan, 0, 0, stringbuffer2);
				amount = 0;
				memset(stringbuffer, 0, HUGESTRINGLEN + 1);
			}
			strncat(stringbuffer, " ", HUGESTRINGLEN - strlen(stringbuffer));
			if(mystate->now > (a->at + OER_LOGON_TIMEOUT)) {
				strncat(stringbuffer, "!", HUGESTRINGLEN - strlen(stringbuffer));
			}
			strncat(stringbuffer, a->user->handle, HUGESTRINGLEN - strlen(stringbuffer));
			amount++;
			a = a->next;
		}
		if(amount > 0) {
			snprintf(stringbuffer2, HUGESTRINGLEN, "autheds on %s [%d]:", this->name, amount);
			strncat(stringbuffer2, stringbuffer, HUGESTRINGLEN - strlen(stringbuffer2));
			sendreply(to, tochan, 0, 0, stringbuffer2);
		}
		return;
	}
	if(!strcasecmp(p1, "handles")) {
		if(haschanflags(channel, "U") && !isatleastop(channel, nick, host)) {
			return;
		}
                if(!isatleastopnow(channel, nick, host)) {
                        return;
                }
                if((this = getchptr(channel)) == NULL) {
                        return;
                }
                if(numofparams(commandline) != 1) {
                        return;
                }
                if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
                        return;
                }
                for(cu = this->nicks; cu != NULL; cu = cu->next) {
                        if(!strcasecmp(cu->nick, p2)) {
                                break;
                        }
                }
                if(cu == NULL || cu->host == NULL) {
                        return;
                }
		amount = 0;
                memset(stringbuffer, 0, HUGESTRINGLEN + 1);
                snprintf(stringbuffer, HUGESTRINGLEN, "%s handles matching %s: ", this->name, cu->nick);
                for(user = this->users; user != NULL; user = user->next) {
                        for(ms = user->firstmask; ms != NULL; ms = ms->next) {
                                if(wild_match(ms->mask, cu->host)) {
                                        /* this one matches, continue with next user */
                                        if(strlen(stringbuffer) + strlen(user->handle) > HUGESTRINGLEN) {
                                                sendreply(to, tochan, 0, 0, stringbuffer);
                                                memset(stringbuffer, 0, HUGESTRINGLEN + 1);
                                                snprintf(stringbuffer, HUGESTRINGLEN, "%s handles matching %s: ", this->name, cu->nick);
                                        }
                                        strncat(stringbuffer, user->handle, HUGESTRINGLEN - strlen(stringbuffer));
                                        strncat(stringbuffer, " ", HUGESTRINGLEN - strlen(stringbuffer));
					amount++;
                                        break;
                                }
                        }
                }
                if((amount > 0) && (strlen(stringbuffer) > 0)) {
                        sendreply(to, tochan, 0, 0, stringbuffer);
                }
                return;
        }
}

void logoffcommand(char *to, int tochan, char *channel, char *nick, char *host, char *commandline)
{
	int ppos;
        char p1[STRINGLEN + 1];
	char stringbuffer[HUGESTRINGLEN + 1];

	oer_debug(OER_DEBUG_INFO, "logoffcommand->from %s!%s for channel %s\n", nick, host, channel);
	/* command line parsing begins here, first parameter = the command */
	ppos = 0;
        if((ppos = parse(commandline, ppos, " ", p1, STRINGLEN, 0)) < 0) {
                return;
        }
	if(!strlen(p1)) {
		return;
	}
	if(isopa(host)) {
		oer_debug(OER_DEBUG_INFO, "logoffcommand->admin logoff for handle %s\n", p1);
		if(!logoff(channel, p1)) {
			oer_debug(OER_DEBUG_INFO, "logoffcommand->admin logoff failed for handle %s\n", p1);
			return;
		}
	} else {
		oer_debug(OER_DEBUG_INFO, "logoffcommand->logoff for handle %s\n", p1);
		if(!issameuser(channel, p1, host)) {
			oer_debug(OER_DEBUG_INFO, "logoffcommand->invalid logoff attempt for handle %s\n", p1);
			return;
		}
		if(!logoff(channel, p1)) {
			oer_debug(OER_DEBUG_INFO, "logoffcommand->logoff failed for handle %s\n", p1);
			return;
		}
	}
	/* logoff shouldn't cause a de-op */
	snprintf(stringbuffer, HUGESTRINGLEN, "%s user %s successfully logged off", channel, p1);
	sendreply(to, tochan, 0, 1, stringbuffer);
}

void logoncommand(char *to, int tochan, char *channel, char *nick, char *host, char *commandline)
{
	int admin;
	int ppos;
        char p1[STRINGLEN + 1];
        char p2[STRINGLEN + 1];
	char stringbuffer[HUGESTRINGLEN + 1];

	oer_debug(OER_DEBUG_INFO, "logoncommand->from %s!%s for channel %s\n", nick, host, channel);
	/* command line parsing begins here, first parameter = the command */
	ppos = 0;
        if((ppos = parse(commandline, ppos, " ", p1, STRINGLEN, 0)) < 0) {
                return;
        }
        if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
                return;
        }
	admin = (isopa(host)) ? 1 : 0;
	/* admins can logon anyone without password, they need
	   to specify the hostmask however */
	if(admin) {
		if(!strlen(p2)) {
                        oer_debug(OER_DEBUG_INFO, "logoncommand->hostmask missi\ng for admin logon\n");
                        return;
                }
		oer_debug(OER_DEBUG_INFO, "logoncommand->admin logon for handle %s\n", p1);
		if(!issameuser(channel, p1, p2)) {
                        oer_debug(OER_DEBUG_INFO, "logoncommand->hostmask %s is invalid for handle %s\n", p2, p1);
                        return;
                }
		if(!logon(channel, p1, p2, p1, 1)) {
			oer_debug(OER_DEBUG_INFO, "logoncommand->admin logon failed for handle %s\n", p1);
			return;
		}
	} else {
		/* we require password for normal logon */
                if(!strlen(p2)) {
                        oer_debug(OER_DEBUG_INFO, "logoncommand->password missing for logon\n");
                        return;
                }
                oer_debug(OER_DEBUG_INFO, "logoncommand->logon for handle %s\n", p1);
		if(!issameuser(channel, p1, host)) {
                        oer_debug(OER_DEBUG_INFO, "logoncommand->hostmask %s is invalid for handle %s\n", host, p1);
                        return;
                }
		if(!logon(channel, p1, host, p2, 0)) {
			oer_debug(OER_DEBUG_INFO, "logoncommand->logon failed for handle %s password %s\n", p1, p2);
			return;
		}
	}
	snprintf(stringbuffer, HUGESTRINGLEN, "%s user %s successfully logged on", channel, p1);
	sendreply(to, tochan, 0, 1, stringbuffer);
	if(admin) {
		/* we don't know how is affected by the handle */
		channelsync(channel);
	} else {
		if(amiop(channel) && isonchan(channel, nick) && hasuserflags(channel, host, "do")) {
			addnewmm(channel, mystate->now, "+o", nick);
		}
	}
}

int logoff(char *channel, char *handle)
{
	struct channel *this;
	struct authed *a;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(a = this->autheds; a != NULL; a = a->next) {
		if(strcasecmp(a->user->handle, handle)) {
			continue;
		}
		a->at = 0;
	}
	cleanautheds(this->name);
	return 1;
}

int logon(char *channel, char *handle, char *host, char *password, int admin)
{
	struct channel *this;
	struct botuser *user;
	char cryptsalt[3];
	char *crypted;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(user = this->users; user != NULL; user = user->next) {
		if(!strcasecmp(user->handle, handle)) {
			break;
		}
	}
	if(user == NULL) {
		return 0;
	}
	if(!admin) {
		if(user->password == NULL) {
			oer_debug(OER_DEBUG_INFO, "logon->password not set for user %s\n", handle);
			return 0;
		}
		cryptsalt[0] = user->password[0];
		cryptsalt[1] = user->password[1];
		cryptsalt[2] = '\0';
		crypted = crypt(password, cryptsalt);
		if(strcasecmp(user->password, crypted)) {
			return 0;
		}
	}
	if(addnewauthed(this->name, mystate->now, user, host) == NULL) {
		return 0;
	}
	cleanautheds(this->name);
	return 1;
}

int setpassword(char *channel, char *handle, char *password)
{
	struct channel *this;
	struct botuser *user;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(user = this->users; user != NULL; user = user->next) {
		if(!strcasecmp(user->handle, handle)) {
			break;
		}
	}
	if(user == NULL) {
		return 0;
	}
	if(index(user->options, (int)'d') == NULL) {
		return 0;
	}
	if((user->password = (char *) malloc(strlen(password) + 1)) == NULL) {
		return 0;
	}
	strcpy(user->password, password);
	return 1;
}

void sendreply(char *target, int tochan, int delay, int randomness, char *message)
{
	time_t when;

	char stringbuffer[WRITE_BUFFER_LENGTH + 1];

	if(tochan) {
		snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "PRIVMSG %s :%s\n", target, message);
	} else {
		snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "NOTICE %s :%s\n", target, message);
	}
	/* the getrandom(4) - 1 was added to avoid Excess Floods,
	   a better solution would need to keep count of client->server msgs */
	if(randomness) {
		when = mystate->now + delay + (getrandom(4) - 1);
	} else {
		when = mystate->now + delay;
	}
	oer_debug(OER_DEBUG_INFO, "sendreply(%lu)->%s", when - mystate->now, stringbuffer);
	addnewtimed(when, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
}

void sendchannelnotice(char *channel, int delay, char *message)
{
	char stringbuffer[WRITE_BUFFER_LENGTH + 1];

	snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "NOTICE %s :%s\n", channel, message);
	oer_debug(OER_DEBUG_INFO, "sendchannelnotice->%s", stringbuffer);
	addnewtimed(mystate->now + delay, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
}

void kickuser(char *channel, char *nick, char *reason)
{
	struct channel *this;
	struct chanuser *cu;
	char stringbuffer[WRITE_BUFFER_LENGTH + 1];
	char kr[STRINGLEN + 1];

        oer_debug(OER_DEBUG_INFO, "kickuser->nick %s will be kicked from %s\n", nick, channel);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			break;
		}
	}
	if(cu == NULL) {
		return;
	}
	if(cu->host == NULL) {
		return;
	}
	if(reason != NULL) {
		striplf(reason);
		snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "KICK %s %s :%s\n", this->name, cu->nick, reason);
	} else {
		if(getkickreason(kr) != NULL) {
			snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "KICK %s %s :%s\n", this->name, cu->nick, kr);
		} else {
			snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "KICK %s %s :%s\n", this->name, cu->nick, (mystate->use_alt_nick) ? mystate->altnick : mystate->nick);
		}
	}
	addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
}

int isvoicenow(char *channel, char *nick)
{
	struct channel *this;
	struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick) && cu->voice) {
			return 1;
		}
	}
	return 0;
}

int nickchange(char *channel, char *nick, char *newnick)
{
	struct channel *this;
	struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			free(cu->nick);
			if((cu->nick = (char *) malloc(strlen(newnick) + 1)) == NULL) {
				return 0;
			}
			strcpy(cu->nick, newnick);
			return 1;
		}
	}
	return 0;
}

char *getlamer(char *channel)
{
	struct channel *this;
	struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		/* get a random lamer and mark for kicking */
		if(!cu->chanop && !cu->tobek && !isop(this->name, cu->host)) {
			if(cu->ircop && mystate->current_server->protected_ircops) {
				continue;
			}
			if(haschanflags(this->name, "F") && hasuserflags(this->name, cu->host, "f")) {
				continue;
			}
			cu->tobek = 1;
			oer_debug(OER_DEBUG_INFO, "getlamer->returning %s\n", cu->nick);
			return cu->nick;
		}
	}
	return NULL;
}

void cleartobeks(char *channel)
{
	struct channel *this;
	struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		cu->tobek = 0;
	}
}

int getrandom(int ceiling)
{
	/* returns a random number between 1 and ceiling */

        int thisrandom;
        struct timeval tv;

        gettimeofday(&tv, 0);
        srand(tv.tv_usec);
        thisrandom = 1 + (int) ((float) ceiling * rand() / (RAND_MAX + 1.0));
        return thisrandom;
}

struct chanuser *getrandomuser(char *channel)
{
	int nthuser;
	int counter;
	struct channel *this;
	struct chanuser *cu;
	struct chanuser *cu2;

        for(this = mystate->channels; this != NULL; this = this->next) {
                if(!strcasecmp(this->name, channel) && this->joined) {
			break;
		}
	}
	if(this == NULL) {
		return NULL;
	}
	nthuser = getrandom(this->nickcount) - 1;
	oer_debug(OER_DEBUG_INFO, "getrandomuser->the winner of %s is user in position %d\n", channel, nthuser);
	cu = this->nicks;
	counter = 0;
	while(cu != NULL && counter < nthuser) {
		counter++;
		cu = cu->next;
	}
	for(cu2 = cu; cu != NULL; cu = cu->prev) {
		if(cu->chanop) {
			continue;
		}
		if(cu->ircop) {
			if(!mystate->current_server->protected_ircops) {
				return cu;
			}
		}
		if(!haschanflags(this->name, "F") || (haschanflags(this->name, "F") && !hasuserflags(this->name, cu->host, "f"))) {
			return cu;
		}
	}
	for(cu = cu2; cu != NULL; cu = cu->next) {
		if(cu->chanop) {
			continue;
		}
		if(cu->ircop) {
			if(!mystate->current_server->protected_ircops) {
				return cu;
			}
		}
		if(!haschanflags(this->name, "F") || (haschanflags(this->name, "F") && !hasuserflags(this->name, cu->host, "f"))) {
			return cu;
		}
	}
	return NULL;
}

int allhostsknown(char *channel)
{
	struct chanuser *cu;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	if(!this->joined) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(cu->host == NULL) {
			return 0;
		}
	}
	return 1;
}

char *getfirsthostless(char *nick)
{
	struct chanuser *cu;
	struct channel *this;

        for(this = mystate->channels; this != NULL; this = this->next) {
		if(this->joined) {
			for(cu = this->nicks; cu != NULL; cu = cu->next) {
			    if(cu->host == NULL && !cu->hostquery) {
					strncpy(nick, cu->nick, NICKLEN);
					return nick;
				}
			}
		}
	}
	return NULL;
}

void sethostquerystatus(char *nick, int status)
{
	struct chanuser *cu;
	struct channel *this;

        for(this = mystate->channels; this != NULL; this = this->next) {
		for(cu = this->nicks; cu != NULL; cu = cu->next) {
			if(!strcasecmp(cu->nick, nick)) {
				cu->hostquery = status;
				break;
			}
		}
	}
}

void setuserhost(char *nick, char *host)
{
	struct chanuser *cu;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "setuserhost->setting host %s to nick %s on all available channels\n", (host == NULL) ? "(null)" : host, nick);
        for(this = mystate->channels; this != NULL; this = this->next) {
		if(!this->joined) {
			continue;
		}
		for(cu = this->nicks; cu != NULL; cu = cu->next) {
			if(!strcasecmp(cu->nick, nick)) {
				if(cu->host != NULL) {
					free(cu->host);
				}
				/* we'll need sometimes to reset the host to
				   force a USERHOST query */
                                if(host == NULL) {
                                        cu->host = NULL;
                                        break;
                                }
				if((cu->host = (char *) malloc(strlen(host) + 1)) == NULL) {
					return;
				}
				strcpy(cu->host, host);
				break;
			}
		}
	}
}

int ishostless(char *nick)
{
	struct chanuser *cu;
	struct channel *this;

        for(this = mystate->channels; this != NULL; this = this->next) {
		if(!this->joined) {
			continue;
		}
		for(cu = this->nicks; cu != NULL; cu = cu->next) {
			if(!strcasecmp(cu->nick, nick)) {
				if(cu->host == NULL) {
					return 1;
				} else {
					return 0;
				}
			}
		}
	}
	return -1;
}

char *isnickbk(char *channel, char *nick)
{
	struct channel *this;
	struct maskstruct *nickbk;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	for(nickbk = this->nickbks; nickbk != NULL; nickbk = nickbk->next) {
		if(wild_match(nickbk->mask, nick)) {
			if(nickbk->optstring != NULL) {
				return nickbk->optstring;
			}
			return nick;
		}
	}
	return NULL;
}

int iswordbk(char *channel, char *message)
{
	struct channel *this;
	struct maskstruct *wordbk;

        for(this = mystate->channels; this != NULL; this = this->next) {
		if(!strcasecmp(this->name, channel)) {
			for(wordbk = this->wordbks; wordbk != NULL; wordbk = wordbk->next) {
				if(wild_match(wordbk->mask, message)) {
					return 1;
				}
			}
		}
        }
	return 0;
}

int isflood(char *channel, char *nick, char *host, char *message)
{
	int weight;
	int lines;
	int chars;
	int length;
	int repinterval;
	time_t first;
	time_t firstrep;
	struct channel *this;
	struct pubmsg *pm;

	oer_debug(OER_DEBUG_INFO, "isflood->%s!%s channel %s\n", nick, host, channel);
        for(this = mystate->channels; this != NULL; this = this->next) {
		if(!strcasecmp(this->name, channel)) {
			first = mystate->now;
			firstrep = mystate->now;
			lines = 1;
			length = strlen(message);
			chars = length;
			weight = 0;
			pm = this->pubmsgs;
			while(pm != NULL) {
				if(!strcasecmp(pm->nick, nick) && !strcasecmp(pm->host, host)) {
					if(pm->at < first) {
						first = pm->at;
					}
					if(!strcasecmp(pm->message, message)) {
						if(pm->at < firstrep) {
							firstrep = pm->at;
						}
						weight++;
					}
					lines++;
					chars += strlen(pm->message);
				}
				if((weight >= this->floodvars.repeat_limit - 1) && (length > 5) && (mystate->now - firstrep < this->floodvars.repeat_expire)) {
					/* immediate ban-kick */
					oer_debug(OER_DEBUG_INFO, "isflood->REPEAT delta: %lu lines: %d chars: %d weight: %d\n", mystate->now - firstrep, lines, chars, weight);
					return OER_PUBMSG_FLOOD_REPEAT;
				}
				pm = pm->next;
			}
			/* check for repeat with < 5 long pubmsgs */
			repinterval = (mystate->now - firstrep);
			if(repinterval) {
				repinterval /= weight;
			}
			oer_debug(OER_DEBUG_INFO, "isflood->repinterval is %d\n", repinterval);
			if((weight >= this->floodvars.repeat_limit - 1) && (length <= 5) \
			   && (repinterval < (this->floodvars.interval / this->floodvars.repeat_limit))) {
				oer_debug(OER_DEBUG_INFO, "isflood->REPEAT delta: %lu lines: %d chars: %d weight: %d\n", mystate->now - firstrep, lines, chars, weight);
					return OER_PUBMSG_FLOOD_REPEAT;
			}
			if((chars > this->floodvars.chars || lines > this->floodvars.lines) && mystate->now - first < this->floodvars.interval) {
				oer_debug(OER_DEBUG_INFO, "isflood->NORMAL delta: %lu lines: %d chars: %d weight: %d\n", mystate->now - first, lines, chars, weight);
					return OER_PUBMSG_FLOOD_NORMAL;
			}
			oer_debug(OER_DEBUG_INFO, "isflood->NO FLOOD delta: %lu lines: %d chars: %d weight: %d\n", mystate->now - first, lines, chars, weight);
			return OER_PUBMSG_FLOOD_NONE;
		}
        }
	return OER_PUBMSG_FLOOD_NONE;
}

void clearflood(char *channel, char *nick, char *host)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	freepubmsguser(this->name, nick, host);
}

int isvalidchannel(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	return 1;
}

int haschanflags(char *channel, char *flags)
{
	int i;
	int len;
	int got_flags;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	/* check if the channel has all the required flags set... */
	for(i = 0, got_flags = 0, len = strlen(flags); i < len; i++) {
		if(index(this->chanflags, (int)flags[i]) != NULL) {
			got_flags++;
		}
	}
	if(got_flags == len) {
		return 1;
	}
	return 0;
}

int hasadminflags(char *host, char *flags)
{
	int i;
	int len;
	int got_flags;
	struct botuser *admin;
	struct maskstruct *ms;

	if(host == NULL) {
		return 0;
	}
	/* go through all admins */
	for(admin = mystate->admins; admin != NULL; admin = admin->next) {
		/* check if the admin has all the required flags set... */
		for(i = 0, got_flags = 0, len = strlen(flags); i < len; i++) {
			if(index(admin->options, (int)flags[i]) != NULL) {
				got_flags++;
			}
		}
		if(got_flags != len) {
			/* nope, skip to next user */
			continue;
		}
		/* the admin has the right flags, what about hostmask? */
		for(ms = admin->firstmask; ms != NULL; ms = ms->next) {
			if(wild_match(ms->mask, host)) {
				return 1;
			}
		}
	}
	return 0;
}

int hasuserflags(char *channel, char *host, char *flags)
{
	int i;
	int len;
	int got_flags;
	struct channel *this;
	struct botuser *user;
	struct maskstruct *ms;

	if(host == NULL) {
		return 0;
	}
	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	/* go through all channel users */
	for(user = this->users; user != NULL; user = user->next) {
		/* check if the user has all the required flags set... */
		for(i = 0, got_flags = 0, len = strlen(flags); i < len; i++) {
			if(index(user->options, (int)flags[i]) != NULL) {
				got_flags++;
			}
		}
		if(got_flags != len || (index(user->options, (int)'!') != NULL)) {
                        /* either not the flags or user is inactive */
                        continue;
                }
		if(got_flags != len) {
			/* nope, skip to next user */
			continue;
		}
		/* the user has the right flags, what about hostmask? */
		for(ms = user->firstmask; ms != NULL; ms = ms->next) {
			if(wild_match(ms->mask, host)) {
				return 1;
			}
		}
        }
	return 0;
}

void isjoined(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	this->joined = 1;
	this->joining = 0;
}

int usersonchan(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return -1;
	}
	return this->nickcount;
}

char *getchanmode(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	if(strlen(this->mode) > 0) {
		return this->mode;
	}
	return NULL;
}

char *getchankey(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	if(!this->haskey) {
		return NULL;
	}
	return this->key;
}

void setchanmode(char *channel, char *mode)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	strncpy(this->mode, mode, CHANLEN);
	this->setchanmode = 1;
}

void setchankey(char *channel, char *key)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	strncpy(this->key, key, CHANLEN);
	this->haskey = 1;
	this->setchanmode = 1;
}

int delchankey(char *channel)
{
	char stringbuffer[STRINGLEN + 1];
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	if(!this->haskey) {
		return 0;
	}
	snprintf(stringbuffer, STRINGLEN, "-k %s", this->key);
	addnewmm(this->name, mystate->now, stringbuffer, "");
	memset(this->key, 0, CHANLEN);
	this->haskey = 0;
	return 1;
}

char *safeban(char *safemask)
{
	int is_safe;
	struct maskstruct *ms;
	char safe[HOSTLEN + 1];
	char safe2[HOSTLEN + 1];

	oer_debug(OER_DEBUG_INFO, "safeban->%s\n", safemask);
	/* check that a domain-level ban wouldn't hurt us, if hurts go for the user@hostname */
	strncpy(safe, index(safemask, '@') + 1, HOSTLEN);
	if(!strcasecmp(safe, mystate->host)) {
		/* check user@hostname */
                strncat(safe, mystate->user, HOSTLEN - strlen(safe));
                strncat(safe, "@", HOSTLEN - strlen(safe));
                strncat(safe, mystate->host, HOSTLEN - strlen(safe));
                if(!strcasecmp(safe, safemask)) {
                        /* that's it, no ban for you */
                        oer_debug(OER_DEBUG_INFO, "safeban->returning NULL\n");
                        return NULL;
                } else {
                        strncpy(safe2, "*!", HOSTLEN);
                        strncat(safe2, safemask, HOSTLEN - strlen(safe2));
                        oer_debug(OER_DEBUG_INFO, "safeban->returning %s\n", safe2);
                        strcpy(safemask, safe2);
                        return safemask;
                }
	}
	/* domain-level ban doesn't hurt us, what about trusted hostnames? */
	is_safe = 1;
	strncpy(safe, index(safemask, '@') + 1, HOSTLEN);	
	for(ms = mystate->trusted; ms != NULL && is_safe; ms = ms->next) {
		if(!strcasecmp(safe, ms->mask)) {
			is_safe = 0;
		}
	}
	if(is_safe) {
		strncpy(safe, "*!*@", HOSTLEN);
		strncat(safe, index(safemask, '@') + 1, HOSTLEN - strlen(safe));
		strcpy(safemask, safe);
	} else {
		strncpy(safe, "*!", HOSTLEN);
		strncat(safe, safemask, HOSTLEN - strlen(safe));
		strcpy(safemask, safe);
	}
	oer_debug(OER_DEBUG_INFO, "safeban->returning %s\n", safemask);
	return safemask;
}

int nthmode(char *modeline, int index)
{
	int i;
	int n;
	int length;
	char polar;

	length = strlen(modeline);
	for(i = 0, n = 0, polar = 'x'; i < length; i++) {
		switch(modeline[i]) {
		case '+':
			polar = '+';
			break;
		case '-':
			polar = '-';
			break;
		case 'o':
			n++;
			if(n == index) {
				if(polar == '+') {
					return OER_NTHMODE_OP;
				} else {
					return OER_NTHMODE_DOP;
				}
			}
			break;
		case 'v':
			n++;
			if(n == index) {
				if(polar == '+') {
					return OER_NTHMODE_VOICE;
				} else {
					return OER_NTHMODE_DVOICE;
				}
			}
			break;
		case 'b':
			n++;
			if(n == index) {
				if(polar == '+') {
					return OER_NTHMODE_BAN;
				} else {
					return OER_NTHMODE_UNBAN;
				}
			}
			break;
		default:
			return OER_NTHMODE_UNKNOWN;
		}

	}
	return OER_NTHMODE_UNKNOWN;
}

void getnthmode(char *modeline, int index, char *to)
{
	int i;
	int n;
	int length;
	char polar;

	memset(to, 0, CHANLEN + 1);
	length = strlen(modeline);
	for(i = 0, n = 0, polar = 'x'; i < length; i++) {
		switch(modeline[i]) {
		case '+':
		case '-':
			polar = modeline[i];
			break;
                default:
			n++;
			if(n == index) {
				snprintf(to, CHANLEN, "%c%c", polar, modeline[i]);
				return;
			}
			break;
		}
	}
}

struct modeline *addnewmm(char *channel, time_t at, char *mode, char *target)
{
	struct modeline *mm;
	struct modeline *mm2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewmm->adding new mmode to channel %s at: %lu (time now: %lu) mode: %s target: %s\n", channel, at, mystate->now, mode, target);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	if((strlen(mode) + strlen(target) + 10) > HUGESTRINGLEN) {
		return NULL;
	}
	if((mm = (struct modeline *) malloc(sizeof(struct modeline))) == NULL) {
		return NULL;
	}
	if((mm->mode = (char *) malloc(strlen(mode) + 1)) == NULL) {
		return NULL;
	}
	strcpy(mm->mode, mode);
	if((mm->target = (char *) malloc(strlen(target) + 1)) == NULL) {
		return NULL;
	}
	strcpy(mm->target, target);
	mm->at = at;
	mm->done = 0;
	mm->prev = NULL;
	mm->next = NULL;
	/* as always, the empty case is special */
	if(this->modelines == NULL) {
		this->modelines = mm;
		return mm;
	}
	for(mm2 = this->modelines; mm2->next != NULL; mm2 = mm2->next) {
	}
	mm2->next = mm;
	mm->prev = mm2;
	return mm;
}

struct timed *addnewtimed(time_t at, int type, int function, char *irc_command, char *optstring1, char *optstring2, char *optstring3)
{
	struct timed *tim;
	struct timed *tim2;

	oer_debug(OER_DEBUG_INFO, "addnewtimed->adding new timed at: %lu (time now: %lu) type: %d function: %d\n", at, mystate->now, type, function);
	if((irc_command != NULL) && strlen(irc_command) > WRITE_BUFFER_LENGTH) {
		return NULL;
	}
	if((tim = (struct timed *) malloc(sizeof(struct timed))) == NULL) {
		return NULL;
	}
	tim->at = at;
	tim->type = type;
	tim->function = function;
	tim->irc_command = NULL;
	tim->optstring1 = NULL;
	tim->optstring2 = NULL;
	tim->optstring3 = NULL;
	if(irc_command != NULL) {
		if((tim->irc_command = (char *) malloc(strlen(irc_command) + 1)) == NULL) {
			return NULL;
		}
		strcpy(tim->irc_command, irc_command);
	}
	if(optstring1 != NULL) {
		if((tim->optstring1 = (char *) malloc(strlen(optstring1) + 1)) == NULL) {
			return NULL;
		}
		strcpy(tim->optstring1, optstring1);
	}
	if(optstring2 != NULL) {
		if((tim->optstring2 = (char *) malloc(strlen(optstring2) + 1)) == NULL) {
			return NULL;
		}
		strcpy(tim->optstring2, optstring2);
	}
	if(optstring3 != NULL) {
		if((tim->optstring3 = (char *) malloc(strlen(optstring3) + 1)) == NULL) {
			return NULL;
		}
		strcpy(tim->optstring3, optstring3);
	}
	/* as always, the empty case is special */
	if(mystate->timeds == NULL) {
		tim->prev = NULL;
		tim->next = NULL;
		mystate->timeds = tim;
		return tim;
	}
	/* there is no need to check for existance, append */
	for(tim2 = mystate->timeds; tim2->next != NULL; tim2 = tim2->next) {
	}
	tim2->next = tim;
	tim->prev = tim2;
	tim->next = NULL;
	return tim;
}

struct pubmsg *addnewpubmsg(char *channel, time_t at, char *nick, char *host, char *message)
{
	int amount;
	struct pubmsg *pm;
	struct pubmsg *pm2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewpubmsg->adding pubmsg for channel %s at %lu by %s!%s\n", channel, at, nick, host);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	/* add a new entry to the list */
	if((pm = (struct pubmsg *) malloc(sizeof(struct pubmsg))) == NULL) {
		return NULL;
	}
	if((pm->nick = (char *) malloc(strlen(nick) + 1)) == NULL) {
		return NULL;
	}
	strcpy(pm->nick, nick);
	if((pm->host = (char *) malloc(strlen(host) + 1)) == NULL) {
		return NULL;
	}
	strcpy(pm->host, host);
	if((pm->message = (char *) malloc(strlen(message) + 1)) == NULL) {
		return NULL;
	}
	strcpy(pm->message, message);
	pm->at = at;
	pm->prev = NULL;
	pm->next = NULL;
	/* the first one is a special case */
	if(this->pubmsgs == NULL) {
		this->pubmsgs = pm;
		return pm;
	}
	/* we got at least 1 pubmsg in the list */
	this->pubmsgs->prev = pm;
	pm->next = this->pubmsgs;
	this->pubmsgs = pm;
	for(pm2 = this->pubmsgs, amount = 0; pm2->next != NULL; pm2 = pm2->next, amount++) {
	}
	if(amount >= OER_PUBMSGS) {
		/* list full, strip last one */
		pm2->prev->next = NULL;
		free(pm2->message);
		free(pm2->host);
		free(pm2->nick);
		free(pm2);
	}
	return pm;
}

struct part *addnewpart(char *channel, time_t at, char *nick, char *host)
{
	int amount;
	struct part *p;
	struct part *p2;
	struct channel *this;

	if(host == NULL) {
                oer_debug(OER_DEBUG_INFO, "addnewpart->hostmask = NULL, not adding part for user\n");
                return NULL;
        }
	oer_debug(OER_DEBUG_INFO, "addnewpart->adding part from %s at %lu for %s!%s\n", channel, at, nick, host);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	/* add a new entry to the list */
	if((p = (struct part *) malloc(sizeof(struct part))) == NULL) {
		return NULL;
	}
	if((p->nick = (char *) malloc(strlen(nick) + 1)) == NULL) {
		return NULL;
	}
	strcpy(p->nick, nick);
	if((p->host = (char *) malloc(strlen(host) + 1)) == NULL) {
		return NULL;
	}
	strcpy(p->host, host);
	p->at = at;
	p->valid = 1;
	p->prev = NULL;
	p->next = NULL;
	/* the first one is a special case */
	if(this->parts == NULL) {
		this->parts = p;
		return p;
	}
	/* we got at least 1 part in the list */
	this->parts->prev = p;
	p->next = this->parts;
	this->parts = p;
	for(p2 = this->parts, amount = 0; p2->next != NULL; p2 = p2->next, amount++) {
	}
	if(amount >= OER_PARTS) {
		/* list full, strip last one */
		p2->prev->next = NULL;
		free(p2->nick);
		free(p2->host);
		free(p2);
	}
	return p;
}

struct join *addnewjoin(char *channel, time_t at, char *nick, char *host)
{
	int amount;
	struct join *j;
	struct join *j2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewjoin->adding join at %lu to %s from %s!%s\n", at, channel, nick, host);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	/* add a new entry to the list */
	if((j = (struct join *) malloc(sizeof(struct join))) == NULL) {
		return NULL;
	}
	if((j->nick = (char *) malloc(strlen(nick) + 1)) == NULL) {
		return NULL;
	}
	strcpy(j->nick, nick);
	if((j->host = (char *) malloc(strlen(host) + 1)) == NULL) {
		return NULL;
	}
	strcpy(j->host, host);
	j->at = at;
	j->prev = NULL;
	j->next = NULL;
	/* the first one is a special case */
	if(this->joins == NULL) {
		this->joins = j;
		return j;
	}
	/* we got at least 1 join in the list */
	this->joins->prev = j;
	j->next = this->joins;
	this->joins = j;
	for(j2 = this->joins, amount = 0; j2->next != NULL; j2 = j2->next, amount++) {
	}
	if(amount >= OER_JOINS) {
		/* list full, strip last one */
		j2->prev->next = NULL;
		free(j2->nick);
		free(j2->host);
		free(j2);
	}
	return j;
}

struct chanuser *getcuptr(char *channel, char *nick)
{
	struct channel *this;
        struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
        for(cu = this->nicks; cu != NULL; cu = cu->next) {
                if(!strcmp(cu->nick, nick)) {
			return cu;
                }
        }
	return NULL;
}

struct chanuser *userjoined(char *channel, char *nick, char *host, int ircop, int chanop, int voice)
{
	struct chanuser *cu;
	struct chanuser *cu2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "userjoined->adding join to %s from %s!%s (%d %d %d)\n", channel, nick, (host == NULL) ? "(null)" : host, ircop, chanop, voice);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	if((cu = (struct chanuser *) malloc(sizeof(struct chanuser))) == NULL) {
		return NULL;
	}
	cu->hostquery = 0;
	cu->ircop = ircop;
	cu->chanop = chanop;
	cu->voice = voice;
	cu->tobek = 0;
	cu->prev = NULL;
	cu->next = NULL;
	if((cu->nick = (char *) malloc(strlen(nick) + 1)) == NULL) {
		return NULL;
	}
	strcpy(cu->nick, nick);
	cu->host = NULL;
	if(host != NULL) {
		if((cu->host = (char *) malloc(strlen(host) + 1)) == NULL) {
			return NULL;
		}
		strcpy(cu->host, host);
	}
	oer_debug(OER_DEBUG_FLOOD, "userjoined->added join to %s from %s!%s (%d %d %d)\n", this->name, cu->nick, (cu->host == NULL) ? "(null)" : cu->host, cu->ircop, cu->chanop, cu->voice);
	/* as always, the empty case is special */
	if(this->nicks == NULL) {
		this->nicks = cu;
		this->nickcount++;
		return cu;
	}
	/* there is no need to check for existance, append */
	for(cu2 = this->nicks; cu2->next != NULL; cu2 = cu2->next) {
	}
	cu2->next = cu;
	cu->prev = cu2;
	this->nickcount++;
	return cu;
}

int userleft(char *channel, char *nick, char *host)
{
	struct chanuser *cu;
	struct channel *this;

        oer_debug(OER_DEBUG_INFO, "userleft->removing from %s %s!%s\n", channel, nick, (host == NULL) ? "(null)" : host);
	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
                if(!strcasecmp(cu->nick, nick)) {
			break;
		}
	}
	if(cu == NULL) {
		/* a ghost user left?!?! */
		return 0;
	}
	/* free the user & adjust lists */
	if(cu->prev == NULL) {
		/* first user in list */
		this->nicks = cu->next;
		/* ... check if also last */
		if(cu->next != NULL) {
			cu->next->prev = NULL;
		}
	}
	if(cu->next == NULL) {
		/* last user in list
		   ... check also if the only one */
		if(cu->prev != NULL) {
			cu->prev->next = NULL;
		} else {
			this->nicks = NULL;
		}
	}
	if(cu->prev != NULL && cu->next != NULL) {
		/* between 2 or more users */
		cu->prev->next = cu->next;
		cu->next->prev = cu->prev;
	}
	oer_debug(OER_DEBUG_FLOOD, "userleft->removed from %s %s!%s\n", this->name, cu->nick, (cu->host == NULL) ? "(null)" : cu->host);
        if(cu->host != NULL) {
                free(cu->host);
        }
	free(cu->nick);
	free(cu);
	this->nickcount--;
	return 1;
}

void linenoise()
{
	char outstring[STRINGLEN + 1];

	if((mystate->current_server->linenoise) && !(mystate->now & 0xF)) {
		snprintf(outstring, STRINGLEN, "ISON %s\n", (mystate->use_alt_nick) ? mystate->altnick : mystate->nick);
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
	}
}

void checkstoned()
{
	char outstring[STRINGLEN + 1];

	if(!mystate->current_server->lastping) {
		return;
	}
	if(!(mystate->now & 0xF)) {
		snprintf(outstring, STRINGLEN, "checkstoned->last known server activity %s", ctime(&mystate->current_server->lastping));
		striplf(outstring);
		tzset();
		oer_debug(OER_DEBUG_INFO, "%s %s %s\n", outstring, tzname[0], tzname[1]);
	}
	if((mystate->now - mystate->current_server->lastping) > (mystate->current_server->pingfrequency * 3)) {
		mystate->current_server->stoned = mystate->now;
		mystate->reconnect = OER_RECONNECT_STONED;
	}
}

int changeuser(char *channel, char *nick, int ircop, int chanop, int voice)
{
	struct chanuser *cu;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "changeuser->changing modes for %s/%s to (%d %d %d)\n", nick, channel, ircop, chanop, voice);
	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			cu->ircop = (ircop == -1) ? cu->ircop : ircop;
			cu->chanop = (chanop == -1) ? cu->chanop : chanop;
			cu->voice = (voice == -1) ? cu->voice : voice;
			return 1;
		}
	}
	return 0;
}

void changetobek(char *channel, char *nick, int tobek)
{
	struct chanuser *cu;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			cu->tobek = tobek;
			return;
		}
	}
}

int gettobek(char *channel, char *nick)
{
	struct chanuser *cu;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			return cu->tobek;
		}
	}
	return 0;
}

void freepubmsguser(char *channel, char *nick, char *host)
{
	struct pubmsg *pm;
	struct pubmsg *pm2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "freepubmsguser->for channel %s nick: %s host: %s\n", channel, nick, host);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	pm = this->pubmsgs;
	while(pm != NULL) {
		pm2 = pm->next;
		if(!strcasecmp(pm->nick, nick) && !strcasecmp(pm->host, host)) {
			if(pm->prev == NULL) {
				/* first pubmsg in list */
				this->pubmsgs = pm->next;
				/* ... check if also last */
				if(pm->next != NULL) {
					pm->next->prev = NULL;
				}
			}
			if(pm->next == NULL) {
				/* last pubmsg in list */
				this->pubmsgs = pm->prev;
				/* ... check also if the only one */
				if(pm->prev != NULL) {
					pm->prev->next = NULL;
				} else {
					this->pubmsgs = NULL;
				}
			}
			if(pm->prev != NULL && pm->next != NULL) {
				/* between 2 or more pubmsgs */
				pm->prev->next = pm->next;
				pm->next->prev = pm->prev;
			}
			oer_debug(OER_DEBUG_INFO, "freepubmsguser->removing: %lu %s %s %s\n", pm->at, pm->nick, pm->host, pm->message);
			free(pm->message);
			free(pm->nick);
			free(pm->host);
			free(pm);
		}
		pm = pm2;
	}
}

void lockchan(char *channel, char *reason, int auto_unlock, char *nick, char *host)
{
	struct channel *this;
	char stringbuffer[STRINGLEN + 1];

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	this->locked.locked = 1;
	this->locked.unlocked = 0;
	this->locked.auto_unlock = auto_unlock;
	memset(this->locked.reason, 0, STRINGLEN + 1);
        if(strlen(reason)) {
                strncpy(this->locked.reason, reason, STRINGLEN);
        }
	strncpy(this->locked.nick, nick, NICKLEN);
	strncpy(this->locked.host, host, HOSTLEN);
	addnewmm(this->name, mystate->now, "+i", "");
	snprintf(stringbuffer, STRINGLEN, "channel %s is locked by %s!%s", this->name, this->locked.nick, this->locked.host);
	sendchannelnotice(this->name, 0, stringbuffer);
}

void unlockchan(char *channel, char *nick, char *host)
{
	struct channel *this;
	char stringbuffer[STRINGLEN + 1];

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	this->locked.unlocked = 1;
	/* this has to be a timed because of the way mmodes & timeds
	   are processed in the mainloop (we want the -i to appear
           after all lamers have been kicked out, not before) */
	snprintf(stringbuffer, STRINGLEN, "MODE %s -i\n", this->name);
	addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
	snprintf(stringbuffer, STRINGLEN, "channel %s was unlocked by %s!%s", this->name, nick, host);
	sendchannelnotice(this->name, 0, stringbuffer);
	cleartobeks(this->name);
}

void wall(char *channel, char *nick, char *host, char *commandline)
{
	int ppos;
	int counter;
	int delay;
        char p1[STRINGLEN + 1];
	char stringbuffer[HUGESTRINGLEN + 1];
	struct channel *this;
	struct chanuser *cu;

	ppos = 0;
        if((ppos = parse(commandline, ppos, " ", p1, STRINGLEN, 0)) < 0) {
                return;
        }
	if(!strlen(p1) || !strlen(commandline + ppos)) {
		return;
	}
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	delay = 0;
	/* all wall messages are being sent with a delay of (counter (0..nicksonchan) * OER_WALL_DELAY) + (counter * (counter >> 2)),
	   this is necessary to avoid 439's */
	if(!strcasecmp(p1, "admins")) {
		if(!isadmin(channel, host)) {
			return;
		}
		for(cu = this->nicks, counter = 0; cu != NULL; cu = cu->next) {
			if(!isme(cu->nick) && isadmin(this->name, cu->host)) {
				snprintf(stringbuffer, HUGESTRINGLEN, "notice to %s admins from %s: %s", this->name, nick, commandline + ppos);
				delay = (counter < OER_MAXTARGETS) ? (counter * OER_WALL_DELAY) : ((counter - OER_MAXTARGETS + 1) * OER_TARGET_DELAY);
				sendreply(cu->nick, 0, delay, 0, stringbuffer);
				counter++;
			}
		}
		if(!counter) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "notified %d %s on %s (took %d %s)", counter, (counter == 1) ? "admin" : "admins", this->name, delay, (counter == 1) ? "second" : "seconds");
		sendreply(nick, 0, delay, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "channel")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "notice to %s from %s: %s", this->name, nick, commandline + ppos);
		sendchannelnotice(this->name, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "lamers")) {
		for(cu = this->nicks, counter = 0; cu != NULL; cu = cu->next) {
			if(!isme(cu->nick) && !cu->chanop) {
				snprintf(stringbuffer, HUGESTRINGLEN, "notice to non-opped %s users from %s: %s", this->name, nick, commandline + ppos);
				delay = (counter < OER_MAXTARGETS) ? (counter * OER_WALL_DELAY) : ((counter - OER_MAXTARGETS + 1) * OER_TARGET_DELAY);
				sendreply(cu->nick, 0, delay, 0, stringbuffer);
				counter++;
			}
		}
		if(!counter) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "notified %d %s on %s (took %d %s)", counter, (counter == 1) ? "lamer" : "lamers", this->name, delay, (counter == 1) ? "second" : "seconds");
		sendreply(nick, 0, delay, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "ops")) {
		for(cu = this->nicks, counter = 0; cu != NULL; cu = cu->next) {
			if(!isme(cu->nick) && cu->chanop) {
				snprintf(stringbuffer, HUGESTRINGLEN, "notice to %s channel operators from %s: %s", this->name, nick, commandline + ppos);
				delay = (counter < OER_MAXTARGETS) ? (counter * OER_WALL_DELAY) : ((counter - OER_MAXTARGETS + 1) * OER_TARGET_DELAY);
				sendreply(cu->nick, 0, delay, 0, stringbuffer);
				counter++;
			}
		}
		if(!counter) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "notified %d %s on %s (took %d %s)", counter, (counter == 1) ? "op" : "ops", this->name, delay, (counter == 1) ? "second" : "seconds");
		sendreply(nick, 0, delay, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "users")) {
		for(cu = this->nicks, counter = 0; cu != NULL; cu = cu->next) {
			if(!isme(cu->nick) && (isadmin(this->name, cu->host) || isop(this->name, cu->host))) {
				snprintf(stringbuffer, HUGESTRINGLEN, "notice to %s bot users from %s: %s", this->name, nick, commandline + ppos);
				delay = (counter < OER_MAXTARGETS) ? (counter * OER_WALL_DELAY) : ((counter - OER_MAXTARGETS + 1) * OER_TARGET_DELAY);
				sendreply(cu->nick, 0, delay, 0, stringbuffer);
				counter++;
			}
		}
		if(!counter) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "notified %d %s on %s (took %d %s)", counter, (counter == 1) ? "bot user" : "bot users", this->name, delay, (counter == 1) ? "second" : "seconds");
		sendreply(nick, 0, delay, 0, stringbuffer);
		return;
	}
}

struct authed *addnewauthed(char *channel, time_t at, struct botuser *user, char *host)
{
	struct authed *a;
	struct authed *a2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewauthed->adding auth for channel %s at %lu for %s\n", channel, at, host);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	if((a = (struct authed *) malloc(sizeof(struct authed))) == NULL) {
		return NULL;
	}
	a->at = at;
	a->user = user;
	a->host = NULL;
	if((a->host = (char *) malloc(strlen(host) + 1)) == NULL) {
		return NULL;
	}
	strcpy(a->host, host);
	a->prev = NULL;
	a->next = NULL;
	/* the first one is a special case */
	if(this->autheds == NULL) {
		this->autheds = a;
		return a;
	}
	/* we got at least 1 authed in the list, append */
	for(a2 = this->autheds; a2->next != NULL; a2 = a2->next) {
		;
	}
	a2->next = a;
	a->prev = a2;
	return a;
}

void cleanautheds(char *channel)
{
	struct authed *a;
	struct authed *a2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "cleanauthed->cleaning autheds for channel %s\n", channel);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	/* oldest first, stripped from first to last */
	a = this->autheds;
	while(a != NULL) {
		if(mystate->now < (a->at + OER_LOGON_TIMEOUT)) {
			/* since the list is oldest entry first, there
			   are no more entries to go through */
			return;
		}
		/* this entry has expired, remove & adjust lists */
		a2 = a->next;
		free(a->host);
		free(a);
		a = a2;
		if(a != NULL) {
			/* the next one will be the first in list */
			a->prev = NULL;
			this->autheds = a;
		} else {
			/* no more autheds for channel */
			this->autheds = NULL;
		}
	}
}
