# MySQL dump 8.12
#
# Host: localhost    Database: oer_quakenet
#--------------------------------------------------------
# Server version	3.23.32

#
# Table structure for table 'admins'
#

CREATE TABLE admins (
  handle VARCHAR(32) NOT NULL DEFAULT '',
  flags VARCHAR(32) DEFAULT '',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (handle,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'adverts'
#

CREATE TABLE adverts (
  channel VARCHAR(50) NOT NULL DEFAULT '',
  type VARCHAR(32) NOT NULL DEFAULT '',
  message TEXT NOT NULL,
  ident VARCHAR(64) NOT NULL DEFAULT ''
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'bantype'
#

CREATE TABLE bantype (
  channel VARCHAR(50) NOT NULL DEFAULT '',
  type TINYINT UNSIGNED NOT NULL DEFAULT '1',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (channel,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'banvars'
#

CREATE TABLE banvars (
  channel VARCHAR(50) NOT NULL DEFAULT '',
  b_auto_rejoin SMALLINT UNSIGNED NOT NULL DEFAULT '30',
  b_part_rejoin SMALLINT UNSIGNED NOT NULL DEFAULT '600',
  b_flood SMALLINT UNSIGNED NOT NULL DEFAULT '300',
  b_flood_repeat SMALLINT UNSIGNED NOT NULL DEFAULT '600',
  b_bad_word SMALLINT UNSIGNED NOT NULL DEFAULT '3600',
  b_bad_nick SMALLINT UNSIGNED NOT NULL DEFAULT '3600',
  b_normal_ban SMALLINT UNSIGNED NOT NULL DEFAULT '3600',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (channel,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'channels'
#

CREATE TABLE channels (
  name VARCHAR(50) NOT NULL DEFAULT '',
  chanmodes VARCHAR(12) DEFAULT '',
  chankey VARCHAR(32) DEFAULT '',
  chanflags VARCHAR(32) DEFAULT '',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (name,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'conf'
#

CREATE TABLE conf (
  nick VARCHAR(15) NOT NULL DEFAULT '',
  altnick VARCHAR(15) NOT NULL DEFAULT '',
  user VARCHAR(16) DEFAULT '',
  usermode VARCHAR(8) DEFAULT '',
  flags VARCHAR(8) DEFAULT '',
  prefix CHAR(32) NOT NULL DEFAULT '',
  realname VARCHAR(64) NOT NULL DEFAULT '',
  vhost VARCHAR(63) DEFAULT '',
  ident VARCHAR(32) NOT NULL DEFAULT '',
  PRIMARY KEY (ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'floodvars'
#

CREATE TABLE floodvars (
  channel VARCHAR(50) NOT NULL DEFAULT '',
  f_expire SMALLINT UNSIGNED NOT NULL DEFAULT '1800',
  f_limit SMALLINT UNSIGNED NOT NULL DEFAULT '3',
  f_interval SMALLINT UNSIGNED NOT NULL DEFAULT '60',
  f_lines SMALLINT UNSIGNED NOT NULL DEFAULT '10',
  f_chars SMALLINT UNSIGNED NOT NULL DEFAULT '1600',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (channel,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'hostmasks'
#

CREATE TABLE hostmasks (
  hostmask VARCHAR(80) NOT NULL DEFAULT '',
  channel VARCHAR(50) NOT NULL DEFAULT '',
  type TINYINT UNSIGNED NOT NULL DEFAULT '0',
  handle VARCHAR(32) NOT NULL DEFAULT '',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (hostmask,channel,type,handle,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'kickreasons'
#

CREATE TABLE kickreasons (
  reason VARCHAR(255) NOT NULL DEFAULT '',
  ident VARCHAR(64) NOT NULL DEFAULT ''
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'nickbks'
#

CREATE TABLE nickbks (
  channel VARCHAR(50) NOT NULL DEFAULT '',
  pattern VARCHAR(32) NOT NULL DEFAULT '',
  reason VARCHAR(64) DEFAULT '',
  setby VARCHAR(32) DEFAULT '',
  twhen INT UNSIGNED NOT NULL DEFAULT '0',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (channel,pattern,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'output'
#

CREATE TABLE output (
  twhen INT UNSIGNED NOT NULL DEFAULT '0',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  message TEXT NOT NULL
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'passwords'
#

CREATE TABLE passwords (
  handle VARCHAR(32) NOT NULL DEFAULT '',
  channel VARCHAR(50) NOT NULL DEFAULT '',
  type TINYINT unsigned NOT NULL DEFAULT '0',
  password VARCHAR(32) NOT NULL DEFAULT '',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (handle,channel,type,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'permbans'
#

CREATE TABLE permbans (
  channel VARCHAR(50) NOT NULL DEFAULT '',
  mask VARCHAR(64) NOT NULL DEFAULT '',
  reason VARCHAR(64) DEFAULT '',
  setby VARCHAR(32) DEFAULT '',
  twhen INT UNSIGNED NOT NULL DEFAULT '0',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (channel,mask,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'raw'
#

CREATE TABLE raw (
  twhen INT UNSIGNED NOT NULL DEFAULT '0',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  message TEXT NOT NULL
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'servers'
#

CREATE TABLE servers (
  hostname VARCHAR(63) NOT NULL DEFAULT '',
  port SMALLINT UNSIGNED NOT NULL DEFAULT '6667',
  servermodes TINYINT UNSIGNED NOT NULL DEFAULT '4',
  pingfreq TINYINT UNSIGNED NOT NULL DEFAULT '90',
  protopers TINYINT UNSIGNED NOT NULL DEFAULT '0',
  linenoise TINYINT UNSIGNED NOT NULL DEFAULT '0',
  password VARCHAR(32) DEFAULT '',
  ident VARCHAR(32) NOT NULL DEFAULT '',
  id TINYINT UNSIGNED NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (hostname,port,servermodes,pingfreq,protopers,linenoise,ident),
  INDEX (id)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'services'
#

CREATE TABLE services (
  host VARCHAR(63) NOT NULL DEFAULT '',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (host,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'timestamps'
#

CREATE TABLE timestamps (
  ttype VARCHAR(32) NOT NULL DEFAULT '',
  twhen INT UNSIGNED NOT NULL DEFAULT '0',
  tchannel VARCHAR(50) NOT NULL DEFAULT '',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (ttype,tchannel,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'topics'
#

CREATE TABLE topics (
  channel VARCHAR(50) NOT NULL DEFAULT '',
  pos TINYINT UNSIGNED NOT NULL DEFAULT '0',
  twhen INT UNSIGNED NOT NULL DEFAULT '0',
  setby VARCHAR(32) NOT NULL DEFAULT '',
  message VARCHAR(255) NOT NULL DEFAULT '',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (channel,pos,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'trusted'
#

CREATE TABLE trusted (
  host VARCHAR(63) NOT NULL DEFAULT '',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (host,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'users'
#

CREATE TABLE users (
  handle VARCHAR(32) NOT NULL DEFAULT '',
  channel VARCHAR(50) NOT NULL DEFAULT '',
  flags VARCHAR(32) DEFAULT '',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (handle,channel,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'wordbks'
#

CREATE TABLE wordbks (
  channel VARCHAR(50) NOT NULL DEFAULT '',
  pattern VARCHAR(32) NOT NULL DEFAULT '',
  reason VARCHAR(64) DEFAULT '',
  setby VARCHAR(32) DEFAULT '',
  twhen INT UNSIGNED NOT NULL DEFAULT '0',
  ident VARCHAR(64) NOT NULL DEFAULT '',
  PRIMARY KEY (channel,pattern,ident)
) TYPE=MyISAM PACK_KEYS=1;





