#!/usr/bin/perl

#
# upgrade.pl can be used to transfer the different oer configurations
# all at once from the normal version to oer+MySQL
#

# usage: upgrade.pl <oer+MySQL handle> <oer base directory>

@configs = ( "conf",
             "admins",
             "channels",
             "chaninfo",
             "kickreasons",
             "trusted",
             "services" );

$args = $#ARGV + 1;

if ($args != 2) {
    print STDERR "insufficient number of arguments.\n";
    print STDERR "usage: upgrade.pl <oer+MySQL handle> <oer base directory>\n";
    exit;
}

$arg1 = @ARGV[0];
$arg2 = @ARGV[1];

$bothandle = $arg1;
$serverid = 1;

for $i ( 0 .. $#configs ) {
    $config = $configs[$i];
    $filename = $arg2 . "/" . "oer." . $config;
    if(open(fd, "$filename")) {
	$got_conf = 0;
	while (<fd>) {
	    chop;
	    $query = "";
	    if($config eq "admins") {
		if(/^admin::(\S*)::(\S*)$/) {
		    $query = "INSERT INTO admins VALUES ('$1', '$2', '$bothandle')";
		}
		if(/^mask::(\S*)::(\S*)$/) {
		    $query = "INSERT INTO hostmasks VALUES ('$2', '', 1, '$1', '$bothandle')";
		}
	    } elsif($config eq "chaninfo") {
		if(/^chaninfo::(\S*)::user::(\S*)::(\S*)$/) {
		    $query = "INSERT INTO users VALUES ('$2', '$1', '$3', '$bothandle')";
		}
		if(/^chaninfo::(\S*)::usermask::(\S*)::(\S*)$/) {
		    $query = "INSERT INTO hostmasks VALUES ('$3', '$1', 2, '$2', '$bothandle')";
		}
		if(/^chaninfo::(\S*)::password::(\S*)::(\S*)$/) {
		    $query = "INSERT INTO passwords VALUES ('$2', '$1', 1, '$3', '$bothandle')";
		}
		if(/^chaninfo::(\S*)::wordbk::(\S*)::(\S*)::(\S*)$/) {
		    $query = "INSERT INTO wordbks VALUES ('$1', '$2', '$3', '$4', 0, '$bothandle')";
		}
		if(/^chaninfo::(\S*)::nickbk::(\S*)::(\S*)::(\S*)$/) {
		    $query = "INSERT INTO nickbks VALUES ('$1', '$2', '$3', '$4', 0, '$bothandle')";
		}
		if(/^chaninfo::(\S*)::permban::(\S*)::(\S*)::(\S*)$/) {
		    $query = "INSERT INTO permbans VALUES ('$1', '$2', '$3', '$4', 0, '$bothandle')";
		}
		if(/^chaninfo::(\S*)::floodvars::(\d*)::(\d*)::(\d*)::(\d*)::(\d*)::(\d*)::(\d*)$/) {
		    $query = "INSERT INTO floodvars VALUES ('$1', $2, $3, $4, $5, $6, $7, $8, '$bothandle')";
		}
		if(/^chaninfo::(\S*)::banvars::(\d*)::(\d*)::(\d*)::(\d*)::(\d*)::(\d*)::(\d*)$/) {
		    $query = "INSERT INTO banvars VALUES ('$1', $2, $3, $4, $5, $6, $7, $8, '$bothandle')";
		}
		if(/^chaninfo::(\S*)::advert::(\S*)::(\S*)$/) {
		    $query = "INSERT INTO adverts VALUES ('$1', '$2', '$3', '$bothandle')";
		}
		if(/^chaninfo::(\S*)::bantype::(\d*)$/) {
		    $query = "INSERT INTO bantype VALUES ('$1', $2, '$bothandle')";
		}
	    } elsif($config eq "channels") {
		if(/^channel::(\S*)::(\S*)::(\S*)::(\S*)::(\S*)$/) {
		    $query = "INSERT INTO channels VALUES ('$1', '$3', '$2', '$5', '$4', '$bothandle')";
		}
	    } elsif($config eq "conf") {
		if(/^nick::(\S*)$/) {
		    $got_conf = 1;
		    $conf_nick = $1;
		}
		if(/^altnick::(\S*)$/) {
		    $got_conf = 1;
		    $conf_altnick = $1;
		}
		if(/^user::(\S*)$/) {
		    $got_conf = 1;
		    $conf_user = $1;
		}
		if(/^usermode::(\S*)$/) {
		    $got_conf = 1;
		    $conf_usermode = $1;
		}
		if(/^flags::(\S*)$/) {
		    $got_conf = 1;
		    $conf_flags = $1;
		}
		if(/^prefix::(\S*)$/) {
		    $got_conf = 1;
		    $conf_prefix = $1;
		}
		if(/^realname::(.*)$/) {
		    $got_conf = 1;
		    $conf_realname = $1;
		}
		if(/^vhost::(\S*)$/) {
		    $got_conf = 1;
		    $conf_vhost = $1;
		}
		if(/^qhost::(\S*)$/) {
		    $got_conf = 1;
		    $conf_qhost = $1;
		}
		if(/^qname::(\S*)$/) {
		    $got_conf = 1;
		    $conf_qname = $1;
		}
		if(/^qpassword::(\S*)$/) {
		    $got_conf = 1;
		    $conf_qpassword = $1;
		}
		if(/^server::(\S*)::(\d*)::(\d*)::(\d*)::(\d*)::(\d*)::(\S*)$/) {
		    $query = "INSERT INTO servers VALUES ('$1', $2, $3, $4, $5, $6, '$7', '$bothandle', $serverid)";
		    $serverid++;
		}
	    } elsif($config eq "kickreasons") {
		if(/^kickreason::(.*)$/) {
		    $kr = $1;
		    $kr =~ s/'/\''/g;
		    $query = "INSERT INTO kickreasons VALUES ('$kr', '$bothandle')";
		}
	    } elsif($config eq "trusted") {
		if(/^trusted::(\S*)$/) {
		    $query = "INSERT INTO trusted VALUES ('$1', '$bothandle')";
		}
	    } elsif($config eq "services") {
		if(/^service::(\S*)$/) {
		    $query = "INSERT INTO services VALUES ('$1', '$bothandle')";
		}
	    }
	    if($query ne "") {
		print "$query;\n";
	    }
	}
	if($got_conf == 1) {
	    $query = "INSERT INTO conf VALUES ('$conf_nick', '$conf_altnick', '$conf_user', '$conf_usermode', '$conf_flags', '$conf_prefix', '$conf_realname', '$conf_vhost', '$conf_qhost', '$conf_qname', '$conf_qpassword', '$bothandle')";
	    print "$query;\n";
	}
	close (fd);
    }
}
