# MySQL dump 8.12
#
# Host: localhost    Database: oer_quakenet
#--------------------------------------------------------
# Server version	3.23.32

#
# Table structure for table 'oer_admins'
#

CREATE TABLE oer_admins (
  handle VARCHAR(32) NOT NULL,
  flags VARCHAR(32),
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (handle,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_adverts'
#

CREATE TABLE oer_adverts (
  channel VARCHAR(50) NOT NULL,
  type VARCHAR(32) NOT NULL,
  message TEXT NOT NULL,
  ident VARCHAR(20) NOT NULL
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_autheds'
#

CREATE TABLE oer_autheds (
  ttype VARCHAR(32) NOT NULL,
  twhen INT UNSIGNED NOT NULL,
  thandle VARCHAR(32) NOT NULL,
  tchannel VARCHAR(50) NOT NULL,
  thostmask VARCHAR(80) NOT NULL,
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (ttype,twhen,thandle,tchannel,thostmask,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_bantype'
#

CREATE TABLE oer_bantype (
  channel VARCHAR(50) NOT NULL,
  type TINYINT UNSIGNED NOT NULL,
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (channel,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_banvars'
#

CREATE TABLE oer_banvars (
  channel VARCHAR(50) NOT NULL,
  b_auto_rejoin SMALLINT UNSIGNED NOT NULL,
  b_part_rejoin SMALLINT UNSIGNED NOT NULL,
  b_flood SMALLINT UNSIGNED NOT NULL,
  b_flood_repeat SMALLINT UNSIGNED NOT NULL,
  b_bad_word SMALLINT UNSIGNED NOT NULL,
  b_bad_nick SMALLINT UNSIGNED NOT NULL,
  b_normal_ban SMALLINT UNSIGNED NOT NULL,
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (channel,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_channels'
#

CREATE TABLE oer_channels (
  name VARCHAR(50) NOT NULL,
  chanmodes VARCHAR(12),
  chankey VARCHAR(32),
  chanlimit VARCHAR(32),
  chanflags VARCHAR(32),
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (name,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_conf'
#

CREATE TABLE oer_conf (
  nick VARCHAR(20) NOT NULL,
  altnick VARCHAR(20) NOT NULL,
  user VARCHAR(16),
  usermode VARCHAR(8),
  flags VARCHAR(8),
  prefix CHAR(32) NOT NULL,
  realname VARCHAR(64) NOT NULL,
  vhost VARCHAR(63),
  qhost VARCHAR(80),
  qname VARCHAR(32),
  qpassword VARCHAR(32),
  proxysetup VARCHAR(128),
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_floodvars'
#

CREATE TABLE oer_floodvars (
  channel VARCHAR(50) NOT NULL,
  f_expire SMALLINT UNSIGNED NOT NULL,
  f_limit SMALLINT UNSIGNED NOT NULL,
  f_interval SMALLINT UNSIGNED NOT NULL,
  f_lines SMALLINT UNSIGNED NOT NULL,
  f_chars SMALLINT UNSIGNED NOT NULL,
  f_nickflood_expire SMALLINT UNSIGNED NOT NULL,
  f_nickflood_changes SMALLINT UNSIGNED NOT NULL,
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (channel,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_hostmasks'
#

CREATE TABLE oer_hostmasks (
  hostmask VARCHAR(80) NOT NULL,
  channel VARCHAR(50) NOT NULL,
  type TINYINT UNSIGNED NOT NULL,
  handle VARCHAR(32) NOT NULL,
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (hostmask,channel,type,handle,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_kickreasons'
#

CREATE TABLE oer_kickreasons (
  reason VARCHAR(255) NOT NULL,
  ident VARCHAR(20) NOT NULL
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_last'
#

CREATE TABLE oer_last (
  channel VARCHAR(50) NOT NULL,
  nick VARCHAR(20) NOT NULL,
  twhen INT UNSIGNED NOT NULL,
  hostmask VARCHAR(80) NOT NULL,
  ident VARCHAR(20) NOT NULL,
  message TEXT NOT NULL,
  INDEX (channel,nick,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_nickbks'
#

CREATE TABLE oer_nickbks (
  channel VARCHAR(50) NOT NULL,
  pattern VARCHAR(32) NOT NULL,
  reason VARCHAR(64),
  setby VARCHAR(32),
  twhen INT UNSIGNED NOT NULL,
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (channel,pattern,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_output'
#

CREATE TABLE oer_output (
  twhen INT UNSIGNED NOT NULL,
  ident VARCHAR(20) NOT NULL,
  message TEXT NOT NULL
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_passwords'
#

CREATE TABLE oer_passwords (
  handle VARCHAR(32) NOT NULL,
  channel VARCHAR(50) NOT NULL,
  type TINYINT unsigned NOT NULL,
  password VARCHAR(32) NOT NULL,
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (handle,channel,type,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_permbans'
#

CREATE TABLE oer_permbans (
  channel VARCHAR(50) NOT NULL,
  mask VARCHAR(64) NOT NULL,
  reason VARCHAR(64),
  setby VARCHAR(32),
  twhen INT UNSIGNED NOT NULL,
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (channel,mask,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_raw'
#

CREATE TABLE oer_raw (
  twhen INT UNSIGNED NOT NULL,
  ident VARCHAR(20) NOT NULL,
  message TEXT NOT NULL
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_seen'
#

CREATE TABLE oer_seen (
  channel VARCHAR(50) NOT NULL,
  nick VARCHAR(20) NOT NULL,
  twhen INT UNSIGNED NOT NULL,
  hostmask VARCHAR(80) NOT NULL,
  ident VARCHAR(20) NOT NULL,
  INDEX (channel,nick,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_servers'
#

CREATE TABLE oer_servers (
  hostname VARCHAR(63) NOT NULL,
  port SMALLINT UNSIGNED NOT NULL,
  servermodes TINYINT UNSIGNED NOT NULL,
  pingfreq TINYINT UNSIGNED NOT NULL,
  protopers TINYINT UNSIGNED NOT NULL,
  linenoise TINYINT UNSIGNED NOT NULL,
  password VARCHAR(32),
  ident VARCHAR(20) NOT NULL,
  id TINYINT UNSIGNED NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (hostname,port,servermodes,pingfreq,protopers,linenoise,ident),
  INDEX (id)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_services'
#

CREATE TABLE oer_services (
  host VARCHAR(63) NOT NULL,
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (host,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_timestamps'
#

CREATE TABLE oer_timestamps (
  ttype VARCHAR(32) NOT NULL,
  twhen INT UNSIGNED NOT NULL,
  tchannel VARCHAR(50) NOT NULL,
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (ttype,tchannel,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_topics'
#

CREATE TABLE oer_topics (
  channel VARCHAR(50) NOT NULL,
  pos TINYINT UNSIGNED NOT NULL,
  twhen INT UNSIGNED NOT NULL,
  setby VARCHAR(32) NOT NULL,
  message VARCHAR(255) NOT NULL,
  ident VARCHAR(20) NOT NULL
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_trusted'
#

CREATE TABLE oer_trusted (
  host VARCHAR(63) NOT NULL,
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (host,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_users'
#

CREATE TABLE oer_users (
  handle VARCHAR(32) NOT NULL,
  channel VARCHAR(50) NOT NULL,
  flags VARCHAR(32),
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (handle,channel,ident)
) TYPE=MyISAM PACK_KEYS=1;

#
# Table structure for table 'oer_wordbks'
#

CREATE TABLE oer_wordbks (
  channel VARCHAR(50) NOT NULL,
  pattern VARCHAR(32) NOT NULL,
  reason VARCHAR(64),
  setby VARCHAR(32),
  twhen INT UNSIGNED NOT NULL,
  ident VARCHAR(20) NOT NULL,
  PRIMARY KEY (channel,pattern,ident)
) TYPE=MyISAM PACK_KEYS=1;



