/*

oer - IRC bot

See ftp://nic.funet.fi/pub/unix/irc/docs/FAQ.gz section 11 for the
definition of the word bot.

Copyright (C) 2000 EQU <equ@equnet.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "oer-common.h"
#include "oer.h"
#include "ds.h"
#include "misc.h"

/* prototype definitions */
void listservers(void);
void listchannels(void);
void listadmins(void);
void listusers(void);
void listchanusers(void);
void listpermbans(void);
void listnickbks(void);
void listwordbks(void);
void listchanmodes(void);
void listchanflags(void);
void listpubmsgs(void);
void listkickreasons(void);
void listtrusted(void);
void listtopics(void);
void listall(void);

void listservers()
{
	struct server *this;

	for(this = mystate->servers; this != NULL; this = this->next) {
		oer_debug(OER_DEBUG_INFO, "server %s port %d modes %d\n", this->serverhost, this->serverport, this->servermodes);
		if(this->prev != NULL) {
			oer_debug(OER_DEBUG_INFO, "\tprevious server %s port %d modes %d\n", this->prev->serverhost, this->prev->serverport, this->prev->servermodes);
		}
	}
}

void listchannels()
{
	struct channel *this;
	for(this = mystate->channels; this != NULL; this = this->next) {
		oer_debug(OER_DEBUG_INFO, "channel %s\n", this->name);
		if(this->prev != NULL) {
			oer_debug(OER_DEBUG_INFO, "\tprevious channel %s\n", this->prev->name);
		}
	}
}

void listadmins()
{
	struct botuser *admin;
	struct maskstruct *ms;

	for(admin = mystate->admins; admin != NULL; admin = admin->next) {
		oer_debug(OER_DEBUG_INFO, "admin %s with options %s\n", admin->handle, admin->options);
		for(ms = admin->firstmask; ms != NULL; ms = ms->next) {
			oer_debug(OER_DEBUG_INFO, "admin %s mask %s\n", admin->handle, ms->mask);
			if(ms->prev != NULL) {
				oer_debug(OER_DEBUG_INFO, "\tprevious admin %s mask %s\n", admin->handle, ms->prev->mask);
			}
		}
	}
}

void listusers()
{
	struct channel *this;
	struct botuser *user;
	struct maskstruct *ms;

	for(this = mystate->channels; this != NULL; this = this->next) {
		for(user = this->users; user != NULL; user = user->next) {
			oer_debug(OER_DEBUG_INFO, "channel %s user %s with options %s\n", this->name, user->handle, user->options);
			for(ms = user->firstmask; ms != NULL; ms = ms->next) {
				oer_debug(OER_DEBUG_INFO, "%s channel user %s mask %s\n", \
				       this->name, user->handle, ms->mask);
				if(ms->prev != NULL) {
					oer_debug(OER_DEBUG_INFO, "\tprevious %s channel user %s mask %s\n", this->name, user->handle, ms->prev->mask);
				}
			}
		}
	}
}

void listchanusers()
{
	struct channel *this;
	struct chanuser *cu;

	for(this = mystate->channels; this != NULL; this = this->next) {
		if(amiop(this->name)) {
			oer_debug(OER_DEBUG_INFO, "there are %d users on %s\n", this->nickcount, this->name);
		} else {
			oer_debug(OER_DEBUG_INFO, "there are %d users on %s *\n", this->nickcount, this->name);
		}
		cu = this->nicks;
		while(cu != NULL) {
			oer_debug(OER_DEBUG_FLOOD, "channel: %s, nick: %s, host: %s, oper: %s, op: %s, voice: %s\n", this->name, cu->nick, cu->host, (cu->ircop) ? "YES" : "NO", (cu->chanop) ? "YES" : "NO", (cu->voice) ? "YES" : "NO");
			cu = cu->next;
		}
	}
}

void listpermbans()
{
	struct channel *this;
	struct maskstruct *ms;

	for(this = mystate->channels; this != NULL; this = this->next) {
		for(ms = this->permbans; ms != NULL; ms = ms->next) {
			oer_debug(OER_DEBUG_INFO, "permban %s on channel %s\n", ms->mask, this->name);
			if(ms->prev != NULL) {
				oer_debug(OER_DEBUG_INFO, "\tprevious permban %s on channel %s\n", ms->prev->mask, this->name);
			}
		}
	}
}

void listnickbks()
{
	struct channel *this;
	struct maskstruct *ms;

	for(this = mystate->channels; this != NULL; this = this->next) {
		for(ms = this->nickbks; ms != NULL; ms = ms->next) {
			oer_debug(OER_DEBUG_INFO, "nick %s gets you banned & kicked from channel %s\n", ms->mask, this->name);
			if(ms->prev != NULL) {
				oer_debug(OER_DEBUG_INFO, "\tprevious nick %s that gets you banned & kicked from channel %s\n", ms->prev->mask, this->name);
			}
		}
	}
}

void listwordbks()
{
	struct channel *this;
	struct maskstruct *ms;

	for(this = mystate->channels; this != NULL; this = this->next) {
		for(ms = this->wordbks; ms != NULL; ms = ms->next) {
			oer_debug(OER_DEBUG_INFO, "word mask %s gets you banned & kicked from channel %s\n", ms->mask, this->name);
			if(ms->prev != NULL) {
				oer_debug(OER_DEBUG_INFO, "\tprevious word mask %s that gets you banned & kicked from channel %s\n", ms->prev->mask, this->name);
			}
		}
	}
}

void listchanmodes()
{
	struct channel *this;
	for(this = mystate->channels; this != NULL; this = this->next) {
		oer_debug(OER_DEBUG_INFO, "channel modes for channel %s are %s\n", this->name, this->mode);
	}
}

void listchanflags()
{
	struct channel *this;

	for(this = mystate->channels; this != NULL; this = this->next) {
		oer_debug(OER_DEBUG_INFO, "channel %s has ansi_prot %s\n", this->name, (haschanflags(this->name, "a")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has ban_prot %s\n", this->name, (haschanflags(this->name, "b")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has perm_bans %s\n", this->name, (haschanflags(this->name, "e")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has pubmsg_floodp %s\n", this->name, (haschanflags(this->name, "f")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has friends %s\n", this->name, (haschanflags(this->name, "F")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has lock_chan %s\n", this->name, (haschanflags(this->name, "l")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has last %s\n", this->name, (haschanflags(this->name, "L")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has mass_prot %s\n", this->name, (haschanflags(this->name, "m")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has nick_bk %s\n", this->name, (haschanflags(this->name, "n")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has auto_op %s\n", this->name, (haschanflags(this->name, "o")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has auto_op_admins %s\n", this->name, (haschanflags(this->name, "O")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has postnj_check %s\n", this->name, (haschanflags(this->name, "p")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has paranoid %s\n", this->name, (haschanflags(this->name, "P")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has quote %s\n", this->name, (haschanflags(this->name, "q")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has autorejoin_kb %s\n", this->name, (haschanflags(this->name, "r")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has seen %s\n", this->name, (haschanflags(this->name, "S")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has users_op %s\n", this->name, (haschanflags(this->name, "u")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has auto_voice %s\n", this->name, (haschanflags(this->name, "v")) ? "ON" : "OFF");
		oer_debug(OER_DEBUG_INFO, "channel %s has word_bk %s\n", this->name, (haschanflags(this->name, "w")) ? "ON" : "OFF");
	}
}

void listpubmsgs()
{
	struct channel *this;
	struct pubmsg *pm;

	for(this = mystate->channels; this != NULL; this = this->next) {
		for(pm = this->pubmsgs; pm != NULL; pm = pm->next) {
			oer_debug(OER_DEBUG_INFO, "channel %s, at: %lu, nick: %s, host: %s, message: %s\n", this->name, pm->at, pm->nick, pm->host, pm->message);
		}
	}
}

void listkickreasons()
{
	struct maskstruct *ms;

	ms = mystate->kickreasons;
	while(ms != NULL) {
		oer_debug(OER_DEBUG_INFO, "kickreason: %s\n", ms->mask);
		if(ms->prev != NULL) {
			oer_debug(OER_DEBUG_INFO, "\tprevious kickreason: %s\n", ms->prev->mask);
		}
		ms = ms->next;
	}
}

void listtrusted()
{
	struct maskstruct *ms;

	ms = mystate->trusted;
	while(ms != NULL) {
		oer_debug(OER_DEBUG_INFO, "trusted domain: %s\n", ms->mask);
		if(ms->prev != NULL) {
			oer_debug(OER_DEBUG_INFO, "\tprevious trusted domain: %s\n", ms->prev->mask);
		}
		ms = ms->next;
	}
}

void listtopics()
{
	struct topic *t;
	struct channel *this;

	for(this = mystate->channels; this != NULL; this = this->next) {
		for(t = this->topics; t != NULL; t = t->next) {
			oer_debug(OER_DEBUG_INFO, "channel: %s, topic: %s, set at: %lu, by nick: %s\n", this->name, t->topic, t->at, t->setby);
			if(t->prev != NULL) {
				oer_debug(OER_DEBUG_INFO, "\tprevios channel: %s, topic: %s, set at: %lu, by nick: %s\n", this->name, t->prev->topic, t->prev->at, t->prev->setby);
			}
		}
	}
}

void listall()
{
	listservers();
        listchannels();
        listusers();
	listchanusers();
        listpermbans();
        listnickbks();
        listwordbks();
        listchanmodes();
	listchanflags();
	listpubmsgs();
	listkickreasons();
     	listtrusted();
        listadmins();
	listtopics();
}

