#!/bin/sh

CURRDIR=`pwd`

readln () {
	echo -n "$1"
        IFS='@' read ans || exit 1
        [ -z "$ans" ] && ans=$2
}

echo ""
echo "oer configuration follows ... "
echo ""
readln "Please specify default IRC nick [oer] " "oer"
NICK=$ans
readln "Please specify alternate IRC nick [oeroer] " "oeroer"
ALTNICK=$ans
readln "Please specify user ID [oer] " "oer"
USERID=$ans
readln "Please specify user modes [+i] " "+i"
USERMODES=$ans
readln "Please specify bot flags [f] " "f"
BOTFLAGS=$ans
readln "Please specify command prefix [!] " "!"
PREFIX=$ans
readln "Please specify IRC REALNAME [http://oer.equnet.org/help.html] " "http://oer.equnet.org/help.html"
REALNAME=$ans
readln "Please specify optional virtual host [] " ""
VIRTHOST=$ans
readln "Please specify default IRC server to connect to [irc.equnet.org] " "irc.equnet.org"
SERVER=$ans
readln "Please specify port [6667] " "6667"
PORT=$ans
readln "Please specify amount of allowed server modes [6] " "6"
MODES=$ans
readln "Please specify ping frequency in seconds on $SERVER [90] " "90"
PINGFREQ=$ans
readln "Please specify whether IRC operators are protected on $SERVER (0 = no, 1 = yes) [0] " "0"
PROT=$ans
readln "Please specify whether you want line noise for $SERVER (0 = off, >>1 = on) [0] " "0"
NOISE=$ans
readln "Please specify optional server password for $SERVER [] " ""
SERVERPW=$ans

echo ""
echo -n "Creating configuration/oer.conf ... "
echo "nick::$NICK" > configuration/oer.conf
echo "altnick::$ALTNICK" >> configuration/oer.conf
echo "user::$USERID" >> configuration/oer.conf
echo "usermode::$USERMODES" >> configuration/oer.conf
echo "flags::$BOTFLAGS" >> configuration/oer.conf
echo "prefix::$PREFIX" >> configuration/oer.conf
echo "realname::$REALNAME" >> configuration/oer.conf
if [ x$VIRTHOST != x ]; then
    echo "vhost::$VIRTHOST" >> configuration/oer.conf
fi
echo "server::$SERVER::$PORT::$MODES::$PINGFREQ::$PROT::$NOISE::$SERVERPW" >> configuration/oer.conf

RC=$?

if [ $RC -eq 1 ]; then
    echo "failed"
    echo ""
    exit 1
fi

echo "ok"
echo ""
readln "Please specify bot admin handle [EQU] " "EQU"
ADMIN=$ans
readln "Please specify bot admin flags [n] " "n"
ADMINFLAGS=$ans
readln "Please specify bot admin hostmask [equ@*.equnet.org] " "equ@*.equnet.org"
ADMINHOSTMASK=$ans

echo ""
echo -n "Creating configuration/oer.admins ... "
echo "admin::$ADMIN::$ADMINFLAGS" > configuration/oer.admins
echo "mask::$ADMIN::$ADMINHOSTMASK" >> configuration/oer.admins

RC=$?

if [ $RC -eq 1 ]; then
    echo "failed"
    echo ""
    exit 1
fi

echo "ok"
echo ""
exit 0
