/*

oersync - a utility for syncing oer+MySQL databases

Copyright (C) 2002 EQU <equ@equnet.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#include <string.h>

#ifdef HAVE_CRYPT_H
#include <crypt.h>
#endif

#ifdef HAVE_CTYPE_H 
  #include <ctype.h> 
#endif

#ifdef HAVE_LOCALE_H
  #include <locale.h>
#endif

#include <errno.h>
#include <unistd.h>
#include <netdb.h>
#include <netinet/in.h>
#include <pwd.h>
#include <signal.h>

#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>

#ifdef TIME_WITH_SYS_TIME
  #include <sys/time.h>
  #include <time.h>
#else
  #ifdef HAVE_SYS_TIME_H
    #include <sys/time.h>
  #else
    #include <time.h>
  #endif
#endif

#include <sys/wait.h>

#include <mysql.h>
#include <mysql/errmsg.h>

#define OERSYNC_VERSION "oersync 0.0.5"

#define TINYSTRINGLEN 32
#define MIDSTRINGLEN 64
#define STRINGLEN 128
#define HUGESTRINGLEN 512
#define HOSTLEN 63
#define IDENTLEN 20

#define DEFAULT_DELIM "::"

/* from glib.h */
#define ABS(a)         (((a) < 0) ? -(a) : (a))

enum DEBUG_LEVELS {
	DEBUG_FATAL,
	DEBUG_ERROR,
	DEBUG_WARNING,
	DEBUG_INFO,
	DEBUG_NOISE,
	DEBUG_FLOOD
};

enum OER_TABLES {
	ADMINS,
	AUTHEDS,
	HOSTMASKS,
	PASSWORDS,
	TIMESTAMPS,
	USERS
};

struct mysqldb {
        char mysqldbdbhost[HOSTLEN + 1];
        char mysqldbdbname[TINYSTRINGLEN + 1];
        char mysqldbdbuser[TINYSTRINGLEN + 1];
        char mysqldbdbpw[TINYSTRINGLEN + 1];
        MYSQL mysqldbconn;
};
