/*

oer - IRC bot

See ftp://nic.funet.fi/pub/unix/irc/docs/FAQ.gz section 11 for the
definition of the word bot.

Copyright (C) 2000 EQU <equ@equnet.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "oer-common.h"
#include "oer.h"
#include "misc.h"
#include "reg.h"
#include "list.h"

/* prototype definitions */
char *getlamer(char *);
char *getchanmode(char *);
char *getchankey(char *);
char *getchanflags(char *);
char *safeban(char *);
char *getfirsthostless(char *);
char *isnickbk(char *, char *);
char *getkickreason(char *);
char *deltopic(char *, int, char *);
int partcount(char *, char *, char *);
int loadall(void);
int loadconf(void);
int loadchannels(void);
int loadtrusted(void);
int loadadmins(void);
int loadkickreasons(void);
int loadchaninfo(void);
int saveall(void);
int saveconf(void);
int savechannels(void);
int savetrusted(void);
int saveadmins(void);
int savekickreasons(void);
int savechaninfo(void);
int parseconf(char *);
int parsechannels(char *);
int parsetrusted(char *);
int parseadmins(char *);
int parsekickreasons(char *);
int parsechaninfo(char *);
int allhostsknown(char *);
int burstjoins(char *);
int amiop(char *);
int isq(char *);
int isme(char *);
int isvalidchannel(char *);
int isvoicenow(char *, char *);
int isatleastopnow(char *, char *, char *);
int isallowedop(char *, char *);
int isop(char *, char *);
int isvalidlogon(char *, char *);
int isopa(char *);
int ishostless(char *);
int delopa(char *);
int isadmin(char *, char *);
int isonchan(char *, char *);
int issameuser(char *, char *, char *);
int isopnow(char *, char *);
int iswordbk(char *, char *);
int isflood(char *, char *, char *, char *);
int ispermban(char *, char *);
int ismoderated(char *);
int permbancount(char *);
int topiccount(char *);
int haschanflags(char *, char *);
int hasadminflags(char *, char *);
int hasuserflags(char *, char *, char *);
int nickchange(char *, char *, char *);
int usersonchan(char *);
int nthmode(char *, int);
int userleft(char *, char *, char *);
int sameuser(char *, char *, char *, char *);
int changeuser(char *, char *, int, int, int);
int whichctcp(char *);
int whichcommand(char *, int);
int gettobek(char *, char *);
int checkforansi(char *, char *, char *, char *);
int checkforflood(char *, char *, char *, char *);
int checkforbadword(char *, char *, char *, char *);
int checkforbadnick(char *, char *, char *);
int checkforautorejoin(char *, char *, char *);
int checkforpartrejoin(char *, char *, char *);
int delchankey(char *);
int delpermban(char *, char *);
int delnickbk(char *, char *);
int delwordbk(char *, char *);
int uptime(time_t *, time_t *);
int deladmin(char *);
int deladminmask(char *, char *);
int deluser(char *, char *);
int delusermask(char *, char *, char *);
int deltrusted(char *);
int delchannel(char *);
int delkickreason(char *);
int getondiskmsgcount(char *, char *);
int getondiskjoincount(char *, char *);
int getjoincount(char *, char *);
int getrandom(int);
int getrandommsg(char *, char *, int, int, char *, int);
int lastquote(char *);
int delserver(char *, int, int, int, int, int);
int setpassword(char *, char *, char *);
int logoff(char *, char *);
int logon(char *, char *, char *, char *, int);
struct authed *addnewauthed(char *, time_t, struct botuser *, char *);
struct botuser *addbotuser(char *, char *);
struct botuser *addnewadmin(char *, char *);
struct botuser *addnewuser(char *, char *, char *);
struct channel *addnewchannel(char *);
struct channel *getchptr(char *);
struct chanuser *userjoined(char *, char *, char *, int, int, int);
struct chanuser *getcuptr(char *, char *);
struct state *emptystate(void);
struct server *getserver(void);
struct server *addnewserver(char *, int, int, int, int, int);
struct maskstruct *addnewpermban(char *, char *);
struct maskstruct *addnewnickbk(char *, char *, char *);
struct maskstruct *addnewwordbk(char *, char *);
struct maskstruct *addnewtrusted(char *);
struct maskstruct *addnewkickreason(char *);
struct maskstruct *addnewusermask(char *, char *, char *);
struct maskstruct *addnewadminmask(char *, char *);
struct maskstruct *editmask(struct maskstruct *, char *, char *);
struct modeline *addnewmm(char *, time_t, char *, char *);
struct pubmsg *addnewpubmsg(char *, time_t, char *, char *, char *);
struct part *addnewpart(char *, time_t, char *, char *);
struct join *addnewjoin(char *, time_t, char *, char *);
struct timed *addnewtimed(time_t, int, int, char *, char *, char *, char *);
struct topic *addnewtopic(char *, char *, char *);
struct topic *insertnewtopic(char *, char *, char *, int);
struct topic *edittopic(char *, char *, char *, int);
struct chanuser *getrandomuser(char *);
struct ls_wrapstruct *addnew_ls(struct ls_wrapstruct *, time_t, char *, char *, char *);
time_t lastoff(char *, char *);
void resetparts(char *, char *, char *);
void iamop(char *, int);
void initpubmsgs(char *);
void freepubmsguser(char *, char *, char *);
void lockchan(char *, char *, int, char *, char *);
void unlockchan(char *, char *, char *);
void clearflood(char *, char *, char *);
void newchannel(char *);
void initchannel(char *);
void initall(void);
void initmmodes(char *);
void inittimeds(void);
void initnicks(char *);
void initparts(char *);
void initjoins(char *);
void initnickbks(char *);
void initwordbks(char *);
void initpermbans(char *);
void initusers(char *);
void linenoise(void);
void checkstoned(void);
void delalltopics(char *);
void refreshtopic(char *);
void swaptopic(char *, int, int);
void gettopic(char *, char *);
void listtopic(char *, int, char *);
void setuserhost(char *, char *);
void sethostquerystatus(char *, int);
void iwaskicked(char *);
void banuser(char *, char *);
void unbanuser(char *, char *);
void bankickuser(char *, char *, char *);
void kickuser(char *, char *, char *);
void sendreply(char *, int, int, int, char *);
void sendchannelnotice(char *, int, char *);
void listcommand(char *, int, char *, char *, char *, char *);
void addcommand(char *, int, char *, char *, char *, char *);
void delcommand(char *, int, char *, char *, char *, char *);
void editcommand(char *, int, char *, char *, char *, char *);
void logoffcommand(char *, int, char *, char *, char *, char *);
void logoncommand(char *, int, char *, char *, char *, char *);
void isjoined(char *);
void changetobek(char *, char *, int);
void setnick(void);
void setumode(void);
void syncvoices(char *);
void syncops(char *);
void syncbans(char *);
void syncnickbks(char *);
void syncuserhosts(void);
void settopic(void);
void processenv(void);
void processlock(void);
void joinchannels(void);
void updatelast(char *, char *, char *, char *);
void updateseen(char *, char *, char *);
void showlast(char *, int, char *, char *);
void showseen(char *, int, char *, char *);
void setchanflags(char *, char *);
void setchanmode(char *, char *);
void setchankey(char *, char *);
void channelsync(char *);
void cleartobeks(char *);
void getnthmode(char *, int, char *);
void massmessage(char *, char *);
void setlastquote(char *, time_t);
void flushall(void);
void quit(void);
void parsectcp(char *, char *, int, char *);
void nstats(char *, int, char *, char *);
void wall(char *, char *, char *, char *);
void cleanautheds(char *);

void quit(void)
{
        char stringbuffer[STRINGLEN + 1];
	
	if(mystate->current_server == NULL || mystate->current_server->registered != OER_REGISTERCONNECTION_STATUS_DONE) {
		close(mystate->sockfd);
		exit(EXIT_SUCCESS);
	}
	snprintf(stringbuffer, STRINGLEN, "QUIT :%s\n", mystate->signoff);
	addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
	mystate->quitting = 1;
}

void flushall(void)
{
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "flushall->flushing all disk I/O\n");
	for(this = mystate->channels; this != NULL; this = this->next) {
		if(this->seen != NULL) {
			fflush(this->seen);
		}
		if(this->last != NULL) {
			fflush(this->last);
		}
	}
	if(mystate->logfp != NULL) {
		fflush(mystate->logfp);
	}
	if(mystate->logto != NULL) {
		fflush(mystate->logto);
	}
}

int uptime(time_t *uptime, time_t *idle)
{
        float this_uptime;
        float this_idle;
	FILE *fp;
        char stringbuffer[STRINGLEN + 1];

	/* read uptime & idle from /proc */
        if((fp = fopen("/proc/uptime", "r")) == NULL) {
		return 0;
	}
        while(fgets(stringbuffer, STRINGLEN, fp) != NULL) {
                sscanf(stringbuffer, "%f %f", &this_uptime, &this_idle);
        }
	*uptime = this_uptime;
	*idle = this_idle;
	return 1;
}

int delpermban(char *channel, char *mask)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	/* find & remove mask */
	ms = this->permbans;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			break;
		}
		ms = ms2->next;
	}
	if(ms == NULL) {
		return 0;
	}
	/* adjust lists */
	if(ms->prev == NULL) {
		/* first mask in list */
		this->permbans = ms->next;
		/* ... check if also last */
		if(ms->next != NULL) {
			ms->next->prev = NULL;
		}
	}
	if(ms->next == NULL) {
		/* last mask in list */
		/* ... check also if the only one */
		if(ms->prev != NULL) {
			ms->prev->next = NULL;
		}
	}
	if(ms->prev != NULL && ms->next != NULL) {
		/* between 2 or more masks */
		ms->prev->next = ms->next;
		ms->next->prev = ms->prev;
	}
	free(ms->mask);
	free(ms->optstring);
	free(ms);
	return 1;
}

int delkickreason(char *kickreason)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;

	/* find & remove mask */
	ms = mystate->kickreasons;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, kickreason)) {
			break;
		}
		ms = ms2->next;
	}
	if(ms == NULL) {
		return 0;
	}
	/* adjust lists */
	if(ms->prev == NULL) {
		/* first mask in list */
		mystate->kickreasons = ms->next;
		/* ... check if also last */
		if(ms->next != NULL) {
			ms->next->prev = NULL;
		}
	}
	if(ms->next == NULL) {
		/* last mask in list */
		/* ... check also if the only one */
		if(ms->prev != NULL) {
			ms->prev->next = NULL;
		}
	}
	if(ms->prev != NULL && ms->next != NULL) {
		/* between 2 or more masks */
		ms->prev->next = ms->next;
		ms->next->prev = ms->prev;
	}
	free(ms->mask);
	free(ms->optstring);
	free(ms);
	mystate->kickrs--;
	return 1;
}

int delserver(char *serverhost, int serverport, int servermodes, int pingfrequency, int protected_ircops, int linenoise)
{
	struct server *s;
	struct server *s2;

	/* find & remove server */
	s = mystate->servers;
        s2 = s;
        while(s != NULL) {
                s2 = s;
                if(!strcasecmp(s->serverhost, serverhost) && s->serverport == serverport && s->servermodes == servermodes && s->pingfrequency == pingfrequency && s->protected_ircops == protected_ircops && s->linenoise == linenoise) {
			break;
                }
                s = s2->next;
        }
	if(s == NULL) {
		return 0;
	}
	if(s == mystate->current_server) {
		/* we won't remove the current server */
		return 0;
	}
	/* adjust lists */
	if(s->prev == NULL) {
		/* first mask in list */
		mystate->servers = s->next;
		/* ... check if also last */
		if(s->next != NULL) {
			s->next->prev = NULL;
		}
	}
	if(s->next == NULL) {
		/* last server in list */
		/* ... check also if the only one */
		if(s->prev != NULL) {
			s->prev->next = NULL;
		}
	}
	if(s->prev != NULL && s->next != NULL) {
		/* between 2 or more servers */
		s->prev->next = s->next;
		s->next->prev = s->prev;
	}
	free(s);
	return 1;
}

int delnickbk(char *channel, char *mask)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	/* find & remove mask */
	ms = this->nickbks;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			break;
		}
		ms = ms2->next;
	}
	if(ms == NULL) {
		return 0;
	}
	/* adjust lists */
	if(ms->prev == NULL) {
		/* first mask in list */
		this->nickbks = ms->next;
		/* ... check if also last */
		if(ms->next != NULL) {
			ms->next->prev = NULL;
		}
	}
	if(ms->next == NULL) {
		/* last mask in list */
		/* ... check also if the only one */
		if(ms->prev != NULL) {
				ms->prev->next = NULL;
		}
	}
	if(ms->prev != NULL && ms->next != NULL) {
		/* between 2 or more masks */
		ms->prev->next = ms->next;
		ms->next->prev = ms->prev;
	}
	free(ms->mask);
	free(ms->optstring);
	free(ms);
	return 1;
}

int delwordbk(char *channel, char *mask) 
{
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	/* find & remove mask */
	ms = this->wordbks;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			break;
		}
		ms = ms2->next;
	}
	if(ms == NULL) {
		return 0;
	}
	/* adjust lists */
	if(ms->prev == NULL) {
		/* first mask in list */
		this->wordbks = ms->next;
		/* ... check if also last */
		if(ms->next != NULL) {
			ms->next->prev = NULL;
		}
	}
	if(ms->next == NULL) {
		/* last mask in list */
		/* ... check also if the only one */
		if(ms->prev != NULL) {
			ms->prev->next = NULL;
		}
	}
	if(ms->prev != NULL && ms->next != NULL) {
		/* between 2 or more masks */
		ms->prev->next = ms->next;
		ms->next->prev = ms->prev;
	}
	free(ms->mask);
	free(ms->optstring);
	free(ms);
	return 1;
}

int getondiskmsgcount(char *channel, char *thisnick)
{
	/* new fds  */

	int i;
	int msgcount;
	int len;
	char outstring[TXT_BUFFER + 1];
	char nick[NICKLEN + 1];
	char *p;
	char *q;
	struct channel *this;
	FILE *fp;

	oer_debug(OER_DEBUG_INFO, "getondiskmsgcount->getting message count for channel %s nick %s\n", channel, thisnick);
	if((this = getchptr(channel)) == NULL) {
		return -1;
	}
	if(this->last == NULL) {
		return -1;
	}
	fflush(this->last);
	snprintf(outstring, HUGESTRINGLEN, "last-%s", this->name);
	if((fp = fopen(outstring, "r")) == NULL) {
		oer_debug(OER_DEBUG_INFO, "getondiskmsgcount->failed to open %s: %s\n", outstring, strerror(errno));
		return -1;
	}
	msgcount = 0;
	while(fgets(outstring, TXT_BUFFER, fp)) {
		p = outstring;
		/* striplf() */
		for(i = strlen(p) - 1; isspace((int)p[i]) && i >= 0; i--) {
			p[i] = '\0';
		}
		/* first field is the timestamp, skip to next */
		for(;*p != '\0'; p++) {
			if(!strncasecmp(p, OER_DEFAULT_DELIM, OER_DEFAULT_DELIM_LEN)) {
				p += 2;
				break;
			}
		}
		if(*p == '\0') {
			continue;
		}
		q = p;
		/* 2nd field is the nick */
		for(;*p != '\0'; p++) {
			if(!strncasecmp(p, OER_DEFAULT_DELIM, OER_DEFAULT_DELIM_LEN)) {
				p += 2;
				break;
			}
		}
		if(*p == '\0') {
			continue;
		}
		len = (p - q) - OER_DEFAULT_DELIM_LEN;
		len = (len > NICKLEN) ? NICKLEN : len;
		strncpy(nick, q, len);
		nick[len] = '\0';
		if(!strcasecmp(thisnick, nick)) {
			msgcount++;
		}
	}
	fclose(fp);
	oer_debug(OER_DEBUG_INFO, "getondiskmsgcount->returning %d\n", msgcount);
	return msgcount;
}

int getondiskjoincount(char *channel, char *thisnick)
{
	/* new fds  */

	int i;
	int joincount;
	int len;
	char outstring[TXT_BUFFER + 1];
	char nick[NICKLEN + 1];
	char *p;
	char *q;
	struct channel *this;
	FILE *fp;

	oer_debug(OER_DEBUG_INFO, "getondiskjoincount->getting join count for channel %s nick %s\n", channel, thisnick);
	if((this = getchptr(channel)) == NULL) {
		return -1;
	}
	if(this->seen == NULL) {
		return -1;
	}
	fflush(this->seen);
	snprintf(outstring, HUGESTRINGLEN, "seen-%s", this->name);
	if((fp = fopen(outstring, "r")) == NULL) {
		oer_debug(OER_DEBUG_INFO, "getondiskjoincount->failed to open %s: %s\n", outstring, strerror(errno));
		return -1;
	}
	joincount = 0;
	while(fgets(outstring, TXT_BUFFER, fp)) {
		p = outstring;
		/* striplf() */
		for(i = strlen(p) - 1; isspace((int)p[i]) && i >= 0; i--) {
			p[i] = '\0';
		}
		/* first field is the timestamp, skip to next */
		for(;*p != '\0'; p++) {
			if(!strncasecmp(p, OER_DEFAULT_DELIM, OER_DEFAULT_DELIM_LEN)) {
				p += 2;
				break;
			}
		}
		if(*p == '\0') {
			continue;
		}
		q = p;
		/* 2nd field is the nick */
		for(;*p != '\0'; p++) {
			if(!strncasecmp(p, OER_DEFAULT_DELIM, OER_DEFAULT_DELIM_LEN)) {
				p += 2;
				break;
			}
		}
		if(*p == '\0') {
			continue;
		}
		len = (p - q) - OER_DEFAULT_DELIM_LEN;
		len = (len > NICKLEN) ? NICKLEN : len;
		strncpy(nick, q, len);
		nick[len] = '\0';
		if(!strcasecmp(thisnick, nick)) {
			joincount++;
		}
	}
	fclose(fp);
	oer_debug(OER_DEBUG_INFO, "getondiskjoincount->returning %d\n", joincount);
	return joincount;
}

int getrandommsg(char *channel, char *thisnick, int nicklen, int which, char *msgstore, int msgstorelen)
{
	/* new fds  */

	int i;
	int pos;
	int strpos;
	int len;
	int rc;
	char outstring[TXT_BUFFER + 1];
	char nick[NICKLEN + 1];
	char message[HUGESTRINGLEN + 1];
	char *p;
	char *q;
	struct channel *this;
	FILE *fp;

	oer_debug(OER_DEBUG_INFO, "getrandommsg->channel %s thisnick %s which %d\n", channel, thisnick, which);
	if((this = getchptr(channel)) == NULL) {
		return -1;
	}
	if(this->last == NULL) {
		return -1;
	}
	fflush(this->last);
	snprintf(outstring, TXT_BUFFER, "last-%s", this->name);
	if((fp = fopen(outstring, "r")) == NULL) {
		oer_debug(OER_DEBUG_INFO, "getrandommsg->failed to open %s: %s\n", outstring, strerror(errno));
		return -1;
	}
	pos = 0;
	rc = -1;
	while(fgets(outstring, TXT_BUFFER, fp)) {
		p = outstring;
		/* striplf() */
		for(i = strlen(p) - 1; isspace((int)p[i]) && i >= 0; i--) {
			p[i] = '\0';
		}
		/* first field is the timestamp, skip to next */
		for(;*p != '\0'; p++) {
			if(!strncasecmp(p, OER_DEFAULT_DELIM, OER_DEFAULT_DELIM_LEN)) {
				p += 2;
				break;
			}
		}
		if(*p == '\0') {
			continue;
		}
		q = p;
		/* 2nd field is the nick */
		for(;*p != '\0'; p++) {
			if(!strncasecmp(p, OER_DEFAULT_DELIM, OER_DEFAULT_DELIM_LEN)) {
				p += 2;
				break;
			}
		}
		if(*p == '\0') {
			continue;
		}
		len = (p - q) - OER_DEFAULT_DELIM_LEN;
		len = (len > NICKLEN) ? NICKLEN : len;
		strncpy(nick, q, len);
		nick[len] = '\0';
		if(strcasecmp(thisnick, nick)) {
			/* not the nick we are after */
			continue;
		}
		pos++;
		if(pos < which) {
			/* not the msg we are after */
			continue;
		}
		/* 3rd field is the host */
		for(;*p != '\0'; p++) {
			if(!strncasecmp(p, OER_DEFAULT_DELIM, OER_DEFAULT_DELIM_LEN)) {
				p += 2;
				break;
			}
		}
		if(*p == '\0') {
			continue;
		}
		/* 4th field is the message */
		strpos = 0;
		while(*p != '\0' && strpos < HUGESTRINGLEN) {
			message[strpos++] = *p++;
		}
		message[strpos] = '\0';
		/* don't retrieve too short/long messages */
		if(strlen(message) < OER_QUOTE_MIN_LENGTH || strlen(message) > OER_QUOTE_MAX_LENGTH) {
			continue;
		}
		strncpy(thisnick, nick, nicklen);
		strncpy(msgstore, message, msgstorelen);
		rc = 0;
		break;
	}
	fclose(fp);
	return rc;
}

void showlast(char *to, int tochan, char *channel, char *mask)
{
	/* new fds  */

	int i;
	int strpos;
	int len;
	char outstring[TXT_BUFFER + 1];
	char pattern[NICKLEN + 1];
	char at[NICKLEN + 1];
	char ts[TINYSTRINGLEN + 1];
	char nick[NICKLEN + 1];
	char host[HOSTLEN + 1];
	char message[HUGESTRINGLEN + 1];
	char *p;
	char *q;
	struct channel *this;
	struct ls_wrapstruct *first;
	struct ls_wrapstruct *ls;
	struct ls_wrapstruct *ls2;
	FILE *fp;

	if(mask != NULL) {
		oer_debug(OER_DEBUG_INFO, "showlast->channel %s mask %s\n", channel, mask);
	} else {
		oer_debug(OER_DEBUG_INFO, "showlast->channel %s\n", channel);
	}
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	if(this->last == NULL) {
		return;
	}
	fflush(this->last);
	snprintf(outstring, TXT_BUFFER, "last-%s", this->name);
	if((fp = fopen(outstring, "r")) == NULL) {
		oer_debug(OER_DEBUG_INFO, "showlast->failed to open %s: %s\n", outstring, strerror(errno));
		return;
	}
	strncpy(pattern, "*", NICKLEN);
	if(mask != NULL) {
		strncpy(pattern, mask, NICKLEN);
	}
        first = NULL;
	while(fgets(outstring, TXT_BUFFER, fp)) {
		p = outstring;
		/* striplf() */
		for(i = strlen(p) - 1; isspace((int)p[i]) && i >= 0; i--) {
			p[i] = '\0';
		}
		/* first field is the timestamp */
		q = p;
		for(;*p != '\0'; p++) {
			if(!strncasecmp(p, OER_DEFAULT_DELIM, OER_DEFAULT_DELIM_LEN)) {
				p += 2;
				break;
			}
		}
		if(*p == '\0') {
			continue;
		}
		len = (p - q) - OER_DEFAULT_DELIM_LEN;
		len = (len > NICKLEN) ? NICKLEN : len;
		strncpy(at, q, len);
		at[len] = '\0';
		/* 2nd field is the nick */
		q = p;
		for(;*p != '\0'; p++) {
			if(!strncasecmp(p, OER_DEFAULT_DELIM, OER_DEFAULT_DELIM_LEN)) {
				p += 2;
				break;
			}
		}
		if(*p == '\0') {
			continue;
		}
		len = (p - q) - OER_DEFAULT_DELIM_LEN;
		len = (len > NICKLEN) ? NICKLEN : len;
		strncpy(nick, q, len);
		nick[len] = '\0';
		if(!wild_match(pattern, nick)) {
			/* not the nick we are after */
			continue;
		}
		/* 3rd field is the host */
		q = p;
		for(;*p != '\0'; p++) {
			if(!strncasecmp(p, OER_DEFAULT_DELIM, OER_DEFAULT_DELIM_LEN)) {
				p += 2;
				break;
			}
		}
		if(*p == '\0') {
			continue;
		}
		len = (p - q) - OER_DEFAULT_DELIM_LEN;
		len = (len > HOSTLEN) ? HOSTLEN : len;
		strncpy(host, q, len);
		host[len] = '\0';
		/* last field is the message */
		strpos = 0;
		while(*p != '\0' && strpos < HUGESTRINGLEN) {
			message[strpos++] = *p++;
		}
		message[strpos] = '\0';
		first = addnew_ls(first, atoi(at), nick, host, message);
	}
	fclose(fp);
	ls = first;
	while(ls != NULL) {
		strncpy(ts, ctime(&ls->at), TINYSTRINGLEN);
		striplf(ts);
		memset(outstring, 0, TXT_BUFFER + 1);
		memset(message, 0, HUGESTRINGLEN + 1);
		if(strlen(ls->str3) > OER_LAST_MAX_LENGTH) {
			strncpy(outstring, ls->str3, OER_LAST_MAX_LENGTH);
			snprintf(message, HUGESTRINGLEN, "%s (truncated)", outstring);
		} else {
			strncpy(message, ls->str3, HUGESTRINGLEN);
		}
		tzset();
		snprintf(outstring, HUGESTRINGLEN, "%s (%s, %s, %s %s %s)", message, ls->str1, ls->str2, ts, tzname[0], tzname[1]);
		sendreply(to, tochan, 0, 0, outstring);
		ls2 = ls->next;
		free(ls->str1);
		free(ls->str2);
		free(ls->str3);
		free(ls);
		ls = ls2;
	}
}

void updatelast(char *channel, char *nick, char *host, char *message)
{
	char outstring[WRITE_BUFFER_LENGTH + 1];
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	if(this->last == NULL) {
		return;
	}
	oer_debug(OER_DEBUG_INFO, "updatelast->updating %s last information at %lu for %s!%s\n", this->name, mystate->now, nick, host);
	snprintf(outstring, WRITE_BUFFER_LENGTH, "%lu::%s::%s::%s\n", mystate->now, nick, host, message);
	fputs(outstring, this->last);
}

void showseen(char *to, int tochan, char *channel, char *mask)
{
	int i;
	int strpos;
	int len;
	char outstring[TXT_BUFFER + 1];
	char pattern[NICKLEN + 1];
	char at[NICKLEN + 1];
	char ts[TINYSTRINGLEN + 1];
	char nick[NICKLEN + 1];
	char host[HOSTLEN + 1];
	char *p;
	char *q;
	struct channel *this;
	struct ls_wrapstruct *first;
	struct ls_wrapstruct *ls;
	struct ls_wrapstruct *ls2;
	FILE *fp;

	if(mask != NULL) {
		oer_debug(OER_DEBUG_INFO, "showseen->channel %s mask %s\n", channel, mask);
	} else {
		oer_debug(OER_DEBUG_INFO, "showseen->channel %s\n", channel);
	}
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	if(this->seen == NULL) {
		return;
	}
	fflush(this->seen);
	snprintf(outstring, BIGSTRINGLEN, "seen-%s", this->name);
	if((fp = fopen(outstring, "r")) == NULL) {
		oer_debug(OER_DEBUG_INFO, "showseen->failed to open %s: %s\n", outstring, strerror(errno));
		return;
	}
	strncpy(pattern, "*", NICKLEN);
	if(mask != NULL) {
		strncpy(pattern, mask, NICKLEN);
	}
        first = NULL;
	while(fgets(outstring, TXT_BUFFER, fp)) {
		p = outstring;
		/* striplf() */
		for(i = strlen(p) - 1; isspace((int)p[i]) && i >= 0; i--) {
			p[i] = '\0';
		}
		/* first field is the timestamp */
		q = p;
		for(;*p != '\0'; p++) {
			if(!strncasecmp(p, OER_DEFAULT_DELIM, OER_DEFAULT_DELIM_LEN)) {
				p += 2;
				break;
			}
		}
		if(*p == '\0') {
			continue;
		}
		len = (p - q) - OER_DEFAULT_DELIM_LEN;
		len = (len > NICKLEN) ? NICKLEN : len;
		strncpy(at, q, len);
		at[len] = '\0';
		/* 2nd field is the nick */
		q = p;
		for(;*p != '\0'; p++) {
			if(!strncasecmp(p, OER_DEFAULT_DELIM, OER_DEFAULT_DELIM_LEN)) {
				p += 2;
				break;
			}
		}
		if(*p == '\0') {
			continue;
		}
		len = (p - q) - OER_DEFAULT_DELIM_LEN;
		len = (len > NICKLEN) ? NICKLEN : len;
		strncpy(nick, q, len);
		nick[len] = '\0';
		if(!wild_match(pattern, nick)) {
			/* not the nick we are after */
			continue;
		}
		/* last field is the host */
		strpos = 0;
		while(*p != '\0' && strpos < HOSTLEN) {
			host[strpos++] = *p++;
		}
		host[strpos] = '\0';
		first = addnew_ls(first, atoi(at), nick, host, NULL);
	}
	fclose(fp);
	ls = first;
	while(ls != NULL) {
		strncpy(ts, ctime(&ls->at), TINYSTRINGLEN);
		striplf(ts);
		tzset();
		snprintf(outstring, HUGESTRINGLEN, "I saw %s with host %s last %s %s %s", ls->str1, ls->str2, ts, tzname[0], tzname[1]);
		sendreply(to, tochan, 0, 0, outstring);
		ls2 = ls->next;
		free(ls->str1);
		free(ls->str2);
		free(ls->str3);
		free(ls);
		ls = ls2;
	}
}

void updateseen(char *channel, char *nick, char *host)
{
	char outstring[BIGSTRINGLEN + 1];
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	if(this->seen == NULL) {
		return;
	}
	oer_debug(OER_DEBUG_INFO, "updateseen->updating %s seen information at %lu for %s!%s\n", this->name, mystate->now, nick, host);
	snprintf(outstring, BIGSTRINGLEN, "%lu::%s::%s\n", mystate->now, nick, host);
	fputs(outstring, this->seen);
}

void nstats(char *to, int tochan, char *channel, char *nick)
{
	int msgs;
	int joins;
	char outstring[BIGSTRINGLEN + 1];

	msgs = getondiskmsgcount(channel, nick);
	joins = getondiskjoincount(channel, nick);
	if(!msgs && !joins) {
		return;
	}
	snprintf(outstring, BIGSTRINGLEN, "I have seen %d joins and %d messages from %s on channel %s", joins, msgs, nick, channel);
	sendreply(to, tochan, 0, 1, outstring);
}

int checkforpartrejoin(char *channel, char *nick, char *host)
{
	int parts;
        char ban[HOSTLEN + 1];
        char outstring[STRINGLEN + 1];
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	if(!haschanflags(channel, "r")) {
                return 0;
        }
	if(isq(nick)) {
		return 0;
	}
        if(isadmin(channel, host)) {
                return 0;
        }
        if(isop(channel, host)) {
                return 0;
        }
        if(isopnow(channel, nick)) {
                return 0;
        }
	if(haschanflags(channel, "F") && hasuserflags(channel, host, "f")) {
		return 0;
	}
	parts = partcount(channel, nick, host);
        oer_debug(OER_DEBUG_INFO, "checkforpartrejoin->credited parts on %s for %s!%s: %d\n", channel, nick, host, parts);
        if(parts < OER_ALLOWED_PARTS) {
                return 0;
        }
        strncpy(ban, host, HOSTLEN);
        if(safeban(ban) == NULL) {
                return 0;
        }
        addnewmm(channel, mystate->now, "+b", ban);
        snprintf(outstring, STRINGLEN, "KICK %s %s :part-rejoin protection triggered, come back when you have made up your mind\n", channel, nick);
        addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
        addnewmm(channel, mystate->now + this->banvars.part_rejoin, "-b", ban);
        return 1;
}

int checkforautorejoin(char *channel, char *nick, char *host)
{
        char ban[HOSTLEN + 1];
        char outstring[STRINGLEN + 1];
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
        if(!haschanflags(channel, "r")) {
                return 0;
        }
	if(isq(nick)) {
                return 0;
        }
        if(isadmin(channel, host)) {
                return 0;
        }
        if(isop(channel, host)) {
                return 0;
        }
        if(isopnow(channel, nick)) {
                return 0;
        }
	if(haschanflags(channel, "F") && hasuserflags(channel, host, "f")) {
		return 0;
	}
        if(lastoff(channel, nick) > OER_AUTO_REJOIN_TIME) {
                return 0;
        }
        strncpy(ban, host, HOSTLEN);
        if(safeban(ban) == NULL) {
                return 0;
        }
        addnewmm(channel, mystate->now, "+b", ban);
        snprintf(outstring, STRINGLEN, "KICK %s %s :auto-rejoin, your prize: a %d second ban\n", channel, nick, this->banvars.auto_rejoin);
        addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
        addnewmm(channel, mystate->now + this->banvars.auto_rejoin, "-b", ban);
        return 1;
}

int checkforansi(char *channel, char *nick, char *host, char *message)
{
        char outstring[STRINGLEN + 1];

        if(!haschanflags(channel, "a")) {
                return 0;
        }
	if(isq(nick)) {
                return 0;
        }
        if(isadmin(channel, host)) {
                return 0;
        }
        if(isop(channel, host)) {
                return 0;
        }
        if(isopnow(channel, nick)) {
                return 0;
        }
	if(haschanflags(channel, "F") && hasuserflags(channel, host, "f")) {
		return 0;
	}
        if(!isansi(message)) {
                return 0;
        }
        oer_debug(OER_DEBUG_INFO, "checkforansi->ansi/control-codes detected on %s from %s\n", channel, nick);
	snprintf(outstring, STRINGLEN, "KICK %s %s :mIRC or non-standard control codes not permitted on this channel\n", channel, nick);
        addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
        return 1;
}

int ismoderated(char *channel)
{
	int moderated;
	char *mode;
	char *p;
	char *q;
	
	if((mode = getchanmode(channel)) == NULL) {
		return 0;
	}
	moderated = 0;
	if((p = index(mode, 'm')) != NULL) {
		for(q = mode; q != p; q++) {
			if(*q == '+') {
				moderated = 1;
			}
			if(*q == '-') {
				moderated = 0;
			}
		}
	}
	return moderated;
}

int checkforflood(char *channel, char *nick, char *host, char *message)
{
        int floodtype;
        char ban[HOSTLEN + 1];
        char outstring[STRINGLEN + 1];
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
        if(!haschanflags(channel, "f")) {
                return 0;
        }
	if(isq(nick)) {
                return 0;
        }
        if(isadmin(channel, host)) {
                return 0;
        }
        if(isop(channel, host)) {
                return 0;
        }
        if(isopnow(channel, nick)) {
                return 0;
        }
	if(haschanflags(channel, "F") && hasuserflags(channel, host, "f")) {
		return 0;
	}
        floodtype = isflood(channel, nick, host, message);
        if(floodtype != OER_PUBMSG_FLOOD_NORMAL && floodtype != OER_PUBMSG_FLOOD_REPEAT) {
                return 0;
        }
        strncpy(ban, host, HOSTLEN);
        if(safeban(ban) == NULL) {
                return 0;
        }
        switch(floodtype) {
        case OER_PUBMSG_FLOOD_NORMAL:
		if(isvoicenow(channel, nick) && ismoderated(channel)) {
			addnewmm(channel, mystate->now, "-v", nick);
			addnewmm(channel, mystate->now + this->banvars.public_flood, "+v", nick);
		}
		addnewmm(channel, mystate->now, "+b", ban);
                snprintf(outstring, STRINGLEN, "flood protection triggered, you can talk again in %d seconds", this->banvars.public_flood);
                sendreply(nick, 0, 0, 1, outstring);
                addnewmm(channel, mystate->now + this->banvars.public_flood, "-b", ban);
                clearflood(channel, nick, host);
                return 1;
        case OER_PUBMSG_FLOOD_REPEAT:
                addnewmm(channel, mystate->now, "+b", ban);
                snprintf(outstring, STRINGLEN, "KICK %s %s :bad choice of channel for your repeating fetish\n", channel, nick);
                addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
                addnewmm(channel, mystate->now + this->banvars.public_flood_repeat, "-b", ban);
		changetobek(channel, nick, 1);
                clearflood(channel, nick, host);
                return 1;
        case OER_PUBMSG_FLOOD_NONE:
                return 0;
        }
        return 0;
}

int checkforbadword(char *channel, char *nick, char *host, char *message)
{
        char ban[HOSTLEN + 1];
        char outstring[STRINGLEN + 1];
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
        if(!haschanflags(channel, "w")) {
                return 0;
        }
	if(isq(nick)) {
                return 0;
        }
        if(isadmin(channel, host)) {
                return 0;
        }
        if(isop(channel, host)) {
                return 0;
        }
        if(isopnow(channel, nick)) {
                return 0;
        }
	if(haschanflags(channel, "F") && hasuserflags(channel, host, "f")) {
		return 0;
	}
        if(!iswordbk(channel, message)) {
                return 0;
        }
        strncpy(ban, host, HOSTLEN);
        if(safeban(ban) == NULL) {
                return 0;
        }
        addnewmm(channel, mystate->now, "+b", ban);
        snprintf(outstring, STRINGLEN, "KICK %s %s :word ban-kick triggered, have a nice life...\n", channel, nick);
        addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
        addnewmm(channel, mystate->now + this->banvars.bad_word, "-b", ban);
        return 1;
}

int checkforbadnick(char *channel, char *nick, char *host)
{
	char *reason;
        char ban[HOSTLEN + 1];
        char outstring[WRITE_BUFFER_LENGTH + 1];
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
        if(!haschanflags(channel, "n")) {
                return 0;
        }
	if(isq(nick)) {
                return 0;
        }
        if(isadmin(channel, host)) {
                return 0;
        }
        if(isop(channel, host)) {
                return 0;
        }
        if(isopnow(channel, nick)) {
                return 0;
        }
	/* we don't allow friends to use prohibited nicks,
	   syncnickbks would kick them anyway */
	if((reason = isnickbk(channel, nick)) == NULL) {
                return 0;
        }
        strncpy(ban, host, HOSTLEN);
        if(safeban(ban) == NULL) {
                return 0;
        }
	if(gettobek(channel, nick)) {
		return 0;
	}
        addnewmm(channel, mystate->now, "+b", ban);
	/* if there was no ban reason, reason = nick */
	if(strcasecmp(nick, reason)) {
		snprintf(outstring, WRITE_BUFFER_LENGTH, "KICK %s %s :%s, reason: %s\n", channel, nick, DEFAULT_NICKBK_MESSAGE, reason);
	} else {
		snprintf(outstring, WRITE_BUFFER_LENGTH, "KICK %s %s :%s\n", channel, nick, DEFAULT_NICKBK_MESSAGE);
	}
        addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
        addnewmm(channel, mystate->now + this->banvars.bad_nick, "-b", ban);
        return 1;
}

void joinchannels()
{
        char stringbuffer[STRINGLEN + 1];
        struct channel *this;

        for(this = mystate->channels; this != NULL; this = this->next) {
                if(!this->joined && !this->joining && (mystate->now >= this->rejoin_at)) {
			break;
		}
	}
	if(this == NULL) {
		return;
	}
	if(this->haskey) {
		snprintf(stringbuffer, STRINGLEN, "JOIN %s %s\n", this->name, this->key);
	} else {
		snprintf(stringbuffer, STRINGLEN, "JOIN %s\n", this->name);
	}
	addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
	/* set flags so that we are joining this channel */
	newchannel(this->name);
}

void processenv()
{
        struct channel *this;
        char stringbuffer[STRINGLEN + 1];

        /* check if connected */
        if(mystate->current_server == NULL) {
                return;
        }
        /* check if registered */
        if(mystate->current_server->registered != OER_REGISTERCONNECTION_STATUS_DONE) {
                return;
        }
        if(mystate->netjoining && mystate->now < mystate->postnj_checks_at) {
		/* don't do any actions until it's safe */
		return;
	}
	if(mystate->netjoining && mystate->now >= mystate->postnj_checks_at) {
                oer_debug(OER_DEBUG_INFO, "processenv->processing post netjoin actions\n");
                for(this = mystate->channels; this != NULL; this = this->next) {
                        /* check for post net join */
                        if(this->joined && haschanflags(this->name, "p") && amiop(this->name)) {
                                /* do the post netjoin checks (ops, voices, permbans and nickbks) */
                                syncvoices(this->name);
                                syncops(this->name);
                                syncbans(this->name);
				syncnickbks(this->name);
                        }
                }
                oer_debug(OER_DEBUG_INFO, "processenv->end of netjoin\n");
		mystate->netjoining = 0;
                mystate->postnj_checks_at = 0;
        }
        /* check that all channels are synced */
        for(this = mystate->channels; this != NULL; this = this->next) {
		if(!this->synced && amiop(this->name)) {
			channelsync(this->name);
		}
	}
        /* check for unset channel-modes */
        for(this = mystate->channels; this != NULL; this = this->next) {
                if(amiop(this->name) && this->joined && this->setchanmode) {
			if(this->haskey) {
				snprintf(stringbuffer, STRINGLEN, "%sk %s", this->mode, this->key);
			} else {
				snprintf(stringbuffer, STRINGLEN, "%s", this->mode);
			}
			addnewmm(this->name, mystate->now, stringbuffer, "");
			this->setchanmode = 0;
                }
        }
	linenoise();
	checkstoned();
	joinchannels();
	syncuserhosts();
	processlock();
	setumode();
	setnick();
	settopic();
	/* check when configs were last saved */
	if(mystate->now -  mystate->last_saved > OER_SAVE_INTERVAL) {
		saveall();
		mystate->last_saved = mystate->now;
	}
}

void channelsync(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	/* are we through with USERHOST queries? */
	if(!allhostsknown(this->name)) {
		return;
	}
	syncvoices(this->name);
	syncops(this->name);
	syncbans(this->name);
	syncnickbks(this->name);
	this->synced = 1;
}

void processlock()
{
	int nicks;
        char *nick;
        char outstring[BIGSTRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];
        char stringbuffer2[BIGSTRINGLEN + 1];
        struct channel *this;

	for(this = mystate->channels; this != NULL; this = this->next) {
		/* get any channel that we have joined & is locked */
                if(this->joined && this->locked.locked) {
                        break;
                }
        }
        if(this == NULL) {
                return;
        }
	if(this->locked.unlocked) {
		/* channel has been unlocked due to manual prevention */
		this->locked.locked = 0;
		return;
	}
	memset(&stringbuffer, 0, BIGSTRINGLEN + 1);
	memset(&stringbuffer2, 0, BIGSTRINGLEN + 1);
	nicks = 0;
	nick = NULL;
	while((nicks < OER_NICKS_PER_KICK) && ((nick = getlamer(this->name)) != NULL)) {
		strncat(stringbuffer, nick, BIGSTRINGLEN - strlen(stringbuffer));
		strncat(stringbuffer2, this->name, BIGSTRINGLEN - strlen(stringbuffer2));
		if((nicks + 1) < OER_NICKS_PER_KICK) {
			strncat(stringbuffer, ",", BIGSTRINGLEN - strlen(stringbuffer));
			strncat(stringbuffer2, ",", BIGSTRINGLEN - strlen(stringbuffer2));
		}
		nicks++;
        }
	if(nicks) {
		if(strlen(this->locked.reason)) {
			snprintf(outstring, BIGSTRINGLEN, "KICK %s %s :%s\n", stringbuffer2, stringbuffer, this->locked.reason);
		} else {
			snprintf(outstring, BIGSTRINGLEN, "KICK %s %s :locking channel\n", stringbuffer2, stringbuffer);
		}
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_KICK, outstring, this->name, NULL, NULL);
	}
	if(nick == NULL) {
		/* no more lamers, unlocking if auto */
		if(this->locked.auto_unlock) {
			/* this has to be a timed because of the way mmodes & timeds
			   are processed in the mainloop (we want the -i to appear
			   after all lamers have been kicked out, not before) */
			snprintf(outstring, BIGSTRINGLEN, "MODE %s -i\n", this->name);
			addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
			this->locked.locked = 0;
		}
	}
}

void settopic()
{
        int i;
        int j;
        int k;
        int l;
        char stringbuffer[WRITE_BUFFER_LENGTH + 1];
        struct channel *this;
        struct topic *t;

	for(this = mystate->channels; this != NULL; this = this->next) {
                if(this->joined && this->topic_change) {
                        break;
                }
        }
        if(this == NULL) {
                return;
        }
	snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "TOPIC %s :", this->name);
	i = strlen(stringbuffer);
	l = i;
	t = this->topics;
	while(t != NULL && i < WRITE_BUFFER_LENGTH) {
		for(k = 0, j = strlen(t->topic); k < j && i < WRITE_BUFFER_LENGTH; k++) {
			if(isprint((int)t->topic[k]) || !iscntrl((int)t->topic[k])) {
				stringbuffer[i++] = t->topic[k];
			}
		}
		if(t->next != NULL && i < (WRITE_BUFFER_LENGTH - 3)) {
			stringbuffer[i++] = ' ';
			stringbuffer[i++] = '|';
			stringbuffer[i++] = ' ';
		}
		t = t->next;
	}
	stringbuffer[i++] = '\n';
	stringbuffer[i++] = '\0';
	this->topic_change = 0;
	addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
}

void syncvoices(char *channel)
{
	struct channel *this;
        struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
        for(cu = this->nicks; cu != NULL; cu = cu->next) {
                if(!cu->voice && hasuserflags(this->name, cu->host, "v")) {
                        addnewmm(this->name, mystate->now, "+v", cu->nick);
                }
		/* .. dynusers, let them have +v even if not logoned */
		if(!cu->voice && hasuserflags(this->name, cu->host, "dv")) {
                        addnewmm(this->name, mystate->now, "+v", cu->nick);
                }
        }
}

void syncops(char *channel)
{
	struct channel *this;
        struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
        for(cu = this->nicks; cu != NULL; cu = cu->next) {
		/* if not opped, give +o if op */
                if(!cu->chanop && isop(this->name, cu->host)) {
                        addnewmm(this->name, mystate->now, "+o", cu->nick);
			continue;
                }
		/* .. else take away +o if not op & channel has "u" flag */
		if(cu->chanop && haschanflags(this->name, "u") && !isallowedop(this->name, cu->nick)) {
                        addnewmm(this->name, mystate->now, "-o", cu->nick);
		}
        }
}

void syncbans(char *channel)
{
        struct maskstruct *ms;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
        for(ms = this->permbans; ms != NULL; ms = ms->next) {
		/* bans are set each time, doing a query would be too heavy */
                addnewmm(this->name, mystate->now, "+b", ms->mask);
        }
}

void syncnickbks(char *channel)
{
	struct channel *this;
        struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(cu->host != NULL && !cu->tobek) {
			checkforbadnick(this->name, cu->nick, cu->host);
		}
	}
}

void setumode()
{
	char outstring[STRINGLEN + 1];

        if(mystate->newmode) {
		snprintf(outstring, STRINGLEN, "MODE %s %s\n", mystate->nick, mystate->mode);
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
                mystate->newmode = 0;
        }
}

void setnick()
{
        char outstring[STRINGLEN + 1];

        if(mystate->newnick) {
                snprintf(outstring, STRINGLEN, "NICK %s\n", mystate->nick);
                addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
                mystate->newnick = 0;
        }
}

void syncuserhosts()
{
	int nicks;
        char nick[NICKLEN + 1];
        char outstring[BIGSTRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];

	nicks = 0;
	memset(&stringbuffer, 0, BIGSTRINGLEN + 1);
	while((nicks < OER_NICKS_PER_USERHOST) && (getfirsthostless(nick) != NULL)) {
		sethostquerystatus(nick, 1);
		strncat(stringbuffer, nick, BIGSTRINGLEN - strlen(stringbuffer));
		if((nicks + 1) < OER_NICKS_PER_USERHOST) {
			strncat(stringbuffer, " ", BIGSTRINGLEN - strlen(stringbuffer));
		}
		nicks++;
        }
	if(!strlen(stringbuffer)) {
		return;
	}
        snprintf(outstring, BIGSTRINGLEN, "USERHOST %s\n", stringbuffer);
        addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
}

struct server *getserver()
{
        struct server *this;

	/* if admin specified a server, we'll take that no matter
	   what (if it exists, doh) */
	if(strlen(mystate->preferredserver) > 0) {
		for(this = mystate->servers; this != NULL; this = this->next) {
			if(!strcasecmp(this->serverhost, mystate->preferredserver)) {
				memset(mystate->preferredserver, 0, HOSTLEN + 1);
				return this;
			}
		}
	}
        for(this = mystate->servers; this != NULL; this = this->next) {
                if(this->used) {
                        /* this will prevent from us getting stuck
                           with no usable server */
                        this->used = 0;
			continue;
		}
		/* check if server is stoned and whether the stoned
                   time has been elapsed */
                if(!this->stoned) {
                        return this;
                }
                if(mystate->now >= (this->stoned + OER_SERVER_IS_STONED_FOR)) {
                        this->stoned = 0;
                        return this;
                }
        }
        return NULL;
}

void massmessage(char *from, char *message)
{
	int delay;
        char stringbuffer[WRITE_BUFFER_LENGTH + 1];
	struct channel *this;

	snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "notice from admin %s: %s", from, message);
	for(this = mystate->channels, delay = 0; this != NULL; this = this->next, delay++) {
		sendchannelnotice(this->name, delay, stringbuffer);
	}
}

void iwaskicked(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
        this->rejoin_at = mystate->now + OER_DELAY_BETWEEN_REJOINS;
}

void initchannel(char *channel)
{
	struct channel *this;

        oer_debug(OER_DEBUG_INFO, "initchannel->initializing channel %s\n", channel);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	this->joined = 0;
	this->joining = 0;
	this->setchanmode = 0;
	this->rejoin_at = 0;
	this->last_quote = 0;
	this->i_am_op = 0;
	this->synced = 0;
	if(this->last != NULL) {
		fclose(this->last);
		this->last = NULL;
	}
	if(this->seen != NULL) {
		fclose(this->seen);
		this->seen = NULL;
	}
	initjoins(this->name);
	initparts(this->name);
	initpubmsgs(this->name);
	initmmodes(this->name);
	memset(&this->locked, 0, sizeof(struct locked));
	initnicks(this->name);
}

void initall(void)
{
	struct channel *this;

	for(this = mystate->channels; this != NULL; this = this->next) {
		initchannel(this->name);
	}
}

void initmmodes(char *channel)
{
	struct modeline *mm;
	struct modeline *mm2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	mm = this->modelines;
	while(mm != NULL) {
		mm2 = mm->next;
		free(mm->mode);
		free(mm->target);
		free(mm);
		mm = mm2;
	}
	this->modelines = NULL;
}

void inittimeds()
{
	struct timed *tim;
	struct timed *tim2;

	tim = mystate->timeds;
	while(tim != NULL) {
		tim2 = tim->next;
		free(tim->irc_command);
		free(tim->optstring1);
		free(tim->optstring2);
		free(tim->optstring3);
		free(tim);
		tim = tim2;
	}
	mystate->timeds = NULL;
}

void initnicks(char *channel)
{
	struct chanuser *cu;
	struct chanuser *cu2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	cu = this->nicks;
	while(cu != NULL) {
		cu2 = cu->next;
		free(cu->host);
		free(cu->nick);
		free(cu);
		cu = cu2;
	}
	this->nicks = NULL;
	this->nickcount = 0;
}

void initpubmsgs(char *channel)
{
	struct pubmsg *pm;
	struct pubmsg *pm2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	pm = this->pubmsgs;
	while(pm != NULL) {
		pm2 = pm->next;
		free(pm->message);
		free(pm->nick);
		free(pm->host);
		free(pm);
		pm = pm2;
	}
	this->pubmsgs = NULL;
}

void initparts(char *channel)
{
	struct part *p;
	struct part *p2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	p = this->parts;
	while(p != NULL) {
		p2 = p->next;
		free(p->nick);
		free(p);
		p = p2;
	}
	this->parts = NULL;
}

void initjoins(char *channel)
{
	struct join *j;
	struct join *j2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	j = this->joins;
	while(j != NULL) {
		j2 = j->next;
		free(j->nick);
		free(j->host);
		free(j);
		j = j2;
	}
	this->joins = NULL;
}

void initpermbans(char *channel)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	ms = this->permbans;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms->next;
		free(ms);
		ms = ms2;
	}
	this->permbans = NULL;
}

void initnickbks(char *channel)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	ms = this->nickbks;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms->next;
		free(ms);
		ms = ms2;
	}
	this->nickbks = NULL;
}

void initwordbks(char *channel)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	ms = this->wordbks;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms->next;
		free(ms);
		ms = ms2;
	}
	this->wordbks = NULL;
}

void initusers(char *channel)
{
	struct botuser *u;
	struct botuser *u2;
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	u = this->users;
	while(u != NULL) {
		u2 = u->next;
		ms = u->firstmask;
		while(ms != NULL) {
			ms2 = ms->next;
			free(ms->mask);
			free(ms);
			ms = ms2;
		}
		free(u);
		u = u2;
	}
	this->users = NULL;
}

struct state *emptystate()
{
	struct state *state;
	if((state = (struct state *) malloc(sizeof(struct state))) == NULL) {
		return NULL;
	}
	memset(state->nick, 0, NICKLEN + 1);
	memset(state->altnick, 0, NICKLEN + 1);
	memset(state->user, 0, USERLEN + 1);
	memset(state->host, 0, HOSTLEN + 1);
	memset(state->mode, 0, CHANLEN + 1);
	memset(state->signoff, 0, STRINGLEN + 1);
	memset(state->preferredserver, 0, HOSTLEN + 1);
	memset(state->realname, 0, STRINGLEN + 1);
	memset(state->flags, 0, FLAGLEN + 1);
	state->prefix = '\0';
	state->netjoining = 0;
	state->reconnect = 0;
	state->now = time(NULL);
	state->last_actions = 0;
	state->startup = time(NULL);
	state->postnj_checks_at = 0;
	state->last_saved = time(NULL);
	state->sockfd = 0;
	state->loopforever = 0;
	state->customuser = 0;
	state->vhost = 0;
	state->newnick = 0;
	state->newmode = 0;
	state->bailout = 0;
	state->quitting = 0;
	state->logfp = NULL;
	state->logto = NULL;
	state->trusted = NULL;
	state->admins = NULL;
	state->kickrs = 0;
	state->kickreasons = NULL;
	state->channels = NULL;
	state->timeds = NULL;
	state->current_server = NULL;
	state->servers = NULL;
	return state;
}

struct topic *addnewtopic(char *channel, char *setby, char *topic)
{
	int amount;
	struct topic *t;
	struct topic *t2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	if(topiccount(channel) >= OER_TOPICS) {
		return NULL;
	}
	t = this->topics;
	t2 = t;
	amount = 0;
	while(t != NULL) {
                t2 = t;
                amount++;
                t = t2->next;
        }
	if((t = (struct topic *) malloc(sizeof(struct topic))) == NULL) {
		return NULL;
	}
	if((t->setby = (char *) malloc(strlen(setby) + 1)) == NULL) {
		return NULL;
	}
	if((t->topic = (char *) malloc(strlen(topic) + 1)) == NULL) {
		return NULL;
	}
	strcpy(t->setby, setby);
	strcpy(t->topic, topic);
	t->at = mystate->now;
	t->list = 0;
	t->next = NULL;
	t->prev = NULL;
	this->topic_list = 0;
	if(strcasecmp(setby, "gettopic()")) {
		this->topic_change = 1;
	}
	if(this->topics == NULL) {
		/* first topic, special case */
		this->topics = t;
		return t;
	}
	/* >=1 topics, normal processing */
        t2->next = t;
        t->prev = t2;
        return t;
}

struct topic *insertnewtopic(char *channel, char *setby, char *topic, int pos)
{
	int amount;
	struct topic *t;
	struct topic *t2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	if(pos < 1 || pos > OER_TOPICS) {
		return NULL;
	}
	if(topiccount(channel) >= OER_TOPICS) {
		return NULL;
	}
	t = this->topics;
	t2 = t;
	amount = 1;
	while((t != NULL) && (amount != pos)) {
                t2 = t;
                amount++;
                t = t2->next;
        }
	if((t = (struct topic *) malloc(sizeof(struct topic))) == NULL) {
		return NULL;
	}
	if((t->setby = (char *) malloc(strlen(setby) + 1)) == NULL) {
		return NULL;
	}
	if((t->topic = (char *) malloc(strlen(topic) + 1)) == NULL) {
		return NULL;
	}
	strcpy(t->setby, setby);
	strcpy(t->topic, topic);
	t->at = mystate->now;
	t->list = 0;
	t->next = NULL;
	t->prev = NULL;
	this->topic_list = 0;
	/* there are 4 possibilities: 1st (new), 1st, last and
	   between 2 other topics */
	if(pos == 1 && this->topics == NULL) {
		/* first */
		this->topic_change = 1;
		this->topics = t;
		return t;
	}
	if(pos == 1 && this->topics != NULL) {
		/* first */
		this->topic_change = 1;
		this->topics = t;
		t->next = t2;
		t2->prev = t;
		return t;
	}
	if(t2->next == NULL) {
		/* last */
		this->topic_change = 1;
		t2->next = t;
		t->prev = t2;
		return t;
	}
	if(t2 != NULL && t2->next != NULL) {
		/* between 2 */
		this->topic_change = 1;
		t->next = t2->next;
		t->prev = t2;
		t2->next->prev = t;
		t2->next = t;
		return t;
	}
	free(t->topic);
	free(t->setby);
	free(t);
	return NULL;
}

struct topic *edittopic(char *channel, char *setby, char *topic, int pos)
{
	int amount;
	struct topic *t;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	if(pos < 1 || pos > OER_TOPICS) {
		return NULL;
	}
	amount = 1;
	t = this->topics;
	while((t != NULL) && (amount != pos)) {
		amount++;
		t = t->next;
	}
	if(t == NULL) {
		return NULL;
	}
	free(t->setby);
	free(t->topic);
	if((t->setby = (char *) malloc(strlen(setby) + 1)) == NULL) {
		return NULL;
	}
	if((t->topic = (char *) malloc(strlen(topic) + 1)) == NULL) {
		return NULL;
	}
	strcpy(t->setby, setby);
	strcpy(t->topic, topic);
	t->at = mystate->now;
	t->list = 0;
	this->topic_change = 1;
	this->topic_list = 0;
	return t;
}

void gettopic(char *channel, char *topic)
{
	int i;
	int k;
	int length;
	char thistopic[TOPICLEN + 1];

	delalltopics(channel);
	for(i = 0, k = 0, length = strlen(topic); i < length && k < TOPICLEN; i++) {
		if(topic[i] == ' ' && topic[i + 1] == '|' && topic[i + 2] == ' ') {
			thistopic[k++] = '\0';
			addnewtopic(channel, "gettopic()", thistopic);
			k = 0;
			i += 2;
		} else {
			thistopic[k++] = topic[i];
		}
	}
	if(k > 0) {
		thistopic[k++] = '\0';
		addnewtopic(channel, "gettopic()", thistopic);
	}
}

void listtopic(char *to, int tochan, char *channel)
{
        int amount;
        struct topic *t;
        struct channel *this;
        char stringbuffer[BIGSTRINGLEN + 1];
        char ts[STRINGLEN + 1];

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	t = this->topics;
	amount = 1;
	while(t != NULL) {
		striplf(t->topic);
		strncpy(ts, ctime(&t->at), STRINGLEN);
		striplf(ts);
		if(!strcasecmp(t->setby, "gettopic()")) {
			tzset();
			snprintf(stringbuffer, BIGSTRINGLEN, "Topic #%d: %s (%s %s %s)", amount, t->topic, ts, tzname[0], tzname[1]);
		} else {
			tzset();
			snprintf(stringbuffer, BIGSTRINGLEN, "Topic #%d: %s (%s %s %s, %s)", amount, t->topic, ts, tzname[0], tzname[1], t->setby);
		}
		sendreply(to, tochan, 0, 0, stringbuffer);
		amount++;
		t = t->next;
	}
}

char *deltopic(char *channel, int nth, char *deleted)
{
	int amount;
	struct topic *t;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	if(nth < 1 || nth > OER_TOPICS) {
		return NULL;
	}
	t = this->topics;
	amount = 1;
	while((t != NULL) && (amount != nth)) {
		amount++;
		t = t->next;
	}
	if(t == NULL) {
		return NULL;
	}
	if(t->next != NULL) {
		t->next->prev = t->prev;
	}
	if(t->prev != NULL) {
		t->prev->next = t->next;
	} else {
		this->topics = t->next;
	}
	free(t->setby);
	strncpy(deleted, t->topic, TOPICLEN);
	free(t->topic);
	free(t);
	this->topic_change = 1;
	return deleted;
}

void delalltopics(char *channel)
{
	struct topic *t;
	struct topic *t2;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	t = this->topics;
	while(t != NULL) {
		t2 = t->next;
		free(t->setby);
		free(t->topic);
		free(t);
		t = t2;
	}
	this->topics = NULL;
}

void refreshtopic(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	this->topic_change = 1;
}

void swaptopic(char *channel, int x, int y)
{
	int amount;
	struct topic *t;
	struct topic *tx;
	struct topic *ty;
	char *ptr;
	time_t at;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	if(x > OER_TOPICS || x < 1 || y > OER_TOPICS || y < 1 || x == y) {
		return;
	}
	t = this->topics;
	amount = 1;
	tx = NULL;
	ty = NULL;
	while((t != NULL)) {
		if(amount == x) {
			tx = t;
		}
		if(amount == y) {
			ty = t;
		}
		amount++;
		t = t->next;
	}
	if(tx == NULL || ty == NULL) {
		return;
	}
	ptr = tx->topic;
	tx->topic = ty->topic;
	ty->topic = ptr;
	ptr = tx->setby;
	tx->setby = ty->setby;
	ty->setby = ptr;
	at = tx->at;
	tx->at = ty->at;
	ty->at = at;
	this->topic_change = 1;
}

void parsectcp(char *nick, char *host, int ctcp, char *message)
{
	int proceed;
	char stringbuffer[HUGESTRINGLEN + 1];
	struct channel *this;

	proceed = 0;
	if(index(mystate->flags, (int)'f') != NULL) {
		proceed = 1;
	}
	for(this = mystate->channels; this != NULL && !proceed; this = this->next) {
		if(isatleastopnow(this->name, nick, host)) {
			proceed = 1;
		}
	}
	if(!proceed) {
		return;
	}
	switch(ctcp) {
	case OER_WHICHCTCP_FINGER:
		snprintf(stringbuffer, HUGESTRINGLEN, "Notice %s :%cFINGER (%s@%s) Idle 0 seconds%c\n", nick, 1, mystate->user, mystate->host, 1);
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
		break;
	case OER_WHICHCTCP_PING:
		snprintf(stringbuffer, HUGESTRINGLEN, "Notice %s :%s\n", nick, message);
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
		break;
	case OER_WHICHCTCP_USERINFO:
		snprintf(stringbuffer, HUGESTRINGLEN, "Notice %s :%cUSERINFO oer IRC bot%s%c\n", nick, 1, (index(mystate->flags, (int)'q') != NULL) ? " (Q friendly)" : "", 1);
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
		break;
	case OER_WHICHCTCP_VERSION:
		snprintf(stringbuffer, HUGESTRINGLEN, "Notice %s :%cVERSION %s%c\n", nick, 1, OER_COPYRIGHT1, 1);
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
		break;
	}
}

int whichctcp(char *message)
{
	int i;
	int k;
	int length;
	char stringbuffer[HUGESTRINGLEN + 1];

	/* We start from the 2nd char (first is ^A) */
	for(i = 1, k = 0, length = strlen(message); i < length && k < HUGESTRINGLEN; i++) {
		if(message[i] == 1) {
			break;
		}
		stringbuffer[k++] = message[i];
	}
	if(k >= HUGESTRINGLEN) {
		return OER_WHICHCTCP_INVALID;
	}
	stringbuffer[k] = '\0';
	if(!strncasecmp(stringbuffer, "ACTION", 6)) {
		return OER_WHICHCTCP_ACTION;
	}
	if(!strncasecmp(stringbuffer, "FINGER", 6)) {
		return OER_WHICHCTCP_FINGER;
	}
	if(!strncasecmp(stringbuffer, "PING", 4)) {
		return OER_WHICHCTCP_PING;
	}
	if(!strncasecmp(stringbuffer, "USERINFO", 8)) {
		return OER_WHICHCTCP_USERINFO;
	}
	if(!strncasecmp(stringbuffer, "VERSION", 7)) {
		return OER_WHICHCTCP_VERSION;
	}
	return OER_WHICHCTCP_INVALID;
}

int whichcommand(char *command, int params)
{
	if(!strcasecmp(command, "action")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_ACTION;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "add")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_ADD;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "b")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_BAN;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "ban")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_BAN;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "bankick")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_BANKICK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "bk")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_BANKICK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "del")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_DEL;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "dop")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_DOP;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "edit")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_EDIT;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "flush")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_FLUSH;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "help")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_HELP;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "info")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_INFO;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "invite")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_INVITE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "jump")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_JUMP;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "k")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_KICK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "kick")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_KICK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "last")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_LAST;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "list")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_LIST;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "lock")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_LOCK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "locku")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_LOCKU;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "logoff")) {
		if(params == 1) {
			return OER_WHICHCOMMAND_LOGOFF;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "logon")) {
		/* params == 1 when admin logon */
		if(params == 1 || params == 2) {
			return OER_WHICHCOMMAND_LOGON;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "mm")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_MASSMESSAGE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "massmessage")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_MASSMESSAGE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "m")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_MODE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "mode")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_MODE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "nstats")) {
		if(params == 1) {
			return OER_WHICHCOMMAND_NSTATS;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "op")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_OP;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "quit")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_QUIT;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "quote")) {
		if(params == 1) {
			return OER_WHICHCOMMAND_QUOTE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "raw")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_RAW;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "rk")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_RANDOM_KICK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "rbk")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_RANDOM_BANKICK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "save")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_SAVE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "say")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_SAY;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "seen")) {
		if(params == 1) {
			return OER_WHICHCOMMAND_SEEN;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "sync")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_SYNC;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "syncall")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_SYNCALL;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "t")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_TOPIC_SET;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "topic")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_TOPIC_SET;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "ta")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_TOPIC_ADD;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "td")) {
		if(params == 1) {
			return OER_WHICHCOMMAND_TOPIC_DEL;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "te")) {
		if(params >= 2) {
			return OER_WHICHCOMMAND_TOPIC_EDIT;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "ti")) {
		if(params >= 2) {
			return OER_WHICHCOMMAND_TOPIC_INS;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "tl")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_TOPIC_LIST;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "tg")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_TOPIC_GET;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "tr")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_TOPIC_REFRESH;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "ts")) {
		if(params == 2) {
			return OER_WHICHCOMMAND_TOPIC_SWAP;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "uptime")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_UPTIME;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "ub")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_UNBAN;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "unban")) {
		if(params >= 1) {
			return OER_WHICHCOMMAND_UNBAN;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "unlock")) {
		if(params == 0) {
			return OER_WHICHCOMMAND_UNLOCK;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "v")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_VOICE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "voice")) {
		if(params >= 0) {
			return OER_WHICHCOMMAND_VOICE;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	if(!strcasecmp(command, "wall")) {
		if(params > 1) {
			return OER_WHICHCOMMAND_WALL;
		}
		return OER_WHICHCOMMAND_INVALID;
	}
	return OER_WHICHCOMMAND_INVALID;
}

struct maskstruct *addnewadminmask(char *handle, char *mask)
{
	struct botuser *admin;
	struct maskstruct *ms;
	struct maskstruct *ms2;
	
	for(admin = mystate->admins; admin != NULL; admin = admin->next) {
		if(!strcasecmp(admin->handle, handle)) {
			break;
		}
	}
	if(admin == NULL) {
		return NULL;
	}
	ms = admin->firstmask;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			return NULL;
		}
		ms = ms2->next;
	}
	if((ms = (struct maskstruct *) malloc(sizeof(struct maskstruct))) == NULL) {
		return NULL;
	}
	if((ms->mask = (char *) malloc(strlen(mask) + 1)) == NULL) {
		return NULL;
	}
	strcpy(ms->mask, mask);
	ms->next = NULL;
	ms->prev = NULL;
	if(admin->firstmask == NULL) {
		/* first mask, special case */
		admin->firstmask = ms;
		return ms;
	}
	/* >=1 masks, normal processing */
	ms2->next = ms;
	ms->prev = ms2;
	return ms;
}

int deladmin(char *handle)
{
	struct botuser *admin;
        struct maskstruct *ms;
        struct maskstruct *ms2;

	for(admin = mystate->admins; admin != NULL; admin = admin->next) {
		if(!strcasecmp(admin->handle, handle)) {
			break;
		}
	}
	if(admin == NULL) {
		return 0;
	}
	/* check if admin can be deleted */
	if(!delopa(admin->handle)) {
		return 0;
	}
	/* first free all masks */
	ms = admin->firstmask;
	while(ms != NULL) {
		ms2 = ms->next;
		free(ms->mask);
		free(ms);
		ms = ms2;
	}
	/* then free the admin & adjust lists */
	if(admin->prev == NULL) {
		/* first admin in list */
		mystate->admins = admin->next;
		/* ... check if also last */
		if(admin->next != NULL) {
			admin->next->prev = NULL;
		}
	}
	if(admin->next == NULL) {
		/* last admin in list */
		/* ... check also if the only one */
		if(admin->prev != NULL) {
			admin->prev->next = NULL;
		} else {
			mystate->admins = NULL;
		}
	}
	if(admin->prev != NULL && admin->next != NULL) {
		/* between 2 or more admins */
		admin->prev->next = admin->next;
		admin->next->prev = admin->prev;
	}
	free(admin->handle);
	free(admin->options);
	free(admin);
	return 1;
}

int deladminmask(char *handle, char *mask)
{
	struct botuser *admin;
	struct maskstruct *ms;
	struct maskstruct *ms2;

	for(admin = mystate->admins; admin != NULL; admin = admin->next) {
		if(!strcasecmp(admin->handle, handle)) {
			break;
		}
	}
	if(admin == NULL) {
		return 0;
	}
	/* find & remove mask */
	ms = admin->firstmask;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			break;
		}
		ms = ms2->next;
	}
	if(ms == NULL) {
		return 0;
	}
	/* adjust lists */
	if(ms->prev == NULL) {
		/* first mask in list */
		admin->firstmask = ms->next;
		/* ... check if also last */
		if(ms->next != NULL) {
			ms->next->prev = NULL;
		}
	}
	if(ms->next == NULL) {
		/* last mask in list */
		/* ... check also if the only one */
		if(ms->prev != NULL) {
			ms->prev->next = NULL;
		} else {
			admin->firstmask = NULL;
		}
	}
	if(ms->prev != NULL && ms->next != NULL) {
		/* between 2 or more masks */
		ms->prev->next = ms->next;
		ms->next->prev = ms->prev;
	}
	free(ms->mask);
	free(ms);
	return 1;
}

int deluser(char *channel, char *handle)
{
	struct channel *this;
	struct botuser *user;
	struct maskstruct *ms;
	struct maskstruct *ms2;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(user = this->users; user != NULL; user = user->next) {
		if(!strcasecmp(user->handle, handle)) {
			break;
		}
	}
	if(user == NULL) {
		return 0;
	}
	/* first free all masks */
	ms = user->firstmask;
	while(ms != NULL) {
		ms2 = ms->next;
		free(ms->mask);
		free(ms);
		ms = ms2;
	}
	/* then free the user & adjust lists */
	if(user->prev == NULL) {
		/* first user in list */
		this->users = user->next;
		/* ... check if also last */
		if(user->next != NULL) {
			user->next->prev = NULL;
		}
	}
	if(user->next == NULL) {
		/* last user in list
		   ... check also if the only one */
		if(user->prev != NULL) {
			user->prev->next = NULL;
		} else {
			this->users = NULL;
		}
	}
	if(user->prev != NULL && user->next != NULL) {
		/* between 2 or more users */
		user->prev->next = user->next;
		user->next->prev = user->prev;
	}
	free(user->handle);
	free(user->options);
	free(user);
	return 1;
}

int delusermask(char *channel, char *handle, char *mask)
{
	struct channel *this;
	struct botuser *user;
	struct maskstruct *ms;
	struct maskstruct *ms2;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(user = this->users; user != NULL; user = user->next) {
		if(!strcasecmp(user->handle, handle)) {
			break;
		}
	}
	if(user == NULL) {
		return 0;
	}
	/* find & remove mask */
	ms = user->firstmask;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			break;
		}
		ms = ms2->next;
	}
	if(ms == NULL) {
		return 0;
	}
	/* adjust lists */
	if(ms->prev == NULL) {
		/* first mask in list */
		user->firstmask = ms->next;
		/* ... check if also last */
		if(ms->next != NULL) {
			ms->next->prev = NULL;
		}
	}
	if(ms->next == NULL) {
		/* last mask in list */
		/* ... check also if the only one */
		if(ms->prev != NULL) {
			ms->prev->next = NULL;
		} else {
			user->firstmask = NULL;
		}
	}
	if(ms->prev != NULL && ms->next != NULL) {
		/* between 2 or more masks */
		ms->prev->next = ms->next;
		ms->next->prev = ms->prev;
	}
	free(ms->mask);
	free(ms);
	return 1;
}

int deltrusted(char *mask)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;

	/* find & remove mask */
	ms = mystate->trusted;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			break;
		}
		ms = ms2->next;
	}
	if(ms == NULL) {
		return 0;
	}
	/* adjust lists */
	if(ms->prev == NULL) {
		/* first mask in list */
		mystate->trusted = ms->next;
		/* ... check if also last */
		if(ms->next != NULL) {
			ms->next->prev = NULL;
		}
	}
	if(ms->next == NULL) {
		/* last mask in list */
		/* ... check also if the only one */
		if(ms->prev != NULL) {
			ms->prev->next = NULL;
		}
	}
	if(ms->prev != NULL && ms->next != NULL) {
		/* between 2 or more masks */
		ms->prev->next = ms->next;
		ms->next->prev = ms->prev;
	}
	free(ms->mask);
	free(ms->optstring);
	free(ms);
	return 1;
}

int delchannel(char *channel)
{
	char outstring[STRINGLEN + 1];
	struct channel *this;
	struct channel *this2;

	/* find channel */
	this = mystate->channels;
	this2 = this;
	while(this != NULL) {
		this2 = this;
		if(!strcasecmp(this->name, channel)) {
			break;
		}
		this = this2->next;
	}
	if(this == NULL) {
		return 0;
	}
	if(this->joined) {
		/* leave the channel */
		snprintf(outstring, STRINGLEN, "PART %s\n", this->name);
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
	}
	/* do the normal init */
	initchannel(channel);
	/* the following differ from normal initchannel() */
	delalltopics(channel);
	initpermbans(channel);
	initnickbks(channel);
	initwordbks(channel);
	initusers(channel);
	/* adjust lists */
	if(this->prev == NULL) {
		/* first channel in list */
		mystate->channels = this->next;
		/* ... check if also last */
		if(this->next != NULL) {
			this->next->prev = NULL;
		}
	}
	if(this->next == NULL) {
		/* last channel in list */
		/* ... check also if the only one */
		if(this->prev != NULL) {
			this->prev->next = NULL;
		}
	}
	if(this->prev != NULL && this->next != NULL) {
		/* between 2 or more channels */
		this->prev->next = this->next;
		this->next->prev = this->prev;
	}
	free(this);
	return 1;
}

struct maskstruct *editmask(struct maskstruct *first, char *from, char *to)
{
	while(first != NULL) {
		if(!strcasecmp(first->mask, from)) {
			break;
		}
		first = first->next;
	}
	if(first == NULL) {
		return NULL;
	}
	free(first->mask);
	if((first->mask = (char *) malloc(strlen(to) + 1)) == NULL) {
		return NULL;
	}
	strcpy(first->mask, to);
	return first;
}

struct maskstruct *addnewusermask(char *channel, char *handle, char *mask)
{
	struct channel *this;
	struct botuser *user;
	struct maskstruct *ms;
	struct maskstruct *ms2;
	
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	for(user = this->users; user != NULL; user = user->next) {
		if(!strcasecmp(user->handle, handle)) {
			break;
		}
	}
	if(user == NULL) {
		return NULL;
	}
	ms = user->firstmask;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			return NULL;
		}
		ms = ms2->next;
	}
	if((ms = (struct maskstruct *) malloc(sizeof(struct maskstruct))) == NULL) {
		return NULL;
	}
	if((ms->mask = (char *) malloc(strlen(mask) + 1)) == NULL) {
		return NULL;
	}
	strcpy(ms->mask, mask);
	ms->next = NULL;
	ms->prev = NULL;
	if(user->firstmask == NULL) {
		/* first mask, special case */
		user->firstmask = ms;
		return ms;
	}
	/* >=1 masks, normal processing */
	ms2->next = ms;
	ms->prev = ms2;
	return ms;
}

struct maskstruct *addnewpermban(char *channel, char *mask)
{
	int amount;
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewpermban->adding new permban %s to channel %s\n", mask, channel);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	ms = this->permbans;
	ms2 = ms;
	amount = 0;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			return NULL;
		}
		amount++;
		ms = ms2->next;
	}
	if(amount >= OER_PERMBANS) {
		/* don't fill the channel ban list with our
		   bans, bad things may happen */
		return NULL;
	}
	if((ms = (struct maskstruct *) malloc(sizeof(struct maskstruct))) == NULL) {
		return NULL;
	}
	if((ms->mask = (char *) malloc(strlen(mask) + 1)) == NULL) {
		return NULL;
	}
	strcpy(ms->mask, mask);
	ms->optstring = NULL;
	ms->next = NULL;
	ms->prev = NULL;
	if(this->permbans == NULL) {
		/* first permban, special case */
		this->permbans = ms;
		return ms;
	}
	/* >=1 permbans, normal processing */
	ms2->next = ms;
	ms->prev = ms2;
	return ms;
}

struct maskstruct *addnewnickbk(char *channel, char *mask, char *reason)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewnickbk->adding nick %s as nickbk to channel %s\n", mask, channel);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	ms = this->nickbks;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			return NULL;
		}
		ms = ms2->next;
	}
	if((ms = (struct maskstruct *) malloc(sizeof(struct maskstruct))) == NULL) {
		return NULL;
	}
	if((ms->mask = (char *) malloc(strlen(mask) + 1)) == NULL) {
		return NULL;
	}
	if(reason != NULL) {
		if((ms->optstring = (char *) malloc(strlen(reason) + 1)) == NULL) {
			return NULL;
		}
		strcpy(ms->optstring, reason);
	} else {
		ms->optstring = NULL;
	}
	strcpy(ms->mask, mask);
	ms->next = NULL;
	ms->prev = NULL;
	if(this->nickbks == NULL) {
		/* first nickbk, special case */
		this->nickbks = ms;
		return ms;
	}
	/* >=1 nickbks, normal processing */
	ms2->next = ms;
	ms->prev = ms2;
	return ms;
}

struct maskstruct *addnewwordbk(char *channel, char *mask)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewwordbk->adding new %s as wordbk to channel %s\n", mask, channel);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	ms = this->wordbks;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			return NULL;
		}
		ms = ms2->next;
	}
	if((ms = (struct maskstruct *) malloc(sizeof(struct maskstruct))) == NULL) {
		return NULL;
	}
	if((ms->mask = (char *) malloc(strlen(mask) + 1)) == NULL) {
		return NULL;
	}
	strcpy(ms->mask, mask);
	ms->optstring = NULL;
	ms->next = NULL;
	ms->prev = NULL;
	if(this->wordbks == NULL) {
		/* first wordbk, special case */
		this->wordbks = ms;
		return ms;
	}
	/* >=1 wordbks, normal processing */
	ms2->next = ms;
	ms->prev = ms2;
	return ms;
}

struct maskstruct *addnewtrusted(char *mask)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;

	oer_debug(OER_DEBUG_INFO, "addnewtrusted->adding new trusted domain %s\n", mask);
	ms = mystate->trusted;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			return NULL;
		}
		ms = ms2->next;
	}
	if((ms = (struct maskstruct *) malloc(sizeof(struct maskstruct))) == NULL) {
		return NULL;
	}
	if((ms->mask = (char *) malloc(strlen(mask) + 1)) == NULL) {
		return NULL;
	}
	strcpy(ms->mask, mask);
	ms->optstring = NULL;
	ms->next = NULL;
	ms->prev = NULL;
	if(mystate->trusted == NULL) {
		/* first trusted, special case */
		mystate->trusted = ms;
		return ms;
	}
	/* >=1 trusted, normal processing */
	ms2->next = ms;
	ms->prev = ms2;
	return ms;
}

struct botuser *addbotuser(char *handle, char *options)
{
	struct botuser *botuser;

	oer_debug(OER_DEBUG_INFO, "addbotuser->adding botuser %s options: %s\n", handle, options);
	if((botuser = (struct botuser *) malloc(sizeof(struct botuser))) == NULL) {
		return NULL;
	}
	memset(botuser->password, 0, TINYSTRINGLEN + 1);
	botuser->firstmask = NULL;
	botuser->prev = NULL;
	botuser->next = NULL;
	if((botuser->handle = (char *) malloc(strlen(handle) + 1)) == NULL) {
		return NULL;
	}
	strcpy(botuser->handle, handle);
	if((botuser->options = (char *) malloc(strlen(options) + 1)) == NULL) {
		return NULL;
	}
	strcpy(botuser->options, options);
	return botuser;
}

struct botuser *addnewuser(char *channel, char *handle, char *options)
{
	struct botuser *bu;
	struct botuser *bu2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewuser->adding new user %s to %s with options %s\n", handle, channel, options);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	bu = this->users;
	bu2 = bu;
	while(bu != NULL) {
		bu2 = bu;
		if(!strcasecmp(bu->handle, handle)) {
			return NULL;
		}
		bu = bu2->next;
	}
	if((bu = addbotuser(handle, options)) == NULL) {
		return NULL;
	}
	if(this->users == NULL) {
		this->users = bu;
		return bu;
	}
	/* >=1 users, normal processing */
	bu2->next = bu;
	bu->prev = bu2;
	return bu;
}

struct botuser *addnewadmin(char *handle, char *options)
{
	struct botuser *admin;
	struct botuser *admin2;

	oer_debug(OER_DEBUG_INFO, "addnewadmin->adding new admin %s with options %s\n", handle, options);
	admin = mystate->admins;
	admin2 = admin;
	while(admin != NULL) {
		admin2 = admin;
		if(!strcasecmp(admin->handle, handle)) {
			return NULL;
		}
		admin = admin2->next;
	}
	if((admin = addbotuser(handle, options)) == NULL) {
		return NULL;
	}
	if(mystate->admins == NULL) {
		mystate->admins = admin;
		return admin;
	}
	/* >1 admins, normal processing */
	admin2->next = admin;
	admin->prev = admin2;
	return admin;
}

struct maskstruct *addnewkickreason(char *mask)
{
	struct maskstruct *ms;
	struct maskstruct *ms2;

	oer_debug(OER_DEBUG_INFO, "addnewkickreason->adding new kick reason %s\n", mask);
	ms = mystate->kickreasons;
	ms2 = ms;
	while(ms != NULL) {
		ms2 = ms;
		if(!strcasecmp(ms->mask, mask)) {
			return NULL;
		}
		ms = ms2->next;
	}
	if((ms = (struct maskstruct *) malloc(sizeof(struct maskstruct))) == NULL) {
		return NULL;
	}
	if((ms->mask = (char *) malloc(strlen(mask) + 1)) == NULL) {
		return NULL;
	}
	strcpy(ms->mask, mask);
	ms->optstring = NULL;
	ms->next = NULL;
	ms->prev = NULL;
	mystate->kickrs++;
	if(mystate->kickreasons == NULL) {
		/* first kickreason, special case */
		mystate->kickreasons = ms;
		return ms;
	}
	/* >=1 kick reasons, normal processing */
	ms2->next = ms;
	ms->prev = ms2;
	return ms;
}

struct server *addnewserver(char *serverhost, int serverport, int servermodes, int pingfrequency, int protected_ircops, int linenoise)
{
	struct server *s;
	struct server *s2;

	oer_debug(OER_DEBUG_INFO, "addnewserver->checking server hostname: %s port: %d servermodes: %d ping frequency: %d protected ircops: %d linenoise: %d\n", serverhost, serverport, servermodes, pingfrequency, protected_ircops, linenoise);
	s = mystate->servers;
	s2 = s;
	while(s != NULL) {
		s2 = s;
		if(!strcasecmp(s->serverhost, serverhost) && s->serverport == serverport && s->servermodes == servermodes && s->pingfrequency == pingfrequency && s->protected_ircops == protected_ircops && s->linenoise == linenoise) {
			/* server already exists */
			return NULL;
		}
		s = s2->next;
	}
	if((s = (struct server *) malloc(sizeof(struct server))) == NULL) {
		return NULL;
	}
	strncpy(s->serverhost, serverhost, HOSTLEN);
	s->serverport = serverport;
	s->servermodes = servermodes;
	s->pingfrequency = pingfrequency;
	s->protected_ircops = protected_ircops;
	s->used = 0;
	s->connected = 0;
	s->stoned = 0;
	s->linenoise = linenoise;
	s->registered = OER_REGISTERCONNECTION_STATUS_BEGIN;
	s->lastping = 0;
	s->prev = NULL;
	s->next = NULL;
	if(mystate->servers == NULL) {
		/* first server, special case */
		mystate->servers = s;
		return s;
	}
	/* >=1 servers, normal case */
	s2->next = s;
	s->prev = s2;
	return s;
}

struct channel *addnewchannel(char *name)
{
	struct channel *this;
	struct channel *this2;

	oer_debug(OER_DEBUG_INFO, "addnewchannel->adding channel %s\n", name);
	this = mystate->channels;
	this2 = this;
	while(this != NULL) {
		this2 = this;
		if(!strcasecmp(this->name, name)) {
			return NULL;
		}
		this = this2->next;
	}
	if((this = (struct channel *) malloc(sizeof(struct channel))) == NULL) {
		return NULL;
	}
	strncpy(this->name, name, CHANLEN);
	memset(this->mode, 0, CHANLEN + 1);
	memset(this->key, 0, CHANLEN + 1);
	this->haskey = 0;
	this->joined = 0;
	this->joining = 0;
	this->setchanmode = 0;
	this->rejoin_at = 0;
	this->last_quote = 0;
	this->nickcount = 0;
	this->i_am_op = 0;
	memset(&this->chanflags, 0, FLAGLEN + 1);
	this->last = NULL;
	this->seen = NULL;
	this->modelines = NULL;
	this->nicks = NULL;
	this->pubmsgs = NULL;
	this->parts = NULL;
	this->joins = NULL;
	memset(&this->locked, 0, sizeof(struct locked));
	memset(&this->floodvars, 0, sizeof(struct floodvars));
	/* set the flood defaults, run-time changable */
	this->floodvars.repeat_expire = PUBMSG_FLOOD_REPEAT_EXPIRE;
	this->floodvars.repeat_limit = PUBMSG_FLOOD_REPEAT;
	this->floodvars.interval = PUBMSG_FLOOD_INTERVAL;
	this->floodvars.lines = PUBMSG_FLOOD_LINES;
	this->floodvars.chars = PUBMSG_FLOOD_CHARS;
	/* .. */
	memset(&this->banvars, 0, sizeof(struct banvars));
	/* set the ban time defaults, run-time changable */
	this->banvars.auto_rejoin = OER_BANVARS_AUTO_REJOIN;
	this->banvars.part_rejoin = OER_BANVARS_PART_REJOIN;
	this->banvars.public_flood = OER_BANVARS_PUBLIC_FLOOD;
	this->banvars.public_flood_repeat = OER_BANVARS_PUBLIC_FLOOD_REPEAT;
	this->banvars.bad_word = OER_BANVARS_BAD_WORD;
	this->banvars.bad_nick = OER_BANVARS_BAD_NICK;
	this->banvars.normal_ban = OER_BANVARS_NORMAL_BAN;
	/* .. */
	this->permbans = NULL;
	this->nickbks = NULL;
	this->wordbks = NULL;
	this->users = NULL;
	this->autheds = NULL;
	this->topic_change = 0;
	this->topic_list = 0;
	this->synced = 0;
	this->topics = NULL;
	this->prev = NULL;
	this->next = NULL;
	/* first one is a special case */
	if(mystate->channels == NULL) {
		mystate->channels = this;
		return this;
	}
	/* >=1 channels, normal case */
	this2->next = this;
	this->prev = this2;
	return this;
}

struct channel *getchptr(char *channel_name)
{
	struct channel *channel_ptr;

	for(channel_ptr = mystate->channels; channel_ptr != NULL; channel_ptr = channel_ptr->next) {
		if(!strcasecmp(channel_ptr->name, channel_name)) {
			break;
		}
	}
	return channel_ptr;
}

int loadall(void)
{
	if(!loadconf()) {
                oer_debug(OER_DEBUG_INFO, "loadall->loadconf() failed\n");
		return 0;
        }
        if(!loadchannels()) {
                oer_debug(OER_DEBUG_INFO, "loadall->loadchannels() failed\n");
		return 0;
        }
        if(!loadtrusted()) {
                oer_debug(OER_DEBUG_INFO, "loadall->loadtrusted() failed\n");
		return 0;
        }
        if(!loadadmins()) {
                oer_debug(OER_DEBUG_INFO, "loadall->loadadmins() failed\n");
		return 0;
        }
        if(!loadkickreasons()) {
                oer_debug(OER_DEBUG_INFO, "loadall->loadkickreasons() failed\n");
		return 0;
        }
        if(!loadchaninfo()) {
                oer_debug(OER_DEBUG_INFO, "loadall->loadchaninfo() failed\n");
		return 0;
        }
	return 1;
}

int loadconf(void)
{
	FILE *fp;
        char filename[STRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];

	snprintf(filename, STRINGLEN, "%s%s", mystate->progname, ".conf");
	oer_debug(OER_DEBUG_INFO, "loadconf->loading %s\n", filename);
	if((fp = fopen(filename, "r")) == NULL) {
                return 0;
        }
        while(fgets(stringbuffer, BIGSTRINGLEN, fp)) {
		striplf(stringbuffer);
		if(emptyline(stringbuffer)) {
			continue;
		}
		if(iscomment(stringbuffer)) {
			continue;
		}
                if(!parseconf(stringbuffer)) {
			oer_debug(OER_DEBUG_WARNING, "loadconf->non-parsable line: '%s'\n", stringbuffer);
                        return 0;
                }
        }
        fclose(fp);
        return 1;
}

int saveall(void)
{
	if(!saveconf()) {
		oer_debug(OER_DEBUG_INFO, "saveall->saveconf() failed\n");
		return 0;
	}
	if(!savechannels()) {
		oer_debug(OER_DEBUG_INFO, "saveall->savechannels() failed\n");
		return 0;
	}
	if(!savetrusted()) {
		oer_debug(OER_DEBUG_INFO, "saveall->savetrusted() failed\n");
		return 0;
	}
	if(!saveadmins()) {
		oer_debug(OER_DEBUG_INFO, "saveall->saveadmins() failed\n");
		return 0;
	}
	if(!savekickreasons()) {
		oer_debug(OER_DEBUG_INFO, "saveall->savekickreasons() failed\n");
		return 0;
	}
	if(!savechaninfo()) {
		oer_debug(OER_DEBUG_INFO, "saveall->savechaninfo() failed\n");
		return 0;
	}
	return 1;
}

int saveconf(void)
{
	FILE *fp;
        char filename[STRINGLEN + 1];
        char newfilename[STRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];
	struct server *server;

	snprintf(filename, STRINGLEN, "%s%s", mystate->progname, ".conf.saving");
	oer_debug(OER_DEBUG_INFO, "saveconf->saving to %s\n", filename);
	if((fp = fopen(filename, "w")) == NULL) {
                return 0;
        }
	snprintf(stringbuffer, BIGSTRINGLEN, "nick::%s\n", mystate->nick);
        fputs(stringbuffer, fp);
        snprintf(stringbuffer, BIGSTRINGLEN, "altnick::%s\n", mystate->altnick);
        fputs(stringbuffer, fp);
        snprintf(stringbuffer, BIGSTRINGLEN, "user::%s\n", mystate->user);
        fputs(stringbuffer, fp);
        snprintf(stringbuffer, BIGSTRINGLEN, "usermode::%s\n", mystate->mode);
        fputs(stringbuffer, fp);
        snprintf(stringbuffer, BIGSTRINGLEN, "flags::%s\n", mystate->flags);
        fputs(stringbuffer, fp);
        snprintf(stringbuffer, BIGSTRINGLEN, "prefix::%c\n", mystate->prefix);
        fputs(stringbuffer, fp);
        snprintf(stringbuffer, BIGSTRINGLEN, "realname::%s\n", mystate->realname);
        fputs(stringbuffer, fp);
        if(mystate->vhost) {
                snprintf(stringbuffer, BIGSTRINGLEN, "vhost::%s\n", mystate->host);
                fputs(stringbuffer, fp);
        }
        for(server = mystate->servers; server != NULL; server = server->next) {
                snprintf(stringbuffer, BIGSTRINGLEN, "server::%s::%d::%d::%d::%d::%d\n", server->serverhost, server->serverport, server->servermodes, server->pingfrequency, server->protected_ircops, server->linenoise);
                fputs(stringbuffer, fp);
        }
        fclose(fp);
	snprintf(newfilename, STRINGLEN, "%s%s", mystate->progname, ".conf");
        oer_debug(OER_DEBUG_INFO, "saveconf->renaming %s to %s\n", filename, newfilename);
        if(rename(filename, newfilename) < 0) {
                return 0;
        }
        return 1;
}

int parseconf(char *paramline)
{
	int ppos;
	char p1[STRINGLEN + 1];
	char p2[STRINGLEN + 1];
	char p3[STRINGLEN + 1];
	char p4[STRINGLEN + 1];
	char p5[STRINGLEN + 1];
	char p6[STRINGLEN + 1];
	char p7[STRINGLEN + 1];
	struct server *server;

	ppos = 0;
	if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p1, STRINGLEN, 1)) < 0) {
		return 0;
	}
	if(!strcasecmp(p1, "nick")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		strncpy(mystate->nick, p2, NICKLEN);
		oer_debug(OER_DEBUG_FLOOD, "parseconf->my nick is %s\n", mystate->nick);
		return 1;
	}
	if(!strcasecmp(p1, "altnick")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		strncpy(mystate->altnick, p2, NICKLEN);
		oer_debug(OER_DEBUG_FLOOD, "parseconf->my alt nick is %s\n", mystate->altnick);
		return 1;
	}
	if(!strcasecmp(p1, "realname")) {
		if(!strlen(paramline + ppos)) {
			return 0;
		}
		strncpy(mystate->realname, paramline + ppos, STRINGLEN);
		oer_debug(OER_DEBUG_FLOOD, "parseconf->my IRC REALNAME is %s\n", mystate->realname);
		return 1;
	}
	if(!strcasecmp(p1, "user")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		strncpy(mystate->user, p2, NICKLEN);
		mystate->customuser = 1;
		oer_debug(OER_DEBUG_FLOOD, "parseconf->my user is %s\n", mystate->user);
		return 1;
	}
	if(!strcasecmp(p1, "usermode")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		strncpy(mystate->mode, p2, CHANLEN);
		mystate->newmode = 1;
		oer_debug(OER_DEBUG_FLOOD, "parseconf->my usermode is %s\n", mystate->mode);
		return 1;
	}
	if(!strcasecmp(p1, "flags")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		strncpy(mystate->flags, p2, FLAGLEN);
		oer_debug(OER_DEBUG_FLOOD, "parseconf->my flags are %s\n", mystate->flags);
		return 1;
	}
	if(!strcasecmp(p1, "prefix")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		mystate->prefix = p2[0];
		oer_debug(OER_DEBUG_FLOOD, "parseconf->my prefix is %c\n", mystate->prefix);
		return 1;
	}
	if(!strcasecmp(p1, "vhost")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		strncpy(mystate->host, p2, HOSTLEN);
		mystate->vhost = 1;
		oer_debug(OER_DEBUG_FLOOD, "parseconf->using virtual host %s\n", mystate->host);
		return 1;
	}
	if(!strcasecmp(p1, "server")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p3, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p4, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p5, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p6, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p7, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((server = addnewserver(p2, atoi(p3), atoi(p4), atoi(p5), atoi(p6), atoi(p7))) == NULL) {
			return 0;
		}
		oer_debug(OER_DEBUG_FLOOD, "parseconf->added IRC server hostname: %s port: %d servermodes: %d ping frequency: %d protected ircops: %d\n", server->serverhost, server->serverport, server->servermodes, server->pingfrequency, server->protected_ircops);
		return 1;
	}
	oer_debug(OER_DEBUG_WARNING, "parseconf->unknown line: '%s'\n", paramline);
	return 1;
}

int loadchannels(void)
{
	FILE *fp;
        char filename[STRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];

	snprintf(filename, STRINGLEN, "%s%s", mystate->progname, ".channels");
	oer_debug(OER_DEBUG_INFO, "loadchannels->loading %s\n", filename);
	if((fp = fopen(filename, "r")) == NULL) {
                return 0;
        }
	while(fgets(stringbuffer, BIGSTRINGLEN, fp)) {
                striplf(stringbuffer);
                if(emptyline(stringbuffer)) {
                        continue;
                }
                if(iscomment(stringbuffer)) {
                        continue;
                }
                if(!parsechannels(stringbuffer)) {
                        oer_debug(OER_DEBUG_WARNING, "loadchannels->non-parsable line: '%s'\n", stringbuffer);
                        return 0;
                }
        }
        fclose(fp);
        return 1;
}

int savechannels(void)
{
	FILE *fp;
        char filename[STRINGLEN + 1];
        char newfilename[STRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];
	struct channel *this;

	snprintf(filename, STRINGLEN, "%s%s", mystate->progname, ".channels.saving");
	oer_debug(OER_DEBUG_INFO, "savechannels->saving to %s\n", filename);
	if((fp = fopen(filename, "w")) == NULL) {
                return 0;
        }
	for(this = mystate->channels; this != NULL; this = this->next) {
		if(this->haskey) {
			snprintf(stringbuffer, BIGSTRINGLEN, "channel::%s::%s::%s::%s\n", this->name, this->key, this->mode, this->chanflags);
		} else {
			snprintf(stringbuffer, BIGSTRINGLEN, "channel::%s::::%s::%s\n", this->name, this->mode, this->chanflags);
		}
                fputs(stringbuffer, fp);
        }
        fclose(fp);
	snprintf(newfilename, STRINGLEN, "%s%s", mystate->progname, ".channels");
        oer_debug(OER_DEBUG_INFO, "savechannels->renaming %s to %s\n", filename, newfilename);
        if(rename(filename, newfilename) < 0) {
                return 0;
        }
        return 1;
}

int parsechannels(char *paramline)
{
	int ppos;
	char p1[STRINGLEN + 1];
	char p2[STRINGLEN + 1];
	char p3[STRINGLEN + 1];
	char p4[STRINGLEN + 1];
	char p5[STRINGLEN + 1];
	struct channel *this;

	ppos = 0;
	if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p1, STRINGLEN, 1)) < 0) {
		return 0;
	}
	if(!strcasecmp(p1, "channel")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p3, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p4, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p5, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((this = addnewchannel(p2)) == NULL) {
			return 0;
		}
		if(strlen(p3) > 0) {
			setchankey(p2, p3);
		}
		setchanmode(p2, p4);
		setchanflags(p2, p5);
		if(this->haskey) {
			oer_debug(OER_DEBUG_FLOOD, "parsechannels->added channel %s with key %s modes %s and flags %s\n", this->name, this->key, this->mode, this->chanflags);
		} else {
			oer_debug(OER_DEBUG_FLOOD, "parsechannels->added channel %s with modes %s and flags %s\n", this->name, this->mode, this->chanflags);
		}
		return 1;
	}
        oer_debug(OER_DEBUG_WARNING, "parsechannels->unknown line: '%s'\n", paramline);
        return 1;
}

int loadtrusted(void)
{
	FILE *fp;
        char filename[STRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];

	snprintf(filename, STRINGLEN, "%s%s", mystate->progname, ".trusted");
	oer_debug(OER_DEBUG_INFO, "loadtrusted->loading %s\n", filename);
	if((fp = fopen(filename, "r")) == NULL) {
                return 0;
        }
	while(fgets(stringbuffer, BIGSTRINGLEN, fp)) {
                striplf(stringbuffer);
                if(emptyline(stringbuffer)) {
                        continue;
                }
                if(iscomment(stringbuffer)) {
                        continue;
                }
                if(!parsetrusted(stringbuffer)) {
                        oer_debug(OER_DEBUG_WARNING, "loadtrusted->non-parsable line: '%s'\n", stringbuffer);
                        return 0;
                }
        }
        fclose(fp);
        return 1;
}

int savetrusted(void)
{
	FILE *fp;
        char filename[STRINGLEN + 1];
        char newfilename[STRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];
	struct maskstruct *ms;

	snprintf(filename, STRINGLEN, "%s%s", mystate->progname, ".trusted.saving");
	oer_debug(OER_DEBUG_INFO, "savetrusted->saving to %s\n", filename);
	if((fp = fopen(filename, "w")) == NULL) {
                return 0;
        }
	for(ms = mystate->trusted; ms != NULL; ms = ms->next) {
                snprintf(stringbuffer, BIGSTRINGLEN, "trusted::%s\n", ms->mask);
                fputs(stringbuffer, fp);
        }
        fclose(fp);
	snprintf(newfilename, STRINGLEN, "%s%s", mystate->progname, ".trusted");
        oer_debug(OER_DEBUG_INFO, "savetrusted->renaming %s to %s\n", filename, newfilename);
        if(rename(filename, newfilename) < 0) {
                return 0;
        }
        return 1;
}

int parsetrusted(char *paramline)
{
	int ppos;
	char p1[STRINGLEN + 1];
	char p2[STRINGLEN + 1];
	struct maskstruct *ms;

	ppos = 0;
	if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p1, STRINGLEN, 1)) < 0) {
		return 0;
	}
	if(!strcasecmp(p1, "trusted")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ms = addnewtrusted(p2)) == NULL) {
			return 0;
		}
		oer_debug(OER_DEBUG_FLOOD, "parsetrusted->added trusted %s\n", ms->mask);
		return 1;
	}
        oer_debug(OER_DEBUG_WARNING, "parsetrusted->unknown line: '%s'\n", paramline);
        return 1;
}

int loadadmins(void)
{
	FILE *fp;
        char filename[STRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];

	snprintf(filename, STRINGLEN, "%s%s", mystate->progname, ".admins");
	oer_debug(OER_DEBUG_INFO, "loadadmins->loading %s\n", filename);
	if((fp = fopen(filename, "r")) == NULL) {
                return 0;
        }
	while(fgets(stringbuffer, BIGSTRINGLEN, fp)) {
                striplf(stringbuffer);
                if(emptyline(stringbuffer)) {
                        continue;
                }
                if(iscomment(stringbuffer)) {
                        continue;
                }
                if(!parseadmins(stringbuffer)) {
                        oer_debug(OER_DEBUG_WARNING, "loadadmins->non-parsable line: '%s'\n", stringbuffer);
                        return 0;
                }
        }
        fclose(fp);
        return 1;
}

int saveadmins(void)
{
	FILE *fp;
        char filename[STRINGLEN + 1];
        char newfilename[STRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];
	struct botuser *admin;
	struct maskstruct *ms;

	snprintf(filename, STRINGLEN, "%s%s", mystate->progname, ".admins.saving");
	oer_debug(OER_DEBUG_INFO, "saveadmins->saving to %s\n", filename);
	if((fp = fopen(filename, "w")) == NULL) {
                return 0;
        }
	for(admin = mystate->admins; admin != NULL; admin = admin->next) {
                snprintf(stringbuffer, BIGSTRINGLEN, "admin::%s::%s\n", admin->handle, admin->options);
                fputs(stringbuffer, fp);
                for(ms = admin->firstmask; ms != NULL; ms = ms->next) {
                        snprintf(stringbuffer, BIGSTRINGLEN, "mask::%s::%s\n", admin->handle, ms->mask);
                        fputs(stringbuffer, fp);
                }
        }
        fclose(fp);
	snprintf(newfilename, STRINGLEN, "%s%s", mystate->progname, ".admins");
        oer_debug(OER_DEBUG_INFO, "saveadmins->renaming %s to %s\n", filename, newfilename);
        if(rename(filename, newfilename) < 0) {
                return 0;
        }
        return 1;
}

int parseadmins(char *paramline)
{
	int ppos;
	char p1[STRINGLEN + 1];
	char p2[STRINGLEN + 1];
	char p3[STRINGLEN + 1];
	struct maskstruct *ms;
	struct botuser *admin;

	ppos = 0;
	if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p1, STRINGLEN, 1)) < 0) {
		return 0;
	}
	if(!strcasecmp(p1, "admin")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p3, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((admin = addnewadmin(p2, p3)) == NULL) {
			return 0;
		}
		oer_debug(OER_DEBUG_FLOOD, "parseadmins->added admin %s with options %s\n", admin->handle, admin->options);
		return 1;
	}
	if(!strcasecmp(p1, "mask")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p3, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ms = addnewadminmask(p2, p3)) == NULL) {
			return 0;
		}
		oer_debug(OER_DEBUG_FLOOD, "parseadmins->added mask %s to admin %s\n", p3, p2);
		return 1;
	}
        oer_debug(OER_DEBUG_WARNING, "parseadmins->unknown line: '%s'\n", paramline);
        return 1;
}

int loadkickreasons(void)
{
	FILE *fp;
        char filename[STRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];

	snprintf(filename, STRINGLEN, "%s%s", mystate->progname, ".kickreasons");
	oer_debug(OER_DEBUG_INFO, "loadkickreasons->loading %s\n", filename);
	if((fp = fopen(filename, "r")) == NULL) {
                return 0;
        }
	while(fgets(stringbuffer, BIGSTRINGLEN, fp)) {
                striplf(stringbuffer);
                if(emptyline(stringbuffer)) {
                        continue;
                }
                if(iscomment(stringbuffer)) {
                        continue;
                }
                if(!parsekickreasons(stringbuffer)) {
                        oer_debug(OER_DEBUG_WARNING, "loadkickreasons->non-parsable line: '%s'\n", stringbuffer);
                        return 0;
                }
        }
        fclose(fp);
        return 1;
}

int savekickreasons(void)
{
	FILE *fp;
        char filename[STRINGLEN + 1];
        char newfilename[STRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];
	struct maskstruct *ms;

	snprintf(filename, STRINGLEN, "%s%s", mystate->progname, ".kickreasons.saving");
	oer_debug(OER_DEBUG_INFO, "savekickreasons->saving to %s\n", filename);
	if((fp = fopen(filename, "w")) == NULL) {
                return 0;
        }
	for(ms = mystate->kickreasons; ms != NULL; ms = ms->next) {
                snprintf(stringbuffer, BIGSTRINGLEN, "kickreason::%s\n", ms->mask);
                fputs(stringbuffer, fp);
        }
        fclose(fp);
	snprintf(newfilename, STRINGLEN, "%s%s", mystate->progname, ".kickreasons");
        oer_debug(OER_DEBUG_INFO, "savekickreasons->renaming %s to %s\n", filename, newfilename);
        if(rename(filename, newfilename) < 0) {
                return 0;
        }
        return 1;
}

int parsekickreasons(char *paramline)
{
	int ppos;
	char p1[STRINGLEN + 1];
	char p2[STRINGLEN + 1];
	struct maskstruct *ms;

	ppos = 0;
	if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p1, STRINGLEN, 1)) < 0) {
		return 0;
	}
	if(!strcasecmp(p1, "kickreason")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if((ms = addnewkickreason(p2)) == NULL) {
			return 0;
		}
		oer_debug(OER_DEBUG_FLOOD, "parsekickreasons->added a new kick reason %s\n", ms->mask);
		return 1;
	}
        oer_debug(OER_DEBUG_WARNING, "parsekickreasons->unknown line: '%s'\n", paramline);
        return 1;
}

int loadchaninfo(void)
{
	FILE *fp;
        char filename[STRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];

	snprintf(filename, STRINGLEN, "%s%s", mystate->progname, ".chaninfo");
	oer_debug(OER_DEBUG_INFO, "loadchaninfo->loading %s\n", filename);
	if((fp = fopen(filename, "r")) == NULL) {
                return 0;
        }
	while(fgets(stringbuffer, BIGSTRINGLEN, fp)) {
                striplf(stringbuffer);
                if(emptyline(stringbuffer)) {
                        continue;
                }
                if(iscomment(stringbuffer)) {
                        continue;
                }
                if(!parsechaninfo(stringbuffer)) {
                        oer_debug(OER_DEBUG_WARNING, "loadchaninfo->non-parsable line: '%s'\n", stringbuffer);
                        return 0;
                }
        }
        fclose(fp);
        return 1;
}

int savechaninfo(void)
{
	FILE *fp;
        char filename[STRINGLEN + 1];
        char newfilename[STRINGLEN + 1];
        char stringbuffer[BIGSTRINGLEN + 1];
	struct channel *this;
	struct botuser *user;
	struct maskstruct *ms;

	snprintf(filename, STRINGLEN, "%s%s", mystate->progname, ".chaninfo.saving");
	oer_debug(OER_DEBUG_INFO, "savechaninfo->saving to %s\n", filename);
	if((fp = fopen(filename, "w")) == NULL) {
                return 0;
        }
	for(this = mystate->channels; this != NULL; this = this->next) {
                for(user = this->users; user != NULL; user = user->next) {
                        snprintf(stringbuffer, BIGSTRINGLEN, "chaninfo::%s::user::%s::%s\n", this->name, user->handle, user->options);
                        fputs(stringbuffer, fp);
                        if(index(user->options, (int)'d') != NULL) {
                                snprintf(stringbuffer, BIGSTRINGLEN, "chaninfo::%s::password::%s::%s\n", this->name, user->handle, user->password);
                                fputs(stringbuffer, fp);
                        }
                        for(ms = user->firstmask; ms != NULL; ms = ms->next) {
                                snprintf(stringbuffer, BIGSTRINGLEN, "chaninfo::%s::usermask::%s::%s\n", this->name, user->handle, ms->mask);
                                fputs(stringbuffer, fp);
                        }
                }
                for(ms = this->wordbks; ms != NULL; ms = ms->next) {
                        snprintf(stringbuffer, BIGSTRINGLEN, "chaninfo::%s::wordbk::%s\n", this->name, ms->mask);
                        fputs(stringbuffer, fp);
                }
                for(ms = this->nickbks; ms != NULL; ms = ms->next) {
                        snprintf(stringbuffer, BIGSTRINGLEN, "chaninfo::%s::nickbk::%s::%s\n", this->name, ms->mask, ms->optstring);
                        fputs(stringbuffer, fp);
                }
                for(ms = this->permbans; ms != NULL; ms = ms->next) {
                        snprintf(stringbuffer, BIGSTRINGLEN, "chaninfo::%s::permban::%s\n", this->name, ms->mask);
                        fputs(stringbuffer, fp);
                }
		snprintf(stringbuffer, BIGSTRINGLEN, "chaninfo::%s::floodvars::%d::%d::%d::%d::%d\n", this->name, this->floodvars.repeat_expire, this->floodvars.repeat_limit, this->floodvars.interval, this->floodvars.lines, this->floodvars.chars);
		fputs(stringbuffer, fp);
		snprintf(stringbuffer, BIGSTRINGLEN, "chaninfo::%s::banvars::%d::%d::%d::%d::%d::%d::%d\n", this->name, this->banvars.auto_rejoin, this->banvars.part_rejoin, this->banvars.public_flood, this->banvars.public_flood_repeat, this->banvars.bad_word, this->banvars.bad_nick, this->banvars.normal_ban);
		fputs(stringbuffer, fp);
        }
        fclose(fp);
	snprintf(newfilename, STRINGLEN, "%s%s", mystate->progname, ".chaninfo");
        oer_debug(OER_DEBUG_INFO, "savechaninfo->renaming %s to %s\n", filename, newfilename);
        if(rename(filename, newfilename) < 0) {
                return 0;
        }
        return 1;
}

int parsechaninfo(char *paramline)
{
	int ppos;
	char p0[STRINGLEN + 1];
	char p1[STRINGLEN + 1];
	char p2[STRINGLEN + 1];
	char p3[STRINGLEN + 1];
	char p4[STRINGLEN + 1];
	char p5[STRINGLEN + 1];
	char p6[STRINGLEN + 1];
	char p7[STRINGLEN + 1];
	char p8[STRINGLEN + 1];
	char p9[STRINGLEN + 1];
	struct maskstruct *ms;
	struct botuser *user;
	struct channel *this;

	ppos = 0;
	if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p0, STRINGLEN, 1)) < 0) {
		return 0;
	}
	if(!strcasecmp(p0, "chaninfo")) {
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p1, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if(!isvalidchannel(p1)) {
			oer_debug(OER_DEBUG_WARNING, "parsechaninfo->unknown channel %s\n", p1);
			return 1;
		}
		if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p2, STRINGLEN, 1)) < 0) {
			return 0;
		}
		if(!strcasecmp(p2, "admin")) {
			/* remove when configs are adjusted */
			return 1;
		}
		if(!strcasecmp(p2, "adminmask")) {
			/* remove when configs are adjusted */
			return 1;
		}
		if(!strcasecmp(p2, "user")) {
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p3, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p4, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((user = addnewuser(p1, p3, p4)) == NULL) {
				return 0;
			}
			oer_debug(OER_DEBUG_FLOOD, "parsechaninfo->added user %s to channel %s with options %s\n", user->handle, p1, user->options);
		return 1;
		}
		if(!strcasecmp(p2, "password")) {
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p3, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p4, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if(!setpassword(p1, p3, p4)) {
				oer_debug(OER_DEBUG_FLOOD, "parsechaninfo->failed to add password %s to %s dyn user %s\n", p4, p1, p3);
				return 0;
			}
			oer_debug(OER_DEBUG_FLOOD, "parsechaninfo->added password %s to %s dyn user %s\n", p4, p1, p3);
			return 1;
		}
		if(!strcasecmp(p2, "usermask")) {
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p3, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p4, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ms = addnewusermask(p1, p3, p4)) == NULL) {
				return 0;
			}
			oer_debug(OER_DEBUG_FLOOD, "parsechaninfo->added mask %s to %s user %s\n", p4, p1, p3);
			return 1;
		}
		if(!strcasecmp(p2, "wordbk")) {
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p3, STRINGLEN, 1)) < 0) {
				return 0;
			}
			addnewwordbk(p1, p3);
			oer_debug(OER_DEBUG_FLOOD, "parsechaninfo->added banned word %s to channel %s\n", p3, p1);
			return 1;
		}
		if(!strcasecmp(p2, "nickbk")) {
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p3, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p4, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if(strlen(p4) > 0) {
				addnewnickbk(p1, p3, p4);
				oer_debug(OER_DEBUG_FLOOD, "parsechaninfo->added banned nick %s to channel %s (%s)\n", p3, p1, p4);
			} else {
				addnewnickbk(p1, p3, NULL);
				oer_debug(OER_DEBUG_FLOOD, "parsechaninfo->added banned nick %s to channel %s\n", p3, p1);
			}
			return 1;
		}
		if(!strcasecmp(p2, "permban")) {
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p3, STRINGLEN, 1)) < 0) {
				return 0;
			}
			addnewpermban(p1, p3);
			oer_debug(OER_DEBUG_FLOOD, "parsechaninfo->added permban %s to channel %s\n", p3, p1);
			return 1;
		}
		if(!strcasecmp(p2, "floodvars")) {
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p3, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p4, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p5, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p6, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p7, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((this = getchptr(p1)) == NULL) {
				return 0;
			}
			this->floodvars.repeat_expire = atoi(p3);
			this->floodvars.repeat_limit = atoi(p4);
			this->floodvars.interval = atoi(p5);
			this->floodvars.lines = atoi(p6);
			this->floodvars.chars = atoi(p7);
			oer_debug(OER_DEBUG_FLOOD, "parsechaninfo->channel %s floodvars set to %d %d %d %d %d\n", p1, this->floodvars.repeat_expire, this->floodvars.repeat_limit, this->floodvars.interval, this->floodvars.lines, this->floodvars.chars);
			return 1;
		}
		if(!strcasecmp(p2, "banvars")) {
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p3, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p4, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p5, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p6, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p7, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p8, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((ppos = parse(paramline, ppos, OER_DEFAULT_DELIM, p9, STRINGLEN, 1)) < 0) {
				return 0;
			}
			if((this = getchptr(p1)) == NULL) {
				return 0;
			}
			this->banvars.auto_rejoin = atoi(p3);
			this->banvars.part_rejoin = atoi(p4);
			this->banvars.public_flood = atoi(p5);
			this->banvars.public_flood_repeat = atoi(p6);
			this->banvars.bad_word = atoi(p7);
			this->banvars.bad_nick = atoi(p8);
			this->banvars.normal_ban = atoi(p9);
			oer_debug(OER_DEBUG_FLOOD, "parsechaninfo->channel %s banvars set to %d %d %d %d %d %d %d\n", p1, this->banvars.auto_rejoin, this->banvars.part_rejoin, this->banvars.public_flood, this->banvars.public_flood_repeat, this->banvars.bad_word, this->banvars.bad_nick, this->banvars.normal_ban);
			return 1;
		}
		oer_debug(OER_DEBUG_FATAL, "parsechaninfo->bad channel parameter %s\n", p2);
		return 0;
	}
        oer_debug(OER_DEBUG_WARNING, "parsechaninfo->unknown line: '%s'\n", paramline);
        return 1;
}

char *getchanflags(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	return this->chanflags;
}

void setchanflags(char *channel, char *chanflags)
{
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "setchanflags->setting %s flags to %s\n", channel, chanflags);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	strncpy(this->chanflags, chanflags, FLAGLEN);
}

int burstjoins(char *channel)
{
	int i;
	time_t delta;
	struct channel *this;
	struct join *j;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(j = this->joins, i = 0; j != NULL; j = j->next) {
		delta = mystate->now - j->at;
		if(delta <= OER_BURST_JOINS_LIMIT) {
			i++;
		}
		if(i >= OER_BURST_JOINS) {
			return 1;
		}
	}
	return 0;
}

int partcount(char *channel, char *nick, char *host)
{
	int count;
	struct channel *this;
	struct part *p;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(count = 0, p = this->parts; p != NULL; p = p->next) {
		if(p->valid && (mystate->now < (p->at + OER_PART_EXPIRE)) && !strcasecmp(p->nick, nick) && !strcasecmp(p->host, host)) {
			count++;
		}
	}
	return count;
}

void resetparts(char *channel, char *nick, char *host)
{
	struct channel *this;
	struct part *p;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(p = this->parts; p != NULL; p = p->next) {
		if(!strcasecmp(p->nick, nick) && !strcasecmp(p->host, host)) {
			p->valid = 0;
		}
	}
}

time_t lastoff(char *channel, char *nick)
{
	time_t delta;
	struct channel *this;
	struct part *p;

	if((this = getchptr(channel)) == NULL) {
		return OER_AUTO_REJOIN_TIME + 1;
	}
	p = this->parts;
	while(p != NULL) {
		if(!strcasecmp(p->nick, nick)) {
			delta = (mystate->now - p->at);
			return delta;
		}
		p = p->next;
	}
	return OER_AUTO_REJOIN_TIME + 1;
}

int lastquote(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	return mystate->now - this->last_quote;
}

void setlastquote(char *channel, time_t last)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	this->last_quote = last;
}

int getjoincount(char *channel, char *nick)
{
	int joins;
	struct channel *this;
	struct join *j;

	if((this = getchptr(channel)) == NULL) {
		return -1;
	}
	joins = 0;
	j = this->joins;
	while(j != NULL) {
		if(!strcasecmp(j->nick, nick)) {
			joins++;
		}
		j = j->next;
	}
	return joins;
}

int isq(char *nick)
{
	if((index(mystate->flags, (int)'q') != NULL) && !strcasecmp(nick, Q_NICK)) {
                return 1;
        }
	return 0;
}

int isme(char *nick)
{
	if(!strcasecmp(mystate->nick, nick)) {
		return 1;
	} else {
		return 0;
	}
}

int amiop(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	return this->i_am_op;
}

void iamop(char *channel, int flag)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	this->i_am_op = flag;
}

int ispermban(char *channel, char *mask)
{
	struct channel *this;
	struct maskstruct *pb;
	
	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	pb = this->permbans;
	while(pb != NULL) {
		if(!strcasecmp(pb->mask, mask)) {
			return 1;
		}
		pb = pb->next;
	}
	return 0;
}

int permbancount(char *channel)
{
	int amount;
	struct channel *this;
	struct maskstruct *pb;

	if((this = getchptr(channel)) == NULL) {
		return -1;
	}
	for(amount = 0, pb = this->permbans; pb != NULL; amount++, pb = pb->next) {
	}
	return amount;
}

int topiccount(char *channel)
{
	int amount;
	struct channel *this;
	struct topic *t;

	if((this = getchptr(channel)) == NULL) {
		return -1;
	}
	for(amount = 0, t = this->topics; t != NULL; amount++, t = t->next) {
	}
	return amount;
}

char *getkickreason(char *reason)
{
	int counter;
	int nthkr;
	struct maskstruct *kr;

	counter = 0;
	kr = mystate->kickreasons;
	nthkr = getrandom(mystate->kickrs) - 1;
	oer_debug(OER_DEBUG_INFO, "getkickreason->returning kickreason %d/%d\n", nthkr, mystate->kickrs);
	while(kr != NULL && counter < nthkr) {
		counter++;
		kr = kr->next;
        }
	if(kr == NULL) {
		return NULL;
	}
	strncpy(reason, kr->mask, STRINGLEN);
	return reason;
}

int isop(char *channel, char *mask)
{
	/* check for static +o user */
	if(hasuserflags(channel, mask, "o") && !hasuserflags(channel, mask, "d")) {
		return 1;
	}
	/* check for dynamic +o (logoned) user */
	if(hasuserflags(channel, mask, "od") && isvalidlogon(channel, mask)) {
		return 1;
	}
	return 0;
}

int isadmin(char *channel, char *mask)
{
	/* check for admin */
	if(isopa(mask)) {
		return 1;
	}
	/* check for static +a user */
	if(hasuserflags(channel, mask, "a") && !hasuserflags(channel, mask, "d")) {
		return 1;
	}
	/* check for dynamic +a (logoned) user */
	if(hasuserflags(channel, mask, "ad") && isvalidlogon(channel, mask)) {
		return 1;
	}
	return 0;
}

int isvalidlogon(char *channel, char *mask)
{
	struct channel *this;
	struct authed *a;
	struct botuser *user;
	struct maskstruct *ms;

	if(mask == NULL) {
		return 0;
	}
	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	/* go through all authed hostmasks that are valid */
	for(a = this->autheds; a != NULL; a = a->next) {
		if(mystate->now > (a->at + OER_LOGON_TIMEOUT)) {
			continue;
		}
		/* check if the auth matches */
		if(strcasecmp(a->host, mask)) {
			continue;
		}
		user = a->user;
		/* check if the masks in the user field match */
		for(ms = user->firstmask; ms != NULL; ms = ms->next) {
			if(wild_match(ms->mask, mask)) {
				return 1;
			}
		}
		/* this auth didn't match, go to next */
		a = a->next;
	}
	/* no authed for this mask */
	return 0;
}

int isatleastopnow(char *channel, char *nick, char *host)
{
	if(isq(nick) || isadmin(channel, host) || isop(channel, host) || isopnow(channel, nick)) {
		return 1;
	}
	return 0;
}

int isallowedop(char *channel, char *nick)
{
	struct channel *this;
	struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			break;
		}
	}
	if(cu == NULL) {
		return 0;
	}
	if(isq(nick)) {
                return 1;
        }
	/* first check for admin */
	if(isadmin(channel, cu->host)) {
		return 1;
	}
	/* then user */
	if(isop(channel, cu->host)) {
		return 1;
	}
	/* only dyn left, is dyn user? */
	if(!hasuserflags(channel, cu->host, "d")) {
		return 0;
	}
	/* does user have +o? */
	if(!hasuserflags(channel, cu->host, "o")) {
		return 0;
	}
	if(!haschanflags(channel, "P")) {
		return 1;
	}
	/* paranoid channel, check for valid logon */
	if(isvalidlogon(channel, cu->host)) {
		return 1;
	}
	return 0;
}

int isopa(char *mask)
{
	struct botuser *admin;
	struct maskstruct *ms;

	if(mask == NULL) {
		return 0;
	}
	for(admin = mystate->admins; admin != NULL; admin = admin->next) {
		for(ms = admin->firstmask; ms != NULL; ms = ms->next) {
			if(wild_match(ms->mask, mask)) {
				return 1;
			}
		}
	}
	return 0;
}

int delopa(char *handle)
{
	struct botuser *admin;

	for(admin = mystate->admins; admin != NULL; admin = admin->next) {
		if(!strcasecmp(admin->handle, handle)) {
			break;
		}
	}
	if(admin == NULL) {
		return 0;
	}
	if(index(admin->options, (int)'n') != NULL) {
		/* we won't delete admins with "n" flag */
		return 0;
	}
	return 1;
}

int isonchan(char *channel, char *nick)
{
	struct channel *this;
	struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			return 1;
		}
	}
	return 0;
}

int issameuser(char *channel, char *handle, char *host)
{
	struct botuser *user;
	struct maskstruct *ms;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(user = this->users; user != NULL; user = user->next) {
		if(!strcasecmp(user->handle, handle)) {
			break;
		}
	}
	if(user == NULL) {
		return 0;
	}
	for(ms = user->firstmask; ms != NULL; ms = ms->next) {
		if(wild_match(ms->mask, host)) {
			return 1;
		}
	}
	return 0;
}

int isopnow(char *channel, char *nick)
{
	struct channel *this;
	struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick) && cu->chanop) {
			return 1;
		}
	}
	return 0;
}

void banuser(char *channel, char *nick)
{
	struct channel *this;
	struct chanuser *cu;
	char ban[HOSTLEN + 1];

	oer_debug(OER_DEBUG_INFO, "banuser->channel %s nick: %s\n", channel, nick);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			if(cu->host == NULL) {
				return;
			}
			strncpy(ban, cu->host, HOSTLEN);
			if(safeban(ban) == NULL) {
				return;
			}
			addnewmm(this->name, mystate->now, "+b", ban);
			addnewmm(this->name, mystate->now + this->banvars.normal_ban, "-b", ban);
			return;
		}
	}
}

void unbanuser(char *channel, char *nick)
{
	struct channel *this;
	struct chanuser *cu;
	char ban[HOSTLEN + 1];

	oer_debug(OER_DEBUG_INFO, "unbanuser->channel %s nick: %s\n", channel, nick);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			if(cu->host == NULL) {
				return;
			}
			if(cu->chanop) {
				continue;
			}
			strncpy(ban, cu->host, HOSTLEN);
			if(safeban(ban) == NULL) {
				return;
			}
			addnewmm(this->name, mystate->now, "-b", ban);
			return;
		}
	}
}

void bankickuser(char *channel, char *nick, char * reason)
{
	struct channel *this;
	struct chanuser *cu;
	char ban[HOSTLEN + 1];
	char stringbuffer[WRITE_BUFFER_LENGTH + 1];
	char kr[STRINGLEN + 1];

	oer_debug(OER_DEBUG_INFO, "bankickuser->channel %s nick: %s\n", channel, nick);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			break;
		}
	}
	if(cu == NULL) {
		return;
	}
	if(cu->host == NULL) {
		return;
	}
	strncpy(ban, cu->host, HOSTLEN);
	if(safeban(ban) == NULL) {
		return;
	}
	addnewmm(this->name, mystate->now, "+b", ban);
	addnewmm(this->name, mystate->now + this->banvars.normal_ban, "-b", ban);
	if(reason != NULL) {
		striplf(reason);
		snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "KICK %s %s :%s\n", this->name, cu->nick, reason);
	} else {
		if(getkickreason(kr) != NULL) {
			snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "KICK %s %s :%s\n", this->name, cu->nick, kr);
		} else {
			snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "KICK %s %s :%s\n", this->name, cu->nick, mystate->nick);
		}
	}
	addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
}

void editcommand(char *to, int tochan, char *channel, char *nick, char *host, char *commandline)
{
	int proceed;
	int ppos;
        char p1[STRINGLEN + 1];
        char p2[STRINGLEN + 1];
        char p3[STRINGLEN + 1];
        char p4[STRINGLEN + 1];
        char p5[STRINGLEN + 1];
        char p6[STRINGLEN + 1];
        char p7[STRINGLEN + 1];
        char p8[STRINGLEN + 1];
	char stringbuffer[BIGSTRINGLEN + 1];
	char *mode;
	char *key;
	char cryptsalt[3];
	char *crypted;
	struct channel *this;
	struct botuser *admin;
	struct botuser *user;

	oer_debug(OER_DEBUG_INFO, "editcommand->command: %s\n", commandline);
	/* command line parsing begins here, first parameter = the command */
	ppos = 0;
        if((ppos = parse(commandline, ppos, " ", p1, STRINGLEN, 0)) < 0) {
                return;
        }
	if(!strcasecmp(p1, "flags")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		/* check if we have to change some behaviour */
		if(index(p2, (int)'l')) {
			if(index(mystate->flags, (int)'l') == NULL) {
				snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "oer-%d.log", getpid());
				if((mystate->logfp = fopen(stringbuffer, "a+")) == NULL) {
					oer_debug(OER_DEBUG_INFO, "editcommand->couldn't open logfile %s: %s\n", stringbuffer, strerror(errno));
				} else {
					oer_debug(OER_DEBUG_INFO, "editcommand->logfile is %s\n", stringbuffer);
				}
			}
		} else {
			if(index(mystate->flags, (int)'l') != NULL) {
				fclose(mystate->logfp);
				mystate->logfp = NULL;
				oer_debug(OER_DEBUG_INFO, "editcommand->logging terminated by request\n");
			}
		}
		strncpy(mystate->flags, p2, FLAGLEN);
		snprintf(stringbuffer, BIGSTRINGLEN, "flags are now %s", mystate->flags);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "floodvars")) {
		if(numofparams(commandline) != 5) {
			return;
		}
		if(!isadmin(channel, host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p5, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p6, STRINGLEN, 0)) < 0) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		this->floodvars.repeat_expire = atoi(p2);
		this->floodvars.repeat_limit = atoi(p3);
		this->floodvars.interval = atoi(p4);
		this->floodvars.lines = atoi(p5);
		this->floodvars.chars = atoi(p6);
		snprintf(stringbuffer, BIGSTRINGLEN, "%s floodvars are now %d %d %d %d %d", this->name, this->floodvars.repeat_expire, this->floodvars.repeat_limit, this->floodvars.interval, this->floodvars.lines, this->floodvars.chars);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "banvars")) {
		if(numofparams(commandline) != 7) {
			return;
		}
		if(!isadmin(channel, host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p5, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p6, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p7, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p8, STRINGLEN, 0)) < 0) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		this->banvars.auto_rejoin = atoi(p2);
		this->banvars.part_rejoin = atoi(p3);
		this->banvars.public_flood = atoi(p4);
		this->banvars.public_flood_repeat = atoi(p5);
		this->banvars.bad_word = atoi(p6);
		this->banvars.bad_nick = atoi(p7);
		this->banvars.normal_ban = atoi(p8);
		snprintf(stringbuffer, BIGSTRINGLEN, "%s banvars are now %d %d %d %d %d %d %d", this->name, this->banvars.auto_rejoin, this->banvars.part_rejoin, this->banvars.public_flood, this->banvars.public_flood_repeat, this->banvars.bad_word, this->banvars.bad_nick, this->banvars.normal_ban);
		sendreply(to, tochan, 0, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "chanflags")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isadmin(channel, host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		/* check if we have to alter some behaviour */
		if(haschanflags(channel, "L") && (index(p2, (int)'L') == NULL)) {
			fclose(this->last);
			this->last = NULL;
		}
		if(!haschanflags(channel, "L") && (index(p2, (int)'L') != NULL)) {
			snprintf(stringbuffer, STRINGLEN, "last-%s", this->name);
			if((this->last = fopen(stringbuffer, "a")) == NULL) {
				oer_debug(OER_DEBUG_INFO, "editcommand->failed to open %s: %s\n", stringbuffer, strerror(errno));
			}
		}
		if(haschanflags(channel, "S") && (index(p2, (int)'S') == NULL)) {
			fclose(this->seen);
			this->seen = NULL;
		}
		if(!haschanflags(channel, "S") && (index(p2, (int)'S') != NULL)) {
			snprintf(stringbuffer, STRINGLEN, "seen-%s", this->name);
			if((this->seen = fopen(stringbuffer, "a")) == NULL) {
				oer_debug(OER_DEBUG_INFO, "editcommand->failed to open %s: %s\n", stringbuffer, strerror(errno));
			}
		}
		setchanflags(channel, p2);
		snprintf(stringbuffer, BIGSTRINGLEN, "%s chanflags are now %s", channel, getchanflags(channel));
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "chanmode")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isadmin(channel, host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		setchanmode(channel, p2);
		if((mode = getchanmode(channel)) != NULL) {
			snprintf(stringbuffer, BIGSTRINGLEN, "%s chanmode now %s", channel, mode);
			sendreply(channel, tochan, 0, 1, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "chankey")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isadmin(channel, host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		setchankey(channel, p2);
		if((key = getchankey(channel)) != NULL) {
			snprintf(stringbuffer, BIGSTRINGLEN, "%s channel key is now %s", channel, key);
			sendreply(channel, tochan, 0, 1, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "nick")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		strncpy(mystate->nick, p2, NICKLEN);
		mystate->newnick = 1;
		return;
	}
	if(!strcasecmp(p1, "prefix")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		mystate->prefix = p2[0];
		return;
	}
	if(!strcasecmp(p1, "realname")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		strncpy(mystate->realname, commandline + ppos, STRINGLEN);
		return;
	}
	if(!strcasecmp(p1, "password")) {
		if(numofparams(commandline) != 2) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		for(user = this->users; user != NULL; user = user->next) {
			if(!strcasecmp(user->handle, p2)) {
				break;
			}
		}
		if(user == NULL) {
			return;
		}
		proceed = (isopa(host)) ? 1 : 0;
		if(index(user->options, (int)'a') != NULL) {
			/* the user has +a flag */
			if(isadmin(channel, host) && issameuser(channel, p2, host)) {
				proceed = 1;
			}
		} else {
			/* a normal user */
			if(isadmin(channel, host)) {
				proceed = 1;
			}
			if(isop(channel, host) && issameuser(channel, p2, host)) {
				proceed = 1;
			}
		}
		if(!proceed) {
			return;
		}
		cryptsalt[0] = salt_chars[getrandom(strlen(salt_chars)) - 1];
		cryptsalt[1] = cryptsalt[0];
		cryptsalt[2] = '\0';
		crypted = crypt(p3, cryptsalt);
		if(!setpassword(channel, p2, crypted)) {
			return;
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "password for %s user %s is now %s", channel, p2, p3);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "options")) {
		if(numofparams(commandline) != 3) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		if(!strcasecmp(p2, "admin")) {
			if(!isopa(host)) {
				return;
			}
			for(admin = mystate->admins; admin != NULL; admin = admin->next) {
				if(!strcasecmp(admin->handle, p3)) {
					break;
				}
			}
			if(admin == NULL) {
				return;
			}
			/* we won't allow removal of the "n" flag for admins */
			if((index(admin->options, (int)'n') != NULL) && (index(p4, (int)'n') == NULL)) {
				oer_debug(OER_DEBUG_INFO, "editcommand->%s!%s attempted to unprotect protected admin %s\n", nick, host, p3);
				return;
			}
			free(admin->options);
			if((admin->options = malloc(strlen(p4) + 1)) == NULL) {
				return;
			}
			strcpy(admin->options, p4);
			snprintf(stringbuffer, BIGSTRINGLEN, "options for admin %s now: %s", admin->handle, admin->options);
			sendreply(to, tochan, 0, 1, stringbuffer);
			return;
		}
		if(!strcasecmp(p2, "user")) {
			if((this = getchptr(channel)) == NULL) {
				return;
			}
			for(user = this->users; user != NULL; user = user->next) {
				if(!strcasecmp(user->handle, p3)) {
					break;
				}
			}
			if(user == NULL) {
				return;
			}
			proceed = (isopa(host)) ? 1 : 0;
			if(index(user->options, (int)'a') != NULL) {
				/* the user has +a flag */
				if(isadmin(channel, host) && issameuser(channel, p3, host)) {
					proceed = 1;
				}
			} else {
				/* a normal user */
				if(isadmin(channel, host)) {
					proceed = 1;
				}
			}
			if(!proceed) {
				return;
			}
			free(user->options);
			if((user->options = malloc(strlen(p4) + 1)) == NULL) {
				return;
			}
			strcpy(user->options, p4);
			snprintf(stringbuffer, BIGSTRINGLEN, "options for user %s now: %s", user->handle, user->options);
			sendreply(to, tochan, 0, 1, stringbuffer);
			if(amiop(channel)) {
				syncvoices(channel);
				syncops(channel);
			}
			return;
		}
		return;
	}
	if(!strcasecmp(p1, "mask")) {
		if(numofparams(commandline) != 4) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p5, STRINGLEN, 0)) < 0) {
			return;
		}
		if(!strcasecmp(p2, "admin")) {
			if(!isopa(host)) {
				return;
			}
			for(admin = mystate->admins; admin != NULL; admin = admin->next) {
				if(!strcasecmp(admin->handle, p3)) {
					break;
				}
			}
			if(admin == NULL) {
				return;
			}
			if(editmask(admin->firstmask, p4, p5) == NULL) {
				return;
			}
			snprintf(stringbuffer, BIGSTRINGLEN, "changed mask for admin %s from %s to %s", p3, p4, p5);
			sendreply(to, tochan, 0, 1, stringbuffer);
			return;
		}
		if(!strcasecmp(p2, "user")) {
			if((this = getchptr(channel)) == NULL) {
				return;
			}
			for(user = this->users; user != NULL; user = user->next) {
				if(!strcasecmp(user->handle, p3)) {
					break;
				}
			}
			if(user == NULL) {
				return;
			}
			proceed = (isopa(host)) ? 1 : 0;
			if(index(user->options, (int)'a') != NULL) {
				/* the user has +a flag */
				if(isadmin(channel, host) && issameuser(channel, p3, host)) {
					proceed = 1;
				}
			} else {
				/* a normal user */
				if(isadmin(channel, host)) {
					proceed = 1;
				}
				if(isop(channel, host) && issameuser(channel, p3, host)) {
					proceed = 1;
				}
			}
			if(!proceed) {
				return;
			}
			if(editmask(user->firstmask, p4, p5) == NULL) {
				return;
			}
			snprintf(stringbuffer, BIGSTRINGLEN, "changed mask for %s channel user %s from %s to %s", this->name, p3, p4, p5);
			sendreply(to, tochan, 0, 1, stringbuffer);
			if(amiop(channel)) {
				syncvoices(channel);
				syncops(channel);
			}
			return;
		}
		return;
	}
}

void delcommand(char *to, int tochan, char *channel, char *nick, char *host, char *commandline)
{
	int proceed;
	int port;
	int modes;
	int ping;
	int opers;
	int noise;
	int req;
	int ppos;
	int nppos;
        char p1[STRINGLEN + 1];
        char p2[STRINGLEN + 1];
        char p3[STRINGLEN + 1];
        char p4[STRINGLEN + 1];
        char p5[STRINGLEN + 1];
        char p6[STRINGLEN + 1];
        char p7[STRINGLEN + 1];
	char stringbuffer[BIGSTRINGLEN + 1];
	char *ptr;
	struct channel *this;
	struct botuser *user;

	oer_debug(OER_DEBUG_INFO, "delcommand->command: %s\n", commandline);
	/* command line parsing begins here, first parameter = the command */
	ppos = 0;
        if((ppos = parse(commandline, ppos, " ", p1, STRINGLEN, 0)) < 0) {
                return;
        }
	if(!strcasecmp(p1, "admin")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if(!deladmin(p2)) {
			oer_debug(OER_DEBUG_INFO, "delcommand->%s!%s attempted to delete protected admin %s\n", nick, host, p2);
			return;
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "deleted admin %s", p2);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "chankey")) {
		if((numofparams(commandline) != 0)) {
			return;
		}
		if(!isadmin(channel, host)) {
			return;
		}
		if(delchankey(channel)) {
			snprintf(stringbuffer, BIGSTRINGLEN, "deleted channel key from %s", channel);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "channel")) {
		req = (tochan) ? 0 : 1;
		if((numofparams(commandline) != req)) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if(!tochan) {
			if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
				return;
			}
			ptr = p2;
		} else {
			ptr = channel;
		}
		if(delchannel(ptr)) {
			/* force save here since there is no way to get
			   back .chaninfo for a channel that was deleted */
			savechannels();
			savechaninfo();
			snprintf(stringbuffer, BIGSTRINGLEN, "deleted channel %s", ptr);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "user")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		for(user = this->users; user != NULL; user = user->next) {
			if(!strcasecmp(user->handle, p2)) {
				break;
			}
		}
		if(user == NULL) {
			return;
		}
		proceed = (isopa(host)) ? 1 : 0;
		if(index(user->options, (int)'a') == NULL) {
			/* a normal user */
			if(isadmin(channel, host)) {
				proceed = 1;
			}
		}
		if(!proceed) {
			return;
		}
		if(!deluser(channel, p2)) {
			return;
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "deleted %s channel user %s", channel, p2);
		sendreply(to, tochan, 0, 1, stringbuffer);
		if(amiop(channel)) {
			syncops(channel);
		}
		return;
	}
	if(!strcasecmp(p1, "mask")) {
		if(numofparams(commandline) != 3) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		if(!strcasecmp(p2, "admin")) {
			if(!isopa(host)) {
				return;
			}
			if(deladminmask(p3, p4)) {
				snprintf(stringbuffer, BIGSTRINGLEN, "deleted mask %s from admin %s", p3, p4);
				sendreply(to, tochan, 0, 1, stringbuffer);
			}
			return;
		}
		if(!strcasecmp(p2, "user")) {
			if((this = getchptr(channel)) == NULL) {
				return;
			}
			for(user = this->users; user != NULL; user = user->next) {
				if(!strcasecmp(user->handle, p3)) {
					break;
				}
			}
			if(user == NULL) {
				return;
			}
			proceed = (isopa(host)) ? 1 : 0;
			if(index(user->options, (int)'a') != NULL) {
				/* the user has +a flag */
				if(isadmin(channel, host) && issameuser(channel, p3, host)) {
					proceed = 1;
				}
			} else {
				/* a normal user */
				if(isadmin(channel, host)) {
					proceed = 1;
				}
				if(isop(channel, host) && issameuser(channel, p3, host)) {
					proceed = 1;
				}
			}
			if(!proceed) {
				return;
			}
			if(delusermask(channel, p3, p4)) {
				snprintf(stringbuffer, BIGSTRINGLEN, "deleted mask %s from %s user %s", p4, channel, p3);
				sendreply(to, tochan, 0, 1, stringbuffer);
				if(amiop(channel)) {
					syncops(channel);
				}
			}
			return;
		}
		return;
	}
	if(!strcasecmp(p1, "permban")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		while(1) {
                        nppos = parse(commandline, ppos, " ", p2, NICKLEN, 0);
                        if(nppos == ppos || nppos < 0) {
                                break;
                        }
			ppos = nppos;
			if(delpermban(channel, p2)) {
				snprintf(stringbuffer, BIGSTRINGLEN, "removed permban %s from channel %s", p2, channel);
				sendreply(to, tochan, 0, 1, stringbuffer);
				if(amiop(channel)) {
					addnewmm(channel, mystate->now, "-b", p2);
				}
			}
		}
		return;
	}
	if(!strcasecmp(p1, "nickbk")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		while(1) {
                        nppos = parse(commandline, ppos, " ", p2, NICKLEN, 0);
                        if(nppos == ppos || nppos < 0) {
                                break;
                        }
			ppos = nppos;
			if(delnickbk(channel, p2)) {
				snprintf(stringbuffer, BIGSTRINGLEN, "removed nickbk %s from channel %s", p2, channel);
				sendreply(to, tochan, 0, 1, stringbuffer);
			}
		}
		return;
	}
	if(!strcasecmp(p1, "wordbk")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		while(1) {
                        nppos = parse(commandline, ppos, " ", p2, NICKLEN, 0);
                        if(nppos == ppos || nppos < 0) {
                                break;
                        }
			ppos = nppos;
			if(delwordbk(channel, p2)) {
				snprintf(stringbuffer, BIGSTRINGLEN, "removed wordbk %s from channel %s", p2, channel);
				sendreply(to, tochan, 0, 1, stringbuffer);
			}
		}
		return;
	}
	if(!strcasecmp(p1, "kickreason")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if(delkickreason(commandline + ppos)) {
			snprintf(stringbuffer, BIGSTRINGLEN, "removed kickreason: %s", commandline + ppos);
			sendreply(to, tochan, 0, 1, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "trusted")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		while(1) {
                        nppos = parse(commandline, ppos, " ", p2, NICKLEN, 0);
                        if(nppos == ppos || nppos < 0) {
                                break;
                        }
			ppos = nppos;
			if(deltrusted(p2)) {
				snprintf(stringbuffer, BIGSTRINGLEN, "removed trusted domain %s", p2);
				sendreply(to, tochan, 0, 1, stringbuffer);
			}
		}
		return;
	}
	if(!strncasecmp(commandline, "server", 6)) {
		if(numofparams(commandline) != 6) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if(!strlen(p3)) {
			return;
		}
		port = atoi(p3);
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		modes = (strlen(p4) > 0) ? atoi(p4) : 6;
		if((ppos = parse(commandline, ppos, " ", p5, STRINGLEN, 0)) < 0) {
			return;
		}
		ping = (strlen(p5) > 0) ? atoi(p5) : 90;
		if((ppos = parse(commandline, ppos, " ", p6, STRINGLEN, 0)) < 0) {
			return;
		}
		opers = (strlen(p6) > 0) ? atoi(p6) : 1;
		if((ppos = parse(commandline, ppos, " ", p7, STRINGLEN, 0)) < 0) {
			return;
		}
		noise = (strlen(p7) > 0) ? atoi(p7) : 1;
		if(!delserver(p2, port, modes, ping, opers, noise)) {
			return;
		}
                snprintf(stringbuffer, BIGSTRINGLEN, "removed IRC server: %s %d %d %d %d %d", p2, port, modes, ping, opers, noise);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
}

void addcommand(char *to, int tochan, char *channel, char *nick, char *host, char *commandline)
{
	int amount;
	int port;
	int modes;
	int ping;
	int opers;
	int noise;
	int proceed;
	int ppos;
	int nppos;
        char p1[STRINGLEN + 1];
        char p2[STRINGLEN + 1];
        char p3[STRINGLEN + 1];
        char p4[STRINGLEN + 1];
        char p5[STRINGLEN + 1];
        char p6[STRINGLEN + 1];
        char p7[STRINGLEN + 1];
	char stringbuffer[BIGSTRINGLEN + 1];
	struct botuser *user;
	struct maskstruct *ms;
	struct channel *this;
	struct server *server;

	oer_debug(OER_DEBUG_INFO, "addcommand->command: %s\n", commandline);
	/* command line parsing begins here, first parameter = the command */
	ppos = 0;
        if((ppos = parse(commandline, ppos, " ", p1, STRINGLEN, 0)) < 0) {
                return;
        }
	if(!strcasecmp(p1, "channel")) {
		if(numofparams(commandline) != 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((this = addnewchannel(p2)) == NULL) {
			return;
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "added new channel %s", p2);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "server")) {
		if(numofparams(commandline) != 2 && numofparams(commandline) != 6) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if(!strlen(p3)) {
			return;
		}
		port = atoi(p3);
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		modes = (strlen(p4) > 0) ? atoi(p4) : 6;
		if((ppos = parse(commandline, ppos, " ", p5, STRINGLEN, 0)) < 0) {
			return;
		}
		ping = (strlen(p5) > 0) ? atoi(p5) : 90;
		if((ppos = parse(commandline, ppos, " ", p6, STRINGLEN, 0)) < 0) {
			return;
		}
		opers = (strlen(p6) > 0) ? atoi(p6) : 1;
		if((ppos = parse(commandline, ppos, " ", p7, STRINGLEN, 0)) < 0) {
			return;
		}
		noise = (strlen(p7) > 0) ? atoi(p7) : 0;
		if((server = addnewserver(p2, port, modes, ping, opers, noise)) == NULL) {
			return;
		}
                snprintf(stringbuffer, BIGSTRINGLEN, "added new IRC server: %s %d %d %d %d %d", server->serverhost, server->serverport, server->servermodes, server->pingfrequency, server->protected_ircops, server->linenoise);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "admin")) {
		if(numofparams(commandline) != 2) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		/* only allow +n admins to add other +n admins */
		if((index(p3, (int)'n') != NULL) && !hasadminflags(host, "n")) {
			return;
		}
		if((user = addnewadmin(p2, p3)) == NULL) {
			return;
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "added admin %s as %s", p2, p3);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "user")) {
		if(numofparams(commandline) != 2) {
			return;
		}
		if(!isadmin(channel, host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if(index(p3, (int)'a') != NULL) {
			/* only admins can add +a users */
			if(!isopa(host)) {
				return;
			}
		}
		if((user = addnewuser(channel, p2, p3)) == NULL) {
			return;
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "added user %s to channel %s as %s", p2, channel, p3);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "mask")) {
		if(numofparams(commandline) != 3) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p4, STRINGLEN, 0)) < 0) {
			return;
		}
		if(!strcasecmp(p2, "admin")) {
			if(!isopa(host)) {
				return;
			}
			if((ms = addnewadminmask(p3, p4)) == NULL) {
				return;
			}
			snprintf(stringbuffer, BIGSTRINGLEN, "added mask %s to admin %s", p4, p3);
			sendreply(to, tochan, 0, 1, stringbuffer);
			return;
		}
		if(!strcasecmp(p2, "user")) {
			if((this = getchptr(channel)) == NULL) {
				return;
			}
			for(user = this->users; user != NULL; user = user->next) {
				if(!strcasecmp(user->handle, p3)) {
					break;
				}
			}
			if(user == NULL) {
				return;
			}
			proceed = (isopa(host)) ? 1 : 0;
			if(index(user->options, (int)'a') != NULL) {
				/* the user has +a flag */
				if(isadmin(channel, host) && issameuser(channel, p3, host)) {
					proceed = 1;
				}
			} else {
				/* a normal user */
				if(isadmin(channel, host)) {
					proceed = 1;
				}
				if(isop(channel, host) && issameuser(channel, p3, host)) {
					proceed = 1;
				}
			}
			if(!proceed) {
				return;
			}
			if((ms = addnewusermask(channel, p3, p4)) == NULL) {
				return;
			}
			snprintf(stringbuffer, BIGSTRINGLEN, "added mask %s to %s user %s", p4, channel, p3);
			sendreply(to, tochan, 0, 1, stringbuffer);
			if(amiop(channel)) {
				syncvoices(channel);
				syncops(channel);
			}
			return;
		}
		return;
	}
	if(!strcasecmp(p1, "permban")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		while(1) {
                        nppos = parse(commandline, ppos, " ", p2, NICKLEN, 0);
                        if(nppos == ppos || nppos < 0) {
                                break;
                        }
			ppos = nppos;
			amount = permbancount(to);
			if(amount >= OER_PERMBANS) {
				snprintf(stringbuffer, BIGSTRINGLEN, "I won't add permban %s to channel %s (max. %d)", p2, channel, OER_PERMBANS);
				sendreply(to, tochan, 0, 1, stringbuffer);
				return;
			}
			if((ms = addnewpermban(channel, p2)) != NULL) {
				if(amiop(channel)) {
					addnewmm(channel, mystate->now, "+b", ms->mask);
				}
				snprintf(stringbuffer, BIGSTRINGLEN, "added new permban %s to channel %s", ms->mask, channel);
				sendreply(to, tochan, 0, 1, stringbuffer);
			}
		}
		return;
	}
	if(!strcasecmp(p1, "nickbk")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		if(strlen(commandline + ppos) > 0) {
			snprintf(stringbuffer, BIGSTRINGLEN, "%s (%s)", commandline + ppos, nick);
		} else {
			snprintf(stringbuffer, BIGSTRINGLEN, "unknown (%s)", nick);
		}
		if((ms = addnewnickbk(channel, p2, stringbuffer)) == NULL) {
			return;
		}
		if(amiop(channel)) {
			syncnickbks(channel);
		}
		snprintf(stringbuffer, BIGSTRINGLEN, "added nick %s as ban & kick for channel %s", ms->mask, channel);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "wordbk")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		while(1) {
                        nppos = parse(commandline, ppos, " ", p2, NICKLEN, 0);
                        if(nppos == ppos || nppos < 0) {
                                break;
                        }
			ppos = nppos;
			if((ms = addnewwordbk(channel, p2)) == NULL) {
				return;
			}
			snprintf(stringbuffer, BIGSTRINGLEN, "added word %s as ban & kick for channel %s", ms->mask, channel);
			sendreply(to, tochan, 0, 1, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "kickreason")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		if(strlen(commandline + ppos) > 0) {
			/* check that the kickreason doesn't exist already */
			for(ms = mystate->kickreasons; ms != NULL; ms = ms->next) {
				if(!strcasecmp(ms->mask, commandline + ppos)) {
					snprintf(stringbuffer, BIGSTRINGLEN, "kickreason %s already exists", commandline + ppos);
					sendreply(to, tochan, 0, 1, stringbuffer);
					return;
				}
			}
			if((ms = addnewkickreason(commandline + ppos)) == NULL) {
				return;
			}
			snprintf(stringbuffer, BIGSTRINGLEN, "added new kickreason: %s", ms->mask);
			sendreply(to, tochan, 0, 1, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "trusted")) {
		if(numofparams(commandline) < 1) {
			return;
		}
		if(!isopa(host)) {
			return;
		}
		while(1) {
                        nppos = parse(commandline, ppos, " ", p2, NICKLEN, 0);
                        if(nppos == ppos || nppos < 0) {
                                break;
                        }
			ppos = nppos;
			/* check that the trust doesn't exist already */
			for(ms = mystate->trusted; ms != NULL; ms = ms->next) {
				if(!strcasecmp(ms->mask, p2)) {
					snprintf(stringbuffer, BIGSTRINGLEN, "trusted domain %s already exists", ms->mask);
					sendreply(to, tochan, 0, 1, stringbuffer);
					return;
				}
			}
			if((ms = addnewtrusted(p2)) == NULL) {
				return;
			}
			snprintf(stringbuffer, BIGSTRINGLEN, "added new trusted %s", ms->mask);
			sendreply(to, tochan, 0, 1, stringbuffer);
		}
		return;
	}
}

void listcommand(char *to, int tochan, char *channel, char *nick, char *host, char *commandline)
{
	int lines;
	int startpos;
	int curpos;
	int more;
	int amount;
	int ppos;
	int proceed;
        char p1[STRINGLEN + 1];
        char p2[STRINGLEN + 1];
        char p3[STRINGLEN + 1];
	char outstring[STRINGLEN + 1];
	char stringbuffer[HUGESTRINGLEN + 1];
	char stringbuffer2[HUGESTRINGLEN + 1];
	struct server *server;
	struct channel *this;
	struct botuser *admin;
	struct botuser *user;
	struct maskstruct *ms;
	struct chanuser *cu;
	struct authed *a;

	ppos = 0;
        if((ppos = parse(commandline, ppos, " ", p1, STRINGLEN, 0)) < 0) {
                return;
        }
	if(!strcasecmp(p1, "nick")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "nick: %s", mystate->nick);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "user")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "user: %s", mystate->user);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "flags")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "flags: %s", mystate->flags);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "prefix")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "prefix is set to %c", mystate->prefix);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "usermode")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "usermode: %s", mystate->mode);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "realname")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "realname: %s", mystate->realname);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "vhost")) {
		if(mystate->vhost) {
			snprintf(stringbuffer, HUGESTRINGLEN, "vhost: %s", mystate->host);
		} else {
			strncpy(stringbuffer, "vhost: (null)", HUGESTRINGLEN);
		}
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "servers")) {
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		for(server = mystate->servers, lines = 0, curpos = 1, more = 0; server != NULL; server = server->next, curpos++) {
			if(lines < OER_MAX_LIST_LINES) {
				if(curpos >= startpos) {
					snprintf(stringbuffer, HUGESTRINGLEN, "%s %d %d %d %d %d%s", server->serverhost, server->serverport, server->servermodes, server->pingfrequency, server->protected_ircops, server->linenoise, (server == mystate->current_server) ? " (current)" : "");
					sendreply(to, tochan, 0, 0, stringbuffer);
					lines++;
				}
			} else {
				more = 1;
			}
		}
		if(more) {
			snprintf(stringbuffer, HUGESTRINGLEN, "%d servers, listing limited to %d lines", curpos - 1, OER_MAX_LIST_LINES);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "channels")) {
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		for(this = mystate->channels, lines = 0, curpos = 1, more = 0; this != NULL; this = this->next, curpos++) {
			if(!isatleastopnow(this->name, nick, host)) {
				/* do not show everything */
				continue;
                        }
			if(lines < OER_MAX_LIST_LINES) {
				if(curpos >= startpos) {
					if(this->haskey) {
						snprintf(stringbuffer, HUGESTRINGLEN, "channel: %s (%s)", this->name, this->key);
					} else {
						snprintf(stringbuffer, HUGESTRINGLEN, "channel: %s", this->name);
					}
					sendreply(to, tochan, 0, 0, stringbuffer);
					lines++;
				}
			} else {
				more = 1;
			}
		}
		if(more) {
			snprintf(stringbuffer, HUGESTRINGLEN, "%d channels, listing limited to %d lines", curpos - 1, OER_MAX_LIST_LINES);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "trusted")) {
		if(!isopa(host)) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		for(ms = mystate->trusted, lines = 0, curpos = 1, more = 0; ms != NULL; ms = ms->next, curpos++) {
			if(lines < OER_MAX_LIST_LINES) {
				if(curpos >= startpos) {
					snprintf(stringbuffer, HUGESTRINGLEN, "trusted: %s", ms->mask);
					sendreply(to, tochan, 0, 0, stringbuffer);
					lines++;
				}
			} else {
				more = 1;
			}
		}
		if(more) {
			snprintf(stringbuffer, HUGESTRINGLEN, "%d safe domains, listing limited to %d lines", curpos - 1, OER_MAX_LIST_LINES);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "admins")) {
		if(numofparams(commandline) >= 1) {
			if(!isopa(host)) {
				return;
			}
			if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
				return;
			}
			if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
				return;
			}
			for(admin = mystate->admins; admin != NULL; admin = admin->next) {
				if(!strcasecmp(admin->handle, p2)) {
					break;
				}
			}
			if(admin == NULL) {
				return;
			}
			if(strlen(p3) > 0) {
				startpos = atoi(p3);
			} else {
				startpos = 1;
				/* only send header info if no startpos */
				snprintf(stringbuffer, HUGESTRINGLEN, "options for admin %s: %s", admin->handle, admin->options);
				sendreply(to, tochan, 0, 0, stringbuffer);
			}
			for(ms = admin->firstmask, lines = 0, curpos = 1, more = 0; ms != NULL; ms = ms->next, curpos++) {
				if(lines < OER_MAX_LIST_LINES) {
					if(curpos >= startpos) {
						snprintf(stringbuffer, HUGESTRINGLEN, "hostmask for admin %s: %s", admin->handle, ms->mask);
						sendreply(to, tochan, 0, 0, stringbuffer);
						lines++;
					}
				} else {
					more = 1;
				}
			}
			if(more) {
				snprintf(stringbuffer, HUGESTRINGLEN, "%d hostmasks in total, listing limited to %d lines", curpos - 1, OER_MAX_LIST_LINES);
				sendreply(to, tochan, 0, 0, stringbuffer);
			}
			return;
		}
		/* no parameters, list all admins */
		memset(stringbuffer, 0, HUGESTRINGLEN + 1);
		strncpy(stringbuffer, "admins: ", HUGESTRINGLEN);
		admin = mystate->admins;
		while(admin != NULL) {
			if(strlen(stringbuffer) + strlen(admin->handle) > HUGESTRINGLEN) {
				sendreply(to, tochan, 0, 0, stringbuffer);
				memset(stringbuffer, 0, HUGESTRINGLEN + 1);
				strncpy(stringbuffer, "admins: ", HUGESTRINGLEN);
			}
			strncat(stringbuffer, admin->handle, HUGESTRINGLEN - strlen(stringbuffer));
			strncat(stringbuffer, " ", HUGESTRINGLEN - strlen(stringbuffer));
			admin = admin->next;
		}
		if(strlen(stringbuffer) > 0) {
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "kickreasons")) {
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		for(ms = mystate->kickreasons, lines = 0, curpos = 1, more = 0; ms != NULL; ms = ms->next, curpos++) {
			if(lines < OER_MAX_LIST_LINES) {
				if(curpos >= startpos) {
					snprintf(stringbuffer, HUGESTRINGLEN, "kickreason: %s", ms->mask);
					sendreply(to, tochan, 0, 0, stringbuffer);
					lines++;
				}
			} else {
				more = 1;
			}
		}
		if(more) {
			snprintf(stringbuffer, HUGESTRINGLEN, "%d kickreasons, listing limited to %d lines", curpos - 1, OER_MAX_LIST_LINES);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "chankey")) {
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "channel key: %s", this->key);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "chanmode")) {
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "channel mode: %s", this->mode);
		sendreply(to, tochan, 0, 1, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "chanflags")) {
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		memset(outstring, 0, STRINGLEN + 1);
		memset(stringbuffer, 0, HUGESTRINGLEN + 1);
		strncat(outstring, (haschanflags(this->name, "a")) ? "a" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "a")) ? "a/ansi_prot=1 " : "a/ansi_prot=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "b")) ? "b" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "b")) ? "b/ban_prot=1 " : "b/ban_prot=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "e")) ? "e" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "e")) ? "e/perm_bans=1 " : "e/perm_bans=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "f")) ? "f" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "f")) ? "f/pubmsg_floodp=1 " : "f/pubmsg_floodp=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "F")) ? "F" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "F")) ? "F/friends=1 " : "F/friends=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "l")) ? "l" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "l")) ? "l/lock_chan=1 " : "l/lock_chan=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "L")) ? "L" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "L")) ? "L/last=1 " : "L/last=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "m")) ? "m" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "m")) ? "m/mass_prot=1 " : "m/mass_prot=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "n")) ? "n" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "n")) ? "n/nick_bk=1 " : "n/nick_bk=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "o")) ? "o" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "o")) ? "o/auto_op=1 " : "o/auto_op=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "O")) ? "O" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "O")) ? "O/auto_op_admins=1 " : "O/auto_op_adims=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "p")) ? "p" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "p")) ? "p/postnj_check=1 " : "p/postnj_check=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "P")) ? "P" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "P")) ? "P/paranoid=1 " : "P/paranoid=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "q")) ? "q" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "q")) ? "q/quote=1 " : "q/quote=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "r")) ? "r" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "r")) ? "r/autorejoin_kb=1 " : "r/autorejoin_kb=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "S")) ? "S" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "S")) ? "S/seen=1 " : "S/seen=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "u")) ? "u" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "u")) ? "u/users_op=1 " : "u/users_op=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "v")) ? "v" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "v")) ? "v/auto_voice=1 " : "v/auto_voice=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		strncat(outstring, (haschanflags(this->name, "w")) ? "w" : "", STRINGLEN - strlen(outstring));
		strncat(stringbuffer, (haschanflags(this->name, "w")) ? "w/word_bk=1 " : "w/word_bk=0 ", HUGESTRINGLEN - strlen(stringbuffer));
		/* strip leading space if any */
		if(strlen(stringbuffer)) {
			stringbuffer[strlen(stringbuffer) - 1] = '\0';
		}
		snprintf(stringbuffer2, HUGESTRINGLEN, "channel flags for %s are [%s] %s", this->name, outstring, stringbuffer);
		sendreply(to, tochan, 0, 1, stringbuffer2);
		return;
	}
	if(!strcasecmp(p1, "users")) {
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		if(numofparams(commandline) >= 1) {
			if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
				return;
			}
			if((ppos = parse(commandline, ppos, " ", p3, STRINGLEN, 0)) < 0) {
				return;
			}
			for(user = this->users; user != NULL; user = user->next) {
				if(!strcasecmp(user->handle, p2)) {
					break;
				}
			}
			if(user == NULL) {
				return;
			}
			proceed = (isopa(host)) ? 1 : 0;
			if(index(user->options, (int)'a') != NULL) {
				if(isadmin(channel, host)) {
					proceed = 1;
				}
			} else {
				proceed = 1;
			}
			if(!proceed) {
				return;
			}
			if(strlen(p3) > 0) {
				startpos = atoi(p3);
			} else {
				startpos = 1;
				/* only send header info if no startpos */
				snprintf(stringbuffer, HUGESTRINGLEN, "options for user %s: %s", user->handle, user->options);
				sendreply(to, tochan, 0, 0, stringbuffer);
			}
			for(ms = user->firstmask, lines = 0, curpos = 1, more = 0; ms != NULL; ms = ms->next, curpos++) {
				if(lines < OER_MAX_LIST_LINES) {
					if(curpos >= startpos) {
						snprintf(stringbuffer, HUGESTRINGLEN, "hostmask for user %s: %s", user->handle, ms->mask);
						sendreply(to, tochan, 0, 0, stringbuffer);
						lines++;
					}
				} else {
					more = 1;
				}
			}
			if(more) {
				snprintf(stringbuffer, HUGESTRINGLEN, "%d hostmasks in total, listing limited to %d lines", curpos - 1, OER_MAX_LIST_LINES);
				sendreply(to, tochan, 0, 0, stringbuffer);
			}
			return;
		}
                /* no parameters, list all channel operators */
		memset(stringbuffer, 0, HUGESTRINGLEN + 1);
		snprintf(stringbuffer, HUGESTRINGLEN, "%s users: ", this->name);
		for(user = this->users; user != NULL; user = user->next) {
			if(strlen(stringbuffer) + strlen(user->handle) > HUGESTRINGLEN) {
				sendreply(to, tochan, 0, 0, stringbuffer);
				memset(stringbuffer, 0, HUGESTRINGLEN + 1);
				snprintf(stringbuffer, HUGESTRINGLEN, "%s users: ", this->name);
			}
			if(index(user->options, (int)'a') != NULL) {
				strncat(stringbuffer, "*", HUGESTRINGLEN - strlen(stringbuffer));
			}
			strncat(stringbuffer, user->handle, HUGESTRINGLEN - strlen(stringbuffer));
			strncat(stringbuffer, " ", HUGESTRINGLEN - strlen(stringbuffer));
		}
		if(strlen(stringbuffer) > 0) {
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "nicks")) {
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		if(numofparams(commandline) >= 1) {
			if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
				return;
			}
			for(cu = this->nicks; cu != NULL; cu = cu->next) {
				if(!strcasecmp(cu->nick, p2)) {
					break;
				}
			}
			if(cu == NULL) {
				return;
			}
			snprintf(stringbuffer, HUGESTRINGLEN, "%s!%s (ircop=%d chanop=%d voice=%d)", cu->nick, cu->host, cu->ircop, cu->chanop, cu->voice);
			sendreply(to, tochan, 0, 0, stringbuffer);
			return;
		}
                /* no parameters, list all channel nicks */
		amount = 0;
		memset(stringbuffer, 0, HUGESTRINGLEN + 1);
		cu = this->nicks;
		while(cu != NULL) {
			if((strlen(stringbuffer) + CHANLEN + NICKLEN + 16) > HUGESTRINGLEN) {
				/* send the thing, empty string */
				snprintf(stringbuffer2, HUGESTRINGLEN, "nicks on %s [%d]:", this->name, amount);
				strncat(stringbuffer2, stringbuffer, HUGESTRINGLEN - strlen(stringbuffer2));
				sendreply(to, tochan, 0, 0, stringbuffer2);
				amount = 0;
				memset(stringbuffer, 0, HUGESTRINGLEN + 1);
			}
			strncat(stringbuffer, " ", HUGESTRINGLEN - strlen(stringbuffer));
			if(cu->ircop) {
				strncat(stringbuffer, "*", HUGESTRINGLEN - strlen(stringbuffer));
			}
			if(cu->voice) {
				strncat(stringbuffer, "+", HUGESTRINGLEN - strlen(stringbuffer));
			}
			if(cu->chanop) {
				strncat(stringbuffer, "@", HUGESTRINGLEN - strlen(stringbuffer));
			}
			strncat(stringbuffer, cu->nick, HUGESTRINGLEN - strlen(stringbuffer));
			amount++;
			cu = cu->next;
		}
		if(amount > 0) {
			snprintf(stringbuffer2, HUGESTRINGLEN, "nicks on %s [%d]:", this->name, amount);
			strncat(stringbuffer2, stringbuffer, HUGESTRINGLEN - strlen(stringbuffer2));
			sendreply(to, tochan, 0, 0, stringbuffer2);
		}
		return;
	}
	if(!strcasecmp(p1, "wordbks")) {
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		for(ms = this->wordbks, lines = 0, curpos = 1, more = 0; ms != NULL; ms = ms->next, curpos++) {
			if(lines < OER_MAX_LIST_LINES) {
				if(curpos >= startpos) {
					snprintf(stringbuffer, HUGESTRINGLEN, "%s wordbk: %s", this->name, ms->mask);
					sendreply(to, tochan, 0, 0, stringbuffer);
					lines++;
				}
			} else {
				more = 1;
			}
		}
		if(more) {
			snprintf(stringbuffer, HUGESTRINGLEN, "%d %s wordbks, listing limited to %d lines", curpos - 1, this->name, OER_MAX_LIST_LINES);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "nickbks")) {
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		for(ms = this->nickbks, lines = 0, curpos = 1, more = 0; ms != NULL; ms = ms->next, curpos++) {
			if(lines < OER_MAX_LIST_LINES) {
				if(curpos >= startpos) {
					snprintf(stringbuffer, HUGESTRINGLEN, "%s nickbk: %s (%s)", this->name, ms->mask, ms->optstring);
					sendreply(to, tochan, 0, 0, stringbuffer);
					lines++;
				}
			} else {
				more = 1;
			}
		}
		if(more) {
			snprintf(stringbuffer, HUGESTRINGLEN, "%d %s nickbks, listing limited to %d lines", curpos - 1, this->name, OER_MAX_LIST_LINES);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "permbans")) {
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
			return;
		}
		startpos =  (strlen(p2) > 0) ? atoi(p2) : 1;
		for(ms = this->permbans, lines = 0, curpos = 1, more = 0; ms != NULL; ms = ms->next, curpos++) {
			if(lines < OER_MAX_LIST_LINES) {
				if(curpos >= startpos) {
					snprintf(stringbuffer, HUGESTRINGLEN, "%s permban: %s", this->name, ms->mask);
					sendreply(to, tochan, 0, 0, stringbuffer);
					lines++;
				}
			} else {
				more = 1;
			}
		}
		if(more) {
			snprintf(stringbuffer, HUGESTRINGLEN, "%d %s permbans, listing limited to %d lines", curpos - 1, this->name, OER_MAX_LIST_LINES);
			sendreply(to, tochan, 0, 0, stringbuffer);
		}
		return;
	}
	if(!strcasecmp(p1, "floodvars")) {
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "%s floodvars are %d %d %d %d %d", this->name, this->floodvars.repeat_expire, this->floodvars.repeat_limit, this->floodvars.interval, this->floodvars.lines, this->floodvars.chars);
		sendreply(to, tochan, 0, 0, stringbuffer);
	}
	if(!strcasecmp(p1, "banvars")) {
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "%s banvars are %d %d %d %d %d %d %d", this->name, this->banvars.auto_rejoin, this->banvars.part_rejoin, this->banvars.public_flood, this->banvars.public_flood_repeat, this->banvars.bad_word, this->banvars.bad_nick, this->banvars.normal_ban);
		sendreply(to, tochan, 0, 0, stringbuffer);
	}
	if(!strcasecmp(p1, "autheds")) {
		if(!isatleastopnow(channel, nick, host)) {
			return;
		}
		if((this = getchptr(channel)) == NULL) {
			return;
		}
		if(numofparams(commandline) >= 1) {
			if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
				return;
			}
			proceed = (isadmin(this->name, host)) ? 1 : 0;
			if(issameuser(this->name, p2, host)) {
				proceed = 1;
			}
			if(!proceed) {
				return;
			}
			for(a = this->autheds; a != NULL; a = a->next) {
				if(mystate->now > (a->at + OER_LOGON_TIMEOUT)) {
					continue;
				}
				if(!strcasecmp(a->user->handle, p2)) {
					snprintf(stringbuffer, HUGESTRINGLEN, "%s is authed from %s", a->user->handle, a->host);
					sendreply(to, tochan, 0, 0, stringbuffer);
				}
			}
			return;
		}
                /* no parameters, list all autheds for channel */
		amount = 0;
		memset(stringbuffer, 0, HUGESTRINGLEN + 1);
		a = this->autheds;
		while(a != NULL) {
			if((strlen(stringbuffer) + CHANLEN + NICKLEN + 16) > HUGESTRINGLEN) {
				/* send the thing, empty string */
				snprintf(stringbuffer2, HUGESTRINGLEN, "autheds on %s [%d]:", this->name, amount);
				strncat(stringbuffer2, stringbuffer, HUGESTRINGLEN - strlen(stringbuffer2));
				sendreply(to, tochan, 0, 0, stringbuffer2);
				amount = 0;
				memset(stringbuffer, 0, HUGESTRINGLEN + 1);
			}
			strncat(stringbuffer, " ", HUGESTRINGLEN - strlen(stringbuffer));
			if(mystate->now > (a->at + OER_LOGON_TIMEOUT)) {
				strncat(stringbuffer, "!", HUGESTRINGLEN - strlen(stringbuffer));
			}
			strncat(stringbuffer, a->user->handle, HUGESTRINGLEN - strlen(stringbuffer));
			amount++;
			a = a->next;
		}
		if(amount > 0) {
			snprintf(stringbuffer2, HUGESTRINGLEN, "autheds on %s [%d]:", this->name, amount);
			strncat(stringbuffer2, stringbuffer, HUGESTRINGLEN - strlen(stringbuffer2));
			sendreply(to, tochan, 0, 0, stringbuffer2);
		}
		return;
	}
}

void logoffcommand(char *to, int tochan, char *channel, char *nick, char *host, char *commandline)
{
	int ppos;
        char p1[STRINGLEN + 1];
	char stringbuffer[HUGESTRINGLEN + 1];

	oer_debug(OER_DEBUG_INFO, "logoffcommand->from %s!%s for channel %s\n", nick, host, channel);
	/* command line parsing begins here, first parameter = the command */
	ppos = 0;
        if((ppos = parse(commandline, ppos, " ", p1, STRINGLEN, 0)) < 0) {
                return;
        }
	if(!strlen(p1)) {
		return;
	}
	if(isopa(host)) {
		oer_debug(OER_DEBUG_INFO, "logoffcommand->admin logoff for handle %s\n", p1);
		if(!logoff(channel, p1)) {
			oer_debug(OER_DEBUG_INFO, "logoffcommand->admin logoff failed for handle %s\n", p1);
			return;
		}
	} else {
		oer_debug(OER_DEBUG_INFO, "logoffcommand->logoff for handle %s\n", p1);
		if(!issameuser(channel, p1, host)) {
			oer_debug(OER_DEBUG_INFO, "logoffcommand->invalid logoff attempt for handle %s\n", p1);
			return;
		}
		if(!logoff(channel, p1)) {
			oer_debug(OER_DEBUG_INFO, "logoffcommand->logoff failed for handle %s\n", p1);
			return;
		}
	}
	/* logoff shouldn't cause a de-op */
	snprintf(stringbuffer, HUGESTRINGLEN, "%s user %s successfully logged off", channel, p1);
	sendreply(to, tochan, 0, 1, stringbuffer);
}

void logoncommand(char *to, int tochan, char *channel, char *nick, char *host, char *commandline)
{
	int admin;
	int ppos;
        char p1[STRINGLEN + 1];
        char p2[STRINGLEN + 1];
	char stringbuffer[HUGESTRINGLEN + 1];

	oer_debug(OER_DEBUG_INFO, "logoncommand->from %s!%s for channel %s\n", nick, host, channel);
	/* command line parsing begins here, first parameter = the command */
	ppos = 0;
        if((ppos = parse(commandline, ppos, " ", p1, STRINGLEN, 0)) < 0) {
                return;
        }
        if((ppos = parse(commandline, ppos, " ", p2, STRINGLEN, 0)) < 0) {
                return;
        }
	admin = (isopa(host)) ? 1 : 0;
	/* admins can logon anyone without password, they need
	 to specify the hostmask however */
	if(admin) {
		if(!strlen(p2)) {
			oer_debug(OER_DEBUG_INFO, "logoncommand->hostmask missing for admin logon\n");
			return;
		}
		oer_debug(OER_DEBUG_INFO, "logoncommand->admin logon for handle %s\n", p1);
		if(!issameuser(channel, p1, p2)) {
			oer_debug(OER_DEBUG_INFO, "logoncommand->hostmask %s is invalid for handle %s\n", p2, p1);
			return;
		}
		if(!logon(channel, p1, p2, p1, 1)) {
			oer_debug(OER_DEBUG_INFO, "logoncommand->admin logon failed for handle %s\n", p1);
			return;
		}
	} else {
		/* we require password for normal logon */
		if(!strlen(p2)) {
			oer_debug(OER_DEBUG_INFO, "logoncommand->password missing for logon\n");
			return;
		}
		oer_debug(OER_DEBUG_INFO, "logoncommand->logon for handle %s\n", p1);
		if(!issameuser(channel, p1, host)) {
			oer_debug(OER_DEBUG_INFO, "logoncommand->hostmask %s is invalid for handle %s\n", host, p1);
			return;
		}
		if(!logon(channel, p1, host, p2, 0)) {
			oer_debug(OER_DEBUG_INFO, "logoncommand->logon failed for handle %s password %s\n", p1, p2);
			return;
		}
	}
	snprintf(stringbuffer, HUGESTRINGLEN, "%s user %s successfully logged on", channel, p1);
	sendreply(to, tochan, 0, 1, stringbuffer);
	if(admin) {
		/* we don't know who is affected by the handle */
		channelsync(channel);
	} else {
		if(amiop(channel) && isonchan(channel, nick) && hasuserflags(channel, host, "do")) {
			addnewmm(channel, mystate->now, "+o", nick);
		}
	}
}

int logoff(char *channel, char *handle)
{
	struct channel *this;
	struct authed *a;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(a = this->autheds; a != NULL; a = a->next) {
		if(strcasecmp(a->user->handle, handle)) {
			continue;
		}
		a->at = 0;
	}
	cleanautheds(this->name);
	return 1;
}

int logon(char *channel, char *handle, char *mask, char *password, int admin)
{
	struct channel *this;
	struct botuser *user;
	char cryptsalt[3];
	char *crypted;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(user = this->users; user != NULL; user = user->next) {
		if(!strcasecmp(user->handle, handle)) {
			break;
		}
	}
	if(user == NULL) {
		return 0;
	}
	if(!admin) {
		cryptsalt[0] = user->password[0];
		cryptsalt[1] = user->password[1];
		cryptsalt[2] = '\0';
		crypted = crypt(password, cryptsalt);
		if(strcasecmp(user->password, crypted)) {
			return 0;
		}
	}
	if(addnewauthed(this->name, mystate->now, user, mask) == NULL) {
		return 0;
	}
	cleanautheds(this->name);
	return 1;
}

int setpassword(char *channel, char *handle, char *password)
{
	struct channel *this;
	struct botuser *user;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(user = this->users; user != NULL; user = user->next) {
		if(!strcasecmp(user->handle, handle)) {
			break;
		}
	}
	if(user == NULL) {
		return 0;
	}
	if(index(user->options, (int)'d') == NULL) {
		return 0;
	}
	strncpy(user->password, password, TINYSTRINGLEN);
	return 1;
}

void sendreply(char *target, int tochan, int delay, int randomness, char *message)
{
	time_t when;

	char stringbuffer[WRITE_BUFFER_LENGTH + 1];

	if(tochan) {
		snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "PRIVMSG %s :%s\n", target, message);
	} else {
		snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "NOTICE %s :%s\n", target, message);
	}
	/* the getrandom(4) - 1 was added to avoid Excess Floods,
	   a better solution would need to keep count of client->server msgs */
	if(randomness) {
		when = mystate->now + delay + (getrandom(4) - 1);
	} else {
		when = mystate->now + delay;
	}
	oer_debug(OER_DEBUG_INFO, "sendreply(%lu)->%s", when - mystate->now, stringbuffer);
	addnewtimed(when, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
}

void sendchannelnotice(char *channel, int delay, char *message)
{
	char stringbuffer[WRITE_BUFFER_LENGTH + 1];

	snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "NOTICE %s :%s\n", channel, message);
	oer_debug(OER_DEBUG_INFO, "sendchannelnotice->%s", stringbuffer);
	addnewtimed(mystate->now + delay, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
}

void kickuser(char *channel, char *nick, char *reason)
{
	struct channel *this;
	struct chanuser *cu;
	char stringbuffer[WRITE_BUFFER_LENGTH + 1];
	char kr[STRINGLEN + 1];

	oer_debug(OER_DEBUG_INFO, "kickuser->channel %s nick %s\n", channel, nick);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			break;
		}
	}
	if(cu == NULL) {
		return;
	}
	if(cu->host == NULL) {
		return;
	}
	if(reason != NULL) {
		striplf(reason);
		snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "KICK %s %s :%s\n", this->name, cu->nick, reason);
	} else {
		if(getkickreason(kr) != NULL) {
			snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "KICK %s %s :%s\n", this->name, cu->nick, kr);
		} else {
			snprintf(stringbuffer, WRITE_BUFFER_LENGTH, "KICK %s %s :%s\n", this->name, cu->nick, mystate->nick);
		}
	}
	addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
}

int isvoicenow(char *channel, char *nick)
{
	struct channel *this;
	struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick) && cu->voice) {
			return 1;
		}
	}
	return 0;
}

int nickchange(char *channel, char *nick, char *newnick)
{
	struct channel *this;
	struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			free(cu->nick);
			if((cu->nick = (char *) malloc(strlen(newnick) + 1)) == NULL) {
				return 0;
			}
			strcpy(cu->nick, newnick);
			return 1;
		}
	}
	return 0;
}

char *getlamer(char *channel)
{
	struct channel *this;
	struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		/* get a random lamer and mark for kicking */
		if(!cu->chanop && !cu->tobek && !isop(this->name, cu->host)) {
			if(cu->ircop && mystate->current_server->protected_ircops) {
				continue;
			}
			if(haschanflags(this->name, "F") && hasuserflags(this->name, cu->host, "f")) {
				continue;
			}
			cu->tobek = 1;
			oer_debug(OER_DEBUG_INFO, "getlamer->returning %s\n", cu->nick);
			return cu->nick;
		}
	}
	return NULL;
}

void cleartobeks(char *channel)
{
	struct channel *this;
	struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		cu->tobek = 0;
	}
}

int getrandom(int ceiling)
{
	/* returns a random number between 1 and ceiling */

        int thisrandom;
        struct timeval tv;

        gettimeofday(&tv, 0);
        srand(tv.tv_usec);
        thisrandom = 1 + (int) ((float) ceiling * rand() / (RAND_MAX + 1.0));
        return thisrandom;
}

struct chanuser *getrandomuser(char *channel)
{
	int nthuser;
	int counter;
	struct channel *this;
	struct chanuser *cu;
	struct chanuser *cu2;

        for(this = mystate->channels; this != NULL; this = this->next) {
                if(!strcasecmp(this->name, channel) && this->joined) {
			break;
		}
	}
	if(this == NULL) {
		return NULL;
	}
	nthuser = getrandom(this->nickcount) - 1;
	oer_debug(OER_DEBUG_INFO, "getrandomuser->the winner of %s is user in position %d\n", channel, nthuser);
	cu = this->nicks;
	counter = 0;
	while(cu != NULL && counter < nthuser) {
		counter++;
		cu = cu->next;
	}
	for(cu2 = cu; cu != NULL; cu = cu->prev) {
		if(cu->chanop) {
			continue;
		}
		if(cu->ircop) {
			if(!mystate->current_server->protected_ircops) {
				return cu;
			}
		}
		if(!haschanflags(this->name, "F") || (haschanflags(this->name, "F") && !hasuserflags(this->name, cu->host, "f"))) {
			return cu;
		}
	}
	for(cu = cu2; cu != NULL; cu = cu->next) {
		if(cu->chanop) {
			continue;
		}
		if(cu->ircop) {
			if(!mystate->current_server->protected_ircops) {
				return cu;
			}
		}
		if(!haschanflags(this->name, "F") || (haschanflags(this->name, "F") && !hasuserflags(this->name, cu->host, "f"))) {
			return cu;
		}
	}
	return NULL;
}

int allhostsknown(char *channel)
{
	struct chanuser *cu;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	if(!this->joined) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(cu->host == NULL) {
			return 0;
		}
	}
	return 1;
}

char *getfirsthostless(char *nick)
{
	struct chanuser *cu;
	struct channel *this;

        for(this = mystate->channels; this != NULL; this = this->next) {
		if(this->joined) {
			for(cu = this->nicks; cu != NULL; cu = cu->next) {
			    if(cu->host == NULL && !cu->hostquery) {
					strncpy(nick, cu->nick, NICKLEN);
					return nick;
				}
			}
		}
	}
	return NULL;
}

void sethostquerystatus(char *nick, int status)
{
	struct chanuser *cu;
	struct channel *this;

        for(this = mystate->channels; this != NULL; this = this->next) {
		for(cu = this->nicks; cu != NULL; cu = cu->next) {
			if(!strcasecmp(cu->nick, nick)) {
				cu->hostquery = status;
				/* optimization so we will jump to next channel */
				break;
			}
		}
	}
}

void setuserhost(char *nick, char *host)
{
	struct chanuser *cu;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "setuserhost->setting host %s to nick %s on all available channels\n", (host == NULL) ? "(null)" : host, nick);
        for(this = mystate->channels; this != NULL; this = this->next) {
		if(!this->joined) {
			continue;
		}
		for(cu = this->nicks; cu != NULL; cu = cu->next) {
			if(!strcasecmp(cu->nick, nick)) {
				if(cu->host != NULL) {
					free(cu->host);
				}
				/* we'll need sometimes to reset the host to
				   force a USERHOST query */
				if(host == NULL) {
					cu->host = NULL;
					break;
				}
				if((cu->host = (char *) malloc(strlen(host) + 1)) == NULL) {
					return;
				}
				strcpy(cu->host, host);
				/* optimization so we jump to next channel */
				break;
			}
		}
	}
}

int ishostless(char *nick)
{
	struct chanuser *cu;
	struct channel *this;

        for(this = mystate->channels; this != NULL; this = this->next) {
		if(!this->joined) {
			continue;
		}
		for(cu = this->nicks; cu != NULL; cu = cu->next) {
			if(!strcasecmp(cu->nick, nick)) {
				if(cu->host == NULL) {
					return 1;
				} else {
					return 0;
				}
			}
		}
	}
	return -1;
}

char *isnickbk(char *channel, char *nick)
{
	struct channel *this;
	struct maskstruct *nickbk;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	for(nickbk = this->nickbks; nickbk != NULL; nickbk = nickbk->next) {
		if(wild_match(nickbk->mask, nick)) {
			if(nickbk->optstring != NULL) {
				return nickbk->optstring;
			}
			return nick;
		}
	}
	return NULL;
}

int iswordbk(char *channel, char *message)
{
	struct channel *this;
	struct maskstruct *wordbk;

        for(this = mystate->channels; this != NULL; this = this->next) {
		if(!strcasecmp(this->name, channel)) {
			for(wordbk = this->wordbks; wordbk != NULL; wordbk = wordbk->next) {
				if(wild_match(wordbk->mask, message)) {
					return 1;
				}
			}
		}
        }
	return 0;
}

int isflood(char *channel, char *nick, char *host, char *message)
{
	int weight;
	int lines;
	int chars;
	int length;
	int repinterval;
	time_t first;
	time_t firstrep;
	struct channel *this;
	struct pubmsg *pm;

	oer_debug(OER_DEBUG_INFO, "isflood->%s!%s channel %s\n", nick, host, channel);
        for(this = mystate->channels; this != NULL; this = this->next) {
		if(!strcasecmp(this->name, channel)) {
			first = mystate->now;
			firstrep = mystate->now;
			lines = 1;
			length = strlen(message);
			chars = length;
			weight = 0;
			pm = this->pubmsgs;
			while(pm != NULL) {
				if(!strcasecmp(pm->nick, nick) && !strcasecmp(pm->host, host)) {
					if(pm->at < first) {
						first = pm->at;
					}
					if(!strcasecmp(pm->message, message)) {
						if(pm->at < firstrep) {
							firstrep = pm->at;
						}
						weight++;
					}
					lines++;
					chars += strlen(pm->message);
				}
				/* optimization, check for repeat-flood in each iteration */
				if((weight >= this->floodvars.repeat_limit - 1) && (length > 5) && (mystate->now - firstrep < this->floodvars.repeat_expire)) {
					/* immediate ban-kick */
					oer_debug(OER_DEBUG_INFO, "isflood->REPEAT delta: %lu lines: %d chars: %d weight: %d\n", mystate->now - firstrep, lines, chars, weight);
					return OER_PUBMSG_FLOOD_REPEAT;
				}
				pm = pm->next;
			}
			/* check for repeat with < 5 long pubmsgs */
			repinterval = (mystate->now - firstrep);
			if(repinterval) {
				repinterval /= weight;
			}
			oer_debug(OER_DEBUG_INFO, "isflood->repinterval is %d\n", repinterval);
			if((weight >= this->floodvars.repeat_limit - 1) && (length <= 5) \
			   && (repinterval < (this->floodvars.interval / this->floodvars.repeat_limit))) {
				oer_debug(OER_DEBUG_INFO, "isflood->REPEAT delta: %lu lines: %d chars: %d weight: %d\n", mystate->now - firstrep, lines, chars, weight);
					return OER_PUBMSG_FLOOD_REPEAT;
			}
			if((chars > this->floodvars.chars || lines > this->floodvars.lines) && mystate->now - first < this->floodvars.interval) {
				oer_debug(OER_DEBUG_INFO, "isflood->NORMAL delta: %lu lines: %d chars: %d weight: %d\n", mystate->now - first, lines, chars, weight);
					return OER_PUBMSG_FLOOD_NORMAL;
			}
			oer_debug(OER_DEBUG_INFO, "isflood->NO FLOOD delta: %lu lines: %d chars: %d weight: %d\n", mystate->now - first, lines, chars, weight);
			return OER_PUBMSG_FLOOD_NONE;
		}
        }
	return OER_PUBMSG_FLOOD_NONE;
}

void clearflood(char *channel, char *nick, char *host)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	freepubmsguser(this->name, nick, host);
}

int isvalidchannel(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	return 1;
}

int haschanflags(char *channel, char *flags)
{
	int i;
	int len;
	int got_flags;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	/* check if the channel has all the required flags set... */
	for(i = 0, got_flags = 0, len = strlen(flags); i < len; i++) {
		if(index(this->chanflags, (int)flags[i]) != NULL) {
			got_flags++;
		}
	}
	if(got_flags == len) {
		return 1;
	}
	return 0;
}

int hasadminflags(char *mask, char *flags)
{
	int i;
	int len;
	int got_flags;
	struct botuser *admin;
	struct maskstruct *ms;

	if(mask == NULL) {
		return 0;
	}
	/* go through all admins */
	for(admin = mystate->admins; admin != NULL; admin = admin->next) {
		/* check if the admin has all the required flags set... */
		for(i = 0, got_flags = 0, len = strlen(flags); i < len; i++) {
			if(index(admin->options, (int)flags[i]) != NULL) {
				got_flags++;
			}
		}
		if(got_flags != len) {
			/* nope, skip to next user */
			continue;
		}
		/* the admin has the right flags, what about hostmask? */
		for(ms = admin->firstmask; ms != NULL; ms = ms->next) {
			if(wild_match(ms->mask, mask)) {
				return 1;
			}
		}
	}
	return 0;
}

int hasuserflags(char *channel, char *mask, char *flags)
{
	int i;
	int len;
	int got_flags;
	struct channel *this;
	struct botuser *user;
	struct maskstruct *ms;

	if(mask == NULL) {
		return 0;
	}
	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	/* go through all channel users */
	for(user = this->users; user != NULL; user = user->next) {
		/* check if the user has all the required flags set... */
		for(i = 0, got_flags = 0, len = strlen(flags); i < len; i++) {
			if(index(user->options, (int)flags[i]) != NULL) {
				got_flags++;
			}
		}
		if(got_flags != len) {
			/* nope, skip to next user */
			continue;
		}
		/* the user has the right flags, what about hostmask? */
		for(ms = user->firstmask; ms != NULL; ms = ms->next) {
			if(wild_match(ms->mask, mask)) {
				return 1;
			}
		}
        }
	return 0;
}

void newchannel(char *channel)
{
	struct channel *this;

        for(this = mystate->channels; this != NULL; this = this->next) {
		if(!strcasecmp(this->name, channel)) {
			this->joined = 0;
			this->joining = 1;
                        this->rejoin_at = 0;
                        this->last_quote = 0;
			this->synced = 0;
			return;
		}
        }
}

void isjoined(char *channel)
{
	struct channel *this;
	char stringbuffer[STRINGLEN + 1];

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	this->joined = 1;
	this->joining = 0;
	if(haschanflags(channel, "S")) {
		snprintf(stringbuffer, STRINGLEN, "seen-%s", this->name);
		if((this->seen = fopen(stringbuffer, "a")) == NULL) {
			oer_debug(OER_DEBUG_INFO, "isjoined->failed to open %s: %s\n", stringbuffer, strerror(errno));
		}
	}
	if(haschanflags(channel, "L")) {
		snprintf(stringbuffer, STRINGLEN, "last-%s", this->name);
		if((this->last = fopen(stringbuffer, "a")) == NULL) {
			oer_debug(OER_DEBUG_INFO, "isjoined->failed to open %s: %s\n", stringbuffer, strerror(errno));
		}
	}
}

int usersonchan(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return -1;
	}
	return this->nickcount;
}

char *getchanmode(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	if(strlen(this->mode) > 0) {
		return this->mode;
	}
	return NULL;
}

char *getchankey(char *channel)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	if(!this->haskey) {
		return NULL;
	}
	return this->key;
}

void setchanmode(char *channel, char *mode)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	strncpy(this->mode, mode, CHANLEN);
	this->setchanmode = 1;
}

void setchankey(char *channel, char *key)
{
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	strncpy(this->key, key, CHANLEN);
	this->haskey = 1;
	this->setchanmode = 1;
}

int delchankey(char *channel)
{
	char stringbuffer[STRINGLEN + 1];
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	if(!this->haskey) {
		return 0;
	}
	snprintf(stringbuffer, STRINGLEN, "-k %s", this->key);
	addnewmm(this->name, mystate->now, stringbuffer, "");
	memset(this->key, 0, CHANLEN);
	this->haskey = 0;
	return 1;
}

char *safeban(char *safemask)
{
	int is_safe;
	struct maskstruct *ms;
	char safe[HOSTLEN + 1];
	char safe2[HOSTLEN + 1];

	oer_debug(OER_DEBUG_INFO, "safeban->%s\n", safemask);
	/* check that a domain ban wouldn't hurt us, if hurts go for the user@domain */
	strncpy(safe, index(safemask, '@') + 1, HOSTLEN);
	if(!strcasecmp(safe, mystate->host)) {
		/* check user@domain */
		strncpy(safe, mystate->nick, HOSTLEN);
		strncat(safe, "!", HOSTLEN - strlen(safe));
		strncat(safe, mystate->user, HOSTLEN - strlen(safe));
		strncat(safe, "@", HOSTLEN - strlen(safe));
		strncat(safe, mystate->host, HOSTLEN - strlen(safe));
		strncpy(safe2, "*!", HOSTLEN);
		strncat(safe2, mystate->user, HOSTLEN - strlen(safe2));
		strncat(safe2, "@", HOSTLEN - strlen(safe2));
		strncat(safe2, mystate->host, HOSTLEN - strlen(safe2));
		if(wild_match(safe2, safe)) {
			/* that's it, no ban for you */
			oer_debug(OER_DEBUG_INFO, "safeban->returning NULL\n");
			return NULL;
		} else {
			strcpy(safemask, safe2);
			oer_debug(OER_DEBUG_INFO, "safeban->returning %s\n", safemask);
			return safemask;
		}
	}
	/* domain-ban doesn't hurt us, what about trusted domains? */
	is_safe = 1;
	strncpy(safe, index(safemask, '@') + 1, HOSTLEN);
	for(ms = mystate->trusted; ms != NULL && is_safe; ms = ms->next) {
		if(!strcasecmp(safe, ms->mask)) {
			is_safe = 0;
		}
	}
	if(is_safe) {
		strncpy(safe, "*!*@", HOSTLEN);
		strncat(safe, index(safemask, '@') + 1, HOSTLEN - strlen(safe));
		strcpy(safemask, safe);
	} else {
		strncpy(safe, "*!", HOSTLEN);
		strncat(safe, safemask, HOSTLEN - strlen(safe));
		strcpy(safemask, safe);
	}
	oer_debug(OER_DEBUG_INFO, "safeban->returning %s\n", safemask);
	return safemask;
}

int nthmode(char *modeline, int index)
{
	int i;
	int n;
	int length;
	char polar;

	length = strlen(modeline);
	for(i = 0, n = 0, polar = 'x'; i < length; i++) {
		switch(modeline[i]) {
		case '+':
			polar = '+';
			break;
		case '-':
			polar = '-';
			break;
		case 'o':
			n++;
			if(n == index) {
				if(polar == '+') {
					return OER_NTHMODE_OP;
				} else {
					return OER_NTHMODE_DOP;
				}
			}
			break;
		case 'v':
			n++;
			if(n == index) {
				if(polar == '+') {
					return OER_NTHMODE_VOICE;
				} else {
					return OER_NTHMODE_DVOICE;
				}
			}
			break;
		case 'b':
			n++;
			if(n == index) {
				if(polar == '+') {
					return OER_NTHMODE_BAN;
				} else {
					return OER_NTHMODE_UNBAN;
				}
			}
			break;
		default:
			return OER_NTHMODE_UNKNOWN;
		}

	}
	return OER_NTHMODE_UNKNOWN;
}

void getnthmode(char *modeline, int index, char *to)
{
	int i;
	int n;
	int length;
	char polar;

	memset(to, 0, CHANLEN + 1);
	length = strlen(modeline);
	for(i = 0, n = 0, polar = 'x'; i < length; i++) {
		switch(modeline[i]) {
		case '+':
		case '-':
			polar = modeline[i];
			break;
                default:
			n++;
			if(n == index) {
				snprintf(to, CHANLEN, "%c%c", polar, modeline[i]);
				return;
			}
			break;
		}
	}
}

struct modeline *addnewmm(char *channel, time_t at, char *mode, char *target)
{
	struct modeline *mm;
	struct modeline *mm2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewmm->adding new mmode to channel %s at: %lu (time now: %lu) mode: %s target: %s\n", channel, at, mystate->now, mode, target);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	if((strlen(mode) + strlen(target) + 10) > HUGESTRINGLEN) {
		return NULL;
	}
	if((mm = (struct modeline *) malloc(sizeof(struct modeline))) == NULL) {
		return NULL;
	}
	if((mm->mode = (char *) malloc(strlen(mode) + 1)) == NULL) {
		return NULL;
	}
	strcpy(mm->mode, mode);
	if((mm->target = (char *) malloc(strlen(target) + 1)) == NULL) {
		return NULL;
	}
	strcpy(mm->target, target);
	mm->at = at;
	mm->done = 0;
	mm->prev = NULL;
	mm->next = NULL;
	/* as always, the empty case is special */
	if(this->modelines == NULL) {
		this->modelines = mm;
		return mm;
	}
	for(mm2 = this->modelines; mm2->next != NULL; mm2 = mm2->next) {
	}
	mm2->next = mm;
	mm->prev = mm2;
	return mm;
}

struct timed *addnewtimed(time_t at, int type, int function, char *irc_command, char *optstring1, char *optstring2, char *optstring3)
{
	struct timed *tim;
	struct timed *tim2;

	oer_debug(OER_DEBUG_INFO, "addnewtimed->adding new timed at: %lu (time now: %lu) type: %d function: %d\n", at, mystate->now, type, function);
	if((irc_command != NULL) && strlen(irc_command) > WRITE_BUFFER_LENGTH) {
		return NULL;
	}
	if((tim = (struct timed *) malloc(sizeof(struct timed))) == NULL) {
		return NULL;
	}
	tim->at = at;
	tim->type = type;
	tim->function = function;
	tim->irc_command = NULL;
	tim->optstring1 = NULL;
	tim->optstring2 = NULL;
	tim->optstring3 = NULL;
	if(irc_command != NULL) {
		if((tim->irc_command = (char *) malloc(strlen(irc_command) + 1)) == NULL) {
			return NULL;
		}
		strcpy(tim->irc_command, irc_command);
	}
	if(optstring1 != NULL) {
		if((tim->optstring1 = (char *) malloc(strlen(optstring1) + 1)) == NULL) {
			return NULL;
		}
		strcpy(tim->optstring1, optstring1);
	}
	if(optstring2 != NULL) {
		if((tim->optstring2 = (char *) malloc(strlen(optstring2) + 1)) == NULL) {
			return NULL;
		}
		strcpy(tim->optstring2, optstring2);
	}
	if(optstring3 != NULL) {
		if((tim->optstring3 = (char *) malloc(strlen(optstring3) + 1)) == NULL) {
			return NULL;
		}
		strcpy(tim->optstring3, optstring3);
	}
	/* as always, the empty case is special */
	if(mystate->timeds == NULL) {
		tim->prev = NULL;
		tim->next = NULL;
		mystate->timeds = tim;
		return tim;
	}
	/* there is no need to check for existance, append */
	for(tim2 = mystate->timeds; tim2->next != NULL; tim2 = tim2->next) {
	}
	tim2->next = tim;
	tim->prev = tim2;
	tim->next = NULL;
	return tim;
}

struct ls_wrapstruct *addnew_ls(struct ls_wrapstruct *first, time_t at, char *nick, char *host, char *message)
{
	int amount;
	struct ls_wrapstruct *ls;
	struct ls_wrapstruct *ls2;

	oer_debug(OER_DEBUG_FLOOD, "addnew_ls->adding at: %lu nick: %s host: %s message: %s\n", at, nick, host, message);
	ls = first;
	ls2 = ls;
	amount = 0;
	while(ls != NULL) {
		ls2 = ls;
		amount++;
		ls = ls2->next;
	}
	/* add a new entry to the list */
	if((ls = (struct ls_wrapstruct *) malloc(sizeof(struct ls_wrapstruct))) == NULL) {
		return NULL;
	}
	if((ls->str1 = (char *) malloc(strlen(nick) + 1)) == NULL) {
		return NULL;
	}
	strcpy(ls->str1, nick);
	if((ls->str2 = (char *) malloc(strlen(host) + 1)) == NULL) {
		return NULL;
	}
	strcpy(ls->str2, host);
	if(message != NULL) {
		if((ls->str3 = (char *) malloc(strlen(message) + 1)) == NULL) {
			return NULL;
		}
		strcpy(ls->str3, message);
	} else {
		ls->str3 = NULL;
	}
	ls->at = at;
	ls->prev = NULL;
	ls->next = NULL;
	/* the first one is a special case */
	if(first == NULL) {
		return ls;
	}
	/* >= 1 ls */
	ls->prev = ls2;
	ls2->next = ls;
	if(amount >= OER_LASTS) {
		/* strip first one */
		first->next->prev = NULL;
		ls2 = first->next;
		free(first->str1);
		free(first->str2);
		free(first->str3);
		free(first);
		first = ls2;
	}
	return first;
}

struct pubmsg *addnewpubmsg(char *channel, time_t at, char *nick, char *host, char *message)
{
	int amount;
	struct pubmsg *pm;
	struct pubmsg *pm2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewpubmsg->adding pubmsg for channel %s at %lu by %s!%s\n", channel, at, nick, host);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	/* add a new entry to the list */
	if((pm = (struct pubmsg *) malloc(sizeof(struct pubmsg))) == NULL) {
		return NULL;
	}
	if((pm->nick = (char *) malloc(strlen(nick) + 1)) == NULL) {
		return NULL;
	}
	strcpy(pm->nick, nick);
	if((pm->host = (char *) malloc(strlen(host) + 1)) == NULL) {
		return NULL;
	}
	strcpy(pm->host, host);
	if((pm->message = (char *) malloc(strlen(message) + 1)) == NULL) {
		return NULL;
	}
	strcpy(pm->message, message);
	pm->at = at;
	pm->prev = NULL;
	pm->next = NULL;
	/* the first one is a special case */
	if(this->pubmsgs == NULL) {
		this->pubmsgs = pm;
		return pm;
	}
	/* we got at least 1 pubmsg in the list */
	this->pubmsgs->prev = pm;
	pm->next = this->pubmsgs;
	this->pubmsgs = pm;
	for(pm2 = this->pubmsgs, amount = 0; pm2->next != NULL; pm2 = pm2->next, amount++) {
	}
	if(amount >= OER_PUBMSGS) {
		/* list full, strip last one */
		pm2->prev->next = NULL;
		free(pm2->message);
		free(pm2->host);
		free(pm2->nick);
		free(pm2);
	}
	return pm;
}

struct part *addnewpart(char *channel, time_t at, char *nick, char *host)
{
	int amount;
	struct part *p;
	struct part *p2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewpart->adding part from %s at %lu for %s!%s\n", channel, at, nick, host);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	/* add a new entry to the list */
	if((p = (struct part *) malloc(sizeof(struct part))) == NULL) {
		return NULL;
	}
	if((p->nick = (char *) malloc(strlen(nick) + 1)) == NULL) {
		return NULL;
	}
	strcpy(p->nick, nick);
	if((p->host = (char *) malloc(strlen(host) + 1)) == NULL) {
		return NULL;
	}
	strcpy(p->host, host);
	p->at = at;
	p->valid = 1;
	p->prev = NULL;
	p->next = NULL;
	/* the first one is a special case */
	if(this->parts == NULL) {
		this->parts = p;
		return p;
	}
	/* we got at least 1 part in the list */
	this->parts->prev = p;
	p->next = this->parts;
	this->parts = p;
	for(p2 = this->parts, amount = 0; p2->next != NULL; p2 = p2->next, amount++) {
	}
	if(amount >= OER_PARTS) {
		/* list full, strip last one */
		p2->prev->next = NULL;
		free(p2->nick);
		free(p2->host);
		free(p2);
	}
	return p;
}

struct join *addnewjoin(char *channel, time_t at, char *nick, char *host)
{
	int amount;
	struct join *j;
	struct join *j2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewjoin->adding join at %lu to %s from %s!%s\n", at, channel, nick, host);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	/* add a new entry to the list */
	if((j = (struct join *) malloc(sizeof(struct join))) == NULL) {
		return NULL;
	}
	if((j->nick = (char *) malloc(strlen(nick) + 1)) == NULL) {
		return NULL;
	}
	strcpy(j->nick, nick);
	if((j->host = (char *) malloc(strlen(host) + 1)) == NULL) {
		return NULL;
	}
	strcpy(j->host, host);
	j->at = at;
	j->prev = NULL;
	j->next = NULL;
	/* the first one is a special case */
	if(this->joins == NULL) {
		this->joins = j;
		return j;
	}
	/* we got at least 1 join in the list */
	this->joins->prev = j;
	j->next = this->joins;
	this->joins = j;
	for(j2 = this->joins, amount = 0; j2->next != NULL; j2 = j2->next, amount++) {
	}
	if(amount >= OER_JOINS) {
		/* list full, strip last one */
		j2->prev->next = NULL;
		free(j2->nick);
		free(j2->host);
		free(j2);
	}
	return j;
}

struct chanuser *getcuptr(char *channel, char *nick)
{
	struct channel *this;
        struct chanuser *cu;

	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
        for(cu = this->nicks; cu != NULL; cu = cu->next) {
                if(!strcmp(cu->nick, nick)) {
			return cu;
                }
        }
	return NULL;
}

struct chanuser *userjoined(char *channel, char *nick, char *host, int ircop, int chanop, int voice)
{
	struct chanuser *cu;
	struct chanuser *cu2;
	struct channel *this;

	if(host != NULL) {
		oer_debug(OER_DEBUG_INFO, "userjoined->adding to %s %s!%s (%d %d %d)\n", channel, nick, host, ircop, chanop, voice);
	} else {
		oer_debug(OER_DEBUG_INFO, "userjoined->adding to %s join from %s (%d %d %d)\n", channel, nick, ircop, chanop, voice);
	}
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	if((cu = (struct chanuser *) malloc(sizeof(struct chanuser))) == NULL) {
		return NULL;
	}
	cu->hostquery = 0;
	cu->ircop = ircop;
	cu->chanop = chanop;
	cu->voice = voice;
	cu->tobek = 0;
	cu->prev = NULL;
	cu->next = NULL;
	if((cu->nick = (char *) malloc(strlen(nick) + 1)) == NULL) {
		return NULL;
	}
	strcpy(cu->nick, nick);
	cu->host = NULL;
	if(host != NULL) {
		if((cu->host = (char *) malloc(strlen(host) + 1)) == NULL) {
			return NULL;
		}
		strcpy(cu->host, host);
	}
	if(cu->host != NULL) {
		oer_debug(OER_DEBUG_FLOOD, "userjoined->added to %s %s!%s (%d %d %d)\n", this->name, cu->nick, cu->host, cu->ircop, cu->chanop, cu->voice);
	} else {
		oer_debug(OER_DEBUG_FLOOD, "userjoined->added to %s join from %s (%d %d %d)\n", this->name, cu->nick, cu->ircop, cu->chanop, cu->voice);
	}
	/* as always, the empty case is special */
	if(this->nicks == NULL) {
		this->nicks = cu;
		this->nickcount++;
		return cu;
	}
	/* there is no need to check for existance, append */
	for(cu2 = this->nicks; cu2->next != NULL; cu2 = cu2->next) {
	}
	cu2->next = cu;
	cu->prev = cu2;
	this->nickcount++;
	return cu;
}

int userleft(char *channel, char *nick, char *host)
{
	struct chanuser *cu;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "userleft->removing from %s %s!%s\n", channel, nick, host);
	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(sameuser(cu->nick, nick, cu->host, host)) {
			break;
		}
	}
	if(cu == NULL) {
		/* a ghost user left?!?! */
		return 0;
	}
	/* free the user & adjust lists */
	if(cu->prev == NULL) {
		/* first user in list */
		this->nicks = cu->next;
		/* ... check if also last */
		if(cu->next != NULL) {
			cu->next->prev = NULL;
		}
	}
	if(cu->next == NULL) {
		/* last user in list
		   ... check also if the only one */
		if(cu->prev != NULL) {
			cu->prev->next = NULL;
		} else {
			this->nicks = NULL;
		}
	}
	if(cu->prev != NULL && cu->next != NULL) {
		/* between 2 or more users */
		cu->prev->next = cu->next;
		cu->next->prev = cu->prev;
	}
	oer_debug(OER_DEBUG_FLOOD, "userleft->removed from %s %s!%s\n", this->name, cu->nick, cu->host);
	free(cu->host);
	free(cu->nick);
	free(cu);
	this->nickcount--;
	return 1;
}

int sameuser(char *n1, char *n2, char *h1, char *h2)
{
	/* we don't always know the hostname... */
	if(h1 == NULL || h2 == NULL) {
		if(!strcasecmp(n1, n2)) {
			return 1;
		} else {
			return 0;
		}
	} else {
		if(!strcasecmp(n1, n2) && !strcasecmp(h1, h2)) {
			return 1;
		} else {
			return 0;
		}
	}
}

void linenoise()
{
	char outstring[STRINGLEN + 1];

	if((mystate->current_server->linenoise) && !(mystate->now & 0xF)) {
		snprintf(outstring, STRINGLEN, "ISON %s\n", mystate->nick);
		addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, outstring, NULL, NULL, NULL);
	}
}

void checkstoned()
{
	char outstring[STRINGLEN + 1];

	if(!mystate->current_server->lastping) {
		return;
	}
	if(!(mystate->now & 0xF)) {
		snprintf(outstring, STRINGLEN, "checkstoned->last known server activity %s", ctime(&mystate->current_server->lastping));
		striplf(outstring);
		tzset();
		oer_debug(OER_DEBUG_INFO, "%s %s %s\n", outstring, tzname[0], tzname[1]);
	}
	if((mystate->now - mystate->current_server->lastping) > (mystate->current_server->pingfrequency * 3)) {
		mystate->current_server->stoned = mystate->now;
		mystate->reconnect = OER_RECONNECT_STONED;
	}
}

int changeuser(char *channel, char *nick, int ircop, int chanop, int voice)
{
	struct chanuser *cu;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "changeuser->changing modes for %s/%s to (%d %d %d)\n", nick, channel, ircop, chanop, voice);
	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			cu->ircop = (ircop == -1) ? cu->ircop : ircop;
			cu->chanop = (chanop == -1) ? cu->chanop : chanop;
			cu->voice = (voice == -1) ? cu->voice : voice;
			return 1;
		}
	}
	return 0;
}

void changetobek(char *channel, char *nick, int tobek)
{
	struct chanuser *cu;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			cu->tobek = tobek;
			return;
		}
	}
}

int gettobek(char *channel, char *nick)
{
	struct chanuser *cu;
	struct channel *this;

	if((this = getchptr(channel)) == NULL) {
		return 0;
	}
	for(cu = this->nicks; cu != NULL; cu = cu->next) {
		if(!strcasecmp(cu->nick, nick)) {
			return cu->tobek;
		}
	}
	return 0;
}

void freepubmsguser(char *channel, char *nick, char *host)
{
	struct pubmsg *pm;
	struct pubmsg *pm2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "freepubmsguser->for channel %s nick: %s host: %s\n", channel, nick, host);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	pm = this->pubmsgs;
	while(pm != NULL) {
		pm2 = pm->next;
		if(!strcasecmp(pm->nick, nick) && !strcasecmp(pm->host, host)) {
			if(pm->prev == NULL) {
				/* first pubmsg in list */
				this->pubmsgs = pm->next;
				/* ... check if also last */
				if(pm->next != NULL) {
					pm->next->prev = NULL;
				}
			}
			if(pm->next == NULL) {
				/* last pubmsg in list */
				this->pubmsgs = pm->prev;
				/* ... check also if the only one */
				if(pm->prev != NULL) {
					pm->prev->next = NULL;
				} else {
					this->pubmsgs = NULL;
				}
			}
			if(pm->prev != NULL && pm->next != NULL) {
				/* between 2 or more pubmsgs */
				pm->prev->next = pm->next;
				pm->next->prev = pm->prev;
			}
			oer_debug(OER_DEBUG_INFO, "freepubmsguser->removing: %lu %s %s %s\n", pm->at, pm->nick, pm->host, pm->message);
			free(pm->message);
			free(pm->nick);
			free(pm->host);
			free(pm);
		}
		pm = pm2;
	}
}

void lockchan(char *channel, char *reason, int auto_unlock, char *nick, char *host)
{
	struct channel *this;
	char stringbuffer[STRINGLEN + 1];

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	this->locked.locked = 1;
	this->locked.unlocked = 0;
	this->locked.auto_unlock = auto_unlock;
	memset(this->locked.reason, 0, STRINGLEN + 1);
	if(strlen(reason)) {
		strncpy(this->locked.reason, reason, STRINGLEN);
	}
	strncpy(this->locked.nick, nick, NICKLEN);
	strncpy(this->locked.host, host, HOSTLEN);
	addnewmm(this->name, mystate->now, "+i", "");
	snprintf(stringbuffer, STRINGLEN, "channel %s is locked by %s!%s", this->name, this->locked.nick, this->locked.host);
	sendchannelnotice(this->name, 0, stringbuffer);
}

void unlockchan(char *channel, char *nick, char *host)
{
	struct channel *this;
	char stringbuffer[STRINGLEN + 1];

	if((this = getchptr(channel)) == NULL) {
		return;
	}
	this->locked.unlocked = 1;
	/* this has to be a timed because of the way mmodes & timeds
	   are processed in the mainloop (we want the -i to appear
           after all lamers have been kicked out, not before) */
	snprintf(stringbuffer, STRINGLEN, "MODE %s -i\n", this->name);
	addnewtimed(mystate->now, OER_TIMED_IRC_COMMAND, OER_TIMED_IRC_COMMAND_DUMMY, stringbuffer, NULL, NULL, NULL);
	snprintf(stringbuffer, STRINGLEN, "channel %s was unlocked by %s!%s", this->name, nick, host);
	sendchannelnotice(this->name, 0, stringbuffer);
	cleartobeks(this->name);
}

void wall(char *channel, char *nick, char *host, char *commandline)
{
	int ppos;
	int counter;
	int delay;
        char p1[STRINGLEN + 1];
	char stringbuffer[HUGESTRINGLEN + 1];
	struct channel *this;
	struct chanuser *cu;

	ppos = 0;
        if((ppos = parse(commandline, ppos, " ", p1, STRINGLEN, 0)) < 0) {
                return;
        }
	if(!strlen(p1) || !strlen(commandline + ppos)) {
		return;
	}
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	delay = 0;
	/* all wall messages are being sent with a delay of (counter (0..nicksonchan) * OER_WALL_DELAY) + (counter * (counter >> 2)),
	   this is necessary to avoid 439's */
	if(!strcasecmp(p1, "admins")) {
		if(!isadmin(channel, host)) {
			return;
		}
		for(cu = this->nicks, counter = 0; cu != NULL; cu = cu->next) {
			if(!isme(cu->nick) && isadmin(this->name, cu->host)) {
				snprintf(stringbuffer, HUGESTRINGLEN, "notice to %s admins from %s: %s", this->name, nick, commandline + ppos);
				delay = (counter < OER_MAXTARGETS) ? (counter * OER_WALL_DELAY) : ((counter - OER_MAXTARGETS + 1) * OER_TARGET_DELAY);
				sendreply(cu->nick, 0, delay, 0, stringbuffer);
				counter++;
			}
		}
		if(!counter) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "notified %d %s on %s (took %d %s)", counter, (counter == 1) ? "admin" : "admins", this->name, delay, (counter == 1) ? "second" : "seconds");
		sendreply(nick, 0, delay, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "channel")) {
		snprintf(stringbuffer, HUGESTRINGLEN, "notice to %s from %s: %s", this->name, nick, commandline + ppos);
		sendchannelnotice(this->name, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "lamers")) {
		for(cu = this->nicks, counter = 0; cu != NULL; cu = cu->next) {
			if(!isme(cu->nick) && !cu->chanop) {
				snprintf(stringbuffer, HUGESTRINGLEN, "notice to non-opped %s users from %s: %s", this->name, nick, commandline + ppos);
				delay = (counter < OER_MAXTARGETS) ? (counter * OER_WALL_DELAY) : ((counter - OER_MAXTARGETS + 1) * OER_TARGET_DELAY);
				sendreply(cu->nick, 0, delay, 0, stringbuffer);
				counter++;
			}
		}
		if(!counter) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "notified %d %s on %s (took %d %s)", counter, (counter == 1) ? "lamer" : "lamers", this->name, delay, (counter == 1) ? "second" : "seconds");
		sendreply(nick, 0, delay, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "ops")) {
		for(cu = this->nicks, counter = 0; cu != NULL; cu = cu->next) {
			if(!isme(cu->nick) && cu->chanop) {
				snprintf(stringbuffer, HUGESTRINGLEN, "notice to %s channel operators from %s: %s", this->name, nick, commandline + ppos);
				delay = (counter < OER_MAXTARGETS) ? (counter * OER_WALL_DELAY) : ((counter - OER_MAXTARGETS + 1) * OER_TARGET_DELAY);
				sendreply(cu->nick, 0, delay, 0, stringbuffer);
				counter++;
			}
		}
		if(!counter) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "notified %d %s on %s (took %d %s)", counter, (counter == 1) ? "op" : "ops", this->name, delay, (counter == 1) ? "second" : "seconds");
		sendreply(nick, 0, delay, 0, stringbuffer);
		return;
	}
	if(!strcasecmp(p1, "users")) {
		for(cu = this->nicks, counter = 0; cu != NULL; cu = cu->next) {
			if(!isme(cu->nick) && (isadmin(this->name, cu->host) || isop(this->name, cu->host))) {
				snprintf(stringbuffer, HUGESTRINGLEN, "notice to %s bot users from %s: %s", this->name, nick, commandline + ppos);
				delay = (counter < OER_MAXTARGETS) ? (counter * OER_WALL_DELAY) : ((counter - OER_MAXTARGETS + 1) * OER_TARGET_DELAY);
				sendreply(cu->nick, 0, delay, 0, stringbuffer);
				counter++;
			}
		}
		if(!counter) {
			return;
		}
		snprintf(stringbuffer, HUGESTRINGLEN, "notified %d %s on %s (took %d %s)", counter, (counter == 1) ? "bot user" : "bot users", this->name, delay, (counter == 1) ? "second" : "seconds");
		sendreply(nick, 0, delay, 0, stringbuffer);
		return;
	}
}

struct authed *addnewauthed(char *channel, time_t at, struct botuser *user, char *host)
{
	struct authed *a;
	struct authed *a2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "addnewauthed->adding auth for channel %s at %lu for %s\n", channel, at, host);
	if((this = getchptr(channel)) == NULL) {
		return NULL;
	}
	/* add a new entry to the list */
	if((a = (struct authed *) malloc(sizeof(struct authed))) == NULL) {
		return NULL;
	}
	a->at = at;
	a->user = user;
	strncpy(a->host, host, HOSTLEN);
	a->prev = NULL;
	a->next = NULL;
	/* the first one is a special case */
	if(this->autheds == NULL) {
		this->autheds = a;
		return a;
	}
	/* we got at least 1 authed in the list, append */
	for(a2 = this->autheds; a2->next != NULL; a2 = a2->next) {
		;
	}
	a2->next = a;
	a->prev = a2;
	return a;
}

void cleanautheds(char *channel)
{
	struct authed *a;
	struct authed *a2;
	struct channel *this;

	oer_debug(OER_DEBUG_INFO, "cleanauthed->cleaning autheds for channel %s\n", channel);
	if((this = getchptr(channel)) == NULL) {
		return;
	}
	/* oldest first, stripped from first to last */
	a = this->autheds;
	while(a != NULL) {
		if(mystate->now < (a->at + OER_LOGON_TIMEOUT)) {
			/* since the list is oldest entry first, there
			   are no more entries to go through */
			return;
		}
		/* this entry has expired, remove & adjust lists */
		a2 = a->next;
		free(a);
		a = a2;
		if(a != NULL) {
			/* the next one will be the first in list */
			a->prev = NULL;
			this->autheds = a;
		} else {
			/* no more autheds for channel */
			this->autheds = NULL;
		}
	}
}
