#include "oer-common.h"

char salt_chars[] = { "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz" };

unsigned int getrandom(unsigned int);

int main(int argc, char *argv[])
{
	char cryptsalt[3];
        char *crypted;

	if(argc != 2) {
		exit(EXIT_FAILURE);
	}
	cryptsalt[0] = salt_chars[getrandom(strlen(salt_chars)) - 1];
	cryptsalt[1] = cryptsalt[0];
	cryptsalt[2] = '\0';
	crypted = crypt(argv[1], cryptsalt);
	printf("%s\n", crypted);
	exit(EXIT_SUCCESS);
}

unsigned int getrandom(unsigned int ceiling)
{
        unsigned int rdelta;
        unsigned int nrand;
        struct timeval tv;
        /* returns a integer between 1..ceiling */
        gettimeofday(&tv, 0);
        srand(tv.tv_usec);
        nrand = rand();
        ceiling = (ceiling > 0) ? ceiling : 1;
        rdelta = (nrand / (RAND_MAX / ceiling)) + 1;
        return rdelta;
}

